import QtQuick 2.8
import QtQuick.Controls 2.8
import QtQuick.Controls 1.4 as Q1
import QtQuick.Controls.Styles 1.4
import SddmComponents 2.0
import "."
Rectangle {
    id : container
    color: "#333333"
    LayoutMirroring.enabled : Qt.locale().textDirection == Qt.RightToLeft
    LayoutMirroring.childrenInherit : true
    property int sessionIndex : session.index

    TextConstants {
        id: textConstants
    }

    Connections {
        target: sddm
        function onLoginSucceeded() {
            errorMessage.color = "green"
            errorMessage.text = textConstants.loginSucceeded
        }
        function onLoginFailed() {
            password.text = ""
            errorMessage.color = "#ff4444"
            errorMessage.text = textConstants.loginFailed
            errorMessage.bold = true
        }
    }

    Image {
        source: "images/header.svg"
        width: parent.width
        height: 36

        Clock2 {
            id: clocky
            anchors.centerIn: parent
            timeFont.family: "Noto Sans"
            color: "white"
        }

        ComboBox {
            id : session
            anchors.left: parent.left
            anchors.verticalCenter: parent.verticalCenter
            anchors.leftMargin:18
            width : 240
            height : 24
            font.pixelSize : 11
            font.family: "Noto Sans"
            arrowColor : "#363636"
            arrowIcon : "images/comboarrow.svg"
            model : sessionModel
            index : sessionModel.lastIndex
            borderColor : "#606060"
            color : "#363636"
            textColor : "#f4f4f2"
            hoverColor : "#847865"
            focusColor : "#847865"
            menuColor : "#282828"
        }

        Image {
            id : shutdownButton
            source : "images/shutdown.svg"
            anchors.right : parent.right
            anchors.verticalCenter : parent.verticalCenter
            anchors.rightMargin : 18
            height: 20
            width: 20

            property string toolTipText1: textConstants.shutdown
            ToolTip.text: toolTipText1
            ToolTip.delay: 500
            ToolTip.visible: toolTipText1 ? ma1.containsMouse : false

            MouseArea {
                id: ma1
                anchors.fill : parent
                hoverEnabled : true
                onEntered : {
                    parent.source = "images/shutdownhover.svg"
                }
                onExited : {
                    parent.source = "images/shutdown.svg"
                }
                onPressed : {
                    parent.source = "images/shutdownpressed.svg"
                    sddm.powerOff()
                }
                onReleased : {
                    parent.source = "images/shutdown.svg"
                }
            }

            KeyNavigation.backtab : rebootButton
            KeyNavigation.tab : rebootButton
        }

        Image {
            id : rebootButton
            source : "images/reboot.svg"
            anchors.right : shutdownButton.left
            anchors.verticalCenter : parent.verticalCenter
            anchors.rightMargin : 18
            height: 20
            width: 20

            property string toolTipText2: textConstants.reboot
            ToolTip.text: toolTipText2
            ToolTip.delay: 500
            ToolTip.visible: toolTipText2 ? ma2.containsMouse : false

            MouseArea {
                id: ma2
                anchors.fill : parent
                hoverEnabled : true
                onEntered : {
                    parent.source = "images/reboothover.svg"
                }
                onExited : {
                    parent.source = "images/reboot.svg"
                }
                onPressed : {
                    parent.source = "images/rebootpressed.svg"
                    sddm.reboot()
                }
                onReleased : {
                    parent.source = "images/reboot.svg"
                }
            }
        }
    }

    Image {
        id : backing
        source: "images/backing.svg"
        width : 640
        height : 480
        anchors.horizontalCenter : parent.horizontalCenter
        anchors.verticalCenter : parent.verticalCenter

        Text {
            id: greeting
            anchors.top: parent.top
            anchors.horizontalCenter: parent.horizontalCenter
            anchors.topMargin: 54
            font.family: "Noto Sans"
            font.pixelSize: 22
            text: textConstants.welcomeText.arg(sddm.hostName)
            color: "white"
        }

        Text {
            id : errorMessage
            anchors.horizontalCenter : parent.horizontalCenter
            anchors.top: greeting.bottom
            anchors.topMargin: 4
            text : textConstants.prompt
            font.pixelSize : 11
            color : "#bbbbbb"
            font.family : "Noto Sans"
        }

        Column{
            anchors.centerIn: parent

            Text {
                id: loginlbl
                color: "#bbbbbb"
                text : textConstants.userName
                font.family: "Noto Sans"
                font.pixelSize: 11
            }

            Image {
                source: "images/input.svg"
                width: 240
                height :28
                TextField {
                    id : nameinput
                    focus: true
                    font.family : "Noto Sans"
                    anchors.fill: parent
                    text : userModel.lastUser
                    font.pixelSize : 13
                    color : "white"
                    background: Image {
                        id: textback
                        source: "images/inputhi.svg"

                        states: [
                            State {
                                name: "yay"
                                PropertyChanges {target: textback; opacity: 1}
                            },
                            State {
                                name: "nay"
                                PropertyChanges {target: textback; opacity: 0}
                            }
                        ]

                        transitions: [
                            Transition {
                                to: "yay"
                                NumberAnimation { target: textback; property: "opacity"; from: 0; to: 1; duration: 200; }
                            },

                            Transition {
                                to: "nay"
                                NumberAnimation { target: textback; property: "opacity"; from: 1; to: 0; duration: 200; }
                            }
                        ]
                    }

                    KeyNavigation.tab : password

                    Keys.onPressed : {
                        if (event.key === Qt.Key_Return || event.key === Qt.Key_Enter) {
                            password.focus = true
                        }
                    }

                    onActiveFocusChanged: {
                        if (activeFocus) {
                            textback.state = "yay"
                        } else {
                            textback.state = "nay"
                        }
                    }
                }
            }

            Rectangle {
                height: 14
                width: 240
                color: "transparent"
            }

            Text {
                id: passwordlbl
                color: "#bbbbbb"
                text : textConstants.password
                font.family: "Noto Sans"
                font.pixelSize: 11
            }

            Image {
                source: "images/input.svg"
                width: 240
                height :28
                TextField {
                    id : password
                    font.family : "Noto Sans"
                    anchors.fill: parent
                    font.pixelSize : 13
                    echoMode : TextInput.Password
                    color : "white"

                    background: Image {
                        id: textback1
                        source: "images/inputhi.svg"

                        states: [
                            State {
                                name: "yay1"
                                PropertyChanges {target: textback1; opacity: 1}
                            },
                            State {
                                name: "nay1"
                                PropertyChanges {target: textback1; opacity: 0}
                            }
                        ]

                        transitions: [
                            Transition {
                                to: "yay1"
                                NumberAnimation { target: textback1; property: "opacity"; from: 0; to: 1; duration: 200; }
                            },

                            Transition {
                                to: "nay1"
                                NumberAnimation { target: textback1; property: "opacity"; from: 1; to: 0; duration: 200; }
                            }
                        ]
                    }

                    KeyNavigation.tab : nameinput

                    Keys.onPressed : {
                        if (event.key === Qt.Key_Return || event.key === Qt.Key_Enter) {
                            sddm.login(nameinput.text, password.text, sessionIndex)
                            event.accepted = true
                        }
                    }

                    onActiveFocusChanged: {
                        if (activeFocus) {
                            textback1.state = "yay1"
                        } else {
                            textback1.state = "nay1"
                        }
                    }
                }
            }
            Rectangle {
                height: 18
                width: 240
                color: "transparent"
            }

            Image {
                anchors.right: parent.right
                width : 84
                height : 28
                source : "images/buttonup.svg"
                id : loginButton
                MouseArea {
                    anchors.fill : parent
                    hoverEnabled : true
                    onEntered : {
                        parent.source = "images/buttonhover.svg"
                    }
                    onExited : {
                        parent.source = "images/buttonup.svg"
                    }
                    onPressed : {
                        parent.source = "images/buttondown.svg"
                        sddm.login(nameinput.text, password.text, sessionIndex)
                    }
                    onReleased : {
                        parent.source = "images/buttonup.svg"
                    }
                }

                Text {
                    anchors.centerIn: parent
                    text: textConstants.login
                    font.family: "Noto Sans"
                    font.pixelSize: 9
                    color: "white"
                }
            }

        } //Column

        Image {
            height: 72
            width: 72
            source: "images/dummy.svg"
            anchors.bottom: parent.bottom
            anchors.horizontalCenter:  parent.horizontalCenter
            anchors.bottomMargin: 8
        }
    }


    Component.onCompleted : {
        nameinput.focus = true
        textback1.state = "nay1"  //dunno why both inputs get focused
    }
}
