import QtQuick 2.0

Column {
    id: ccontainer

    property date dateTime: new Date()
    property alias timeFont: time.font
    property alias color: time.color
    
    Timer {
        interval: 100; running: true; repeat: true;
        onTriggered: ccontainer.dateTime = new Date()
    }

    Text {
        id: time
        anchors.horizontalCenter: parent.horizontalCenter
        color: "red"
        text : Qt.formatDateTime(ccontainer.dateTime, "dddd h:mm ap")
        font.pixelSize: 16
    }
}
