/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.sspi;

import com.amazon.redshift.core.RedshiftStream;
import com.amazon.redshift.logger.LogLevel;
import com.amazon.redshift.logger.RedshiftLogger;
import com.amazon.redshift.sspi.ISSPIClient;
import com.amazon.redshift.sspi.NTDSAPIWrapper;
import com.amazon.redshift.util.HostSpec;
import com.amazon.redshift.util.RedshiftException;
import com.amazon.redshift.util.RedshiftState;
import com.sun.jna.LastErrorException;
import com.sun.jna.Platform;
import com.sun.jna.platform.win32.Sspi;
import com.sun.jna.platform.win32.Win32Exception;
import java.io.IOException;
import java.sql.SQLException;
import waffle.windows.auth.IWindowsCredentialsHandle;
import waffle.windows.auth.impl.WindowsCredentialsHandleImpl;
import waffle.windows.auth.impl.WindowsSecurityContextImpl;

public class SSPIClient
implements ISSPIClient {
    public static final String SSPI_DEFAULT_SPN_SERVICE_CLASS = "REDSHIFT";
    private RedshiftLogger logger;
    private final RedshiftStream rsStream;
    private final String spnServiceClass;
    private final boolean enableNegotiate;
    private IWindowsCredentialsHandle clientCredentials;
    private WindowsSecurityContextImpl sspiContext;
    private String targetName;

    public SSPIClient(RedshiftStream rsStream, String spnServiceClass, boolean enableNegotiate) {
        this.logger = rsStream != null ? rsStream.getLogger() : RedshiftLogger.getDriverLogger();
        this.rsStream = rsStream;
        if (spnServiceClass == null || spnServiceClass.isEmpty()) {
            spnServiceClass = SSPI_DEFAULT_SPN_SERVICE_CLASS;
        }
        this.spnServiceClass = spnServiceClass;
        this.enableNegotiate = enableNegotiate;
    }

    @Override
    public boolean isSSPISupported() {
        try {
            if (!Platform.isWindows()) {
                if (RedshiftLogger.isEnable()) {
                    this.logger.log(LogLevel.DEBUG, "SSPI not supported: non-Windows host", new Object[0]);
                }
                return false;
            }
            Class.forName("waffle.windows.auth.impl.WindowsSecurityContextImpl");
            return true;
        }
        catch (NoClassDefFoundError ex) {
            if (RedshiftLogger.isEnable()) {
                this.logger.log(LogLevel.INFO, "SSPI unavailable (no Waffle/JNA libraries?)", ex);
            }
            return false;
        }
        catch (ClassNotFoundException ex) {
            if (RedshiftLogger.isEnable()) {
                this.logger.log(LogLevel.INFO, "SSPI unavailable (no Waffle/JNA libraries?)", ex);
            }
            return false;
        }
    }

    private String makeSPN() throws RedshiftException {
        HostSpec hs = this.rsStream.getHostSpec();
        try {
            return NTDSAPIWrapper.instance.DsMakeSpn(this.spnServiceClass, hs.getHost(), null, (short)0, null);
        }
        catch (LastErrorException ex) {
            throw new RedshiftException("SSPI setup failed to determine SPN", RedshiftState.CONNECTION_UNABLE_TO_CONNECT, (Throwable)ex);
        }
    }

    @Override
    public void startSSPI() throws SQLException, IOException {
        String securityPackage;
        String string = securityPackage = this.enableNegotiate ? "negotiate" : "kerberos";
        if (RedshiftLogger.isEnable()) {
            this.logger.log(LogLevel.DEBUG, "Beginning SSPI/Kerberos negotiation with SSPI package: {0}", securityPackage);
        }
        try {
            try {
                this.clientCredentials = WindowsCredentialsHandleImpl.getCurrent((String)securityPackage);
                this.clientCredentials.initialize();
            }
            catch (Win32Exception ex) {
                throw new RedshiftException("Could not obtain local Windows credentials for SSPI", RedshiftState.CONNECTION_UNABLE_TO_CONNECT, (Throwable)ex);
            }
            try {
                this.targetName = this.makeSPN();
                if (RedshiftLogger.isEnable()) {
                    this.logger.log(LogLevel.DEBUG, "SSPI target name: {0}", this.targetName);
                }
                this.sspiContext = new WindowsSecurityContextImpl();
                this.sspiContext.setPrincipalName(this.targetName);
                this.sspiContext.setCredentialsHandle(this.clientCredentials);
                this.sspiContext.setSecurityPackage(securityPackage);
                this.sspiContext.initialize(null, null, this.targetName);
            }
            catch (Win32Exception ex) {
                throw new RedshiftException("Could not initialize SSPI security context", RedshiftState.CONNECTION_UNABLE_TO_CONNECT, (Throwable)ex);
            }
            this.sendSSPIResponse(this.sspiContext.getToken());
            if (RedshiftLogger.isEnable()) {
                this.logger.log(LogLevel.DEBUG, "Sent first SSPI negotiation message", new Object[0]);
            }
        }
        catch (NoClassDefFoundError ex) {
            throw new RedshiftException("SSPI cannot be used, Waffle or its dependencies are missing from the classpath", RedshiftState.NOT_IMPLEMENTED, (Throwable)ex);
        }
    }

    @Override
    public void continueSSPI(int msgLength) throws SQLException, IOException {
        if (this.sspiContext == null) {
            throw new IllegalStateException("Cannot continue SSPI authentication that we didn't begin");
        }
        if (RedshiftLogger.isEnable()) {
            this.logger.log(LogLevel.DEBUG, "Continuing SSPI negotiation", new Object[0]);
        }
        byte[] receivedToken = this.rsStream.receive(msgLength);
        Sspi.SecBufferDesc continueToken = new Sspi.SecBufferDesc(2, receivedToken);
        this.sspiContext.initialize(this.sspiContext.getHandle(), continueToken, this.targetName);
        byte[] responseToken = this.sspiContext.getToken();
        if (responseToken.length > 0) {
            this.sendSSPIResponse(responseToken);
            if (RedshiftLogger.isEnable()) {
                this.logger.log(LogLevel.DEBUG, "Sent SSPI negotiation continuation message", new Object[0]);
            }
        } else if (RedshiftLogger.isEnable()) {
            this.logger.log(LogLevel.DEBUG, "SSPI authentication complete, no reply required", new Object[0]);
        }
    }

    private void sendSSPIResponse(byte[] outToken) throws IOException {
        this.rsStream.sendChar(112);
        this.rsStream.sendInteger4(4 + outToken.length);
        this.rsStream.send(outToken);
        this.rsStream.flush();
    }

    @Override
    public void dispose() {
        if (this.sspiContext != null) {
            this.sspiContext.dispose();
            this.sspiContext = null;
        }
        if (this.clientCredentials != null) {
            this.clientCredentials.dispose();
            this.clientCredentials = null;
        }
    }
}

