/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.binary;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.binary.JSAndNodeGen;
import com.oracle.truffle.js.nodes.binary.JSLogicalNode;
import com.oracle.truffle.js.nodes.cast.JSToBooleanNode;
import java.util.Set;

@NodeInfo(shortName="&&")
public abstract class JSAndNode
extends JSLogicalNode {
    JSAndNode(JavaScriptNode left, JavaScriptNode right) {
        super(left, right);
    }

    public static JavaScriptNode create(JavaScriptNode left, JavaScriptNode right) {
        return JSAndNodeGen.create(left, right);
    }

    @Specialization
    protected Object doBoolean(VirtualFrame frame, boolean leftValue, @Cached @Cached.Shared InlinedConditionProfile canShortCircuit) {
        if (canShortCircuit.profile((Node)this, !leftValue)) {
            return leftValue;
        }
        return this.rightNode.execute(frame);
    }

    @Specialization(replaces={"doBoolean"})
    protected Object doGeneric(VirtualFrame frame, Object leftValue, @Cached(inline=true) JSToBooleanNode toBoolean, @Cached @Cached.Shared InlinedConditionProfile canShortCircuit) {
        if (canShortCircuit.profile((Node)this, !toBoolean.executeBoolean(this, leftValue))) {
            return leftValue;
        }
        return this.rightNode.execute(frame);
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return JSAndNode.create(JSAndNode.cloneUninitialized(this.getLeft(), materializedTags), JSAndNode.cloneUninitialized(this.getRight(), materializedTags));
    }
}

