/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.ast;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonDialectsTokenSetProvider;
import com.jetbrains.python.ast.PyAstElementKt;
import com.jetbrains.python.ast.PyAstElementVisitor;
import com.jetbrains.python.ast.PyAstImplicitImportNameDefiner;
import com.jetbrains.python.ast.PyAstImportStatement;
import com.jetbrains.python.ast.PyAstImportStatementBase;
import com.jetbrains.python.ast.PyAstReferenceExpression;
import com.jetbrains.python.ast.PyAstStarImportElement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public interface PyAstFromImportStatement
extends PyAstImportStatementBase,
PyAstImplicitImportNameDefiner {
    default public boolean isStarImport() {
        return this.getStarImportElement() != null;
    }

    @Nullable
    default public PyAstReferenceExpression getImportSource() {
        return (PyAstReferenceExpression)this.childToPsi(PythonDialectsTokenSetProvider.getInstance().getReferenceExpressionTokens(), 0);
    }

    @Nullable
    default public QualifiedName getImportSourceQName() {
        PyAstReferenceExpression importSource = this.getImportSource();
        if (importSource == null) {
            return null;
        }
        return importSource.asQualifiedName();
    }

    @Nullable
    public PyAstStarImportElement getStarImportElement();

    default public int getRelativeLevel() {
        ASTNode seeker;
        int result2 = 0;
        for (seeker = this.getNode().getFirstChildNode(); seeker != null && (seeker.getElementType() == PyTokenTypes.FROM_KEYWORD || seeker.getElementType() == TokenType.WHITE_SPACE); seeker = seeker.getTreeNext()) {
        }
        while (seeker != null && seeker.getElementType() == PyTokenTypes.DOT) {
            ++result2;
            seeker = seeker.getTreeNext();
        }
        return result2;
    }

    default public boolean isFromFuture() {
        QualifiedName qName = this.getImportSourceQName();
        return qName != null && qName.matches(new String[]{"__future__"});
    }

    @Nullable
    default public PsiElement getLeftParen() {
        return PyAstElementKt.findChildByType((PsiElement)this, PyTokenTypes.LPAR);
    }

    @Nullable
    default public PsiElement getRightParen() {
        return PyAstElementKt.findChildByType((PsiElement)this, PyTokenTypes.RPAR);
    }

    @Override
    @NotNull
    default public List<String> getFullyQualifiedObjectNames() {
        QualifiedName source = this.getImportSourceQName();
        String prefix = source != null ? source.join(".") + "." : "";
        List<String> unqualifiedNames = PyAstImportStatement.getImportElementNames(this.getImportElements());
        ArrayList<String> result2 = new ArrayList<String>(unqualifiedNames.size());
        for (String unqualifiedName : unqualifiedNames) {
            result2.add(prefix + unqualifiedName);
        }
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            PyAstFromImportStatement.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    @Override
    default public void acceptPyVisitor(PyAstElementVisitor pyVisitor) {
        pyVisitor.visitPyFromImportStatement(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/ast/PyAstFromImportStatement", "getFullyQualifiedObjectNames"));
    }
}

