/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.util.PathUtil;
import java.io.File;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public final class FilePathImpl
implements FilePath {
    @NotNull
    private final String myPath;
    private final boolean myIsDirectory;

    public FilePathImpl(@NotNull String path, boolean isDirectory) {
        if (path == null) {
            FilePathImpl.$$$reportNull$$$0(0);
        }
        this.myPath = FileUtil.toCanonicalPath((String)path);
        this.myIsDirectory = isDirectory;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilePathImpl path = (FilePathImpl)o;
        if (this.myIsDirectory != path.myIsDirectory) {
            return false;
        }
        return !SystemInfoRt.isFileSystemCaseSensitive ? this.myPath.equalsIgnoreCase(path.myPath) : this.myPath.equals(path.myPath);
    }

    public int hashCode() {
        int result2 = SystemInfoRt.isFileSystemCaseSensitive ? this.myPath.hashCode() : Strings.stringHashCodeInsensitive((CharSequence)this.myPath);
        result2 = 31 * result2 + (this.myIsDirectory ? 1 : 0);
        return result2;
    }

    @NotNull
    public String getPath() {
        String string = this.myPath;
        if (string == null) {
            FilePathImpl.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isDirectory() {
        return this.myIsDirectory;
    }

    public boolean isUnder(@NotNull FilePath parent, boolean strict) {
        if (parent == null) {
            FilePathImpl.$$$reportNull$$$0(2);
        }
        return FileUtil.isAncestor((String)parent.getPath(), (String)this.getPath(), (boolean)strict);
    }

    @Nullable
    public FilePath getParentPath() {
        String parent = PathUtil.getParentPath((String)this.myPath);
        return parent.isEmpty() ? null : new FilePathImpl(parent, true);
    }

    @Nullable
    public VirtualFile getVirtualFile() {
        return LocalFileSystem.getInstance().findFileByPath(this.myPath);
    }

    @Nullable
    public VirtualFile getVirtualFileParent() {
        FilePath parent = this.getParentPath();
        return parent != null ? parent.getVirtualFile() : null;
    }

    @NotNull
    public File getIOFile() {
        return new File(this.myPath);
    }

    @NotNull
    public String getName() {
        String string = PathUtil.getFileName((String)this.myPath);
        if (string == null) {
            FilePathImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getPresentableUrl() {
        String string = FileUtil.toSystemDependentName((String)this.myPath);
        if (string == null) {
            FilePathImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public Charset getCharset() {
        Charset charset = this.getCharset(null);
        if (charset == null) {
            FilePathImpl.$$$reportNull$$$0(5);
        }
        return charset;
    }

    @NotNull
    public Charset getCharset(@Nullable Project project) {
        VirtualFile file = this.getVirtualFile();
        String path = this.myPath;
        while (!(file != null && file.isValid() || path.isEmpty())) {
            path = PathUtil.getParentPath((String)path);
            file = LocalFileSystem.getInstance().findFileByPath(path);
        }
        if (file != null) {
            Charset charset = file.getCharset();
            if (charset == null) {
                FilePathImpl.$$$reportNull$$$0(6);
            }
            return charset;
        }
        EncodingManager e = project == null ? EncodingManager.getInstance() : EncodingProjectManager.getInstance((Project)project);
        Charset charset = e.getDefaultCharset();
        if (charset == null) {
            FilePathImpl.$$$reportNull$$$0(7);
        }
        return charset;
    }

    @NotNull
    public FileType getFileType() {
        VirtualFile file = this.getVirtualFile();
        FileTypeManager manager = FileTypeManager.getInstance();
        FileType fileType = file != null ? manager.getFileTypeByFile(file) : manager.getFileTypeByFileName(this.getName());
        if (fileType == null) {
            FilePathImpl.$$$reportNull$$$0(8);
        }
        return fileType;
    }

    @NonNls
    public String toString() {
        return this.myPath + (this.myIsDirectory ? "/" : "");
    }

    public boolean isNonLocal() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 4, 5, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/FilePathImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/FilePathImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableUrl";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCharset";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isUnder";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 4, 5, 6, 7, 8 -> new IllegalStateException(string);
        };
    }
}

