/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.plugin.stats;

import com.google.common.cache.CacheStats;
import com.google.common.collect.ImmutableMap;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.opensearch.cluster.health.ClusterHealthStatus;
import org.opensearch.knn.common.KNNConstants;
import org.opensearch.knn.index.engine.KNNEngine;
import org.opensearch.knn.index.memory.NativeMemoryCacheManager;
import org.opensearch.knn.indices.ModelCache;
import org.opensearch.knn.indices.ModelDao;
import org.opensearch.knn.plugin.stats.KNNCounter;
import org.opensearch.knn.plugin.stats.KNNGraphValue;
import org.opensearch.knn.plugin.stats.KNNRemoteIndexBuildValue;
import org.opensearch.knn.plugin.stats.KNNStat;
import org.opensearch.knn.plugin.stats.StatNames;
import org.opensearch.knn.plugin.stats.suppliers.EventOccurredWithinThresholdSupplier;
import org.opensearch.knn.plugin.stats.suppliers.KNNCircuitBreakerSupplier;
import org.opensearch.knn.plugin.stats.suppliers.KNNCounterSupplier;
import org.opensearch.knn.plugin.stats.suppliers.KNNInnerCacheStatsSupplier;
import org.opensearch.knn.plugin.stats.suppliers.LibraryInitializedSupplier;
import org.opensearch.knn.plugin.stats.suppliers.ModelIndexStatusSupplier;
import org.opensearch.knn.plugin.stats.suppliers.ModelIndexingDegradingSupplier;
import org.opensearch.knn.plugin.stats.suppliers.NativeMemoryCacheManagerSupplier;

public class KNNStats {
    private final Map<String, KNNStat<?>> knnStats = this.buildStatsMap();

    public Map<String, KNNStat<?>> getStats() {
        return this.knnStats;
    }

    public Map<String, KNNStat<?>> getNodeStats() {
        return this.getFilteredStats(false);
    }

    public Map<String, KNNStat<?>> getClusterStats() {
        return this.getFilteredStats(true);
    }

    private Map<String, KNNStat<?>> getFilteredStats(boolean isClusterLevel) {
        return (Map)this.knnStats.entrySet().stream().filter(entry -> ((KNNStat)entry.getValue()).isClusterLevel() == isClusterLevel).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Map<String, KNNStat<?>> buildStatsMap() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        this.addQueryStats(builder);
        this.addNativeMemoryStats(builder);
        this.addEngineStats(builder);
        this.addScriptStats(builder);
        this.addModelStats(builder);
        this.addGraphStats(builder);
        this.addRemoteIndexBuildStats(builder);
        return builder.build();
    }

    private void addQueryStats(ImmutableMap.Builder<String, KNNStat<?>> builder) {
        builder.put((Object)StatNames.KNN_QUERY_REQUESTS.getName(), KNNStats.createNodeStat(new KNNCounterSupplier(KNNCounter.KNN_QUERY_REQUESTS))).put((Object)StatNames.KNN_QUERY_WITH_FILTER_REQUESTS.getName(), KNNStats.createNodeStat(new KNNCounterSupplier(KNNCounter.KNN_QUERY_WITH_FILTER_REQUESTS)));
        builder.put((Object)StatNames.MIN_SCORE_QUERY_REQUESTS.getName(), KNNStats.createNodeStat(new KNNCounterSupplier(KNNCounter.MIN_SCORE_QUERY_REQUESTS))).put((Object)StatNames.MIN_SCORE_QUERY_WITH_FILTER_REQUESTS.getName(), KNNStats.createNodeStat(new KNNCounterSupplier(KNNCounter.MIN_SCORE_QUERY_WITH_FILTER_REQUESTS)));
        builder.put((Object)StatNames.MAX_DISTANCE_QUERY_REQUESTS.getName(), KNNStats.createNodeStat(new KNNCounterSupplier(KNNCounter.MAX_DISTANCE_QUERY_REQUESTS))).put((Object)StatNames.MAX_DISTANCE_QUERY_WITH_FILTER_REQUESTS.getName(), KNNStats.createNodeStat(new KNNCounterSupplier(KNNCounter.MAX_DISTANCE_QUERY_WITH_FILTER_REQUESTS)));
    }

    private void addNativeMemoryStats(ImmutableMap.Builder<String, KNNStat<?>> builder) {
        builder.put((Object)StatNames.HIT_COUNT.getName(), KNNStats.createNodeStat(new KNNInnerCacheStatsSupplier(CacheStats::hitCount))).put((Object)StatNames.MISS_COUNT.getName(), KNNStats.createNodeStat(new KNNInnerCacheStatsSupplier(CacheStats::missCount))).put((Object)StatNames.LOAD_SUCCESS_COUNT.getName(), KNNStats.createNodeStat(new KNNInnerCacheStatsSupplier(CacheStats::loadSuccessCount))).put((Object)StatNames.LOAD_EXCEPTION_COUNT.getName(), KNNStats.createNodeStat(new KNNInnerCacheStatsSupplier(CacheStats::loadExceptionCount))).put((Object)StatNames.TOTAL_LOAD_TIME.getName(), KNNStats.createNodeStat(new KNNInnerCacheStatsSupplier(CacheStats::totalLoadTime))).put((Object)StatNames.EVICTION_COUNT.getName(), KNNStats.createNodeStat(new KNNInnerCacheStatsSupplier(CacheStats::evictionCount))).put((Object)StatNames.GRAPH_MEMORY_USAGE.getName(), KNNStats.createNodeStat(new NativeMemoryCacheManagerSupplier<Long>(NativeMemoryCacheManager::getIndicesSizeInKilobytes))).put((Object)StatNames.GRAPH_MEMORY_USAGE_PERCENTAGE.getName(), KNNStats.createNodeStat(new NativeMemoryCacheManagerSupplier<Float>(NativeMemoryCacheManager::getIndicesSizeAsPercentage))).put((Object)StatNames.INDICES_IN_CACHE.getName(), KNNStats.createNodeStat(new NativeMemoryCacheManagerSupplier<Map>(NativeMemoryCacheManager::getIndicesCacheStats))).put((Object)StatNames.CACHE_CAPACITY_REACHED.getName(), KNNStats.createNodeStat(new NativeMemoryCacheManagerSupplier<Boolean>(NativeMemoryCacheManager::isCacheCapacityReached))).put((Object)StatNames.GRAPH_QUERY_ERRORS.getName(), KNNStats.createNodeStat(new KNNCounterSupplier(KNNCounter.GRAPH_QUERY_ERRORS))).put((Object)StatNames.GRAPH_QUERY_REQUESTS.getName(), KNNStats.createNodeStat(new KNNCounterSupplier(KNNCounter.GRAPH_QUERY_REQUESTS))).put((Object)StatNames.GRAPH_INDEX_ERRORS.getName(), KNNStats.createNodeStat(new KNNCounterSupplier(KNNCounter.GRAPH_INDEX_ERRORS))).put((Object)StatNames.GRAPH_INDEX_REQUESTS.getName(), KNNStats.createNodeStat(new KNNCounterSupplier(KNNCounter.GRAPH_INDEX_REQUESTS))).put((Object)StatNames.CIRCUIT_BREAKER_TRIGGERED.getName(), KNNStats.createClusterStat(new KNNCircuitBreakerSupplier()));
    }

    private void addEngineStats(ImmutableMap.Builder<String, KNNStat<?>> builder) {
        builder.put((Object)StatNames.FAISS_LOADED.getName(), KNNStats.createNodeStat(new LibraryInitializedSupplier(KNNEngine.FAISS))).put((Object)StatNames.NMSLIB_LOADED.getName(), KNNStats.createNodeStat(new LibraryInitializedSupplier(KNNEngine.NMSLIB))).put((Object)StatNames.LUCENE_LOADED.getName(), KNNStats.createNodeStat(new LibraryInitializedSupplier(KNNEngine.LUCENE)));
    }

    private void addScriptStats(ImmutableMap.Builder<String, KNNStat<?>> builder) {
        builder.put((Object)StatNames.SCRIPT_COMPILATIONS.getName(), KNNStats.createNodeStat(new KNNCounterSupplier(KNNCounter.SCRIPT_COMPILATIONS))).put((Object)StatNames.SCRIPT_COMPILATION_ERRORS.getName(), KNNStats.createNodeStat(new KNNCounterSupplier(KNNCounter.SCRIPT_COMPILATION_ERRORS))).put((Object)StatNames.SCRIPT_QUERY_REQUESTS.getName(), KNNStats.createNodeStat(new KNNCounterSupplier(KNNCounter.SCRIPT_QUERY_REQUESTS))).put((Object)StatNames.SCRIPT_QUERY_ERRORS.getName(), KNNStats.createNodeStat(new KNNCounterSupplier(KNNCounter.SCRIPT_QUERY_ERRORS)));
    }

    private void addModelStats(ImmutableMap.Builder<String, KNNStat<?>> builder) {
        builder.put((Object)StatNames.INDEXING_FROM_MODEL_DEGRADED.getName(), KNNStats.createNodeStat(new EventOccurredWithinThresholdSupplier(new ModelIndexingDegradingSupplier(ModelCache::getEvictedDueToSizeAt), KNNConstants.MODEL_CACHE_CAPACITY_ATROPHY_THRESHOLD_IN_MINUTES.intValue(), ChronoUnit.MINUTES))).put((Object)StatNames.MODEL_INDEX_STATUS.getName(), KNNStats.createClusterStat(new ModelIndexStatusSupplier<ClusterHealthStatus>(ModelDao::getHealthStatus))).put((Object)StatNames.TRAINING_REQUESTS.getName(), KNNStats.createNodeStat(new KNNCounterSupplier(KNNCounter.TRAINING_REQUESTS))).put((Object)StatNames.TRAINING_ERRORS.getName(), KNNStats.createNodeStat(new KNNCounterSupplier(KNNCounter.TRAINING_ERRORS))).put((Object)StatNames.TRAINING_MEMORY_USAGE.getName(), KNNStats.createNodeStat(new NativeMemoryCacheManagerSupplier<Long>(NativeMemoryCacheManager::getTrainingSizeInKilobytes))).put((Object)StatNames.TRAINING_MEMORY_USAGE_PERCENTAGE.getName(), KNNStats.createNodeStat(new NativeMemoryCacheManagerSupplier<Float>(NativeMemoryCacheManager::getTrainingSizeAsPercentage)));
    }

    private void addGraphStats(ImmutableMap.Builder<String, KNNStat<?>> builder) {
        builder.put((Object)StatNames.GRAPH_STATS.getName(), KNNStats.createNodeStat(new Supplier<Map<String, Map<String, Object>>>(){

            @Override
            public Map<String, Map<String, Object>> get() {
                return KNNStats.this.createGraphStatsMap();
            }
        }));
    }

    private Map<String, Map<String, Object>> createGraphStatsMap() {
        HashMap<String, Long> mergeMap = new HashMap<String, Long>();
        mergeMap.put(KNNGraphValue.MERGE_CURRENT_OPERATIONS.getName(), KNNGraphValue.MERGE_CURRENT_OPERATIONS.getValue());
        mergeMap.put(KNNGraphValue.MERGE_CURRENT_DOCS.getName(), KNNGraphValue.MERGE_CURRENT_DOCS.getValue());
        mergeMap.put(KNNGraphValue.MERGE_CURRENT_SIZE_IN_BYTES.getName(), KNNGraphValue.MERGE_CURRENT_SIZE_IN_BYTES.getValue());
        mergeMap.put(KNNGraphValue.MERGE_TOTAL_OPERATIONS.getName(), KNNGraphValue.MERGE_TOTAL_OPERATIONS.getValue());
        mergeMap.put(KNNGraphValue.MERGE_TOTAL_TIME_IN_MILLIS.getName(), KNNGraphValue.MERGE_TOTAL_TIME_IN_MILLIS.getValue());
        mergeMap.put(KNNGraphValue.MERGE_TOTAL_DOCS.getName(), KNNGraphValue.MERGE_TOTAL_DOCS.getValue());
        mergeMap.put(KNNGraphValue.MERGE_TOTAL_SIZE_IN_BYTES.getName(), KNNGraphValue.MERGE_TOTAL_SIZE_IN_BYTES.getValue());
        HashMap<String, Long> refreshMap = new HashMap<String, Long>();
        refreshMap.put(KNNGraphValue.REFRESH_TOTAL_OPERATIONS.getName(), KNNGraphValue.REFRESH_TOTAL_OPERATIONS.getValue());
        refreshMap.put(KNNGraphValue.REFRESH_TOTAL_TIME_IN_MILLIS.getName(), KNNGraphValue.REFRESH_TOTAL_TIME_IN_MILLIS.getValue());
        HashMap<String, Map<String, Object>> graphStatsMap = new HashMap<String, Map<String, Object>>();
        graphStatsMap.put(StatNames.MERGE.getName(), mergeMap);
        graphStatsMap.put(StatNames.REFRESH.getName(), refreshMap);
        return graphStatsMap;
    }

    private void addRemoteIndexBuildStats(ImmutableMap.Builder<String, KNNStat<?>> builder) {
        builder.put((Object)StatNames.REMOTE_VECTOR_INDEX_BUILD_STATS.getName(), new KNNStat<Map>(false, this::createRemoteIndexStatsMap));
    }

    private Map<String, Map<String, Object>> createRemoteIndexStatsMap() {
        HashMap<String, Long> clientStatsMap = new HashMap<String, Long>();
        clientStatsMap.put(KNNRemoteIndexBuildValue.BUILD_REQUEST_SUCCESS_COUNT.getName(), KNNRemoteIndexBuildValue.BUILD_REQUEST_SUCCESS_COUNT.getValue());
        clientStatsMap.put(KNNRemoteIndexBuildValue.BUILD_REQUEST_FAILURE_COUNT.getName(), KNNRemoteIndexBuildValue.BUILD_REQUEST_FAILURE_COUNT.getValue());
        clientStatsMap.put(KNNRemoteIndexBuildValue.STATUS_REQUEST_SUCCESS_COUNT.getName(), KNNRemoteIndexBuildValue.STATUS_REQUEST_SUCCESS_COUNT.getValue());
        clientStatsMap.put(KNNRemoteIndexBuildValue.STATUS_REQUEST_FAILURE_COUNT.getName(), KNNRemoteIndexBuildValue.STATUS_REQUEST_FAILURE_COUNT.getValue());
        clientStatsMap.put(KNNRemoteIndexBuildValue.INDEX_BUILD_SUCCESS_COUNT.getName(), KNNRemoteIndexBuildValue.INDEX_BUILD_SUCCESS_COUNT.getValue());
        clientStatsMap.put(KNNRemoteIndexBuildValue.INDEX_BUILD_FAILURE_COUNT.getName(), KNNRemoteIndexBuildValue.INDEX_BUILD_FAILURE_COUNT.getValue());
        clientStatsMap.put(KNNRemoteIndexBuildValue.WAITING_TIME.getName(), KNNRemoteIndexBuildValue.WAITING_TIME.getValue());
        HashMap<String, Long> repoStatsMap = new HashMap<String, Long>();
        repoStatsMap.put(KNNRemoteIndexBuildValue.WRITE_SUCCESS_COUNT.getName(), KNNRemoteIndexBuildValue.WRITE_SUCCESS_COUNT.getValue());
        repoStatsMap.put(KNNRemoteIndexBuildValue.WRITE_FAILURE_COUNT.getName(), KNNRemoteIndexBuildValue.WRITE_FAILURE_COUNT.getValue());
        repoStatsMap.put(KNNRemoteIndexBuildValue.WRITE_TIME.getName(), KNNRemoteIndexBuildValue.WRITE_TIME.getValue());
        repoStatsMap.put(KNNRemoteIndexBuildValue.READ_SUCCESS_COUNT.getName(), KNNRemoteIndexBuildValue.READ_SUCCESS_COUNT.getValue());
        repoStatsMap.put(KNNRemoteIndexBuildValue.READ_FAILURE_COUNT.getName(), KNNRemoteIndexBuildValue.READ_FAILURE_COUNT.getValue());
        repoStatsMap.put(KNNRemoteIndexBuildValue.READ_TIME.getName(), KNNRemoteIndexBuildValue.READ_TIME.getValue());
        HashMap<String, Long> buildStatsMap = new HashMap<String, Long>();
        buildStatsMap.put(KNNRemoteIndexBuildValue.REMOTE_INDEX_BUILD_CURRENT_FLUSH_OPERATIONS.getName(), KNNRemoteIndexBuildValue.REMOTE_INDEX_BUILD_CURRENT_FLUSH_OPERATIONS.getValue());
        buildStatsMap.put(KNNRemoteIndexBuildValue.REMOTE_INDEX_BUILD_CURRENT_MERGE_OPERATIONS.getName(), KNNRemoteIndexBuildValue.REMOTE_INDEX_BUILD_CURRENT_MERGE_OPERATIONS.getValue());
        buildStatsMap.put(KNNRemoteIndexBuildValue.REMOTE_INDEX_BUILD_CURRENT_FLUSH_SIZE.getName(), KNNRemoteIndexBuildValue.REMOTE_INDEX_BUILD_CURRENT_FLUSH_SIZE.getValue());
        buildStatsMap.put(KNNRemoteIndexBuildValue.REMOTE_INDEX_BUILD_CURRENT_MERGE_SIZE.getName(), KNNRemoteIndexBuildValue.REMOTE_INDEX_BUILD_CURRENT_MERGE_SIZE.getValue());
        buildStatsMap.put(KNNRemoteIndexBuildValue.REMOTE_INDEX_BUILD_FLUSH_TIME.getName(), KNNRemoteIndexBuildValue.REMOTE_INDEX_BUILD_FLUSH_TIME.getValue());
        buildStatsMap.put(KNNRemoteIndexBuildValue.REMOTE_INDEX_BUILD_MERGE_TIME.getName(), KNNRemoteIndexBuildValue.REMOTE_INDEX_BUILD_MERGE_TIME.getValue());
        HashMap<String, Map<String, Object>> remoteIndexBuildStatsMap = new HashMap<String, Map<String, Object>>();
        remoteIndexBuildStatsMap.put(StatNames.BUILD_STATS.getName(), buildStatsMap);
        remoteIndexBuildStatsMap.put(StatNames.CLIENT_STATS.getName(), clientStatsMap);
        remoteIndexBuildStatsMap.put(StatNames.REPOSITORY_STATS.getName(), repoStatsMap);
        return remoteIndexBuildStatsMap;
    }

    private static <T> KNNStat<T> createNodeStat(Supplier<T> supplier) {
        return new KNNStat<T>(false, supplier);
    }

    private static <T> KNNStat<T> createClusterStat(Supplier<T> supplier) {
        return new KNNStat<T>(true, supplier);
    }
}

