/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.CapacityBlockStatus;
import software.amazon.awssdk.services.ec2.model.DescribeCapacityBlockStatusRequest;
import software.amazon.awssdk.services.ec2.model.DescribeCapacityBlockStatusResponse;

public class DescribeCapacityBlockStatusPublisher
implements SdkPublisher<DescribeCapacityBlockStatusResponse> {
    private final Ec2AsyncClient client;
    private final DescribeCapacityBlockStatusRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeCapacityBlockStatusPublisher(Ec2AsyncClient client, DescribeCapacityBlockStatusRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeCapacityBlockStatusPublisher(Ec2AsyncClient client, DescribeCapacityBlockStatusRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeCapacityBlockStatusResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeCapacityBlockStatusResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CapacityBlockStatus> capacityBlockStatuses() {
        Function<DescribeCapacityBlockStatusResponse, Iterator> getIterator = response -> {
            if (response != null && response.capacityBlockStatuses() != null) {
                return response.capacityBlockStatuses().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeCapacityBlockStatusResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeCapacityBlockStatusResponseFetcher
    implements AsyncPageFetcher<DescribeCapacityBlockStatusResponse> {
        private DescribeCapacityBlockStatusResponseFetcher() {
        }

        public boolean hasNextPage(DescribeCapacityBlockStatusResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeCapacityBlockStatusResponse> nextPage(DescribeCapacityBlockStatusResponse previousPage) {
            if (previousPage == null) {
                return DescribeCapacityBlockStatusPublisher.this.client.describeCapacityBlockStatus(DescribeCapacityBlockStatusPublisher.this.firstRequest);
            }
            return DescribeCapacityBlockStatusPublisher.this.client.describeCapacityBlockStatus((DescribeCapacityBlockStatusRequest)((Object)DescribeCapacityBlockStatusPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

