"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAIFeaturesSetting = void 0;
var _configSchema = require("@osd/config-schema");
var _i18n = require("@osd/i18n");
var _types = require("../types");
var _constants = require("../../../../core/utils/constants");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const getAIFeaturesSetting = () => {
  return {
    [_constants.ENABLE_AI_FEATURES]: {
      name: _i18n.i18n.translate('core.ui_settings.params.enableAIFeaturesTitle', {
        defaultMessage: 'Enable AI features'
      }),
      value: true,
      description: _i18n.i18n.translate('core.ui_settings.params.enableAIFeaturesText', {
        defaultMessage: 'The setting to enable all AI-powered features in OpenSearch Dashboards.'
      }),
      requiresPageReload: true,
      scope: _types.UiSettingScope.DASHBOARD_ADMIN,
      schema: _configSchema.schema.boolean()
    }
  };
};
exports.getAIFeaturesSetting = getAIFeaturesSetting;