/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.openapidiff.core.compare;

import io.swagger.v3.oas.models.security.OAuthFlows;
import java.util.Map;
import java.util.Optional;
import org.openapitools.openapidiff.core.compare.OpenApiDiff;
import org.openapitools.openapidiff.core.model.ChangedOAuthFlows;
import org.openapitools.openapidiff.core.model.DiffContext;
import org.openapitools.openapidiff.core.utils.ChangedUtils;

public class OAuthFlowsDiff {
    private final OpenApiDiff openApiDiff;

    public OAuthFlowsDiff(OpenApiDiff openApiDiff) {
        this.openApiDiff = openApiDiff;
    }

    private static Map<String, Object> getExtensions(OAuthFlows oAuthFlow) {
        return Optional.ofNullable(oAuthFlow).map(OAuthFlows::getExtensions).orElse(null);
    }

    public Optional<ChangedOAuthFlows> diff(OAuthFlows left, OAuthFlows right, DiffContext context) {
        ChangedOAuthFlows changedOAuthFlows = new ChangedOAuthFlows(left, right);
        if (left != null && right != null) {
            this.openApiDiff.getOAuthFlowDiff().diff(left.getImplicit(), right.getImplicit(), context).ifPresent(changedOAuthFlows::setImplicitOAuthFlow);
            this.openApiDiff.getOAuthFlowDiff().diff(left.getPassword(), right.getPassword(), context).ifPresent(changedOAuthFlows::setPasswordOAuthFlow);
            this.openApiDiff.getOAuthFlowDiff().diff(left.getClientCredentials(), right.getClientCredentials(), context).ifPresent(changedOAuthFlows::setClientCredentialOAuthFlow);
            this.openApiDiff.getOAuthFlowDiff().diff(left.getAuthorizationCode(), right.getAuthorizationCode(), context).ifPresent(changedOAuthFlows::setAuthorizationCodeOAuthFlow);
        }
        this.openApiDiff.getExtensionsDiff().diff(OAuthFlowsDiff.getExtensions(left), OAuthFlowsDiff.getExtensions(right)).ifPresent(changedOAuthFlows::setExtensions);
        return ChangedUtils.isChanged(changedOAuthFlows);
    }
}

