/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.swift.tasks;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.IgnoreEmptyDirectories;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.WorkResult;
import org.gradle.internal.Cast;
import org.gradle.internal.file.Deleter;
import org.gradle.internal.operations.logging.BuildOperationLogger;
import org.gradle.internal.operations.logging.BuildOperationLoggerFactory;
import org.gradle.language.base.compile.CompilerVersion;
import org.gradle.language.base.internal.compile.CompileSpec;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.language.base.internal.compile.VersionAwareCompiler;
import org.gradle.language.swift.SwiftVersion;
import org.gradle.language.swift.tasks.internal.DefaultSwiftCompileSpec;
import org.gradle.nativeplatform.internal.BuildOperationLoggingCompilerDecorator;
import org.gradle.nativeplatform.internal.CompilerOutputFileNamingSchemeFactory;
import org.gradle.nativeplatform.platform.NativePlatform;
import org.gradle.nativeplatform.platform.internal.NativePlatformInternal;
import org.gradle.nativeplatform.toolchain.NativeToolChain;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainInternal;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;
import org.gradle.nativeplatform.toolchain.internal.compilespec.SwiftCompileSpec;
import org.gradle.nativeplatform.toolchain.internal.swift.IncrementalSwiftCompiler;
import org.gradle.work.ChangeType;
import org.gradle.work.FileChange;
import org.gradle.work.InputChanges;

@CacheableTask
public abstract class SwiftCompile
extends DefaultTask {
    private final CompilerOutputFileNamingSchemeFactory compilerOutputFileNamingSchemeFactory;
    private final Deleter deleter;
    private final Property<Boolean> debuggable;
    private final Property<Boolean> optimize;

    @Inject
    public SwiftCompile(CompilerOutputFileNamingSchemeFactory compilerOutputFileNamingSchemeFactory, Deleter deleter) {
        this.compilerOutputFileNamingSchemeFactory = compilerOutputFileNamingSchemeFactory;
        this.deleter = deleter;
        ObjectFactory objectFactory = this.getProject().getObjects();
        this.debuggable = objectFactory.property(Boolean.class).value((Object)false);
        this.optimize = objectFactory.property(Boolean.class).value((Object)false);
    }

    @Internal
    public abstract Property<NativeToolChain> getToolChain();

    @Nested
    public abstract Property<NativePlatform> getTargetPlatform();

    @InputFiles
    @SkipWhenEmpty
    @IgnoreEmptyDirectories
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public abstract ConfigurableFileCollection getSource();

    @Input
    public abstract ListProperty<String> getMacros();

    @Internal
    public boolean isDebuggable() {
        return (Boolean)this.getDebuggable().get();
    }

    @Input
    public Property<Boolean> getDebuggable() {
        return this.debuggable;
    }

    @Internal
    public boolean isOptimized() {
        return (Boolean)this.getOptimized().get();
    }

    @Input
    public Property<Boolean> getOptimized() {
        return this.optimize;
    }

    @Input
    public abstract ListProperty<String> getCompilerArgs();

    @OutputDirectory
    public abstract DirectoryProperty getObjectFileDir();

    @OutputFile
    public abstract RegularFileProperty getModuleFile();

    @Optional
    @Input
    public abstract Property<String> getModuleName();

    @InputFiles
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    public abstract ConfigurableFileCollection getModules();

    @Input
    public abstract Property<SwiftVersion> getSourceCompatibility();

    @Nested
    protected CompilerVersion getCompilerVersion() {
        return ((VersionAwareCompiler)this.createCompiler()).getVersion();
    }

    private Compiler<SwiftCompileSpec> createCompiler() {
        NativePlatformInternal targetPlatform = (NativePlatformInternal)Cast.cast(NativePlatformInternal.class, (Object)((NativePlatform)this.getTargetPlatform().get()));
        NativeToolChainInternal toolChain = (NativeToolChainInternal)Cast.cast(NativeToolChainInternal.class, (Object)((NativeToolChain)this.getToolChain().get()));
        PlatformToolProvider toolProvider = toolChain.select(targetPlatform);
        return toolProvider.newCompiler(SwiftCompileSpec.class);
    }

    @TaskAction
    protected void compile(InputChanges inputs) {
        ArrayList<File> removedFiles = new ArrayList<File>();
        HashSet<File> changedFiles = new HashSet<File>();
        boolean isIncremental = inputs.isIncremental();
        if (isIncremental) {
            for (FileChange fileChange : inputs.getFileChanges((FileCollection)this.getSource())) {
                if (fileChange.getChangeType() == ChangeType.REMOVED) {
                    removedFiles.add(fileChange.getFile());
                    continue;
                }
                changedFiles.add(fileChange.getFile());
            }
        }
        BuildOperationLogger operationLogger = ((BuildOperationLoggerFactory)this.getServices().get(BuildOperationLoggerFactory.class)).newOperationLogger(this.getName(), this.getTemporaryDir());
        NativePlatformInternal targetPlatform = (NativePlatformInternal)Cast.cast(NativePlatformInternal.class, (Object)((NativePlatform)this.getTargetPlatform().get()));
        SwiftCompileSpec spec = this.createSpec(operationLogger, isIncremental, changedFiles, removedFiles, targetPlatform);
        IncrementalSwiftCompiler baseCompiler = new IncrementalSwiftCompiler(this.createCompiler(), this.getOutputs(), this.compilerOutputFileNamingSchemeFactory, this.deleter);
        Compiler loggingCompiler = BuildOperationLoggingCompilerDecorator.wrap((Compiler)baseCompiler);
        WorkResult result = loggingCompiler.execute((CompileSpec)spec);
        this.setDidWork(result.getDidWork());
    }

    private SwiftCompileSpec createSpec(BuildOperationLogger operationLogger, boolean isIncremental, Collection<File> changedFiles, Collection<File> removedFiles, NativePlatformInternal targetPlatform) {
        DefaultSwiftCompileSpec spec = new DefaultSwiftCompileSpec();
        spec.setModuleName((String)this.getModuleName().getOrNull());
        spec.setModuleFile(((RegularFile)this.getModuleFile().get()).getAsFile());
        for (File file : this.getModules().getFiles()) {
            if (file.isFile()) {
                spec.include(new File[]{file.getParentFile()});
                continue;
            }
            spec.include(new File[]{file});
        }
        spec.setTargetPlatform((NativePlatform)targetPlatform);
        spec.setTempDir(this.getTemporaryDir());
        spec.setObjectFileDir(((Directory)this.getObjectFileDir().get()).getAsFile());
        spec.source((Iterable)this.getSource());
        spec.setRemovedSourceFiles(removedFiles);
        spec.setChangedFiles(changedFiles);
        LinkedHashMap<String, Object> macros = new LinkedHashMap<String, Object>();
        for (String macro : (List)this.getMacros().get()) {
            macros.put(macro, null);
        }
        spec.setMacros(macros);
        spec.args((List)this.getCompilerArgs().get());
        spec.setDebuggable((Boolean)this.getDebuggable().get());
        spec.setOptimized((Boolean)this.getOptimized().get());
        spec.setIncrementalCompile(isIncremental);
        spec.setOperationLogger(operationLogger);
        spec.setSourceCompatibility((SwiftVersion)this.getSourceCompatibility().get());
        return spec;
    }
}

