/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.LinkedStringList;
import io.sf.carte.doc.StringList;
import io.sf.carte.doc.style.css.StyleFormattingContext;
import io.sf.carte.doc.style.css.nsac.CSSBudgetException;
import io.sf.carte.doc.style.css.nsac.CSSErrorHandler;
import io.sf.carte.doc.style.css.nsac.CSSException;
import io.sf.carte.doc.style.css.nsac.CSSHandler;
import io.sf.carte.doc.style.css.nsac.CSSNamespaceParseException;
import io.sf.carte.doc.style.css.nsac.CSSParseException;
import io.sf.carte.doc.style.css.nsac.Parser;
import io.sf.carte.doc.style.css.om.AbstractCSSRule;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSStyleSheet;
import io.sf.carte.doc.style.css.om.CSSOMParser;
import io.sf.carte.doc.style.css.om.CSSRuleArrayList;
import io.sf.carte.doc.style.css.om.DefaultStyleFormattingContext;
import io.sf.carte.doc.style.css.om.SheetHandler;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import org.w3c.dom.DOMException;

abstract class BaseCSSRule
extends AbstractCSSRule {
    private static final long serialVersionUID = 1L;
    private AbstractCSSStyleSheet parentSheet = null;
    private AbstractCSSRule parentRule = null;
    private final short ruleType;
    private final byte ruleOrigin;
    private StringList precedingComments = null;
    private StringList trailingComments = null;

    protected BaseCSSRule(AbstractCSSStyleSheet parentSheet, short type, byte origin) {
        this.parentSheet = parentSheet;
        this.ruleType = type;
        this.ruleOrigin = origin;
    }

    protected BaseCSSRule(BaseCSSRule copyMe) {
        this(copyMe.parentSheet, copyMe.ruleType, copyMe.ruleOrigin);
        this.precedingComments = copyMe.precedingComments;
        this.trailingComments = copyMe.trailingComments;
    }

    @Override
    public short getType() {
        return this.ruleType;
    }

    @Override
    public AbstractCSSStyleSheet getParentStyleSheet() {
        return this.parentSheet != null ? this.parentSheet : (this.parentRule != null ? this.parentRule.getParentStyleSheet() : null);
    }

    @Override
    void setParentStyleSheet(AbstractCSSStyleSheet parentSheet) {
        this.parentSheet = parentSheet;
    }

    protected Parser createSACParser() throws DOMException {
        Parser parser = this.getParentStyleSheet() != null ? this.getParentStyleSheet().getStyleSheetFactory().createSACParser() : new CSSOMParser();
        return parser;
    }

    @Override
    public AbstractCSSRule getParentRule() {
        return this.parentRule;
    }

    @Override
    public void setParentRule(AbstractCSSRule parent) {
        this.parentRule = parent;
    }

    @Override
    public byte getOrigin() {
        return this.ruleOrigin;
    }

    @Override
    public void enablePrecedingComments() {
        if (this.precedingComments == null) {
            this.precedingComments = new LinkedStringList();
        }
    }

    @Override
    public StringList getPrecedingComments() {
        return this.precedingComments;
    }

    @Override
    void setPrecedingComments(StringList precedingComments) {
        this.precedingComments = precedingComments;
    }

    @Override
    public void enableTrailingComments() {
        if (this.trailingComments == null) {
            this.trailingComments = new LinkedStringList();
        }
    }

    @Override
    public StringList getTrailingComments() {
        return this.trailingComments;
    }

    @Override
    void setTrailingComments(StringList trailingComments) {
        this.trailingComments = trailingComments;
    }

    void resetComments() {
        this.precedingComments = null;
        this.trailingComments = null;
    }

    @Override
    boolean hasErrorsOrWarnings() {
        return false;
    }

    @Override
    public String getMinifiedCssText() {
        return this.getCssText();
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        AbstractCSSStyleSheet parentSS = this.getParentStyleSheet();
        if (parentSS == null) {
            throw new DOMException(11, "This rule must be added to a sheet first");
        }
        BaseCSSStyleSheet css = (BaseCSSStyleSheet)parentSS.getStyleSheetFactory().createRuleStyleSheet(this, null, null);
        SheetHandler handler = css.createSheetHandler(this.getOrigin(), (short)2);
        StringReader re = new StringReader(cssText);
        try {
            this.parseRule((Reader)re, handler);
        }
        catch (IOException e) {
            throw new DOMException(11, e.getMessage());
        }
        CSSRuleArrayList parsedRules = css.getCssRules();
        int len = parsedRules.getLength();
        if (len > 1) {
            throw new DOMException(13, "Attempted to parse more than one rule inside this one");
        }
        if (len == 1) {
            AbstractCSSRule firstRule = (AbstractCSSRule)parsedRules.item(0);
            if (firstRule.getType() != this.getType()) {
                throw new DOMException(13, "Attempted to parse a rule of type " + firstRule.getType());
            }
            this.setRule(firstRule);
            if (css.hasRuleErrorsOrWarnings()) {
                parentSS.getErrorHandler().mergeState(css.getErrorHandler());
            }
        } else {
            this.clear();
        }
    }

    abstract void clear();

    void parseRule(Reader reader, CSSHandler handler) throws IOException {
        Parser parser = this.createSACParser();
        AllowWarningsRuleErrorHandler errorHandler = new AllowWarningsRuleErrorHandler();
        parser.setDocumentHandler(handler);
        parser.setErrorHandler(errorHandler);
        this.parseRule(reader, parser);
    }

    void parseRule(Reader reader, Parser parser) throws DOMException, IOException {
        try {
            parser.parseRule(reader);
        }
        catch (CSSNamespaceParseException e) {
            DOMException ex = new DOMException(14, e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        catch (CSSBudgetException e) {
            DOMException ex = new DOMException(9, e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        catch (CSSParseException e) {
            DOMException ex = new DOMException(12, "Parse error at [" + e.getLineNumber() + ',' + e.getColumnNumber() + "]: " + e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        catch (CSSException e) {
            DOMException ex = new DOMException(15, e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        catch (DOMException e) {
            throw e;
        }
        catch (RuntimeException e) {
            String href;
            String message = e.getMessage();
            AbstractCSSStyleSheet parentSS = this.getParentStyleSheet();
            if (parentSS != null && (href = parentSS.getHref()) != null) {
                message = "Error in stylesheet at " + href + ": " + message;
            }
            DOMException ex = new DOMException(11, message);
            ex.initCause(e);
            throw ex;
        }
    }

    abstract void setRule(AbstractCSSRule var1);

    protected StyleFormattingContext getStyleFormattingContext() {
        AbstractCSSStyleSheet sheet = this.getParentStyleSheet();
        StyleFormattingContext context = sheet != null ? sheet.getStyleSheetFactory().getStyleFormattingFactory().createStyleFormattingContext() : new DefaultStyleFormattingContext();
        return context;
    }

    protected URL getURL(String uri) throws MalformedURLException {
        URL url;
        if (uri.length() == 0) {
            throw new MalformedURLException("Empty URI");
        }
        String phref = this.getParentStyleSheet().getHref();
        if (phref != null) {
            URL pUrl;
            try {
                pUrl = new URL(phref);
            }
            catch (MalformedURLException e) {
                return new URL(uri);
            }
            url = new URL(pUrl, uri);
        } else {
            url = new URL(uri);
        }
        return url;
    }

    class AllowWarningsRuleErrorHandler
    implements CSSErrorHandler {
        AllowWarningsRuleErrorHandler() {
        }

        @Override
        public void warning(CSSParseException exception) throws CSSParseException {
            AbstractCSSStyleSheet sheet = BaseCSSRule.this.getParentStyleSheet();
            if (sheet != null) {
                sheet.getErrorHandler().ruleParseWarning(BaseCSSRule.this, exception);
            }
        }

        @Override
        public void error(CSSParseException exception) throws CSSParseException {
            throw exception;
        }
    }
}

