﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/autoscaling/AutoScaling_EXPORTS.h>
#include <aws/autoscaling/model/Instance.h>
#include <aws/autoscaling/model/ResponseMetadata.h>
#include <aws/autoscaling/model/WarmPoolConfiguration.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Xml {
class XmlDocument;
}  // namespace Xml
}  // namespace Utils
namespace AutoScaling {
namespace Model {
class DescribeWarmPoolResult {
 public:
  AWS_AUTOSCALING_API DescribeWarmPoolResult() = default;
  AWS_AUTOSCALING_API DescribeWarmPoolResult(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);
  AWS_AUTOSCALING_API DescribeWarmPoolResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);

  ///@{
  /**
   * <p>The warm pool configuration details. </p>
   */
  inline const WarmPoolConfiguration& GetWarmPoolConfiguration() const { return m_warmPoolConfiguration; }
  template <typename WarmPoolConfigurationT = WarmPoolConfiguration>
  void SetWarmPoolConfiguration(WarmPoolConfigurationT&& value) {
    m_warmPoolConfigurationHasBeenSet = true;
    m_warmPoolConfiguration = std::forward<WarmPoolConfigurationT>(value);
  }
  template <typename WarmPoolConfigurationT = WarmPoolConfiguration>
  DescribeWarmPoolResult& WithWarmPoolConfiguration(WarmPoolConfigurationT&& value) {
    SetWarmPoolConfiguration(std::forward<WarmPoolConfigurationT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The instances that are currently in the warm pool.</p>
   */
  inline const Aws::Vector<Instance>& GetInstances() const { return m_instances; }
  template <typename InstancesT = Aws::Vector<Instance>>
  void SetInstances(InstancesT&& value) {
    m_instancesHasBeenSet = true;
    m_instances = std::forward<InstancesT>(value);
  }
  template <typename InstancesT = Aws::Vector<Instance>>
  DescribeWarmPoolResult& WithInstances(InstancesT&& value) {
    SetInstances(std::forward<InstancesT>(value));
    return *this;
  }
  template <typename InstancesT = Instance>
  DescribeWarmPoolResult& AddInstances(InstancesT&& value) {
    m_instancesHasBeenSet = true;
    m_instances.emplace_back(std::forward<InstancesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>This string indicates that the response contains more items than can be
   * returned in a single response. To receive additional items, specify this string
   * for the <code>NextToken</code> value when requesting the next set of items. This
   * value is null when there are no more items to return.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  DescribeWarmPoolResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const ResponseMetadata& GetResponseMetadata() const { return m_responseMetadata; }
  template <typename ResponseMetadataT = ResponseMetadata>
  void SetResponseMetadata(ResponseMetadataT&& value) {
    m_responseMetadataHasBeenSet = true;
    m_responseMetadata = std::forward<ResponseMetadataT>(value);
  }
  template <typename ResponseMetadataT = ResponseMetadata>
  DescribeWarmPoolResult& WithResponseMetadata(ResponseMetadataT&& value) {
    SetResponseMetadata(std::forward<ResponseMetadataT>(value));
    return *this;
  }
  ///@}
 private:
  WarmPoolConfiguration m_warmPoolConfiguration;
  bool m_warmPoolConfigurationHasBeenSet = false;

  Aws::Vector<Instance> m_instances;
  bool m_instancesHasBeenSet = false;

  Aws::String m_nextToken;
  bool m_nextTokenHasBeenSet = false;

  ResponseMetadata m_responseMetadata;
  bool m_responseMetadataHasBeenSet = false;
};

}  // namespace Model
}  // namespace AutoScaling
}  // namespace Aws
