/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.similarities;

import org.apache.lucene.misc.SweetSpotSimilarity;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.search.similarities.ClassicSimilarityFactory;

public class SweetSpotSimilarityFactory
extends ClassicSimilarityFactory {
    private Integer ln_min;
    private Integer ln_max;
    private Float ln_steep;
    private Float hyper_min;
    private Float hyper_max;
    private Double hyper_base;
    private Float hyper_offset;
    private Float baseline_base;
    private Float baseline_min;

    @Override
    public void init(SolrParams params) {
        super.init(params);
        this.ln_min = params.getInt("lengthNormMin");
        this.ln_max = params.getInt("lengthNormMax");
        this.ln_steep = params.getFloat("lengthNormSteepness");
        if (!SweetSpotSimilarityFactory.allOrNoneNull(this.ln_min, this.ln_max, this.ln_steep)) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Overriding default lengthNorm settings requires all to be specified: lengthNormMin, lengthNormMax, lengthNormSteepness");
        }
        this.hyper_min = params.getFloat("hyperbolicTfMin");
        this.hyper_max = params.getFloat("hyperbolicTfMax");
        this.hyper_base = params.getDouble("hyperbolicTfBase");
        this.hyper_offset = params.getFloat("hyperbolicTfOffset");
        if (!SweetSpotSimilarityFactory.allOrNoneNull(this.hyper_min, this.hyper_max, this.hyper_base, this.hyper_offset)) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Overriding default hyperbolicTf settings requires all to be specified: hyperbolicTfMin, hyperbolicTfMax, hyperbolicTfBase, hyperbolicTfOffset");
        }
        this.baseline_base = params.getFloat("baselineTfBase");
        this.baseline_min = params.getFloat("baselineTfMin");
        if (!SweetSpotSimilarityFactory.allOrNoneNull(this.baseline_min, this.baseline_base)) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Overriding default baselineTf settings requires all to be specified: baselineTfBase, baselineTfMin");
        }
        if (null != this.hyper_min && null != this.baseline_min) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Can not mix hyperbolicTf settings with baselineTf settings");
        }
    }

    @Override
    public Similarity getSimilarity() {
        HyperbolicSweetSpotSimilarity sim;
        HyperbolicSweetSpotSimilarity hyperbolicSweetSpotSimilarity = sim = null != this.hyper_min ? new HyperbolicSweetSpotSimilarity(this.discountOverlaps) : new SweetSpotSimilarity(this.discountOverlaps);
        if (null != this.ln_min) {
            sim.setLengthNormFactors(this.ln_min, this.ln_max, this.ln_steep.floatValue());
        }
        if (null != this.hyper_min) {
            sim.setHyperbolicTfFactors(this.hyper_min.floatValue(), this.hyper_max.floatValue(), this.hyper_base, this.hyper_offset.floatValue());
        }
        if (null != this.baseline_min) {
            sim.setBaselineTfFactors(this.baseline_base.floatValue(), this.baseline_min.floatValue());
        }
        return sim;
    }

    private static boolean allOrNoneNull(Object ... args) {
        int nulls = 0;
        int objs = 0;
        for (Object o : args) {
            ++objs;
            if (null != o) continue;
            ++nulls;
        }
        return 0 == nulls || nulls == objs;
    }

    private static final class HyperbolicSweetSpotSimilarity
    extends SweetSpotSimilarity {
        private HyperbolicSweetSpotSimilarity(boolean discountOverlaps) {
            super(discountOverlaps);
        }

        public float tf(float freq) {
            return this.hyperbolicTf(freq);
        }
    }
}

