/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cli;

import java.lang.invoke.MethodHandles;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.solr.cli.SolrCLI;
import org.apache.solr.cli.ToolBase;
import org.apache.solr.cli.ToolRuntime;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.packagemanager.PackageUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkMkrootTool
extends ToolBase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public ZkMkrootTool(ToolRuntime runtime) {
        super(runtime);
    }

    @Override
    public List<Option> getOptions() {
        return List.of(Option.builder().longOpt("fail-on-exists").hasArg().required(false).desc("Raise an error if the root exists.  Defaults to false.").build(), SolrCLI.OPTION_SOLRURL, SolrCLI.OPTION_SOLRURL_DEPRECATED, SolrCLI.OPTION_SOLRURL_DEPRECATED_SHORT, SolrCLI.OPTION_ZKHOST, SolrCLI.OPTION_ZKHOST_DEPRECATED);
    }

    @Override
    public String getName() {
        return "mkroot";
    }

    @Override
    public String getUsage() {
        return "bin/solr zk mkroot [--fail-on-exists <arg>] [-s <HOST>] [-u <credentials>] [-v] [-z <HOST>] path";
    }

    @Override
    public String getHeader() {
        StringBuilder sb = new StringBuilder();
        PackageUtils.format(sb, "mkroot makes a znode in Zookeeper with no data. Can be used to make a path of arbitrary");
        PackageUtils.format(sb, "depth but primarily intended to create a 'chroot'.\n\nList of options:");
        return sb.toString();
    }

    @Override
    public void runImpl(CommandLine cli) throws Exception {
        SolrCLI.raiseLogLevelUnlessVerbose(cli);
        String zkHost = SolrCLI.getZkHost(cli);
        String znode = cli.getArgs()[0];
        boolean failOnExists = cli.hasOption("fail-on-exists");
        try (SolrZkClient zkClient = SolrCLI.getSolrZkClient(cli, zkHost);){
            this.echoIfVerbose("\nConnecting to ZooKeeper at " + zkHost + " ...", cli);
            this.echo("Creating ZooKeeper path " + znode + " on ZooKeeper at " + zkHost);
            zkClient.makePath(znode, failOnExists, true);
        }
        catch (Exception e) {
            log.error("Could not complete mkroot operation for reason: ", (Throwable)e);
            throw e;
        }
    }
}

