/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.io.Serializable;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import org.semanticweb.owlapi.vocab.XSDVocabulary;
import uk.ac.manchester.cs.owl.owlapi.OWL2DatatypeImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLAnnotationImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLAnnotationPropertyImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLClassImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDataFactoryInternals;
import uk.ac.manchester.cs.owl.owlapi.OWLDataPropertyImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDatatypeImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLLiteralImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLLiteralImplBoolean;
import uk.ac.manchester.cs.owl.owlapi.OWLLiteralImplDouble;
import uk.ac.manchester.cs.owl.owlapi.OWLLiteralImplFloat;
import uk.ac.manchester.cs.owl.owlapi.OWLLiteralImplInteger;
import uk.ac.manchester.cs.owl.owlapi.OWLLiteralImplNoCompression;
import uk.ac.manchester.cs.owl.owlapi.OWLLiteralImplPlain;
import uk.ac.manchester.cs.owl.owlapi.OWLLiteralImplString;
import uk.ac.manchester.cs.owl.owlapi.OWLNamedIndividualImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectImplWithoutEntityAndAnonCaching;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectPropertyImpl;

public class OWLDataFactoryInternalsImplNoCache
implements OWLDataFactoryInternals,
Serializable {
    private static final long serialVersionUID = 40000L;
    @Nonnull
    private static final OWLDatatype PLAIN = new OWL2DatatypeImpl(OWL2Datatype.RDF_PLAIN_LITERAL);
    @Nonnull
    private static final OWLDatatype XSDBOOLEAN = new OWL2DatatypeImpl(OWL2Datatype.XSD_BOOLEAN);
    @Nonnull
    private static final OWLDatatype XSDDOUBLE = new OWL2DatatypeImpl(OWL2Datatype.XSD_DOUBLE);
    @Nonnull
    private static final OWLDatatype XSDFLOAT = new OWL2DatatypeImpl(OWL2Datatype.XSD_FLOAT);
    @Nonnull
    private static final OWLDatatype XSDINTEGER = new OWL2DatatypeImpl(OWL2Datatype.XSD_INTEGER);
    @Nonnull
    private static final OWLDatatype RDFSLITERAL = new OWL2DatatypeImpl(OWL2Datatype.RDFS_LITERAL);
    @Nonnull
    private static final OWLLiteral TRUELITERAL = new OWLLiteralImplBoolean(true, XSDBOOLEAN);
    @Nonnull
    private static final OWLLiteral FALSELITERAL = new OWLLiteralImplBoolean(false, XSDBOOLEAN);
    @Nullable
    private OWLLiteral negativeFloatZero;
    private final boolean useCompression;

    public OWLDataFactoryInternalsImplNoCache(boolean useCompression) {
        this.useCompression = useCompression;
    }

    @Override
    public void purge() {
    }

    @Override
    public OWLClass getOWLClass(IRI iri) {
        return new OWLClassImpl(iri);
    }

    @Override
    public OWLObjectProperty getOWLObjectProperty(IRI iri) {
        return new OWLObjectPropertyImpl(iri);
    }

    @Override
    public OWLDataProperty getOWLDataProperty(IRI iri) {
        return new OWLDataPropertyImpl(iri);
    }

    @Override
    public OWLNamedIndividual getOWLNamedIndividual(IRI iri) {
        return new OWLNamedIndividualImpl(iri);
    }

    @Override
    public OWLDatatype getOWLDatatype(IRI iri) {
        return new OWLDatatypeImpl(iri);
    }

    @Override
    public OWLAnnotationProperty getOWLAnnotationProperty(IRI iri) {
        return new OWLAnnotationPropertyImpl(iri);
    }

    @Override
    public OWLLiteral getOWLLiteral(float value) {
        return new OWLLiteralImplFloat(value, this.getFloatOWLDatatype());
    }

    @Override
    public OWLLiteral getOWLLiteral(@Nonnull String value) {
        if (this.useCompression) {
            return new OWLLiteralImpl(value, "", this.getOWLDatatype(XSDVocabulary.STRING.getIRI()));
        }
        return new OWLLiteralImplString(value);
    }

    @Override
    public OWLLiteral getOWLLiteral(String literal, @Nullable String lang) {
        String normalisedLang = lang == null ? "" : lang.trim().toLowerCase(Locale.ENGLISH);
        if (this.useCompression) {
            return new OWLLiteralImpl(literal, normalisedLang, null);
        }
        return new OWLLiteralImplPlain(literal, normalisedLang);
    }

    @Override
    public OWLLiteral getOWLLiteral(int value) {
        return new OWLLiteralImplInteger(value, this.getIntegerOWLDatatype());
    }

    @Override
    public OWLLiteral getOWLLiteral(boolean value) {
        return value ? TRUELITERAL : FALSELITERAL;
    }

    @Override
    public OWLLiteral getOWLLiteral(double value) {
        return new OWLLiteralImplDouble(value, this.getDoubleOWLDatatype());
    }

    @Override
    public OWLLiteral getOWLLiteral(@Nonnull String lexicalValue, @Nonnull OWLDatatype datatype) {
        OWLLiteral literal;
        if (datatype.isRDFPlainLiteral()) {
            int sep = lexicalValue.lastIndexOf(64);
            if (sep != -1) {
                String lex = lexicalValue.substring(0, sep);
                String lang = lexicalValue.substring(sep + 1);
                literal = this.getBasicLiteral(lex, lang, this.getRDFPlainLiteral());
            } else {
                literal = this.getBasicLiteral(lexicalValue, datatype);
            }
        } else {
            try {
                if (datatype.isString()) {
                    literal = this.getOWLLiteral(lexicalValue);
                } else if (datatype.isBoolean()) {
                    literal = this.getOWLLiteral(OWLDataFactoryInternalsImplNoCache.isBooleanTrueValue(lexicalValue.trim()));
                } else if (datatype.isFloat()) {
                    if (lexicalValue.trim().equals("-0.0")) {
                        if (this.negativeFloatZero == null) {
                            this.negativeFloatZero = this.getBasicLiteral("-0.0", XSDFLOAT);
                        }
                        literal = this.negativeFloatZero;
                    } else {
                        try {
                            float f = Float.parseFloat(lexicalValue);
                            literal = this.getOWLLiteral(f);
                        }
                        catch (NumberFormatException e) {
                            literal = this.getBasicLiteral(lexicalValue, datatype);
                        }
                    }
                } else if (datatype.isDouble()) {
                    literal = this.getOWLLiteral(Double.parseDouble(lexicalValue));
                } else if (datatype.isInteger()) {
                    if (lexicalValue.trim().isEmpty()) {
                        literal = this.getBasicLiteral(lexicalValue, datatype);
                    } else if (lexicalValue.trim().charAt(0) == '0') {
                        literal = this.getBasicLiteral(lexicalValue, this.getIntegerOWLDatatype());
                    } else {
                        try {
                            literal = this.getOWLLiteral(Integer.parseInt(lexicalValue));
                        }
                        catch (NumberFormatException ex) {
                            literal = this.getBasicLiteral(lexicalValue, datatype);
                        }
                    }
                } else {
                    literal = this.getBasicLiteral(lexicalValue, datatype);
                }
            }
            catch (NumberFormatException e) {
                literal = this.getBasicLiteral(lexicalValue, datatype);
            }
        }
        return literal;
    }

    @Nonnull
    protected OWLLiteral getBasicLiteral(@Nonnull String lexicalValue, OWLDatatype datatype) {
        return this.getBasicLiteral(lexicalValue, "", datatype);
    }

    @Nonnull
    protected OWLLiteral getBasicLiteral(@Nonnull String lexicalValue, String lang, OWLDatatype datatype) {
        OWLObjectImplWithoutEntityAndAnonCaching literal = null;
        literal = this.useCompression ? (datatype == null || datatype.isRDFPlainLiteral() ? new OWLLiteralImplPlain(lexicalValue, lang) : new OWLLiteralImpl(lexicalValue, lang, datatype)) : new OWLLiteralImplNoCompression(lexicalValue, lang, datatype);
        return literal;
    }

    private static boolean isBooleanTrueValue(@Nonnull String lexicalValue) {
        return lexicalValue.equals("1") || lexicalValue.equals("true");
    }

    @Override
    public OWLDatatype getTopDatatype() {
        return RDFSLITERAL;
    }

    @Override
    public OWLDatatype getIntegerOWLDatatype() {
        return XSDINTEGER;
    }

    @Override
    public OWLDatatype getFloatOWLDatatype() {
        return XSDFLOAT;
    }

    @Override
    public OWLDatatype getDoubleOWLDatatype() {
        return XSDDOUBLE;
    }

    @Override
    public OWLDatatype getBooleanOWLDatatype() {
        return XSDBOOLEAN;
    }

    @Override
    public OWLDatatype getRDFPlainLiteral() {
        return PLAIN;
    }

    @Override
    public OWLAnnotation getOWLAnnotation(OWLAnnotationProperty property, OWLAnnotationValue value, @Nonnull Set<? extends OWLAnnotation> annotations) {
        return new OWLAnnotationImpl(property, value, annotations);
    }
}

