/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.mapping;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class TextIndexPrefixes
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, TextIndexPrefixes> {
    private final int maxChars;
    private final int minChars;
    public static final JsonpDeserializer<TextIndexPrefixes> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TextIndexPrefixes::setupTextIndexPrefixesDeserializer);

    private TextIndexPrefixes(Builder builder) {
        this.maxChars = ApiTypeHelper.requireNonNull(builder.maxChars, this, "maxChars");
        this.minChars = ApiTypeHelper.requireNonNull(builder.minChars, this, "minChars");
    }

    public static TextIndexPrefixes of(Function<Builder, ObjectBuilder<TextIndexPrefixes>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int maxChars() {
        return this.maxChars;
    }

    public final int minChars() {
        return this.minChars;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("max_chars");
        generator.write(this.maxChars);
        generator.writeKey("min_chars");
        generator.write(this.minChars);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupTextIndexPrefixesDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::maxChars, JsonpDeserializer.integerDeserializer(), "max_chars");
        op.add(Builder::minChars, JsonpDeserializer.integerDeserializer(), "min_chars");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Integer.hashCode(this.maxChars);
        result = 31 * result + Integer.hashCode(this.minChars);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextIndexPrefixes other = (TextIndexPrefixes)o;
        return this.maxChars == other.maxChars && this.minChars == other.minChars;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, TextIndexPrefixes> {
        private Integer maxChars;
        private Integer minChars;

        public Builder() {
        }

        private Builder(TextIndexPrefixes o) {
            this.maxChars = o.maxChars;
            this.minChars = o.minChars;
        }

        private Builder(Builder o) {
            this.maxChars = o.maxChars;
            this.minChars = o.minChars;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder maxChars(int value) {
            this.maxChars = value;
            return this;
        }

        @Nonnull
        public final Builder minChars(int value) {
            this.minChars = value;
            return this;
        }

        @Override
        @Nonnull
        public TextIndexPrefixes build() {
            this._checkSingleUse();
            return new TextIndexPrefixes(this);
        }
    }
}

