wsn = {
	"elements": {
		"nodes": [
			{
				"data": {
					"id": "86f48f58-145d-92cc-0d33-aaf639984733",
					"bbox": {
						"x": 918.6946839627489,
						"y": 268.1553060642376,
						"w": 20,
						"h": 40
					},
					"class": "macromolecule",
					"label": "a6",
					"statesandinfos": [],
					"language": "PD",
					"border-width": 0.000,
					"border-color": "#555555",
					"background-color": "#ffffff",
					"background-opacity": 1,
					"background-image-opacity": "1 1",
					"text-wrap": "wrap",
					"font-size": 11,
					"font-family": "Helvetica",
					"font-style": "normal",
					"font-weight": "normal",
					"color": "#000",
					"background-image": "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABYAAAAyCAYAAABYiSsbAAAABHNCSVQICAgIfAhkiAAABA5JREFUWIXtmM9LI2cYxz9KCOlWcOpqjew2zYK1Uy00tLDMoTShFISePOptLwvpf5C7B28rCCVKDwUv8b6H4M01oBEPsXjQ6iFx3RqruA4eHAkl3x6aGYyZSWLZFgr9wsv78j7zfvLM+zzvj0mPJPEPqNevs1KpsL+/3xWgWCxi23arQXfkOI7i8bgsy7prapHjOAI0PT3dYmsBp9NpAcrn83IcR3t7e77Qzc1NSVImkxGgXC4XDC6VSk0epFIpGYbRAnWfm5ub894wGo3KcRx/8NzcnADt7e0pm80KUCaTkSTNzs5qcnJShUJBkmRZliKRiMrlsubn5wWoVCr5g6empjwP3bbjOJqZmRHglZWVFW1ubgrQ/Py8185ms/5g0zS9oN1u9/X1KQz6qQGenJz0ApdOp5varprSLRqNcnp6CoBhGF4axWIxasAPjefGxsY8m2EY3pjh4WH/PE4kElQqFWzbxrIs9vf3WVtbY2lpiXA4zB/AxMQECwsLLC4uApBMJtnZ2fHG++ZxLpfz5q1arcowDJmmKUlKJpMCVCgUVC6XFYlElEqlvHgAqlar/nPsOI5M0/Sinc/nvay4Db68vFQ6nVa5XPacuT2/LWBJXoSnpqaa+m+DbzsSjUYVj8ebcrgleACWZZHNZjFNs3X9+yiRSJDL5YhEIs2Gux4Hyc/jdvLd3d6F/gf/h8Ed0y2fzyuVSnlb5sjIiKanpwNPFldtwevr6wqFQvpwaEifPX4sQNb4uAD19/e3rLauwe7m8olh6EdQBPQr6NHAgAAtLy8Hjm07x0dHRwAc2jazQ0NYiQRfhMP89vYtANvb24Fj24KPj48JAT8D5vk57OyQqtV40bDv7u7+veCFw2ENguRTekCjo6P3nwrbtqnVanwUYH/Q00O1Wr3/VGxsbADwcYD9Awnn+vr+4EKhAMBXAfY4UJc4ODi4H9i9FH4ZYP+0UW9tbd0P7HryfYDd/UF3yroGn52dEQ4yAt816sDrbmC69PZqJCDVbqdcLBbrPt1s26ZerxNt4zHAA+Di4sLX5gteXV0FoNM5/RC4Dkg5X7B7ZRrvAI4Bknj98iXUap3BpVIJgFQH8OeNevfFCwg3h9oXfHx8DMDXHcDu4lktFuHmpjP45OSkbaq5+qZRl25uoFjsDL66uuJhF+AxoAd4DfDqVXvw0dER9Xo9cPO5q/eBc4A3b9qDi41XetIleAC4AXj+vKk/dPfBw8NDoHOquXoCfPvsGTx92my4uxRXVlb+Oo07LGe3PDKMppu8K9+9wjAMAUqCKgHAX0Cjjc8KP/mCK5WK+vr6vEuK0XiDZKO81+hPJBJBe1j7e0Umk9Hg4KBCoVDTB2Rvb6/G43H9XqkEju2R/sX/K96F/gTllaEEcp1NCgAAAABJRU5ErkJggg==",
					"ports": [],
					"background-fit": "none",
					"background-position-x": "50%",
					"background-position-y": "50%",
					"background-width": "100%",
					"background-height": "100%",
					"infoboxCalculated": true,
					"auxunitlayouts": {}
				},
				"position": {
					"x": 918.6946839627489,
					"y": 268.1553060642376
				},
				"group": "nodes",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "67add58f-1a8c-17d9-8cfa-ff468527f6c9",
					"bbox": {
						"x": 910.624263262373,
						"y": 209.60764253071486,
						"w": 20,
						"h": 40
					},
					"class": "macromolecule",
					"label": "u1",
					"statesandinfos": [],
					"language": "PD",
					"border-width": 0.001,
					"border-color": "#555555",
					"background-color": "#ffffff",
					"background-opacity": 1,
					"background-image-opacity": "1 1",
					"text-wrap": "wrap",
					"font-size": 11,
					"font-family": "Helvetica",
					"font-style": "normal",
					"font-weight": "normal",
					"color": "#000",
					"background-image": "data:image/png;base64,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",
					"ports": [],
					"background-fit": "none",
					"background-position-x": "50%",
					"background-position-y": "50%",
					"background-width": "100%",
					"background-height": "100%",
					"infoboxCalculated": true,
					"auxunitlayouts": {}
				},
				"position": {
					"x": 910.624263262373,
					"y": 209.60764253071486
				},
				"group": "nodes",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "7c1292d7-1feb-63b9-65a6-fb9db2547eb3",
					"bbox": {
						"x": 777.4499113106275,
						"y": 242.69847222540457,
						"w": 20,
						"h": 40
					},
					"class": "macromolecule",
					"label": "u2",
					"statesandinfos": [],
					"language": "PD",
					"border-width": 0.001,
					"border-color": "#555555",
					"background-color": "#ffffff",
					"background-opacity": 1,
					"background-image-opacity": "1 1",
					"text-wrap": "wrap",
					"font-size": 11,
					"font-family": "Helvetica",
					"font-style": "normal",
					"font-weight": "normal",
					"color": "#000",
					"background-image": "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABwAAABACAIAAACGI4BPAAAAA3NCSVQICAjb4U/gAAAAGXRFWHRTb2Z0d2FyZQBnbm9tZS1zY3JlZW5zaG907wO/PgAAB8dJREFUWIXtmMtPE+8ax9+ZzkwvM9OhN9pyK5jSlgCNgsRAICYQw8LoQl2gKxcmLv0HjDFu3bhz4YYYVhJjTEyoJpqI0WC5JYCU0gu1NC3l0tu007l0Zn6LOYdTS8sPz/mdk/yS812+l888z/s+87zP+0KyLIO/WvBfTvwfQhmGWVpaYhhGkqRG00RRLBaLW1tbhULhz6GlUikcDvt8vlKpdIotsixzHOfz+aLRKMdxNb1IzdB4PP7x48dkMgnDsCAIMAwjCAJB0PEYSZJEUZQkiSAIv99PEITRaOzo6Kj95rHK5fLMzMzVq1dTqVSlUlleXg4EAjzPV4/JZrPBYHBra0uW5ZWVlXv37r148UL+Vb+4v7q6GovFJiYmTCZTMpl89erV9+/fAQAsywaDwWg0qqzJ8vLys2fPOI5zu92dnZ3pdHp9fb2h+4lEIpfLDQ0NoSg6OzuL43h7e/vKysrs7Oz29rZKpert7b1y5YrVatVoNG/evLl27ZrD4QiHw7FYrL+/vz40nU6XSqXu7m4AwPv376empsxms8/nm56epmlakqTFxUUURScnJz0ez9u3bycmJhRoIpGo5vzLfUmSaJoWBMFisYiimEqlSJJkWTYcDudyOYIgNBrN3t5eMBikadpisUQiEUEQzGYzACCTydR3XxRFAIBKpZJluVKpVG86DMNqtVqWZUEQIAj6x27AMARBKpVKMai+pSiKWiwWDMN2dnbUarXD4chkMkaj8eLFiyqVKpVKZbNZnU7n9XpbWlri8fiFCxcwDItGowCAmpD6ZfetVitBEKFQCABw9+7dQCCwuro6Pj7+6NEjAABJkg8fPrx58+b29rbf779//z5Jkj9//gQAtLW1NYR6PB6LxTI/Py8IwvDw8MDAgMlk0uv1Ho8HAKDT6VwuF0EQWq328uXLbrebpulQKKTT6Xp6ehpC29ranE4ny7Jfv37V6/VjY2NutxtBELVarawPhmEajcblck1OTmq12g8fPqAo2tPTY7Va628UAECr1Xq93kKhMD8/7/V6Ozo6IAgqFovVY5qampqamkRRpGn6y5cv4+Pjly5dUrarPhQA4HA4SJKcm5sDAEiSVDP6WJVKZX9/f2hoaHBwsLm5uaa3FqrYcuvWLRRFq/NIjTAM6+zsbGtrQ5A6hDpNSlQ2wilSIrSRH3/r4+T/0P9QdUKqWolEYmVl5fPnzwCAQqHw6dMnFEU9Ho/dbj9llurx48eN+gKBwLt3716/fu33+w8PDyuVSjabjcVihUKBJMmTP9KZLJ2bm5ueno5GoxRFoSh67tw5mqZ9Pt/a2hrDML29vQ1nyg3Ecdz169chCDp//vyDBw+8Xu/MzMyTJ0+GhoYwDBsdHVVO/7pzG1q6vb1dKBRQFCUIwuVy3blzR6VSlUolHMd5ns/n8zRNkyRZNz80hG5ububzeavVajKZNjc3fT6fSqVqaWkBAKjVap7nf/786fF4MAz7bWhTU9PAwMDIyEgmk4EgiKIoDMPW19d5no/H406n8/egOzs7xWLRbrc7nc7h4WGNRiOKIsdx4XDYYDCwLBuPxyuVSt25DYM/lUqVy2WKooxGY3U7RVEmk4njuFgs9tvQo6MjjuMoilLKhWMZjUar1crzfDQa/W1osVisVCqKXdXtNputvb2d5/mdnZ1G0DprKklSpVLheR6GYYIgcByv7jWbzXa7XRCERCLxG5byPB8Oh3me1+v1er2+5hRSq9U4jsuynMvllNrrTFCGYRYXF3meVyqJ2gkwjGGYEqrpdPpkbV4fWi6X19bWeJ43GAwEQZwcgGEYSZIAgGQyyTDMmaAcx4VCIaVMpCjq5ACNRmMwGMA/Y/lMUEEQdnd3RVE0m80n3QcAEATR2toKANjb22NZ9qzQdDqtQOtaSpKkUuYlEomzui+KYi6XkySp0ZpSFNXV1aVYWi6X/xyq/OAsyyIIYjAYaoJUkV6vdzgcAIDd3d1sNsuybE3A1kIZhtnf35dlmSRJkiTrJiFlo2AYPjg4SKfTJ7m10IODA+VSZDKZGlVUx6EqiuLR0dHBwUEul2MYRkn7daD5fD4WiwEAbDabRqOpC1W4FEXBMKxYyvN8oVAolUr1oblcLhKJAACam5tPgaIoarPZVCpVJpOhaRoAIAiCsr11oMViMZlMAgDsdrtWq20ERRCkBirLMs/zgiBIklQLLZfLh4eHivunQNVqdVdXF4Ig2WxWgSqqD+U4TnkXUC6gjaAajaavrw9F0aOjo2po/TWVJEnJZhaL5ZR6GsMwh8OBIMjh4WE+nz9uV66BtVAURZWAZxhGuVieLo7jqlOqclOohR7/gjMzMxsbG3XzBcuyoVDo+fPnNE27XC4lD8AwjOO4cqOtPU66u7tv3LgRDof9fr8gCEtLSz09PR0dHa2trZIkZbPZSCSyvr6+sbGxsLCAIMjIyIjb7YYgSEmyivtQzWOX8gjx9OnThYWFVCpFUZTT6VSgyltHJBIJBALZbNZutw8PD09NTfX19eE4rtPpcByHFJ18QeN5fm9v7+XLl9++fUskEjRNl0olJRthGIbjOEVRdrt9dHT09u3bZrMZRVEEQapDpQ70WIlEYmNjY3Fx8cePH8FgEABgs9n6+/vHxsYGBweVuqquToP+2/r7XCT+K9A/AN6eWQAzvN+SAAAAAElFTkSuQmCC",
					"ports": [],
					"background-fit": "none",
					"background-position-x": "50%",
					"background-position-y": "50%",
					"background-width": "100%",
					"background-height": "100%",
					"infoboxCalculated": true,
					"auxunitlayouts": {}
				},
				"position": {
					"x": 777.4499113106275,
					"y": 242.69847222540457
				},
				"group": "nodes",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "9bf069c9-034b-1bee-35e5-2d2addaeaf38",
					"bbox": {
						"x": 779.0933397934479,
						"y": 279.18258454401627,
						"w": 20,
						"h": 40
					},
					"class": "macromolecule",
					"label": "u3",
					"statesandinfos": [],
					"language": "PD",
					"border-width": 0.001,
					"border-color": "#555555",
					"background-color": "#ffffff",
					"background-opacity": 1,
					"background-image-opacity": "1 1",
					"text-wrap": "wrap",
					"font-size": 11,
					"font-family": "Helvetica",
					"font-style": "normal",
					"font-weight": "normal",
					"color": "#000",
					"background-image": "data:image/png;base64,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",
					"ports": [],
					"background-fit": "none",
					"background-position-x": "50%",
					"background-position-y": "50%",
					"background-width": "100%",
					"background-height": "100%",
					"infoboxCalculated": true,
					"auxunitlayouts": {}
				},
				"position": {
					"x": 779.0933397934479,
					"y": 279.18258454401627
				},
				"group": "nodes",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "d64b38d9-db3d-4128-1ec4-ddf1e5648c72",
					"bbox": {
						"x": 728.8044282191453,
						"y": 278.85389884745223,
						"w": 20,
						"h": 40
					},
					"class": "macromolecule",
					"label": "u4",
					"statesandinfos": [],
					"language": "PD",
					"border-width": 0.001,
					"border-color": "#555555",
					"background-color": "#ffffff",
					"background-opacity": 1,
					"background-image-opacity": "1 1",
					"text-wrap": "wrap",
					"font-size": 11,
					"font-family": "Helvetica",
					"font-style": "normal",
					"font-weight": "normal",
					"color": "#000",
					"background-image": "data:image/png;base64,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",
					"ports": [],
					"background-fit": "none",
					"background-position-x": "50%",
					"background-position-y": "50%",
					"background-width": "100%",
					"background-height": "100%",
					"infoboxCalculated": true,
					"auxunitlayouts": {}
				},
				"position": {
					"x": 728.8044282191453,
					"y": 278.85389884745223
				},
				"group": "nodes",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "7435cbfb-9e49-d44e-4357-c413a22e188a",
					"bbox": {
						"x": 727.4896854328889,
						"y": 324.2125249732938,
						"w": 20,
						"h": 40
					},
					"class": "macromolecule",
					"label": "u5",
					"statesandinfos": [],
					"language": "PD",
					"border-width": 0.001,
					"border-color": "#555555",
					"background-color": "#ffffff",
					"background-opacity": 1,
					"background-image-opacity": "1 1",
					"text-wrap": "wrap",
					"font-size": 11,
					"font-family": "Helvetica",
					"font-style": "normal",
					"font-weight": "normal",
					"color": "#000",
					"background-image": "data:image/png;base64,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",
					"ports": [],
					"background-fit": "none",
					"background-position-x": "50%",
					"background-position-y": "50%",
					"background-width": "100%",
					"background-height": "100%",
					"infoboxCalculated": true,
					"auxunitlayouts": {}
				},
				"position": {
					"x": 727.4896854328889,
					"y": 324.2125249732938
				},
				"group": "nodes",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "f91d914e-6ab7-92cf-b16d-b9a7661e0044",
					"bbox": {
						"x": 648.8383670046286,
						"y": 373.40718335288847,
						"w": 20,
						"h": 40
					},
					"class": "macromolecule",
					"label": "a9",
					"statesandinfos": [],
					"language": "PD",
					"border-width": 0.001,
					"border-color": "#555555",
					"background-color": "#ffffff",
					"background-opacity": 1,
					"background-image-opacity": "1 1",
					"text-wrap": "wrap",
					"font-size": 11,
					"font-family": "Helvetica",
					"font-style": "normal",
					"font-weight": "normal",
					"color": "#000",
					"background-image": "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABYAAAAyCAYAAABYiSsbAAAABHNCSVQICAgIfAhkiAAABA5JREFUWIXtmM9LI2cYxz9KCOlWcOpqjew2zYK1Uy00tLDMoTShFISePOptLwvpf5C7B28rCCVKDwUv8b6H4M01oBEPsXjQ6iFx3RqruA4eHAkl3x6aGYyZSWLZFgr9wsv78j7zfvLM+zzvj0mPJPEPqNevs1KpsL+/3xWgWCxi23arQXfkOI7i8bgsy7prapHjOAI0PT3dYmsBp9NpAcrn83IcR3t7e77Qzc1NSVImkxGgXC4XDC6VSk0epFIpGYbRAnWfm5ub894wGo3KcRx/8NzcnADt7e0pm80KUCaTkSTNzs5qcnJShUJBkmRZliKRiMrlsubn5wWoVCr5g6empjwP3bbjOJqZmRHglZWVFW1ubgrQ/Py8185ms/5g0zS9oN1u9/X1KQz6qQGenJz0ApdOp5varprSLRqNcnp6CoBhGF4axWIxasAPjefGxsY8m2EY3pjh4WH/PE4kElQqFWzbxrIs9vf3WVtbY2lpiXA4zB/AxMQECwsLLC4uApBMJtnZ2fHG++ZxLpfz5q1arcowDJmmKUlKJpMCVCgUVC6XFYlElEqlvHgAqlar/nPsOI5M0/Sinc/nvay4Db68vFQ6nVa5XPacuT2/LWBJXoSnpqaa+m+DbzsSjUYVj8ebcrgleACWZZHNZjFNs3X9+yiRSJDL5YhEIs2Gux4Hyc/jdvLd3d6F/gf/h8Ed0y2fzyuVSnlb5sjIiKanpwNPFldtwevr6wqFQvpwaEifPX4sQNb4uAD19/e3rLauwe7m8olh6EdQBPQr6NHAgAAtLy8Hjm07x0dHRwAc2jazQ0NYiQRfhMP89vYtANvb24Fj24KPj48JAT8D5vk57OyQqtV40bDv7u7+veCFw2ENguRTekCjo6P3nwrbtqnVanwUYH/Q00O1Wr3/VGxsbADwcYD9Awnn+vr+4EKhAMBXAfY4UJc4ODi4H9i9FH4ZYP+0UW9tbd0P7HryfYDd/UF3yroGn52dEQ4yAt816sDrbmC69PZqJCDVbqdcLBbrPt1s26ZerxNt4zHAA+Di4sLX5gteXV0FoNM5/RC4Dkg5X7B7ZRrvAI4Bknj98iXUap3BpVIJgFQH8OeNevfFCwg3h9oXfHx8DMDXHcDu4lktFuHmpjP45OSkbaq5+qZRl25uoFjsDL66uuJhF+AxoAd4DfDqVXvw0dER9Xo9cPO5q/eBc4A3b9qDi41XetIleAC4AXj+vKk/dPfBw8NDoHOquXoCfPvsGTx92my4uxRXVlb+Oo07LGe3PDKMppu8K9+9wjAMAUqCKgHAX0Cjjc8KP/mCK5WK+vr6vEuK0XiDZKO81+hPJBJBe1j7e0Umk9Hg4KBCoVDTB2Rvb6/G43H9XqkEju2R/sX/K96F/gTllaEEcp1NCgAAAABJRU5ErkJggg==",
					"ports": [],
					"background-fit": "none",
					"background-position-x": "50%",
					"background-position-y": "50%",
					"background-width": "100%",
					"background-height": "100%",
					"infoboxCalculated": true,
					"auxunitlayouts": {}
				},
				"position": {
					"x": 648.8383670046286,
					"y": 373.40718335288847
				},
				"group": "nodes",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "3ffdee99-d217-2dc6-5b0e-1229ee1d1bd4",
					"bbox": {
						"x": 829.3822513677504,
						"y": 328.15675333206264,
						"w": 20,
						"h": 40
					},
					"class": "macromolecule",
					"label": "u6",
					"statesandinfos": [],
					"language": "PD",
					"border-width": 0.001,
					"border-color": "#555555",
					"background-color": "#ffffff",
					"background-opacity": 1,
					"background-image-opacity": "1 1",
					"text-wrap": "wrap",
					"font-size": 11,
					"font-family": "Helvetica",
					"font-style": "normal",
					"font-weight": "normal",
					"color": "#000",
					"background-image": "data:image/png;base64,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",
					"ports": [],
					"background-fit": "none",
					"background-position-x": "50%",
					"background-position-y": "50%",
					"background-width": "100%",
					"background-height": "100%",
					"infoboxCalculated": true,
					"auxunitlayouts": {}
				},
				"position": {
					"x": 829.3822513677504,
					"y": 328.15675333206264
				},
				"group": "nodes",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "88642a3e-3f7a-60a3-9c61-425f1f3cf2d7",
					"bbox": {
						"x": 831.3543655471349,
						"y": 295.94555506878385,
						"w": 20,
						"h": 40
					},
					"class": "macromolecule",
					"label": "u7",
					"statesandinfos": [],
					"language": "PD",
					"border-width": 0.001,
					"border-color": "#555555",
					"background-color": "#ffffff",
					"background-opacity": 1,
					"background-image-opacity": "1 1",
					"text-wrap": "wrap",
					"font-size": 11,
					"font-family": "Helvetica",
					"font-style": "normal",
					"font-weight": "normal",
					"color": "#000",
					"background-image": "data:image/png;base64,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",
					"ports": [],
					"background-fit": "none",
					"background-position-x": "50%",
					"background-position-y": "50%",
					"background-width": "100%",
					"background-height": "100%",
					"infoboxCalculated": true,
					"auxunitlayouts": {}
				},
				"position": {
					"x": 831.3543655471349,
					"y": 295.94555506878385
				},
				"group": "nodes",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "c21a716f-9ce2-4976-bdc3-320395e5ed97",
					"bbox": {
						"x": 826.7527657952379,
						"y": 258.804071357044,
						"w": 20,
						"h": 40
					},
					"class": "macromolecule",
					"label": "u8",
					"statesandinfos": [],
					"language": "PD",
					"border-width": 0.001,
					"border-color": "#555555",
					"background-color": "#ffffff",
					"background-opacity": 1,
					"background-image-opacity": "1 1",
					"text-wrap": "wrap",
					"font-size": 11,
					"font-family": "Helvetica",
					"font-style": "normal",
					"font-weight": "normal",
					"color": "#000",
					"background-image": "data:image/png;base64,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",
					"ports": [],
					"background-fit": "none",
					"background-position-x": "50%",
					"background-position-y": "50%",
					"background-width": "100%",
					"background-height": "100%",
					"infoboxCalculated": true,
					"auxunitlayouts": {}
				},
				"position": {
					"x": 826.7527657952379,
					"y": 258.804071357044
				},
				"group": "nodes",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "1eee479d-d3a1-44d9-316e-b70bc4556169",
					"bbox": {
						"x": 614.0181970745487,
						"y": 498.44324810181206,
						"w": 20,
						"h": 40
					},
					"class": "macromolecule",
					"label": "u9",
					"statesandinfos": [],
					"language": "PD",
					"border-width": 0.001,
					"border-color": "#555555",
					"background-color": "#ffffff",
					"background-opacity": 1,
					"background-image-opacity": "1 1",
					"text-wrap": "wrap",
					"font-size": 11,
					"font-family": "Helvetica",
					"font-style": "normal",
					"font-weight": "normal",
					"color": "#000",
					"background-image": "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABwAAABACAIAAACGI4BPAAAAA3NCSVQICAjb4U/gAAAAGXRFWHRTb2Z0d2FyZQBnbm9tZS1zY3JlZW5zaG907wO/PgAAB8dJREFUWIXtmMtPE+8ax9+ZzkwvM9OhN9pyK5jSlgCNgsRAICYQw8LoQl2gKxcmLv0HjDFu3bhz4YYYVhJjTEyoJpqI0WC5JYCU0gu1NC3l0tu007l0Zn6LOYdTS8sPz/mdk/yS812+l888z/s+87zP+0KyLIO/WvBfTvwfQhmGWVpaYhhGkqRG00RRLBaLW1tbhULhz6GlUikcDvt8vlKpdIotsixzHOfz+aLRKMdxNb1IzdB4PP7x48dkMgnDsCAIMAwjCAJB0PEYSZJEUZQkiSAIv99PEITRaOzo6Kj95rHK5fLMzMzVq1dTqVSlUlleXg4EAjzPV4/JZrPBYHBra0uW5ZWVlXv37r148UL+Vb+4v7q6GovFJiYmTCZTMpl89erV9+/fAQAsywaDwWg0qqzJ8vLys2fPOI5zu92dnZ3pdHp9fb2h+4lEIpfLDQ0NoSg6OzuL43h7e/vKysrs7Oz29rZKpert7b1y5YrVatVoNG/evLl27ZrD4QiHw7FYrL+/vz40nU6XSqXu7m4AwPv376empsxms8/nm56epmlakqTFxUUURScnJz0ez9u3bycmJhRoIpGo5vzLfUmSaJoWBMFisYiimEqlSJJkWTYcDudyOYIgNBrN3t5eMBikadpisUQiEUEQzGYzACCTydR3XxRFAIBKpZJluVKpVG86DMNqtVqWZUEQIAj6x27AMARBKpVKMai+pSiKWiwWDMN2dnbUarXD4chkMkaj8eLFiyqVKpVKZbNZnU7n9XpbWlri8fiFCxcwDItGowCAmpD6ZfetVitBEKFQCABw9+7dQCCwuro6Pj7+6NEjAABJkg8fPrx58+b29rbf779//z5Jkj9//gQAtLW1NYR6PB6LxTI/Py8IwvDw8MDAgMlk0uv1Ho8HAKDT6VwuF0EQWq328uXLbrebpulQKKTT6Xp6ehpC29ranE4ny7Jfv37V6/VjY2NutxtBELVarawPhmEajcblck1OTmq12g8fPqAo2tPTY7Va628UAECr1Xq93kKhMD8/7/V6Ozo6IAgqFovVY5qampqamkRRpGn6y5cv4+Pjly5dUrarPhQA4HA4SJKcm5sDAEiSVDP6WJVKZX9/f2hoaHBwsLm5uaa3FqrYcuvWLRRFq/NIjTAM6+zsbGtrQ5A6hDpNSlQ2wilSIrSRH3/r4+T/0P9QdUKqWolEYmVl5fPnzwCAQqHw6dMnFEU9Ho/dbj9llurx48eN+gKBwLt3716/fu33+w8PDyuVSjabjcVihUKBJMmTP9KZLJ2bm5ueno5GoxRFoSh67tw5mqZ9Pt/a2hrDML29vQ1nyg3Ecdz169chCDp//vyDBw+8Xu/MzMyTJ0+GhoYwDBsdHVVO/7pzG1q6vb1dKBRQFCUIwuVy3blzR6VSlUolHMd5ns/n8zRNkyRZNz80hG5ububzeavVajKZNjc3fT6fSqVqaWkBAKjVap7nf/786fF4MAz7bWhTU9PAwMDIyEgmk4EgiKIoDMPW19d5no/H406n8/egOzs7xWLRbrc7nc7h4WGNRiOKIsdx4XDYYDCwLBuPxyuVSt25DYM/lUqVy2WKooxGY3U7RVEmk4njuFgs9tvQo6MjjuMoilLKhWMZjUar1crzfDQa/W1osVisVCqKXdXtNputvb2d5/mdnZ1G0DprKklSpVLheR6GYYIgcByv7jWbzXa7XRCERCLxG5byPB8Oh3me1+v1er2+5hRSq9U4jsuynMvllNrrTFCGYRYXF3meVyqJ2gkwjGGYEqrpdPpkbV4fWi6X19bWeJ43GAwEQZwcgGEYSZIAgGQyyTDMmaAcx4VCIaVMpCjq5ACNRmMwGMA/Y/lMUEEQdnd3RVE0m80n3QcAEATR2toKANjb22NZ9qzQdDqtQOtaSpKkUuYlEomzui+KYi6XkySp0ZpSFNXV1aVYWi6X/xyq/OAsyyIIYjAYaoJUkV6vdzgcAIDd3d1sNsuybE3A1kIZhtnf35dlmSRJkiTrJiFlo2AYPjg4SKfTJ7m10IODA+VSZDKZGlVUx6EqiuLR0dHBwUEul2MYRkn7daD5fD4WiwEAbDabRqOpC1W4FEXBMKxYyvN8oVAolUr1oblcLhKJAACam5tPgaIoarPZVCpVJpOhaRoAIAiCsr11oMViMZlMAgDsdrtWq20ERRCkBirLMs/zgiBIklQLLZfLh4eHivunQNVqdVdXF4Ig2WxWgSqqD+U4TnkXUC6gjaAajaavrw9F0aOjo2po/TWVJEnJZhaL5ZR6GsMwh8OBIMjh4WE+nz9uV66BtVAURZWAZxhGuVieLo7jqlOqclOohR7/gjMzMxsbG3XzBcuyoVDo+fPnNE27XC4lD8AwjOO4cqOtPU66u7tv3LgRDof9fr8gCEtLSz09PR0dHa2trZIkZbPZSCSyvr6+sbGxsLCAIMjIyIjb7YYgSEmyivtQzWOX8gjx9OnThYWFVCpFUZTT6VSgyltHJBIJBALZbNZutw8PD09NTfX19eE4rtPpcByHFJ18QeN5fm9v7+XLl9++fUskEjRNl0olJRthGIbjOEVRdrt9dHT09u3bZrMZRVEEQapDpQ70WIlEYmNjY3Fx8cePH8FgEABgs9n6+/vHxsYGBweVuqquToP+2/r7XCT+K9A/AN6eWQAzvN+SAAAAAElFTkSuQmCC",
					"ports": [],
					"background-fit": "none",
					"background-position-x": "50%",
					"background-position-y": "50%",
					"background-width": "100%",
					"background-height": "100%",
					"infoboxCalculated": true,
					"auxunitlayouts": {}
				},
				"position": {
					"x": 614.0181970745487,
					"y": 498.44324810181206
				},
				"group": "nodes",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "96f4c006-33d1-a00e-a389-782f23c38a65",
					"bbox": {
						"x": 777.1212256140635,
						"y": 374.1727508510323,
						"w": 20,
						"h": 40
					},
					"class": "macromolecule",
					"label": "u10",
					"statesandinfos": [],
					"language": "PD",
					"border-width": 0.001,
					"border-color": "#555555",
					"background-color": "#ffffff",
					"background-opacity": 1,
					"background-image-opacity": "1 1",
					"text-wrap": "wrap",
					"font-size": 11,
					"font-family": "Helvetica",
					"font-style": "normal",
					"font-weight": "normal",
					"color": "#000",
					"background-image": "data:image/png;base64,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",
					"ports": [],
					"background-fit": "none",
					"background-position-x": "50%",
					"background-position-y": "50%",
					"background-width": "100%",
					"background-height": "100%",
					"infoboxCalculated": true,
					"auxunitlayouts": {}
				},
				"position": {
					"x": 777.1212256140635,
					"y": 374.1727508510323
				},
				"group": "nodes",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "a3218cf9-fd48-f0b4-4c45-99cf2e52a0e8",
					"bbox": {
						"x": 833.9838511196474,
						"y": 373.1866937613401,
						"w": 20,
						"h": 40
					},
					"class": "macromolecule",
					"label": "u11",
					"statesandinfos": [],
					"language": "PD",
					"border-width": 0.001,
					"border-color": "#555555",
					"background-color": "#ffffff",
					"background-opacity": 1,
					"background-image-opacity": "1 1",
					"text-wrap": "wrap",
					"font-size": 11,
					"font-family": "Helvetica",
					"font-style": "normal",
					"font-weight": "normal",
					"color": "#000",
					"background-image": "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABwAAABACAIAAACGI4BPAAAAA3NCSVQICAjb4U/gAAAAGXRFWHRTb2Z0d2FyZQBnbm9tZS1zY3JlZW5zaG907wO/PgAAB8dJREFUWIXtmMtPE+8ax9+ZzkwvM9OhN9pyK5jSlgCNgsRAICYQw8LoQl2gKxcmLv0HjDFu3bhz4YYYVhJjTEyoJpqI0WC5JYCU0gu1NC3l0tu007l0Zn6LOYdTS8sPz/mdk/yS812+l888z/s+87zP+0KyLIO/WvBfTvwfQhmGWVpaYhhGkqRG00RRLBaLW1tbhULhz6GlUikcDvt8vlKpdIotsixzHOfz+aLRKMdxNb1IzdB4PP7x48dkMgnDsCAIMAwjCAJB0PEYSZJEUZQkiSAIv99PEITRaOzo6Kj95rHK5fLMzMzVq1dTqVSlUlleXg4EAjzPV4/JZrPBYHBra0uW5ZWVlXv37r148UL+Vb+4v7q6GovFJiYmTCZTMpl89erV9+/fAQAsywaDwWg0qqzJ8vLys2fPOI5zu92dnZ3pdHp9fb2h+4lEIpfLDQ0NoSg6OzuL43h7e/vKysrs7Oz29rZKpert7b1y5YrVatVoNG/evLl27ZrD4QiHw7FYrL+/vz40nU6XSqXu7m4AwPv376empsxms8/nm56epmlakqTFxUUURScnJz0ez9u3bycmJhRoIpGo5vzLfUmSaJoWBMFisYiimEqlSJJkWTYcDudyOYIgNBrN3t5eMBikadpisUQiEUEQzGYzACCTydR3XxRFAIBKpZJluVKpVG86DMNqtVqWZUEQIAj6x27AMARBKpVKMai+pSiKWiwWDMN2dnbUarXD4chkMkaj8eLFiyqVKpVKZbNZnU7n9XpbWlri8fiFCxcwDItGowCAmpD6ZfetVitBEKFQCABw9+7dQCCwuro6Pj7+6NEjAABJkg8fPrx58+b29rbf779//z5Jkj9//gQAtLW1NYR6PB6LxTI/Py8IwvDw8MDAgMlk0uv1Ho8HAKDT6VwuF0EQWq328uXLbrebpulQKKTT6Xp6ehpC29ranE4ny7Jfv37V6/VjY2NutxtBELVarawPhmEajcblck1OTmq12g8fPqAo2tPTY7Va628UAECr1Xq93kKhMD8/7/V6Ozo6IAgqFovVY5qampqamkRRpGn6y5cv4+Pjly5dUrarPhQA4HA4SJKcm5sDAEiSVDP6WJVKZX9/f2hoaHBwsLm5uaa3FqrYcuvWLRRFq/NIjTAM6+zsbGtrQ5A6hDpNSlQ2wilSIrSRH3/r4+T/0P9QdUKqWolEYmVl5fPnzwCAQqHw6dMnFEU9Ho/dbj9llurx48eN+gKBwLt3716/fu33+w8PDyuVSjabjcVihUKBJMmTP9KZLJ2bm5ueno5GoxRFoSh67tw5mqZ9Pt/a2hrDML29vQ1nyg3Ecdz169chCDp//vyDBw+8Xu/MzMyTJ0+GhoYwDBsdHVVO/7pzG1q6vb1dKBRQFCUIwuVy3blzR6VSlUolHMd5ns/n8zRNkyRZNz80hG5ububzeavVajKZNjc3fT6fSqVqaWkBAKjVap7nf/786fF4MAz7bWhTU9PAwMDIyEgmk4EgiKIoDMPW19d5no/H406n8/egOzs7xWLRbrc7nc7h4WGNRiOKIsdx4XDYYDCwLBuPxyuVSt25DYM/lUqVy2WKooxGY3U7RVEmk4njuFgs9tvQo6MjjuMoilLKhWMZjUar1crzfDQa/W1osVisVCqKXdXtNputvb2d5/mdnZ1G0DprKklSpVLheR6GYYIgcByv7jWbzXa7XRCERCLxG5byPB8Oh3me1+v1er2+5hRSq9U4jsuynMvllNrrTFCGYRYXF3meVyqJ2gkwjGGYEqrpdPpkbV4fWi6X19bWeJ43GAwEQZwcgGEYSZIAgGQyyTDMmaAcx4VCIaVMpCjq5ACNRmMwGMA/Y/lMUEEQdnd3RVE0m80n3QcAEATR2toKANjb22NZ9qzQdDqtQOtaSpKkUuYlEomzui+KYi6XkySp0ZpSFNXV1aVYWi6X/xyq/OAsyyIIYjAYaoJUkV6vdzgcAIDd3d1sNsuybE3A1kIZhtnf35dlmSRJkiTrJiFlo2AYPjg4SKfTJ7m10IODA+VSZDKZGlVUx6EqiuLR0dHBwUEul2MYRkn7daD5fD4WiwEAbDabRqOpC1W4FEXBMKxYyvN8oVAolUr1oblcLhKJAACam5tPgaIoarPZVCpVJpOhaRoAIAiCsr11oMViMZlMAgDsdrtWq20ERRCkBirLMs/zgiBIklQLLZfLh4eHivunQNVqdVdXF4Ig2WxWgSqqD+U4TnkXUC6gjaAajaavrw9F0aOjo2po/TWVJEnJZhaL5ZR6GsMwh8OBIMjh4WE+nz9uV66BtVAURZWAZxhGuVieLo7jqlOqclOohR7/gjMzMxsbG3XzBcuyoVDo+fPnNE27XC4lD8AwjOO4cqOtPU66u7tv3LgRDof9fr8gCEtLSz09PR0dHa2trZIkZbPZSCSyvr6+sbGxsLCAIMjIyIjb7YYgSEmyivtQzWOX8gjx9OnThYWFVCpFUZTT6VSgyltHJBIJBALZbNZutw8PD09NTfX19eE4rtPpcByHFJ18QeN5fm9v7+XLl9++fUskEjRNl0olJRthGIbjOEVRdrt9dHT09u3bZrMZRVEEQapDpQ70WIlEYmNjY3Fx8cePH8FgEABgs9n6+/vHxsYGBweVuqquToP+2/r7XCT+K9A/AN6eWQAzvN+SAAAAAElFTkSuQmCC",
					"ports": [],
					"background-fit": "none",
					"background-position-x": "50%",
					"background-position-y": "50%",
					"background-width": "100%",
					"background-height": "100%",
					"infoboxCalculated": true,
					"auxunitlayouts": {}
				},
				"position": {
					"x": 833.9838511196474,
					"y": 373.1866937613401
				},
				"group": "nodes",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "267b649b-6d09-255c-67b4-46bd2c40375e",
					"bbox": {
						"x": 735.3781421504267,
						"y": 375.8161793338527,
						"w": 20,
						"h": 40
					},
					"class": "macromolecule",
					"label": "u12",
					"statesandinfos": [],
					"language": "PD",
					"border-width": 0.001,
					"border-color": "#555555",
					"background-color": "#ffffff",
					"background-opacity": 1,
					"background-image-opacity": "1 1",
					"text-wrap": "wrap",
					"font-size": 11,
					"font-family": "Helvetica",
					"font-style": "normal",
					"font-weight": "normal",
					"color": "#000",
					"background-image": "data:image/png;base64,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",
					"ports": [],
					"background-fit": "none",
					"background-position-x": "50%",
					"background-position-y": "50%",
					"background-width": "100%",
					"background-height": "100%",
					"infoboxCalculated": true,
					"auxunitlayouts": {}
				},
				"position": {
					"x": 735.3781421504267,
					"y": 375.8161793338527
				},
				"group": "nodes",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "a1be056e-0b97-5a8e-56e9-8c3e08e9c24b",
					"bbox": {
						"x": 689.3621446314569,
						"y": 372.529322368212,
						"w": 20,
						"h": 40
					},
					"class": "macromolecule",
					"label": "u13",
					"statesandinfos": [],
					"language": "PD",
					"border-width": 0.001,
					"border-color": "#555555",
					"background-color": "#ffffff",
					"background-opacity": 1,
					"background-image-opacity": "1 1",
					"text-wrap": "wrap",
					"font-size": 11,
					"font-family": "Helvetica",
					"font-style": "normal",
					"font-weight": "normal",
					"color": "#000",
					"background-image": "data:image/png;base64,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",
					"ports": [],
					"background-fit": "none",
					"background-position-x": "50%",
					"background-position-y": "50%",
					"background-width": "100%",
					"background-height": "100%",
					"infoboxCalculated": true,
					"auxunitlayouts": {}
				},
				"position": {
					"x": 689.3621446314569,
					"y": 372.529322368212
				},
				"group": "nodes",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "33f80abd-028e-ad1c-068b-33d5b40d9a93",
					"bbox": {
						"x": 564.9534121730723,
						"y": 455.709403187623,
						"w": 20,
						"h": 40
					},
					"class": "macromolecule",
					"label": "a12",
					"statesandinfos": [],
					"language": "PD",
					"border-width": 0.001,
					"border-color": "#555555",
					"background-color": "#ffffff",
					"background-opacity": 1,
					"background-image-opacity": "1 1",
					"text-wrap": "wrap",
					"font-size": 11,
					"font-family": "Helvetica",
					"font-style": "normal",
					"font-weight": "normal",
					"color": "#000",
					"background-image": "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABYAAAAyCAYAAABYiSsbAAAABHNCSVQICAgIfAhkiAAABA5JREFUWIXtmM9LI2cYxz9KCOlWcOpqjew2zYK1Uy00tLDMoTShFISePOptLwvpf5C7B28rCCVKDwUv8b6H4M01oBEPsXjQ6iFx3RqruA4eHAkl3x6aGYyZSWLZFgr9wsv78j7zfvLM+zzvj0mPJPEPqNevs1KpsL+/3xWgWCxi23arQXfkOI7i8bgsy7prapHjOAI0PT3dYmsBp9NpAcrn83IcR3t7e77Qzc1NSVImkxGgXC4XDC6VSk0epFIpGYbRAnWfm5ub894wGo3KcRx/8NzcnADt7e0pm80KUCaTkSTNzs5qcnJShUJBkmRZliKRiMrlsubn5wWoVCr5g6empjwP3bbjOJqZmRHglZWVFW1ubgrQ/Py8185ms/5g0zS9oN1u9/X1KQz6qQGenJz0ApdOp5varprSLRqNcnp6CoBhGF4axWIxasAPjefGxsY8m2EY3pjh4WH/PE4kElQqFWzbxrIs9vf3WVtbY2lpiXA4zB/AxMQECwsLLC4uApBMJtnZ2fHG++ZxLpfz5q1arcowDJmmKUlKJpMCVCgUVC6XFYlElEqlvHgAqlar/nPsOI5M0/Sinc/nvay4Db68vFQ6nVa5XPacuT2/LWBJXoSnpqaa+m+DbzsSjUYVj8ebcrgleACWZZHNZjFNs3X9+yiRSJDL5YhEIs2Gux4Hyc/jdvLd3d6F/gf/h8Ed0y2fzyuVSnlb5sjIiKanpwNPFldtwevr6wqFQvpwaEifPX4sQNb4uAD19/e3rLauwe7m8olh6EdQBPQr6NHAgAAtLy8Hjm07x0dHRwAc2jazQ0NYiQRfhMP89vYtANvb24Fj24KPj48JAT8D5vk57OyQqtV40bDv7u7+veCFw2ENguRTekCjo6P3nwrbtqnVanwUYH/Q00O1Wr3/VGxsbADwcYD9Awnn+vr+4EKhAMBXAfY4UJc4ODi4H9i9FH4ZYP+0UW9tbd0P7HryfYDd/UF3yroGn52dEQ4yAt816sDrbmC69PZqJCDVbqdcLBbrPt1s26ZerxNt4zHAA+Di4sLX5gteXV0FoNM5/RC4Dkg5X7B7ZRrvAI4Bknj98iXUap3BpVIJgFQH8OeNevfFCwg3h9oXfHx8DMDXHcDu4lktFuHmpjP45OSkbaq5+qZRl25uoFjsDL66uuJhF+AxoAd4DfDqVXvw0dER9Xo9cPO5q/eBc4A3b9qDi41XetIleAC4AXj+vKk/dPfBw8NDoHOquXoCfPvsGTx92my4uxRXVlb+Oo07LGe3PDKMppu8K9+9wjAMAUqCKgHAX0Cjjc8KP/mCK5WK+vr6vEuK0XiDZKO81+hPJBJBe1j7e0Umk9Hg4KBCoVDTB2Rvb6/G43H9XqkEju2R/sX/K96F/gTllaEEcp1NCgAAAABJRU5ErkJggg==",
					"ports": [],
					"background-fit": "none",
					"background-position-x": "50%",
					"background-position-y": "50%",
					"background-width": "100%",
					"background-height": "100%",
					"infoboxCalculated": true,
					"auxunitlayouts": {}
				},
				"position": {
					"x": 564.9534121730723,
					"y": 455.709403187623
				},
				"group": "nodes",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "d036dd9f-8368-bfac-a080-87b82544be20",
					"bbox": {
						"x": 696.9219156524304,
						"y": 326.8420105458064,
						"w": 20,
						"h": 40
					},
					"class": "macromolecule",
					"label": "u14",
					"statesandinfos": [],
					"language": "PD",
					"border-width": 0.001,
					"border-color": "#555555",
					"background-color": "#ffffff",
					"background-opacity": 1,
					"background-image-opacity": "1 1",
					"text-wrap": "wrap",
					"font-size": 11,
					"font-family": "Helvetica",
					"font-style": "normal",
					"font-weight": "normal",
					"color": "#000",
					"background-image": "data:image/png;base64,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",
					"ports": [],
					"background-fit": "none",
					"background-position-x": "50%",
					"background-position-y": "50%",
					"background-width": "100%",
					"background-height": "100%",
					"infoboxCalculated": true,
					"auxunitlayouts": {}
				},
				"position": {
					"x": 696.9219156524304,
					"y": 326.8420105458064
				},
				"group": "nodes",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "b45bf870-2439-dc1d-38f2-fc491752ff05",
					"bbox": {
						"x": 655.1788321887938,
						"y": 324.8698963664219,
						"w": 20,
						"h": 40
					},
					"class": "macromolecule",
					"label": "u15",
					"statesandinfos": [],
					"language": "PD",
					"border-width": 0.001,
					"border-color": "#555555",
					"background-color": "#ffffff",
					"background-opacity": 1,
					"background-image-opacity": "1 1",
					"text-wrap": "wrap",
					"font-size": 11,
					"font-family": "Helvetica",
					"font-style": "normal",
					"font-weight": "normal",
					"color": "#000",
					"background-image": "data:image/png;base64,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",
					"ports": [],
					"background-fit": "none",
					"background-position-x": "50%",
					"background-position-y": "50%",
					"background-width": "100%",
					"background-height": "100%",
					"infoboxCalculated": true,
					"auxunitlayouts": {}
				},
				"position": {
					"x": 655.1788321887938,
					"y": 324.8698963664219
				},
				"group": "nodes",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "a44fe57b-d4e6-a062-6b2a-bf6f5f92c5f1",
					"bbox": {
						"x": 692.9776872936616,
						"y": 277.5391560611959,
						"w": 20,
						"h": 40
					},
					"class": "macromolecule",
					"label": "u16",
					"statesandinfos": [],
					"language": "PD",
					"border-width": 0.001,
					"border-color": "#555555",
					"background-color": "#ffffff",
					"background-opacity": 1,
					"background-image-opacity": "1 1",
					"text-wrap": "wrap",
					"font-size": 11,
					"font-family": "Helvetica",
					"font-style": "normal",
					"font-weight": "normal",
					"color": "#000",
					"background-image": "data:image/png;base64,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",
					"ports": [],
					"background-fit": "none",
					"background-position-x": "50%",
					"background-position-y": "50%",
					"background-width": "100%",
					"background-height": "100%",
					"infoboxCalculated": true,
					"auxunitlayouts": {}
				},
				"position": {
					"x": 692.9776872936616,
					"y": 277.5391560611959
				},
				"group": "nodes",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "2b855d36-0c89-996d-9281-ea54f711cc8e",
					"bbox": {
						"x": 723.2269118552542,
						"y": 156.5724887882993,
						"w": 20,
						"h": 40
					},
					"class": "macromolecule",
					"label": "a1",
					"statesandinfos": [],
					"language": "PD",
					"border-width": 0.001,
					"border-color": "#555555",
					"background-color": "#ffffff",
					"background-opacity": 1,
					"background-image-opacity": "1 1",
					"text-wrap": "wrap",
					"font-size": 11,
					"font-family": "Helvetica",
					"font-style": "normal",
					"font-weight": "normal",
					"color": "#000",
					"background-image": "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABYAAAAyCAYAAABYiSsbAAAABHNCSVQICAgIfAhkiAAABA5JREFUWIXtmM9LI2cYxz9KCOlWcOpqjew2zYK1Uy00tLDMoTShFISePOptLwvpf5C7B28rCCVKDwUv8b6H4M01oBEPsXjQ6iFx3RqruA4eHAkl3x6aGYyZSWLZFgr9wsv78j7zfvLM+zzvj0mPJPEPqNevs1KpsL+/3xWgWCxi23arQXfkOI7i8bgsy7prapHjOAI0PT3dYmsBp9NpAcrn83IcR3t7e77Qzc1NSVImkxGgXC4XDC6VSk0epFIpGYbRAnWfm5ub894wGo3KcRx/8NzcnADt7e0pm80KUCaTkSTNzs5qcnJShUJBkmRZliKRiMrlsubn5wWoVCr5g6empjwP3bbjOJqZmRHglZWVFW1ubgrQ/Py8185ms/5g0zS9oN1u9/X1KQz6qQGenJz0ApdOp5varprSLRqNcnp6CoBhGF4axWIxasAPjefGxsY8m2EY3pjh4WH/PE4kElQqFWzbxrIs9vf3WVtbY2lpiXA4zB/AxMQECwsLLC4uApBMJtnZ2fHG++ZxLpfz5q1arcowDJmmKUlKJpMCVCgUVC6XFYlElEqlvHgAqlar/nPsOI5M0/Sinc/nvay4Db68vFQ6nVa5XPacuT2/LWBJXoSnpqaa+m+DbzsSjUYVj8ebcrgleACWZZHNZjFNs3X9+yiRSJDL5YhEIs2Gux4Hyc/jdvLd3d6F/gf/h8Ed0y2fzyuVSnlb5sjIiKanpwNPFldtwevr6wqFQvpwaEifPX4sQNb4uAD19/e3rLauwe7m8olh6EdQBPQr6NHAgAAtLy8Hjm07x0dHRwAc2jazQ0NYiQRfhMP89vYtANvb24Fj24KPj48JAT8D5vk57OyQqtV40bDv7u7+veCFw2ENguRTekCjo6P3nwrbtqnVanwUYH/Q00O1Wr3/VGxsbADwcYD9Awnn+vr+4EKhAMBXAfY4UJc4ODi4H9i9FH4ZYP+0UW9tbd0P7HryfYDd/UF3yroGn52dEQ4yAt816sDrbmC69PZqJCDVbqdcLBbrPt1s26ZerxNt4zHAA+Di4sLX5gteXV0FoNM5/RC4Dkg5X7B7ZRrvAI4Bknj98iXUap3BpVIJgFQH8OeNevfFCwg3h9oXfHx8DMDXHcDu4lktFuHmpjP45OSkbaq5+qZRl25uoFjsDL66uuJhF+AxoAd4DfDqVXvw0dER9Xo9cPO5q/eBc4A3b9qDi41XetIleAC4AXj+vKk/dPfBw8NDoHOquXoCfPvsGTx92my4uxRXVlb+Oo07LGe3PDKMppu8K9+9wjAMAUqCKgHAX0Cjjc8KP/mCK5WK+vr6vEuK0XiDZKO81+hPJBJBe1j7e0Umk9Hg4KBCoVDTB2Rvb6/G43H9XqkEju2R/sX/K96F/gTllaEEcp1NCgAAAABJRU5ErkJggg==",
					"ports": [],
					"background-fit": "none",
					"background-position-x": "50%",
					"background-position-y": "50%",
					"background-width": "100%",
					"background-height": "100%",
					"infoboxCalculated": true,
					"auxunitlayouts": {}
				},
				"position": {
					"x": 723.2269118552542,
					"y": 156.5724887882993
				},
				"group": "nodes",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "464bae1c-0c35-3b4a-3af2-371ef03a0dcb",
					"bbox": {
						"x": 701.8522011008915,
						"y": 242.04110083227644,
						"w": 20,
						"h": 40
					},
					"class": "macromolecule",
					"label": "u17",
					"statesandinfos": [],
					"language": "PD",
					"border-width": 0.001,
					"border-color": "#555555",
					"background-color": "#ffffff",
					"background-opacity": 1,
					"background-image-opacity": "1 1",
					"text-wrap": "wrap",
					"font-size": 11,
					"font-family": "Helvetica",
					"font-style": "normal",
					"font-weight": "normal",
					"color": "#000",
					"background-image": "data:image/png;base64,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",
					"ports": [],
					"background-fit": "none",
					"background-position-x": "50%",
					"background-position-y": "50%",
					"background-width": "100%",
					"background-height": "100%",
					"infoboxCalculated": true,
					"auxunitlayouts": {}
				},
				"position": {
					"x": 701.8522011008915,
					"y": 242.04110083227644
				},
				"group": "nodes",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "9e04da58-86d5-7fc8-e79e-3883f25b5c2d",
					"bbox": {
						"x": 659.1230605475625,
						"y": 239.4116152597639,
						"w": 20,
						"h": 40
					},
					"class": "macromolecule",
					"label": "u18",
					"statesandinfos": [],
					"language": "PD",
					"border-width": 0.001,
					"border-color": "#555555",
					"background-color": "#ffffff",
					"background-opacity": 1,
					"background-image-opacity": "1 1",
					"text-wrap": "wrap",
					"font-size": 11,
					"font-family": "Helvetica",
					"font-style": "normal",
					"font-weight": "normal",
					"color": "#000",
					"background-image": "data:image/png;base64,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",
					"ports": [],
					"background-fit": "none",
					"background-position-x": "50%",
					"background-position-y": "50%",
					"background-width": "100%",
					"background-height": "100%",
					"infoboxCalculated": true,
					"auxunitlayouts": {}
				},
				"position": {
					"x": 659.1230605475625,
					"y": 239.4116152597639
				},
				"group": "nodes",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "16102c94-c326-51c3-8636-3ae19b603483",
					"bbox": {
						"x": 827.5998410823756,
						"y": 419.9455390609479,
						"w": 20,
						"h": 40
					},
					"class": "macromolecule",
					"label": "u19",
					"statesandinfos": [],
					"language": "PD",
					"border-width": 0.001,
					"border-color": "#555555",
					"background-color": "#ffffff",
					"background-opacity": 1,
					"background-image-opacity": "1 1",
					"text-wrap": "wrap",
					"font-size": 11,
					"font-family": "Helvetica",
					"font-style": "normal",
					"font-weight": "normal",
					"color": "#000",
					"background-image": "data:image/png;base64,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",
					"ports": [],
					"background-fit": "none",
					"background-position-x": "50%",
					"background-position-y": "50%",
					"background-width": "100%",
					"background-height": "100%",
					"infoboxCalculated": true,
					"auxunitlayouts": {}
				},
				"position": {
					"x": 827.5998410823756,
					"y": 419.9455390609479
				},
				"group": "nodes",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "e833b238-0bb7-c5d2-ebec-aa0604bcd484",
					"bbox": {
						"x": 772.0136740057479,
						"y": 420.8797603563535,
						"w": 20,
						"h": 40
					},
					"class": "macromolecule",
					"label": "u20",
					"statesandinfos": [],
					"language": "PD",
					"border-width": 0.001,
					"border-color": "#555555",
					"background-color": "#ffffff",
					"background-opacity": 1,
					"background-image-opacity": "1 1",
					"text-wrap": "wrap",
					"font-size": 11,
					"font-family": "Helvetica",
					"font-style": "normal",
					"font-weight": "normal",
					"color": "#000",
					"background-image": "data:image/png;base64,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",
					"ports": [],
					"background-fit": "none",
					"background-position-x": "50%",
					"background-position-y": "50%",
					"background-width": "100%",
					"background-height": "100%",
					"infoboxCalculated": true,
					"auxunitlayouts": {}
				},
				"position": {
					"x": 772.0136740057479,
					"y": 420.8797603563535
				},
				"group": "nodes",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "7e30e3e1-7f31-1080-0970-22d019957584",
					"bbox": {
						"x": 735.3590911745005,
						"y": 465.98770776577527,
						"w": 20,
						"h": 40
					},
					"class": "macromolecule",
					"label": "u21",
					"statesandinfos": [],
					"language": "PD",
					"border-width": 0.001,
					"border-color": "#555555",
					"background-color": "#ffffff",
					"background-opacity": 1,
					"background-image-opacity": "1 1",
					"text-wrap": "wrap",
					"font-size": 11,
					"font-family": "Helvetica",
					"font-style": "normal",
					"font-weight": "normal",
					"color": "#000",
					"background-image": "data:image/png;base64,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",
					"ports": [],
					"background-fit": "none",
					"background-position-x": "50%",
					"background-position-y": "50%",
					"background-width": "100%",
					"background-height": "100%",
					"infoboxCalculated": true,
					"auxunitlayouts": {}
				},
				"position": {
					"x": 735.3590911745005,
					"y": 465.98770776577527
				},
				"group": "nodes",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "11284cd9-d716-52f7-20c7-5d1750de5309",
					"bbox": {
						"x": 693.0719745439824,
						"y": 417.60998582243417,
						"w": 20,
						"h": 40
					},
					"class": "macromolecule",
					"label": "u22",
					"statesandinfos": [],
					"language": "PD",
					"border-width": 0.001,
					"border-color": "#555555",
					"background-color": "#ffffff",
					"background-opacity": 1,
					"background-image-opacity": "1 1",
					"text-wrap": "wrap",
					"font-size": 11,
					"font-family": "Helvetica",
					"font-style": "normal",
					"font-weight": "normal",
					"color": "#000",
					"background-image": "data:image/png;base64,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",
					"ports": [],
					"background-fit": "none",
					"background-position-x": "50%",
					"background-position-y": "50%",
					"background-width": "100%",
					"background-height": "100%",
					"infoboxCalculated": true,
					"auxunitlayouts": {}
				},
				"position": {
					"x": 693.0719745439824,
					"y": 417.60998582243417
				},
				"group": "nodes",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "b386ca2b-81a7-e365-4706-f955f13db03f",
					"bbox": {
						"x": 830.061524140727,
						"y": 500.0259830986339,
						"w": 20,
						"h": 40
					},
					"class": "macromolecule",
					"label": "a14",
					"statesandinfos": [],
					"language": "PD",
					"border-width": 0.001,
					"border-color": "#555555",
					"background-color": "#ffffff",
					"background-opacity": 1,
					"background-image-opacity": "1 1",
					"text-wrap": "wrap",
					"font-size": 11,
					"font-family": "Helvetica",
					"font-style": "normal",
					"font-weight": "normal",
					"color": "#000",
					"background-image": "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABYAAAAyCAYAAABYiSsbAAAABHNCSVQICAgIfAhkiAAABA5JREFUWIXtmM9LI2cYxz9KCOlWcOpqjew2zYK1Uy00tLDMoTShFISePOptLwvpf5C7B28rCCVKDwUv8b6H4M01oBEPsXjQ6iFx3RqruA4eHAkl3x6aGYyZSWLZFgr9wsv78j7zfvLM+zzvj0mPJPEPqNevs1KpsL+/3xWgWCxi23arQXfkOI7i8bgsy7prapHjOAI0PT3dYmsBp9NpAcrn83IcR3t7e77Qzc1NSVImkxGgXC4XDC6VSk0epFIpGYbRAnWfm5ub894wGo3KcRx/8NzcnADt7e0pm80KUCaTkSTNzs5qcnJShUJBkmRZliKRiMrlsubn5wWoVCr5g6empjwP3bbjOJqZmRHglZWVFW1ubgrQ/Py8185ms/5g0zS9oN1u9/X1KQz6qQGenJz0ApdOp5varprSLRqNcnp6CoBhGF4axWIxasAPjefGxsY8m2EY3pjh4WH/PE4kElQqFWzbxrIs9vf3WVtbY2lpiXA4zB/AxMQECwsLLC4uApBMJtnZ2fHG++ZxLpfz5q1arcowDJmmKUlKJpMCVCgUVC6XFYlElEqlvHgAqlar/nPsOI5M0/Sinc/nvay4Db68vFQ6nVa5XPacuT2/LWBJXoSnpqaa+m+DbzsSjUYVj8ebcrgleACWZZHNZjFNs3X9+yiRSJDL5YhEIs2Gux4Hyc/jdvLd3d6F/gf/h8Ed0y2fzyuVSnlb5sjIiKanpwNPFldtwevr6wqFQvpwaEifPX4sQNb4uAD19/e3rLauwe7m8olh6EdQBPQr6NHAgAAtLy8Hjm07x0dHRwAc2jazQ0NYiQRfhMP89vYtANvb24Fj24KPj48JAT8D5vk57OyQqtV40bDv7u7+veCFw2ENguRTekCjo6P3nwrbtqnVanwUYH/Q00O1Wr3/VGxsbADwcYD9Awnn+vr+4EKhAMBXAfY4UJc4ODi4H9i9FH4ZYP+0UW9tbd0P7HryfYDd/UF3yroGn52dEQ4yAt816sDrbmC69PZqJCDVbqdcLBbrPt1s26ZerxNt4zHAA+Di4sLX5gteXV0FoNM5/RC4Dkg5X7B7ZRrvAI4Bknj98iXUap3BpVIJgFQH8OeNevfFCwg3h9oXfHx8DMDXHcDu4lktFuHmpjP45OSkbaq5+qZRl25uoFjsDL66uuJhF+AxoAd4DfDqVXvw0dER9Xo9cPO5q/eBc4A3b9qDi41XetIleAC4AXj+vKk/dPfBw8NDoHOquXoCfPvsGTx92my4uxRXVlb+Oo07LGe3PDKMppu8K9+9wjAMAUqCKgHAX0Cjjc8KP/mCK5WK+vr6vEuK0XiDZKO81+hPJBJBe1j7e0Umk9Hg4KBCoVDTB2Rvb6/G43H9XqkEju2R/sX/K96F/gTllaEEcp1NCgAAAABJRU5ErkJggg==",
					"ports": [],
					"background-fit": "none",
					"background-position-x": "50%",
					"background-position-y": "50%",
					"background-width": "100%",
					"background-height": "100%",
					"infoboxCalculated": true,
					"auxunitlayouts": {}
				},
				"position": {
					"x": 830.061524140727,
					"y": 500.0259830986339
				},
				"group": "nodes",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "db182fe4-ce6c-7869-72ce-7a4b11327e3a",
					"bbox": {
						"x": 606.6565047189728,
						"y": 416.67576452702866,
						"w": 20,
						"h": 40
					},
					"class": "macromolecule",
					"label": "u23",
					"statesandinfos": [],
					"language": "PD",
					"border-width": 0.001,
					"border-color": "#555555",
					"background-color": "#ffffff",
					"background-opacity": 1,
					"background-image-opacity": "1 1",
					"text-wrap": "wrap",
					"font-size": 11,
					"font-family": "Helvetica",
					"font-style": "normal",
					"font-weight": "normal",
					"color": "#000",
					"background-image": "data:image/png;base64,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",
					"ports": [],
					"background-fit": "none",
					"background-position-x": "50%",
					"background-position-y": "50%",
					"background-width": "100%",
					"background-height": "100%",
					"infoboxCalculated": true,
					"auxunitlayouts": {}
				},
				"position": {
					"x": 606.6565047189728,
					"y": 416.67576452702866
				},
				"group": "nodes",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "97d3df31-9033-96c4-359d-08ed397b29c4",
					"bbox": {
						"x": 608.5249473097838,
						"y": 367.16203587053667,
						"w": 20,
						"h": 40
					},
					"class": "macromolecule",
					"label": "u24",
					"statesandinfos": [],
					"language": "PD",
					"border-width": 0.001,
					"border-color": "#555555",
					"background-color": "#ffffff",
					"background-opacity": 1,
					"background-image-opacity": "1 1",
					"text-wrap": "wrap",
					"font-size": 11,
					"font-family": "Helvetica",
					"font-style": "normal",
					"font-weight": "normal",
					"color": "#000",
					"background-image": "data:image/png;base64,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",
					"ports": [],
					"background-fit": "none",
					"background-position-x": "50%",
					"background-position-y": "50%",
					"background-width": "100%",
					"background-height": "100%",
					"infoboxCalculated": true,
					"auxunitlayouts": {}
				},
				"position": {
					"x": 608.5249473097838,
					"y": 367.16203587053667
				},
				"group": "nodes",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "91966017-4d7f-7634-6823-1a405da45139",
					"bbox": {
						"x": 597.7814024126204,
						"y": 327.9247414635053,
						"w": 20,
						"h": 40
					},
					"class": "macromolecule",
					"label": "u25",
					"statesandinfos": [],
					"language": "PD",
					"border-width": 0.001,
					"border-color": "#555555",
					"background-color": "#ffffff",
					"background-opacity": 1,
					"background-image-opacity": "1 1",
					"text-wrap": "wrap",
					"font-size": 11,
					"font-family": "Helvetica",
					"font-style": "normal",
					"font-weight": "normal",
					"color": "#000",
					"background-image": "data:image/png;base64,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",
					"ports": [],
					"background-fit": "none",
					"background-position-x": "50%",
					"background-position-y": "50%",
					"background-width": "100%",
					"background-height": "100%",
					"infoboxCalculated": true,
					"auxunitlayouts": {}
				},
				"position": {
					"x": 597.7814024126204,
					"y": 327.9247414635053
				},
				"group": "nodes",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "1998dad6-f944-21b8-11dc-05d4cebd39e6",
					"bbox": {
						"x": 612.2618324914058,
						"y": 289.6216683518794,
						"w": 20,
						"h": 40
					},
					"class": "macromolecule",
					"label": "u26",
					"statesandinfos": [],
					"language": "PD",
					"border-width": 0.001,
					"border-color": "#555555",
					"background-color": "#ffffff",
					"background-opacity": 1,
					"background-image-opacity": "1 1",
					"text-wrap": "wrap",
					"font-size": 11,
					"font-family": "Helvetica",
					"font-style": "normal",
					"font-weight": "normal",
					"color": "#000",
					"background-image": "data:image/png;base64,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",
					"ports": [],
					"background-fit": "none",
					"background-position-x": "50%",
					"background-position-y": "50%",
					"background-width": "100%",
					"background-height": "100%",
					"infoboxCalculated": true,
					"auxunitlayouts": {}
				},
				"position": {
					"x": 612.2618324914058,
					"y": 289.6216683518794
				},
				"group": "nodes",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "45d5101e-e0a1-821c-37d6-378cbd632d55",
					"bbox": {
						"x": 605.2551727758645,
						"y": 246.64748876322597,
						"w": 20,
						"h": 40
					},
					"class": "macromolecule",
					"label": "u27",
					"statesandinfos": [],
					"language": "PD",
					"border-width": 0.001,
					"border-color": "#555555",
					"background-color": "#ffffff",
					"background-opacity": 1,
					"background-image-opacity": "1 1",
					"text-wrap": "wrap",
					"font-size": 11,
					"font-family": "Helvetica",
					"font-style": "normal",
					"font-weight": "normal",
					"color": "#000",
					"background-image": "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABwAAABACAIAAACGI4BPAAAAA3NCSVQICAjb4U/gAAAAGXRFWHRTb2Z0d2FyZQBnbm9tZS1zY3JlZW5zaG907wO/PgAAB8dJREFUWIXtmMtPE+8ax9+ZzkwvM9OhN9pyK5jSlgCNgsRAICYQw8LoQl2gKxcmLv0HjDFu3bhz4YYYVhJjTEyoJpqI0WC5JYCU0gu1NC3l0tu007l0Zn6LOYdTS8sPz/mdk/yS812+l888z/s+87zP+0KyLIO/WvBfTvwfQhmGWVpaYhhGkqRG00RRLBaLW1tbhULhz6GlUikcDvt8vlKpdIotsixzHOfz+aLRKMdxNb1IzdB4PP7x48dkMgnDsCAIMAwjCAJB0PEYSZJEUZQkiSAIv99PEITRaOzo6Kj95rHK5fLMzMzVq1dTqVSlUlleXg4EAjzPV4/JZrPBYHBra0uW5ZWVlXv37r148UL+Vb+4v7q6GovFJiYmTCZTMpl89erV9+/fAQAsywaDwWg0qqzJ8vLys2fPOI5zu92dnZ3pdHp9fb2h+4lEIpfLDQ0NoSg6OzuL43h7e/vKysrs7Oz29rZKpert7b1y5YrVatVoNG/evLl27ZrD4QiHw7FYrL+/vz40nU6XSqXu7m4AwPv376empsxms8/nm56epmlakqTFxUUURScnJz0ez9u3bycmJhRoIpGo5vzLfUmSaJoWBMFisYiimEqlSJJkWTYcDudyOYIgNBrN3t5eMBikadpisUQiEUEQzGYzACCTydR3XxRFAIBKpZJluVKpVG86DMNqtVqWZUEQIAj6x27AMARBKpVKMai+pSiKWiwWDMN2dnbUarXD4chkMkaj8eLFiyqVKpVKZbNZnU7n9XpbWlri8fiFCxcwDItGowCAmpD6ZfetVitBEKFQCABw9+7dQCCwuro6Pj7+6NEjAABJkg8fPrx58+b29rbf779//z5Jkj9//gQAtLW1NYR6PB6LxTI/Py8IwvDw8MDAgMlk0uv1Ho8HAKDT6VwuF0EQWq328uXLbrebpulQKKTT6Xp6ehpC29ranE4ny7Jfv37V6/VjY2NutxtBELVarawPhmEajcblck1OTmq12g8fPqAo2tPTY7Va628UAECr1Xq93kKhMD8/7/V6Ozo6IAgqFovVY5qampqamkRRpGn6y5cv4+Pjly5dUrarPhQA4HA4SJKcm5sDAEiSVDP6WJVKZX9/f2hoaHBwsLm5uaa3FqrYcuvWLRRFq/NIjTAM6+zsbGtrQ5A6hDpNSlQ2wilSIrSRH3/r4+T/0P9QdUKqWolEYmVl5fPnzwCAQqHw6dMnFEU9Ho/dbj9llurx48eN+gKBwLt3716/fu33+w8PDyuVSjabjcVihUKBJMmTP9KZLJ2bm5ueno5GoxRFoSh67tw5mqZ9Pt/a2hrDML29vQ1nyg3Ecdz169chCDp//vyDBw+8Xu/MzMyTJ0+GhoYwDBsdHVVO/7pzG1q6vb1dKBRQFCUIwuVy3blzR6VSlUolHMd5ns/n8zRNkyRZNz80hG5ububzeavVajKZNjc3fT6fSqVqaWkBAKjVap7nf/786fF4MAz7bWhTU9PAwMDIyEgmk4EgiKIoDMPW19d5no/H406n8/egOzs7xWLRbrc7nc7h4WGNRiOKIsdx4XDYYDCwLBuPxyuVSt25DYM/lUqVy2WKooxGY3U7RVEmk4njuFgs9tvQo6MjjuMoilLKhWMZjUar1crzfDQa/W1osVisVCqKXdXtNputvb2d5/mdnZ1G0DprKklSpVLheR6GYYIgcByv7jWbzXa7XRCERCLxG5byPB8Oh3me1+v1er2+5hRSq9U4jsuynMvllNrrTFCGYRYXF3meVyqJ2gkwjGGYEqrpdPpkbV4fWi6X19bWeJ43GAwEQZwcgGEYSZIAgGQyyTDMmaAcx4VCIaVMpCjq5ACNRmMwGMA/Y/lMUEEQdnd3RVE0m80n3QcAEATR2toKANjb22NZ9qzQdDqtQOtaSpKkUuYlEomzui+KYi6XkySp0ZpSFNXV1aVYWi6X/xyq/OAsyyIIYjAYaoJUkV6vdzgcAIDd3d1sNsuybE3A1kIZhtnf35dlmSRJkiTrJiFlo2AYPjg4SKfTJ7m10IODA+VSZDKZGlVUx6EqiuLR0dHBwUEul2MYRkn7daD5fD4WiwEAbDabRqOpC1W4FEXBMKxYyvN8oVAolUr1oblcLhKJAACam5tPgaIoarPZVCpVJpOhaRoAIAiCsr11oMViMZlMAgDsdrtWq20ERRCkBirLMs/zgiBIklQLLZfLh4eHivunQNVqdVdXF4Ig2WxWgSqqD+U4TnkXUC6gjaAajaavrw9F0aOjo2po/TWVJEnJZhaL5ZR6GsMwh8OBIMjh4WE+nz9uV66BtVAURZWAZxhGuVieLo7jqlOqclOohR7/gjMzMxsbG3XzBcuyoVDo+fPnNE27XC4lD8AwjOO4cqOtPU66u7tv3LgRDof9fr8gCEtLSz09PR0dHa2trZIkZbPZSCSyvr6+sbGxsLCAIMjIyIjb7YYgSEmyivtQzWOX8gjx9OnThYWFVCpFUZTT6VSgyltHJBIJBALZbNZutw8PD09NTfX19eE4rtPpcByHFJ18QeN5fm9v7+XLl9++fUskEjRNl0olJRthGIbjOEVRdrt9dHT09u3bZrMZRVEEQapDpQ70WIlEYmNjY3Fx8cePH8FgEABgs9n6+/vHxsYGBweVuqquToP+2/r7XCT+K9A/AN6eWQAzvN+SAAAAAElFTkSuQmCC",
					"ports": [],
					"background-fit": "none",
					"background-position-x": "50%",
					"background-position-y": "50%",
					"background-width": "100%",
					"background-height": "100%",
					"infoboxCalculated": true,
					"auxunitlayouts": {}
				},
				"position": {
					"x": 605.2551727758645,
					"y": 246.64748876322597
				},
				"group": "nodes",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "97f86367-eafd-54f7-4951-8360862b846f",
					"bbox": {
						"x": 825.2642878438619,
						"y": 461.9854973541959,
						"w": 20,
						"h": 40
					},
					"class": "macromolecule",
					"label": "u28",
					"statesandinfos": [],
					"language": "PD",
					"border-width": 0.001,
					"border-color": "#555555",
					"background-color": "#ffffff",
					"background-opacity": 1,
					"background-image-opacity": "1 1",
					"text-wrap": "wrap",
					"font-size": 11,
					"font-family": "Helvetica",
					"font-style": "normal",
					"font-weight": "normal",
					"color": "#000",
					"background-image": "data:image/png;base64,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",
					"ports": [],
					"background-fit": "none",
					"background-position-x": "50%",
					"background-position-y": "50%",
					"background-width": "100%",
					"background-height": "100%",
					"infoboxCalculated": true,
					"auxunitlayouts": {}
				},
				"position": {
					"x": 825.2642878438619,
					"y": 461.9854973541959
				},
				"group": "nodes",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "5ea74092-08ec-6937-33c9-9f6fbe9226a2",
					"bbox": {
						"x": 777.619001778181,
						"y": 461.9854973541959,
						"w": 20,
						"h": 40
					},
					"class": "macromolecule",
					"label": "u29",
					"statesandinfos": [],
					"language": "PD",
					"border-width": 0.001,
					"border-color": "#555555",
					"background-color": "#ffffff",
					"background-opacity": 1,
					"background-image-opacity": "1 1",
					"text-wrap": "wrap",
					"font-size": 11,
					"font-family": "Helvetica",
					"font-style": "normal",
					"font-weight": "normal",
					"color": "#000",
					"background-image": "data:image/png;base64,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",
					"ports": [],
					"background-fit": "none",
					"background-position-x": "50%",
					"background-position-y": "50%",
					"background-width": "100%",
					"background-height": "100%",
					"infoboxCalculated": true,
					"auxunitlayouts": {}
				},
				"position": {
					"x": 777.619001778181,
					"y": 461.9854973541959
				},
				"group": "nodes",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "8edd562b-196b-4f7e-37bf-a9e2072917b0",
					"bbox": {
						"x": 918.3078371044154,
						"y": 397.88472998291235,
						"w": 20,
						"h": 40
					},
					"class": "macromolecule",
					"label": "u30",
					"statesandinfos": [],
					"language": "PD",
					"border-width": 0.001,
					"border-color": "#555555",
					"background-color": "#ffffff",
					"background-opacity": 1,
					"background-image-opacity": "1 1",
					"text-wrap": "wrap",
					"font-size": 11,
					"font-family": "Helvetica",
					"font-style": "normal",
					"font-weight": "normal",
					"color": "#000",
					"background-image": "data:image/png;base64,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",
					"ports": [],
					"background-fit": "none",
					"background-position-x": "50%",
					"background-position-y": "50%",
					"background-width": "100%",
					"background-height": "100%",
					"infoboxCalculated": true,
					"auxunitlayouts": {}
				},
				"position": {
					"x": 918.3078371044154,
					"y": 397.88472998291235
				},
				"group": "nodes",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "f3fc754e-1421-a039-0ef0-c2d989db228e",
					"bbox": {
						"x": 701.0128555549292,
						"y": 461.5183867064931,
						"w": 20,
						"h": 40
					},
					"class": "macromolecule",
					"label": "u31",
					"statesandinfos": [],
					"language": "PD",
					"border-width": 0.001,
					"border-color": "#555555",
					"background-color": "#ffffff",
					"background-opacity": 1,
					"background-image-opacity": "1 1",
					"text-wrap": "wrap",
					"font-size": 11,
					"font-family": "Helvetica",
					"font-style": "normal",
					"font-weight": "normal",
					"color": "#000",
					"background-image": "data:image/png;base64,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",
					"ports": [],
					"background-fit": "none",
					"background-position-x": "50%",
					"background-position-y": "50%",
					"background-width": "100%",
					"background-height": "100%",
					"infoboxCalculated": true,
					"auxunitlayouts": {}
				},
				"position": {
					"x": 701.0128555549292,
					"y": 461.5183867064931
				},
				"group": "nodes",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "3a85e050-463c-f484-c100-9d39adb1a23e",
					"bbox": {
						"x": 656.6373440231675,
						"y": 459.1828334679793,
						"w": 20,
						"h": 40
					},
					"class": "macromolecule",
					"label": "u32",
					"statesandinfos": [],
					"language": "PD",
					"border-width": 0.001,
					"border-color": "#555555",
					"background-color": "#ffffff",
					"background-opacity": 1,
					"background-image-opacity": "1 1",
					"text-wrap": "wrap",
					"font-size": 11,
					"font-family": "Helvetica",
					"font-style": "normal",
					"font-weight": "normal",
					"color": "#000",
					"background-image": "data:image/png;base64,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",
					"ports": [],
					"background-fit": "none",
					"background-position-x": "50%",
					"background-position-y": "50%",
					"background-width": "100%",
					"background-height": "100%",
					"infoboxCalculated": true,
					"auxunitlayouts": {}
				},
				"position": {
					"x": 656.6373440231675,
					"y": 459.1828334679793
				},
				"group": "nodes",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "607d3097-a2d2-ed9d-39dc-b5c8a12ea7eb",
					"bbox": {
						"x": 608.5249473097838,
						"y": 457.7815015248711,
						"w": 20,
						"h": 40
					},
					"class": "macromolecule",
					"label": "u33",
					"statesandinfos": [],
					"language": "PD",
					"border-width": 0.001,
					"border-color": "#555555",
					"background-color": "#ffffff",
					"background-opacity": 1,
					"background-image-opacity": "1 1",
					"text-wrap": "wrap",
					"font-size": 11,
					"font-family": "Helvetica",
					"font-style": "normal",
					"font-weight": "normal",
					"color": "#000",
					"background-image": "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABwAAABACAIAAACGI4BPAAAAA3NCSVQICAjb4U/gAAAAGXRFWHRTb2Z0d2FyZQBnbm9tZS1zY3JlZW5zaG907wO/PgAAB8dJREFUWIXtmMtPE+8ax9+ZzkwvM9OhN9pyK5jSlgCNgsRAICYQw8LoQl2gKxcmLv0HjDFu3bhz4YYYVhJjTEyoJpqI0WC5JYCU0gu1NC3l0tu007l0Zn6LOYdTS8sPz/mdk/yS812+l888z/s+87zP+0KyLIO/WvBfTvwfQhmGWVpaYhhGkqRG00RRLBaLW1tbhULhz6GlUikcDvt8vlKpdIotsixzHOfz+aLRKMdxNb1IzdB4PP7x48dkMgnDsCAIMAwjCAJB0PEYSZJEUZQkiSAIv99PEITRaOzo6Kj95rHK5fLMzMzVq1dTqVSlUlleXg4EAjzPV4/JZrPBYHBra0uW5ZWVlXv37r148UL+Vb+4v7q6GovFJiYmTCZTMpl89erV9+/fAQAsywaDwWg0qqzJ8vLys2fPOI5zu92dnZ3pdHp9fb2h+4lEIpfLDQ0NoSg6OzuL43h7e/vKysrs7Oz29rZKpert7b1y5YrVatVoNG/evLl27ZrD4QiHw7FYrL+/vz40nU6XSqXu7m4AwPv376empsxms8/nm56epmlakqTFxUUURScnJz0ez9u3bycmJhRoIpGo5vzLfUmSaJoWBMFisYiimEqlSJJkWTYcDudyOYIgNBrN3t5eMBikadpisUQiEUEQzGYzACCTydR3XxRFAIBKpZJluVKpVG86DMNqtVqWZUEQIAj6x27AMARBKpVKMai+pSiKWiwWDMN2dnbUarXD4chkMkaj8eLFiyqVKpVKZbNZnU7n9XpbWlri8fiFCxcwDItGowCAmpD6ZfetVitBEKFQCABw9+7dQCCwuro6Pj7+6NEjAABJkg8fPrx58+b29rbf779//z5Jkj9//gQAtLW1NYR6PB6LxTI/Py8IwvDw8MDAgMlk0uv1Ho8HAKDT6VwuF0EQWq328uXLbrebpulQKKTT6Xp6ehpC29ranE4ny7Jfv37V6/VjY2NutxtBELVarawPhmEajcblck1OTmq12g8fPqAo2tPTY7Va628UAECr1Xq93kKhMD8/7/V6Ozo6IAgqFovVY5qampqamkRRpGn6y5cv4+Pjly5dUrarPhQA4HA4SJKcm5sDAEiSVDP6WJVKZX9/f2hoaHBwsLm5uaa3FqrYcuvWLRRFq/NIjTAM6+zsbGtrQ5A6hDpNSlQ2wilSIrSRH3/r4+T/0P9QdUKqWolEYmVl5fPnzwCAQqHw6dMnFEU9Ho/dbj9llurx48eN+gKBwLt3716/fu33+w8PDyuVSjabjcVihUKBJMmTP9KZLJ2bm5ueno5GoxRFoSh67tw5mqZ9Pt/a2hrDML29vQ1nyg3Ecdz169chCDp//vyDBw+8Xu/MzMyTJ0+GhoYwDBsdHVVO/7pzG1q6vb1dKBRQFCUIwuVy3blzR6VSlUolHMd5ns/n8zRNkyRZNz80hG5ububzeavVajKZNjc3fT6fSqVqaWkBAKjVap7nf/786fF4MAz7bWhTU9PAwMDIyEgmk4EgiKIoDMPW19d5no/H406n8/egOzs7xWLRbrc7nc7h4WGNRiOKIsdx4XDYYDCwLBuPxyuVSt25DYM/lUqVy2WKooxGY3U7RVEmk4njuFgs9tvQo6MjjuMoilLKhWMZjUar1crzfDQa/W1osVisVCqKXdXtNputvb2d5/mdnZ1G0DprKklSpVLheR6GYYIgcByv7jWbzXa7XRCERCLxG5byPB8Oh3me1+v1er2+5hRSq9U4jsuynMvllNrrTFCGYRYXF3meVyqJ2gkwjGGYEqrpdPpkbV4fWi6X19bWeJ43GAwEQZwcgGEYSZIAgGQyyTDMmaAcx4VCIaVMpCjq5ACNRmMwGMA/Y/lMUEEQdnd3RVE0m80n3QcAEATR2toKANjb22NZ9qzQdDqtQOtaSpKkUuYlEomzui+KYi6XkySp0ZpSFNXV1aVYWi6X/xyq/OAsyyIIYjAYaoJUkV6vdzgcAIDd3d1sNsuybE3A1kIZhtnf35dlmSRJkiTrJiFlo2AYPjg4SKfTJ7m10IODA+VSZDKZGlVUx6EqiuLR0dHBwUEul2MYRkn7daD5fD4WiwEAbDabRqOpC1W4FEXBMKxYyvN8oVAolUr1oblcLhKJAACam5tPgaIoarPZVCpVJpOhaRoAIAiCsr11oMViMZlMAgDsdrtWq20ERRCkBirLMs/zgiBIklQLLZfLh4eHivunQNVqdVdXF4Ig2WxWgSqqD+U4TnkXUC6gjaAajaavrw9F0aOjo2po/TWVJEnJZhaL5ZR6GsMwh8OBIMjh4WE+nz9uV66BtVAURZWAZxhGuVieLo7jqlOqclOohR7/gjMzMxsbG3XzBcuyoVDo+fPnNE27XC4lD8AwjOO4cqOtPU66u7tv3LgRDof9fr8gCEtLSz09PR0dHa2trZIkZbPZSCSyvr6+sbGxsLCAIMjIyIjb7YYgSEmyivtQzWOX8gjx9OnThYWFVCpFUZTT6VSgyltHJBIJBALZbNZutw8PD09NTfX19eE4rtPpcByHFJ18QeN5fm9v7+XLl9++fUskEjRNl0olJRthGIbjOEVRdrt9dHT09u3bZrMZRVEEQapDpQ70WIlEYmNjY3Fx8cePH8FgEABgs9n6+/vHxsYGBweVuqquToP+2/r7XCT+K9A/AN6eWQAzvN+SAAAAAElFTkSuQmCC",
					"ports": [],
					"background-fit": "none",
					"background-position-x": "50%",
					"background-position-y": "50%",
					"background-width": "100%",
					"background-height": "100%",
					"infoboxCalculated": true,
					"auxunitlayouts": {}
				},
				"position": {
					"x": 608.5249473097838,
					"y": 457.7815015248711
				},
				"group": "nodes",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "c54786e2-bbea-d15b-3e21-7cf32b9338ca",
					"bbox": {
						"x": 773.5200858791309,
						"y": 200.08021628162345,
						"w": 20,
						"h": 40
					},
					"class": "macromolecule",
					"label": "u34",
					"statesandinfos": [],
					"language": "PD",
					"border-width": 0.001,
					"border-color": "#555555",
					"background-color": "#ffffff",
					"background-opacity": 1,
					"background-image-opacity": "1 1",
					"text-wrap": "wrap",
					"font-size": 11,
					"font-family": "Helvetica",
					"font-style": "normal",
					"font-weight": "normal",
					"color": "#000",
					"background-image": "data:image/png;base64,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",
					"ports": [],
					"background-fit": "none",
					"background-position-x": "50%",
					"background-position-y": "50%",
					"background-width": "100%",
					"background-height": "100%",
					"infoboxCalculated": true,
					"auxunitlayouts": {}
				},
				"position": {
					"x": 773.5200858791309,
					"y": 200.08021628162345
				},
				"group": "nodes",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "d4e4f860-ffb4-cbf6-80b7-675c821ed4d2",
					"bbox": {
						"x": 724.4863719898078,
						"y": 199.08963620305127,
						"w": 20,
						"h": 40
					},
					"class": "macromolecule",
					"label": "u35",
					"statesandinfos": [],
					"language": "PD",
					"border-width": 0.001,
					"border-color": "#555555",
					"background-color": "#ffffff",
					"background-opacity": 1,
					"background-image-opacity": "1 1",
					"text-wrap": "wrap",
					"font-size": 11,
					"font-family": "Helvetica",
					"font-style": "normal",
					"font-weight": "normal",
					"color": "#000",
					"background-image": "data:image/png;base64,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",
					"ports": [],
					"background-fit": "none",
					"background-position-x": "50%",
					"background-position-y": "50%",
					"background-width": "100%",
					"background-height": "100%",
					"infoboxCalculated": true,
					"auxunitlayouts": {}
				},
				"position": {
					"x": 724.4863719898078,
					"y": 199.08963620305127
				},
				"group": "nodes",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "25f4cc48-4e4e-e80e-174f-fa4ba64616da",
					"bbox": {
						"x": 699.226579986217,
						"y": 195.12731588876252,
						"w": 20,
						"h": 40
					},
					"class": "macromolecule",
					"label": "u36",
					"statesandinfos": [],
					"language": "PD",
					"border-width": 0.001,
					"border-color": "#555555",
					"background-color": "#ffffff",
					"background-opacity": 1,
					"background-image-opacity": "1 1",
					"text-wrap": "wrap",
					"font-size": 11,
					"font-family": "Helvetica",
					"font-style": "normal",
					"font-weight": "normal",
					"color": "#000",
					"background-image": "data:image/png;base64,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",
					"ports": [],
					"background-fit": "none",
					"background-position-x": "50%",
					"background-position-y": "50%",
					"background-width": "100%",
					"background-height": "100%",
					"infoboxCalculated": true,
					"auxunitlayouts": {}
				},
				"position": {
					"x": 699.226579986217,
					"y": 195.12731588876252
				},
				"group": "nodes",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "73eceeb1-0069-9139-4398-5dffeb19bddf",
					"bbox": {
						"x": 656.1363465683271,
						"y": 199.58492624233736,
						"w": 20,
						"h": 40
					},
					"class": "macromolecule",
					"label": "u37",
					"statesandinfos": [],
					"language": "PD",
					"border-width": 0.001,
					"border-color": "#555555",
					"background-color": "#ffffff",
					"background-opacity": 1,
					"background-image-opacity": "1 1",
					"text-wrap": "wrap",
					"font-size": 11,
					"font-family": "Helvetica",
					"font-style": "normal",
					"font-weight": "normal",
					"color": "#000",
					"background-image": "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABwAAABACAIAAACGI4BPAAAAA3NCSVQICAjb4U/gAAAAGXRFWHRTb2Z0d2FyZQBnbm9tZS1zY3JlZW5zaG907wO/PgAAB8dJREFUWIXtmMtPE+8ax9+ZzkwvM9OhN9pyK5jSlgCNgsRAICYQw8LoQl2gKxcmLv0HjDFu3bhz4YYYVhJjTEyoJpqI0WC5JYCU0gu1NC3l0tu007l0Zn6LOYdTS8sPz/mdk/yS812+l888z/s+87zP+0KyLIO/WvBfTvwfQhmGWVpaYhhGkqRG00RRLBaLW1tbhULhz6GlUikcDvt8vlKpdIotsixzHOfz+aLRKMdxNb1IzdB4PP7x48dkMgnDsCAIMAwjCAJB0PEYSZJEUZQkiSAIv99PEITRaOzo6Kj95rHK5fLMzMzVq1dTqVSlUlleXg4EAjzPV4/JZrPBYHBra0uW5ZWVlXv37r148UL+Vb+4v7q6GovFJiYmTCZTMpl89erV9+/fAQAsywaDwWg0qqzJ8vLys2fPOI5zu92dnZ3pdHp9fb2h+4lEIpfLDQ0NoSg6OzuL43h7e/vKysrs7Oz29rZKpert7b1y5YrVatVoNG/evLl27ZrD4QiHw7FYrL+/vz40nU6XSqXu7m4AwPv376empsxms8/nm56epmlakqTFxUUURScnJz0ez9u3bycmJhRoIpGo5vzLfUmSaJoWBMFisYiimEqlSJJkWTYcDudyOYIgNBrN3t5eMBikadpisUQiEUEQzGYzACCTydR3XxRFAIBKpZJluVKpVG86DMNqtVqWZUEQIAj6x27AMARBKpVKMai+pSiKWiwWDMN2dnbUarXD4chkMkaj8eLFiyqVKpVKZbNZnU7n9XpbWlri8fiFCxcwDItGowCAmpD6ZfetVitBEKFQCABw9+7dQCCwuro6Pj7+6NEjAABJkg8fPrx58+b29rbf779//z5Jkj9//gQAtLW1NYR6PB6LxTI/Py8IwvDw8MDAgMlk0uv1Ho8HAKDT6VwuF0EQWq328uXLbrebpulQKKTT6Xp6ehpC29ranE4ny7Jfv37V6/VjY2NutxtBELVarawPhmEajcblck1OTmq12g8fPqAo2tPTY7Va628UAECr1Xq93kKhMD8/7/V6Ozo6IAgqFovVY5qampqamkRRpGn6y5cv4+Pjly5dUrarPhQA4HA4SJKcm5sDAEiSVDP6WJVKZX9/f2hoaHBwsLm5uaa3FqrYcuvWLRRFq/NIjTAM6+zsbGtrQ5A6hDpNSlQ2wilSIrSRH3/r4+T/0P9QdUKqWolEYmVl5fPnzwCAQqHw6dMnFEU9Ho/dbj9llurx48eN+gKBwLt3716/fu33+w8PDyuVSjabjcVihUKBJMmTP9KZLJ2bm5ueno5GoxRFoSh67tw5mqZ9Pt/a2hrDML29vQ1nyg3Ecdz169chCDp//vyDBw+8Xu/MzMyTJ0+GhoYwDBsdHVVO/7pzG1q6vb1dKBRQFCUIwuVy3blzR6VSlUolHMd5ns/n8zRNkyRZNz80hG5ububzeavVajKZNjc3fT6fSqVqaWkBAKjVap7nf/786fF4MAz7bWhTU9PAwMDIyEgmk4EgiKIoDMPW19d5no/H406n8/egOzs7xWLRbrc7nc7h4WGNRiOKIsdx4XDYYDCwLBuPxyuVSt25DYM/lUqVy2WKooxGY3U7RVEmk4njuFgs9tvQo6MjjuMoilLKhWMZjUar1crzfDQa/W1osVisVCqKXdXtNputvb2d5/mdnZ1G0DprKklSpVLheR6GYYIgcByv7jWbzXa7XRCERCLxG5byPB8Oh3me1+v1er2+5hRSq9U4jsuynMvllNrrTFCGYRYXF3meVyqJ2gkwjGGYEqrpdPpkbV4fWi6X19bWeJ43GAwEQZwcgGEYSZIAgGQyyTDMmaAcx4VCIaVMpCjq5ACNRmMwGMA/Y/lMUEEQdnd3RVE0m80n3QcAEATR2toKANjb22NZ9qzQdDqtQOtaSpKkUuYlEomzui+KYi6XkySp0ZpSFNXV1aVYWi6X/xyq/OAsyyIIYjAYaoJUkV6vdzgcAIDd3d1sNsuybE3A1kIZhtnf35dlmSRJkiTrJiFlo2AYPjg4SKfTJ7m10IODA+VSZDKZGlVUx6EqiuLR0dHBwUEul2MYRkn7daD5fD4WiwEAbDabRqOpC1W4FEXBMKxYyvN8oVAolUr1oblcLhKJAACam5tPgaIoarPZVCpVJpOhaRoAIAiCsr11oMViMZlMAgDsdrtWq20ERRCkBirLMs/zgiBIklQLLZfLh4eHivunQNVqdVdXF4Ig2WxWgSqqD+U4TnkXUC6gjaAajaavrw9F0aOjo2po/TWVJEnJZhaL5ZR6GsMwh8OBIMjh4WE+nz9uV66BtVAURZWAZxhGuVieLo7jqlOqclOohR7/gjMzMxsbG3XzBcuyoVDo+fPnNE27XC4lD8AwjOO4cqOtPU66u7tv3LgRDof9fr8gCEtLSz09PR0dHa2trZIkZbPZSCSyvr6+sbGxsLCAIMjIyIjb7YYgSEmyivtQzWOX8gjx9OnThYWFVCpFUZTT6VSgyltHJBIJBALZbNZutw8PD09NTfX19eE4rtPpcByHFJ18QeN5fm9v7+XLl9++fUskEjRNl0olJRthGIbjOEVRdrt9dHT09u3bZrMZRVEEQapDpQ70WIlEYmNjY3Fx8cePH8FgEABgs9n6+/vHxsYGBweVuqquToP+2/r7XCT+K9A/AN6eWQAzvN+SAAAAAElFTkSuQmCC",
					"ports": [],
					"background-fit": "none",
					"background-position-x": "50%",
					"background-position-y": "50%",
					"background-width": "100%",
					"background-height": "100%",
					"infoboxCalculated": true,
					"auxunitlayouts": {}
				},
				"position": {
					"x": 656.1363465683271,
					"y": 199.58492624233736
				},
				"group": "nodes",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "0ddcc98c-7b7c-ac2e-2207-081c5ffc9921",
					"bbox": {
						"x": 869.6298990612723,
						"y": 402.68778079409213,
						"w": 20,
						"h": 40
					},
					"class": "macromolecule",
					"label": "a11",
					"statesandinfos": [],
					"language": "PD",
					"border-width": 0.001,
					"border-color": "#555555",
					"background-color": "#ffffff",
					"background-opacity": 1,
					"background-image-opacity": "1 1",
					"text-wrap": "wrap",
					"font-size": 11,
					"font-family": "Helvetica",
					"font-style": "normal",
					"font-weight": "normal",
					"color": "#000",
					"background-image": "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABYAAAAyCAYAAABYiSsbAAAABHNCSVQICAgIfAhkiAAABA5JREFUWIXtmM9LI2cYxz9KCOlWcOpqjew2zYK1Uy00tLDMoTShFISePOptLwvpf5C7B28rCCVKDwUv8b6H4M01oBEPsXjQ6iFx3RqruA4eHAkl3x6aGYyZSWLZFgr9wsv78j7zfvLM+zzvj0mPJPEPqNevs1KpsL+/3xWgWCxi23arQXfkOI7i8bgsy7prapHjOAI0PT3dYmsBp9NpAcrn83IcR3t7e77Qzc1NSVImkxGgXC4XDC6VSk0epFIpGYbRAnWfm5ub894wGo3KcRx/8NzcnADt7e0pm80KUCaTkSTNzs5qcnJShUJBkmRZliKRiMrlsubn5wWoVCr5g6empjwP3bbjOJqZmRHglZWVFW1ubgrQ/Py8185ms/5g0zS9oN1u9/X1KQz6qQGenJz0ApdOp5varprSLRqNcnp6CoBhGF4axWIxasAPjefGxsY8m2EY3pjh4WH/PE4kElQqFWzbxrIs9vf3WVtbY2lpiXA4zB/AxMQECwsLLC4uApBMJtnZ2fHG++ZxLpfz5q1arcowDJmmKUlKJpMCVCgUVC6XFYlElEqlvHgAqlar/nPsOI5M0/Sinc/nvay4Db68vFQ6nVa5XPacuT2/LWBJXoSnpqaa+m+DbzsSjUYVj8ebcrgleACWZZHNZjFNs3X9+yiRSJDL5YhEIs2Gux4Hyc/jdvLd3d6F/gf/h8Ed0y2fzyuVSnlb5sjIiKanpwNPFldtwevr6wqFQvpwaEifPX4sQNb4uAD19/e3rLauwe7m8olh6EdQBPQr6NHAgAAtLy8Hjm07x0dHRwAc2jazQ0NYiQRfhMP89vYtANvb24Fj24KPj48JAT8D5vk57OyQqtV40bDv7u7+veCFw2ENguRTekCjo6P3nwrbtqnVanwUYH/Q00O1Wr3/VGxsbADwcYD9Awnn+vr+4EKhAMBXAfY4UJc4ODi4H9i9FH4ZYP+0UW9tbd0P7HryfYDd/UF3yroGn52dEQ4yAt816sDrbmC69PZqJCDVbqdcLBbrPt1s26ZerxNt4zHAA+Di4sLX5gteXV0FoNM5/RC4Dkg5X7B7ZRrvAI4Bknj98iXUap3BpVIJgFQH8OeNevfFCwg3h9oXfHx8DMDXHcDu4lktFuHmpjP45OSkbaq5+qZRl25uoFjsDL66uuJhF+AxoAd4DfDqVXvw0dER9Xo9cPO5q/eBc4A3b9qDi41XetIleAC4AXj+vKk/dPfBw8NDoHOquXoCfPvsGTx92my4uxRXVlb+Oo07LGe3PDKMppu8K9+9wjAMAUqCKgHAX0Cjjc8KP/mCK5WK+vr6vEuK0XiDZKO81+hPJBJBe1j7e0Umk9Hg4KBCoVDTB2Rvb6/G43H9XqkEju2R/sX/K96F/gTllaEEcp1NCgAAAABJRU5ErkJggg==",
					"ports": [],
					"background-fit": "none",
					"background-position-x": "50%",
					"background-position-y": "50%",
					"background-width": "100%",
					"background-height": "100%",
					"infoboxCalculated": true,
					"auxunitlayouts": {}
				},
				"position": {
					"x": 869.6298990612723,
					"y": 402.68778079409213
				},
				"group": "nodes",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "97a17094-822f-fc65-78f3-fc5b8aca0b23",
					"bbox": {
						"x": 871.8902896484761,
						"y": 237.60001383886802,
						"w": 20,
						"h": 40
					},
					"class": "macromolecule",
					"label": "u38",
					"statesandinfos": [],
					"language": "PD",
					"border-width": 0.001,
					"border-color": "#555555",
					"background-color": "#ffffff",
					"background-opacity": 1,
					"background-image-opacity": "1 1",
					"text-wrap": "wrap",
					"font-size": 11,
					"font-family": "Helvetica",
					"font-style": "normal",
					"font-weight": "normal",
					"color": "#000",
					"background-image": "data:image/png;base64,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",
					"ports": [],
					"background-fit": "none",
					"background-position-x": "50%",
					"background-position-y": "50%",
					"background-width": "100%",
					"background-height": "100%",
					"infoboxCalculated": true,
					"auxunitlayouts": {}
				},
				"position": {
					"x": 871.8902896484761,
					"y": 237.60001383886802
				},
				"group": "nodes",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "8c9ccb35-a1e8-1772-cbad-6e5f46b95b8a",
					"bbox": {
						"x": 868.5711254822504,
						"y": 279.42148233331346,
						"w": 20,
						"h": 40
					},
					"class": "macromolecule",
					"label": "u39",
					"statesandinfos": [],
					"language": "PD",
					"border-width": 0.001,
					"border-color": "#555555",
					"background-color": "#ffffff",
					"background-opacity": 1,
					"background-image-opacity": "1 1",
					"text-wrap": "wrap",
					"font-size": 11,
					"font-family": "Helvetica",
					"font-style": "normal",
					"font-weight": "normal",
					"color": "#000",
					"background-image": "data:image/png;base64,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",
					"ports": [],
					"background-fit": "none",
					"background-position-x": "50%",
					"background-position-y": "50%",
					"background-width": "100%",
					"background-height": "100%",
					"infoboxCalculated": true,
					"auxunitlayouts": {}
				},
				"position": {
					"x": 868.5711254822504,
					"y": 279.42148233331346
				},
				"group": "nodes",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "e98b25fb-7352-b78a-de16-240d09bda830",
					"bbox": {
						"x": 870.562623981986,
						"y": 315.2684553285524,
						"w": 20,
						"h": 40
					},
					"class": "macromolecule",
					"label": "u40",
					"statesandinfos": [],
					"language": "PD",
					"border-width": 0.001,
					"border-color": "#555555",
					"background-color": "#ffffff",
					"background-opacity": 1,
					"background-image-opacity": "1 1",
					"text-wrap": "wrap",
					"font-size": 11,
					"font-family": "Helvetica",
					"font-style": "normal",
					"font-weight": "normal",
					"color": "#000",
					"background-image": "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABwAAABACAIAAACGI4BPAAAAA3NCSVQICAjb4U/gAAAAGXRFWHRTb2Z0d2FyZQBnbm9tZS1zY3JlZW5zaG907wO/PgAAB8dJREFUWIXtmMtPE+8ax9+ZzkwvM9OhN9pyK5jSlgCNgsRAICYQw8LoQl2gKxcmLv0HjDFu3bhz4YYYVhJjTEyoJpqI0WC5JYCU0gu1NC3l0tu007l0Zn6LOYdTS8sPz/mdk/yS812+l888z/s+87zP+0KyLIO/WvBfTvwfQhmGWVpaYhhGkqRG00RRLBaLW1tbhULhz6GlUikcDvt8vlKpdIotsixzHOfz+aLRKMdxNb1IzdB4PP7x48dkMgnDsCAIMAwjCAJB0PEYSZJEUZQkiSAIv99PEITRaOzo6Kj95rHK5fLMzMzVq1dTqVSlUlleXg4EAjzPV4/JZrPBYHBra0uW5ZWVlXv37r148UL+Vb+4v7q6GovFJiYmTCZTMpl89erV9+/fAQAsywaDwWg0qqzJ8vLys2fPOI5zu92dnZ3pdHp9fb2h+4lEIpfLDQ0NoSg6OzuL43h7e/vKysrs7Oz29rZKpert7b1y5YrVatVoNG/evLl27ZrD4QiHw7FYrL+/vz40nU6XSqXu7m4AwPv376empsxms8/nm56epmlakqTFxUUURScnJz0ez9u3bycmJhRoIpGo5vzLfUmSaJoWBMFisYiimEqlSJJkWTYcDudyOYIgNBrN3t5eMBikadpisUQiEUEQzGYzACCTydR3XxRFAIBKpZJluVKpVG86DMNqtVqWZUEQIAj6x27AMARBKpVKMai+pSiKWiwWDMN2dnbUarXD4chkMkaj8eLFiyqVKpVKZbNZnU7n9XpbWlri8fiFCxcwDItGowCAmpD6ZfetVitBEKFQCABw9+7dQCCwuro6Pj7+6NEjAABJkg8fPrx58+b29rbf779//z5Jkj9//gQAtLW1NYR6PB6LxTI/Py8IwvDw8MDAgMlk0uv1Ho8HAKDT6VwuF0EQWq328uXLbrebpulQKKTT6Xp6ehpC29ranE4ny7Jfv37V6/VjY2NutxtBELVarawPhmEajcblck1OTmq12g8fPqAo2tPTY7Va628UAECr1Xq93kKhMD8/7/V6Ozo6IAgqFovVY5qampqamkRRpGn6y5cv4+Pjly5dUrarPhQA4HA4SJKcm5sDAEiSVDP6WJVKZX9/f2hoaHBwsLm5uaa3FqrYcuvWLRRFq/NIjTAM6+zsbGtrQ5A6hDpNSlQ2wilSIrSRH3/r4+T/0P9QdUKqWolEYmVl5fPnzwCAQqHw6dMnFEU9Ho/dbj9llurx48eN+gKBwLt3716/fu33+w8PDyuVSjabjcVihUKBJMmTP9KZLJ2bm5ueno5GoxRFoSh67tw5mqZ9Pt/a2hrDML29vQ1nyg3Ecdz169chCDp//vyDBw+8Xu/MzMyTJ0+GhoYwDBsdHVVO/7pzG1q6vb1dKBRQFCUIwuVy3blzR6VSlUolHMd5ns/n8zRNkyRZNz80hG5ububzeavVajKZNjc3fT6fSqVqaWkBAKjVap7nf/786fF4MAz7bWhTU9PAwMDIyEgmk4EgiKIoDMPW19d5no/H406n8/egOzs7xWLRbrc7nc7h4WGNRiOKIsdx4XDYYDCwLBuPxyuVSt25DYM/lUqVy2WKooxGY3U7RVEmk4njuFgs9tvQo6MjjuMoilLKhWMZjUar1crzfDQa/W1osVisVCqKXdXtNputvb2d5/mdnZ1G0DprKklSpVLheR6GYYIgcByv7jWbzXa7XRCERCLxG5byPB8Oh3me1+v1er2+5hRSq9U4jsuynMvllNrrTFCGYRYXF3meVyqJ2gkwjGGYEqrpdPpkbV4fWi6X19bWeJ43GAwEQZwcgGEYSZIAgGQyyTDMmaAcx4VCIaVMpCjq5ACNRmMwGMA/Y/lMUEEQdnd3RVE0m80n3QcAEATR2toKANjb22NZ9qzQdDqtQOtaSpKkUuYlEomzui+KYi6XkySp0ZpSFNXV1aVYWi6X/xyq/OAsyyIIYjAYaoJUkV6vdzgcAIDd3d1sNsuybE3A1kIZhtnf35dlmSRJkiTrJiFlo2AYPjg4SKfTJ7m10IODA+VSZDKZGlVUx6EqiuLR0dHBwUEul2MYRkn7daD5fD4WiwEAbDabRqOpC1W4FEXBMKxYyvN8oVAolUr1oblcLhKJAACam5tPgaIoarPZVCpVJpOhaRoAIAiCsr11oMViMZlMAgDsdrtWq20ERRCkBirLMs/zgiBIklQLLZfLh4eHivunQNVqdVdXF4Ig2WxWgSqqD+U4TnkXUC6gjaAajaavrw9F0aOjo2po/TWVJEnJZhaL5ZR6GsMwh8OBIMjh4WE+nz9uV66BtVAURZWAZxhGuVieLo7jqlOqclOohR7/gjMzMxsbG3XzBcuyoVDo+fPnNE27XC4lD8AwjOO4cqOtPU66u7tv3LgRDof9fr8gCEtLSz09PR0dHa2trZIkZbPZSCSyvr6+sbGxsLCAIMjIyIjb7YYgSEmyivtQzWOX8gjx9OnThYWFVCpFUZTT6VSgyltHJBIJBALZbNZutw8PD09NTfX19eE4rtPpcByHFJ18QeN5fm9v7+XLl9++fUskEjRNl0olJRthGIbjOEVRdrt9dHT09u3bZrMZRVEEQapDpQ70WIlEYmNjY3Fx8cePH8FgEABgs9n6+/vHxsYGBweVuqquToP+2/r7XCT+K9A/AN6eWQAzvN+SAAAAAElFTkSuQmCC",
					"ports": [],
					"background-fit": "none",
					"background-position-x": "50%",
					"background-position-y": "50%",
					"background-width": "100%",
					"background-height": "100%",
					"infoboxCalculated": true,
					"auxunitlayouts": {}
				},
				"position": {
					"x": 870.562623981986,
					"y": 315.2684553285524
				},
				"group": "nodes",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "5678f1a3-0919-aecd-fb70-613a8a55c4d7",
					"bbox": {
						"x": 871.8902896484761,
						"y": 359.0814223227333,
						"w": 20,
						"h": 40
					},
					"class": "macromolecule",
					"label": "u41",
					"statesandinfos": [],
					"language": "PD",
					"border-width": 0.001,
					"border-color": "#555555",
					"background-color": "#ffffff",
					"background-opacity": 1,
					"background-image-opacity": "1 1",
					"text-wrap": "wrap",
					"font-size": 11,
					"font-family": "Helvetica",
					"font-style": "normal",
					"font-weight": "normal",
					"color": "#000",
					"background-image": "data:image/png;base64,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",
					"ports": [],
					"background-fit": "none",
					"background-position-x": "50%",
					"background-position-y": "50%",
					"background-width": "100%",
					"background-height": "100%",
					"infoboxCalculated": true,
					"auxunitlayouts": {}
				},
				"position": {
					"x": 871.8902896484761,
					"y": 359.0814223227333
				},
				"group": "nodes",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "1ebc687b-0b6a-eb35-4ac7-9b6d57a784da",
					"bbox": {
						"x": 918.3259027243886,
						"y": 342.9041536102673,
						"w": 20,
						"h": 40
					},
					"class": "macromolecule",
					"label": "u42",
					"statesandinfos": [],
					"language": "PD",
					"border-width": 0.001,
					"border-color": "#555555",
					"background-color": "#ffffff",
					"background-opacity": 1,
					"background-image-opacity": "1 1",
					"text-wrap": "wrap",
					"font-size": 11,
					"font-family": "Helvetica",
					"font-style": "normal",
					"font-weight": "normal",
					"color": "#000",
					"background-image": "data:image/png;base64,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",
					"ports": [],
					"background-fit": "none",
					"background-position-x": "50%",
					"background-position-y": "50%",
					"background-width": "100%",
					"background-height": "100%",
					"infoboxCalculated": true,
					"auxunitlayouts": {}
				},
				"position": {
					"x": 918.3259027243886,
					"y": 342.9041536102673
				},
				"group": "nodes",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "06fddad6-2abd-3413-6e24-a955f0763c53",
					"bbox": {
						"x": 871.2264568152311,
						"y": 449.36268764407583,
						"w": 20,
						"h": 40
					},
					"class": "macromolecule",
					"label": "u43",
					"statesandinfos": [],
					"language": "PD",
					"border-width": 0.001,
					"border-color": "#555555",
					"background-color": "#ffffff",
					"background-opacity": 1,
					"background-image-opacity": "1 1",
					"text-wrap": "wrap",
					"font-size": 11,
					"font-family": "Helvetica",
					"font-style": "normal",
					"font-weight": "normal",
					"color": "#000",
					"background-image": "data:image/png;base64,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",
					"ports": [],
					"background-fit": "none",
					"background-position-x": "50%",
					"background-position-y": "50%",
					"background-width": "100%",
					"background-height": "100%",
					"infoboxCalculated": true,
					"auxunitlayouts": {}
				},
				"position": {
					"x": 871.2264568152311,
					"y": 449.36268764407583
				},
				"group": "nodes",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "99f5cbe5-2c57-75ff-52b8-99e2baad068b",
					"bbox": {
						"x": 918.1656828079734,
						"y": 444.6994869196927,
						"w": 20,
						"h": 40
					},
					"class": "macromolecule",
					"label": "u44",
					"statesandinfos": [],
					"language": "PD",
					"border-width": 0.001,
					"border-color": "#555555",
					"background-color": "#ffffff",
					"background-opacity": 1,
					"background-image-opacity": "1 1",
					"text-wrap": "wrap",
					"font-size": 11,
					"font-family": "Helvetica",
					"font-style": "normal",
					"font-weight": "normal",
					"color": "#000",
					"background-image": "data:image/png;base64,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",
					"ports": [],
					"background-fit": "none",
					"background-position-x": "50%",
					"background-position-y": "50%",
					"background-width": "100%",
					"background-height": "100%",
					"infoboxCalculated": true,
					"auxunitlayouts": {}
				},
				"position": {
					"x": 918.1656828079734,
					"y": 444.6994869196927
				},
				"group": "nodes",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "30c49899-09d0-818a-a71d-fd15346f65e5",
					"bbox": {
						"x": 776.2983616611724,
						"y": 501.1416486371987,
						"w": 20,
						"h": 40
					},
					"class": "macromolecule",
					"label": "u45",
					"statesandinfos": [],
					"language": "PD",
					"border-width": 0.001,
					"border-color": "#555555",
					"background-color": "#ffffff",
					"background-opacity": 1,
					"background-image-opacity": "1 1",
					"text-wrap": "wrap",
					"font-size": 11,
					"font-family": "Helvetica",
					"font-style": "normal",
					"font-weight": "normal",
					"color": "#000",
					"background-image": "data:image/png;base64,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",
					"ports": [],
					"background-fit": "none",
					"background-position-x": "50%",
					"background-position-y": "50%",
					"background-width": "100%",
					"background-height": "100%",
					"infoboxCalculated": true,
					"auxunitlayouts": {}
				},
				"position": {
					"x": 776.2983616611724,
					"y": 501.1416486371987
				},
				"group": "nodes",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "ed36ef56-dd89-40e1-251c-09f13686eb66",
					"bbox": {
						"x": 731.8215618337465,
						"y": 499.15015013746324,
						"w": 20,
						"h": 40
					},
					"class": "macromolecule",
					"label": "u46",
					"statesandinfos": [],
					"language": "PD",
					"border-width": 0.001,
					"border-color": "#555555",
					"background-color": "#ffffff",
					"background-opacity": 1,
					"background-image-opacity": "1 1",
					"text-wrap": "wrap",
					"font-size": 11,
					"font-family": "Helvetica",
					"font-style": "normal",
					"font-weight": "normal",
					"color": "#000",
					"background-image": "data:image/png;base64,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",
					"ports": [],
					"background-fit": "none",
					"background-position-x": "50%",
					"background-position-y": "50%",
					"background-width": "100%",
					"background-height": "100%",
					"infoboxCalculated": true,
					"auxunitlayouts": {}
				},
				"position": {
					"x": 731.8215618337465,
					"y": 499.15015013746324
				},
				"group": "nodes",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "7078c4e8-4b4c-0563-9938-8af2c753f92c",
					"bbox": {
						"x": 690.000093339301,
						"y": 496.4948188044825,
						"w": 20,
						"h": 40
					},
					"class": "macromolecule",
					"label": "u47",
					"statesandinfos": [],
					"language": "PD",
					"border-width": 0.001,
					"border-color": "#555555",
					"background-color": "#ffffff",
					"background-opacity": 1,
					"background-image-opacity": "1 1",
					"text-wrap": "wrap",
					"font-size": 11,
					"font-family": "Helvetica",
					"font-style": "normal",
					"font-weight": "normal",
					"color": "#000",
					"background-image": "data:image/png;base64,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",
					"ports": [],
					"background-fit": "none",
					"background-position-x": "50%",
					"background-position-y": "50%",
					"background-width": "100%",
					"background-height": "100%",
					"infoboxCalculated": true,
					"auxunitlayouts": {}
				},
				"position": {
					"x": 690.000093339301,
					"y": 496.4948188044825
				},
				"group": "nodes",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "115069e9-e7e3-51e4-da42-481b318e5f1f",
					"bbox": {
						"x": 646.4945146902844,
						"y": 421.97873928869126,
						"w": 20,
						"h": 40
					},
					"class": "macromolecule",
					"label": "u48",
					"statesandinfos": [],
					"language": "PD",
					"border-width": 0.001,
					"border-color": "#555555",
					"background-color": "#ffffff",
					"background-opacity": 1,
					"background-image-opacity": "1 1",
					"text-wrap": "wrap",
					"font-size": 11,
					"font-family": "Helvetica",
					"font-style": "normal",
					"font-weight": "normal",
					"color": "#000",
					"background-image": "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABwAAABACAIAAACGI4BPAAAAA3NCSVQICAjb4U/gAAAAGXRFWHRTb2Z0d2FyZQBnbm9tZS1zY3JlZW5zaG907wO/PgAAB8dJREFUWIXtmMtPE+8ax9+ZzkwvM9OhN9pyK5jSlgCNgsRAICYQw8LoQl2gKxcmLv0HjDFu3bhz4YYYVhJjTEyoJpqI0WC5JYCU0gu1NC3l0tu007l0Zn6LOYdTS8sPz/mdk/yS812+l888z/s+87zP+0KyLIO/WvBfTvwfQhmGWVpaYhhGkqRG00RRLBaLW1tbhULhz6GlUikcDvt8vlKpdIotsixzHOfz+aLRKMdxNb1IzdB4PP7x48dkMgnDsCAIMAwjCAJB0PEYSZJEUZQkiSAIv99PEITRaOzo6Kj95rHK5fLMzMzVq1dTqVSlUlleXg4EAjzPV4/JZrPBYHBra0uW5ZWVlXv37r148UL+Vb+4v7q6GovFJiYmTCZTMpl89erV9+/fAQAsywaDwWg0qqzJ8vLys2fPOI5zu92dnZ3pdHp9fb2h+4lEIpfLDQ0NoSg6OzuL43h7e/vKysrs7Oz29rZKpert7b1y5YrVatVoNG/evLl27ZrD4QiHw7FYrL+/vz40nU6XSqXu7m4AwPv376empsxms8/nm56epmlakqTFxUUURScnJz0ez9u3bycmJhRoIpGo5vzLfUmSaJoWBMFisYiimEqlSJJkWTYcDudyOYIgNBrN3t5eMBikadpisUQiEUEQzGYzACCTydR3XxRFAIBKpZJluVKpVG86DMNqtVqWZUEQIAj6x27AMARBKpVKMai+pSiKWiwWDMN2dnbUarXD4chkMkaj8eLFiyqVKpVKZbNZnU7n9XpbWlri8fiFCxcwDItGowCAmpD6ZfetVitBEKFQCABw9+7dQCCwuro6Pj7+6NEjAABJkg8fPrx58+b29rbf779//z5Jkj9//gQAtLW1NYR6PB6LxTI/Py8IwvDw8MDAgMlk0uv1Ho8HAKDT6VwuF0EQWq328uXLbrebpulQKKTT6Xp6ehpC29ranE4ny7Jfv37V6/VjY2NutxtBELVarawPhmEajcblck1OTmq12g8fPqAo2tPTY7Va628UAECr1Xq93kKhMD8/7/V6Ozo6IAgqFovVY5qampqamkRRpGn6y5cv4+Pjly5dUrarPhQA4HA4SJKcm5sDAEiSVDP6WJVKZX9/f2hoaHBwsLm5uaa3FqrYcuvWLRRFq/NIjTAM6+zsbGtrQ5A6hDpNSlQ2wilSIrSRH3/r4+T/0P9QdUKqWolEYmVl5fPnzwCAQqHw6dMnFEU9Ho/dbj9llurx48eN+gKBwLt3716/fu33+w8PDyuVSjabjcVihUKBJMmTP9KZLJ2bm5ueno5GoxRFoSh67tw5mqZ9Pt/a2hrDML29vQ1nyg3Ecdz169chCDp//vyDBw+8Xu/MzMyTJ0+GhoYwDBsdHVVO/7pzG1q6vb1dKBRQFCUIwuVy3blzR6VSlUolHMd5ns/n8zRNkyRZNz80hG5ububzeavVajKZNjc3fT6fSqVqaWkBAKjVap7nf/786fF4MAz7bWhTU9PAwMDIyEgmk4EgiKIoDMPW19d5no/H406n8/egOzs7xWLRbrc7nc7h4WGNRiOKIsdx4XDYYDCwLBuPxyuVSt25DYM/lUqVy2WKooxGY3U7RVEmk4njuFgs9tvQo6MjjuMoilLKhWMZjUar1crzfDQa/W1osVisVCqKXdXtNputvb2d5/mdnZ1G0DprKklSpVLheR6GYYIgcByv7jWbzXa7XRCERCLxG5byPB8Oh3me1+v1er2+5hRSq9U4jsuynMvllNrrTFCGYRYXF3meVyqJ2gkwjGGYEqrpdPpkbV4fWi6X19bWeJ43GAwEQZwcgGEYSZIAgGQyyTDMmaAcx4VCIaVMpCjq5ACNRmMwGMA/Y/lMUEEQdnd3RVE0m80n3QcAEATR2toKANjb22NZ9qzQdDqtQOtaSpKkUuYlEomzui+KYi6XkySp0ZpSFNXV1aVYWi6X/xyq/OAsyyIIYjAYaoJUkV6vdzgcAIDd3d1sNsuybE3A1kIZhtnf35dlmSRJkiTrJiFlo2AYPjg4SKfTJ7m10IODA+VSZDKZGlVUx6EqiuLR0dHBwUEul2MYRkn7daD5fD4WiwEAbDabRqOpC1W4FEXBMKxYyvN8oVAolUr1oblcLhKJAACam5tPgaIoarPZVCpVJpOhaRoAIAiCsr11oMViMZlMAgDsdrtWq20ERRCkBirLMs/zgiBIklQLLZfLh4eHivunQNVqdVdXF4Ig2WxWgSqqD+U4TnkXUC6gjaAajaavrw9F0aOjo2po/TWVJEnJZhaL5ZR6GsMwh8OBIMjh4WE+nz9uV66BtVAURZWAZxhGuVieLo7jqlOqclOohR7/gjMzMxsbG3XzBcuyoVDo+fPnNE27XC4lD8AwjOO4cqOtPU66u7tv3LgRDof9fr8gCEtLSz09PR0dHa2trZIkZbPZSCSyvr6+sbGxsLCAIMjIyIjb7YYgSEmyivtQzWOX8gjx9OnThYWFVCpFUZTT6VSgyltHJBIJBALZbNZutw8PD09NTfX19eE4rtPpcByHFJ18QeN5fm9v7+XLl9++fUskEjRNl0olJRthGIbjOEVRdrt9dHT09u3bZrMZRVEEQapDpQ70WIlEYmNjY3Fx8cePH8FgEABgs9n6+/vHxsYGBweVuqquToP+2/r7XCT+K9A/AN6eWQAzvN+SAAAAAElFTkSuQmCC",
					"ports": [],
					"background-fit": "none",
					"background-position-x": "50%",
					"background-position-y": "50%",
					"background-width": "100%",
					"background-height": "100%",
					"infoboxCalculated": true,
					"auxunitlayouts": {}
				},
				"position": {
					"x": 646.4945146902844,
					"y": 421.97873928869126
				},
				"group": "nodes",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "e53126c9-70fe-ca8a-3b85-bab123a93d70",
					"bbox": {
						"x": 733.5146893345959,
						"y": 417.7237632638994,
						"w": 20,
						"h": 40
					},
					"class": "macromolecule",
					"label": "a10",
					"statesandinfos": [],
					"language": "PD",
					"border-width": 0.001,
					"border-color": "#555555",
					"background-color": "#ffffff",
					"background-opacity": 1,
					"background-image-opacity": "1 1",
					"text-wrap": "wrap",
					"font-size": 11,
					"font-family": "Helvetica",
					"font-style": "normal",
					"font-weight": "normal",
					"color": "#000",
					"background-image": "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABYAAAAyCAYAAABYiSsbAAAABHNCSVQICAgIfAhkiAAABA5JREFUWIXtmM9LI2cYxz9KCOlWcOpqjew2zYK1Uy00tLDMoTShFISePOptLwvpf5C7B28rCCVKDwUv8b6H4M01oBEPsXjQ6iFx3RqruA4eHAkl3x6aGYyZSWLZFgr9wsv78j7zfvLM+zzvj0mPJPEPqNevs1KpsL+/3xWgWCxi23arQXfkOI7i8bgsy7prapHjOAI0PT3dYmsBp9NpAcrn83IcR3t7e77Qzc1NSVImkxGgXC4XDC6VSk0epFIpGYbRAnWfm5ub894wGo3KcRx/8NzcnADt7e0pm80KUCaTkSTNzs5qcnJShUJBkmRZliKRiMrlsubn5wWoVCr5g6empjwP3bbjOJqZmRHglZWVFW1ubgrQ/Py8185ms/5g0zS9oN1u9/X1KQz6qQGenJz0ApdOp5varprSLRqNcnp6CoBhGF4axWIxasAPjefGxsY8m2EY3pjh4WH/PE4kElQqFWzbxrIs9vf3WVtbY2lpiXA4zB/AxMQECwsLLC4uApBMJtnZ2fHG++ZxLpfz5q1arcowDJmmKUlKJpMCVCgUVC6XFYlElEqlvHgAqlar/nPsOI5M0/Sinc/nvay4Db68vFQ6nVa5XPacuT2/LWBJXoSnpqaa+m+DbzsSjUYVj8ebcrgleACWZZHNZjFNs3X9+yiRSJDL5YhEIs2Gux4Hyc/jdvLd3d6F/gf/h8Ed0y2fzyuVSnlb5sjIiKanpwNPFldtwevr6wqFQvpwaEifPX4sQNb4uAD19/e3rLauwe7m8olh6EdQBPQr6NHAgAAtLy8Hjm07x0dHRwAc2jazQ0NYiQRfhMP89vYtANvb24Fj24KPj48JAT8D5vk57OyQqtV40bDv7u7+veCFw2ENguRTekCjo6P3nwrbtqnVanwUYH/Q00O1Wr3/VGxsbADwcYD9Awnn+vr+4EKhAMBXAfY4UJc4ODi4H9i9FH4ZYP+0UW9tbd0P7HryfYDd/UF3yroGn52dEQ4yAt816sDrbmC69PZqJCDVbqdcLBbrPt1s26ZerxNt4zHAA+Di4sLX5gteXV0FoNM5/RC4Dkg5X7B7ZRrvAI4Bknj98iXUap3BpVIJgFQH8OeNevfFCwg3h9oXfHx8DMDXHcDu4lktFuHmpjP45OSkbaq5+qZRl25uoFjsDL66uuJhF+AxoAd4DfDqVXvw0dER9Xo9cPO5q/eBc4A3b9qDi41XetIleAC4AXj+vKk/dPfBw8NDoHOquXoCfPvsGTx92my4uxRXVlb+Oo07LGe3PDKMppu8K9+9wjAMAUqCKgHAX0Cjjc8KP/mCK5WK+vr6vEuK0XiDZKO81+hPJBJBe1j7e0Umk9Hg4KBCoVDTB2Rvb6/G43H9XqkEju2R/sX/K96F/gTllaEEcp1NCgAAAABJRU5ErkJggg==",
					"ports": [],
					"background-fit": "none",
					"background-position-x": "50%",
					"background-position-y": "50%",
					"background-width": "100%",
					"background-height": "100%",
					"infoboxCalculated": true,
					"auxunitlayouts": {}
				},
				"position": {
					"x": 733.5146893345959,
					"y": 417.7237632638994
				},
				"group": "nodes",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "979162a0-08fc-54e2-0ba2-b54b2eb59266",
					"bbox": {
						"x": 569.8463505219261,
						"y": 491.18415613852125,
						"w": 20,
						"h": 40
					},
					"class": "macromolecule",
					"label": "u49",
					"statesandinfos": [],
					"language": "PD",
					"border-width": 0.001,
					"border-color": "#555555",
					"background-color": "#ffffff",
					"background-opacity": 1,
					"background-image-opacity": "1 1",
					"text-wrap": "wrap",
					"font-size": 11,
					"font-family": "Helvetica",
					"font-style": "normal",
					"font-weight": "normal",
					"color": "#000",
					"background-image": "data:image/png;base64,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",
					"ports": [],
					"background-fit": "none",
					"background-position-x": "50%",
					"background-position-y": "50%",
					"background-width": "100%",
					"background-height": "100%",
					"infoboxCalculated": true,
					"auxunitlayouts": {}
				},
				"position": {
					"x": 569.8463505219261,
					"y": 491.18415613852125
				},
				"group": "nodes",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "4ca3044f-9b82-020b-e1cb-bbb45e4b0088",
					"bbox": {
						"x": 780.2053717408396,
						"y": 327.5078684450557,
						"w": 20,
						"h": 40
					},
					"class": "macromolecule",
					"label": "a7",
					"statesandinfos": [],
					"language": "PD",
					"border-width": 0.001,
					"border-color": "#555555",
					"background-color": "#ffffff",
					"background-opacity": 1,
					"background-image-opacity": "1 1",
					"text-wrap": "wrap",
					"font-size": 11,
					"font-family": "Helvetica",
					"font-style": "normal",
					"font-weight": "normal",
					"color": "#000",
					"background-image": "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABYAAAAyCAYAAABYiSsbAAAABHNCSVQICAgIfAhkiAAABA5JREFUWIXtmM9LI2cYxz9KCOlWcOpqjew2zYK1Uy00tLDMoTShFISePOptLwvpf5C7B28rCCVKDwUv8b6H4M01oBEPsXjQ6iFx3RqruA4eHAkl3x6aGYyZSWLZFgr9wsv78j7zfvLM+zzvj0mPJPEPqNevs1KpsL+/3xWgWCxi23arQXfkOI7i8bgsy7prapHjOAI0PT3dYmsBp9NpAcrn83IcR3t7e77Qzc1NSVImkxGgXC4XDC6VSk0epFIpGYbRAnWfm5ub894wGo3KcRx/8NzcnADt7e0pm80KUCaTkSTNzs5qcnJShUJBkmRZliKRiMrlsubn5wWoVCr5g6empjwP3bbjOJqZmRHglZWVFW1ubgrQ/Py8185ms/5g0zS9oN1u9/X1KQz6qQGenJz0ApdOp5varprSLRqNcnp6CoBhGF4axWIxasAPjefGxsY8m2EY3pjh4WH/PE4kElQqFWzbxrIs9vf3WVtbY2lpiXA4zB/AxMQECwsLLC4uApBMJtnZ2fHG++ZxLpfz5q1arcowDJmmKUlKJpMCVCgUVC6XFYlElEqlvHgAqlar/nPsOI5M0/Sinc/nvay4Db68vFQ6nVa5XPacuT2/LWBJXoSnpqaa+m+DbzsSjUYVj8ebcrgleACWZZHNZjFNs3X9+yiRSJDL5YhEIs2Gux4Hyc/jdvLd3d6F/gf/h8Ed0y2fzyuVSnlb5sjIiKanpwNPFldtwevr6wqFQvpwaEifPX4sQNb4uAD19/e3rLauwe7m8olh6EdQBPQr6NHAgAAtLy8Hjm07x0dHRwAc2jazQ0NYiQRfhMP89vYtANvb24Fj24KPj48JAT8D5vk57OyQqtV40bDv7u7+veCFw2ENguRTekCjo6P3nwrbtqnVanwUYH/Q00O1Wr3/VGxsbADwcYD9Awnn+vr+4EKhAMBXAfY4UJc4ODi4H9i9FH4ZYP+0UW9tbd0P7HryfYDd/UF3yroGn52dEQ4yAt816sDrbmC69PZqJCDVbqdcLBbrPt1s26ZerxNt4zHAA+Di4sLX5gteXV0FoNM5/RC4Dkg5X7B7ZRrvAI4Bknj98iXUap3BpVIJgFQH8OeNevfFCwg3h9oXfHx8DMDXHcDu4lktFuHmpjP45OSkbaq5+qZRl25uoFjsDL66uuJhF+AxoAd4DfDqVXvw0dER9Xo9cPO5q/eBc4A3b9qDi41XetIleAC4AXj+vKk/dPfBw8NDoHOquXoCfPvsGTx92my4uxRXVlb+Oo07LGe3PDKMppu8K9+9wjAMAUqCKgHAX0Cjjc8KP/mCK5WK+vr6vEuK0XiDZKO81+hPJBJBe1j7e0Umk9Hg4KBCoVDTB2Rvb6/G43H9XqkEju2R/sX/K96F/gTllaEEcp1NCgAAAABJRU5ErkJggg==",
					"ports": [],
					"background-fit": "none",
					"background-position-x": "50%",
					"background-position-y": "50%",
					"background-width": "100%",
					"background-height": "100%",
					"infoboxCalculated": true,
					"auxunitlayouts": {}
				},
				"position": {
					"x": 780.2053717408396,
					"y": 327.5078684450557
				},
				"group": "nodes",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "73cc39db-10c0-542a-7d9f-198fa3e0975e",
					"bbox": {
						"x": 567.8548520221906,
						"y": 416.1710459818175,
						"w": 20,
						"h": 40
					},
					"class": "macromolecule",
					"label": "u50",
					"statesandinfos": [],
					"language": "PD",
					"border-width": 0.001,
					"border-color": "#555555",
					"background-color": "#ffffff",
					"background-opacity": 1,
					"background-image-opacity": "1 1",
					"text-wrap": "wrap",
					"font-size": 11,
					"font-family": "Helvetica",
					"font-style": "normal",
					"font-weight": "normal",
					"color": "#000",
					"background-image": "data:image/png;base64,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",
					"ports": [],
					"background-fit": "none",
					"background-position-x": "50%",
					"background-position-y": "50%",
					"background-width": "100%",
					"background-height": "100%",
					"infoboxCalculated": true,
					"auxunitlayouts": {}
				},
				"position": {
					"x": 567.8548520221906,
					"y": 416.1710459818175
				},
				"group": "nodes",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "7c4ed529-4da9-7eed-59fe-4590b57b2dfc",
					"bbox": {
						"x": 565.19952068921,
						"y": 371.0304133211462,
						"w": 20,
						"h": 40
					},
					"class": "macromolecule",
					"label": "u51",
					"statesandinfos": [],
					"language": "PD",
					"border-width": 0.001,
					"border-color": "#555555",
					"background-color": "#ffffff",
					"background-opacity": 1,
					"background-image-opacity": "1 1",
					"text-wrap": "wrap",
					"font-size": 11,
					"font-family": "Helvetica",
					"font-style": "normal",
					"font-weight": "normal",
					"color": "#000",
					"background-image": "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABwAAABACAIAAACGI4BPAAAAA3NCSVQICAjb4U/gAAAAGXRFWHRTb2Z0d2FyZQBnbm9tZS1zY3JlZW5zaG907wO/PgAAB8dJREFUWIXtmMtPE+8ax9+ZzkwvM9OhN9pyK5jSlgCNgsRAICYQw8LoQl2gKxcmLv0HjDFu3bhz4YYYVhJjTEyoJpqI0WC5JYCU0gu1NC3l0tu007l0Zn6LOYdTS8sPz/mdk/yS812+l888z/s+87zP+0KyLIO/WvBfTvwfQhmGWVpaYhhGkqRG00RRLBaLW1tbhULhz6GlUikcDvt8vlKpdIotsixzHOfz+aLRKMdxNb1IzdB4PP7x48dkMgnDsCAIMAwjCAJB0PEYSZJEUZQkiSAIv99PEITRaOzo6Kj95rHK5fLMzMzVq1dTqVSlUlleXg4EAjzPV4/JZrPBYHBra0uW5ZWVlXv37r148UL+Vb+4v7q6GovFJiYmTCZTMpl89erV9+/fAQAsywaDwWg0qqzJ8vLys2fPOI5zu92dnZ3pdHp9fb2h+4lEIpfLDQ0NoSg6OzuL43h7e/vKysrs7Oz29rZKpert7b1y5YrVatVoNG/evLl27ZrD4QiHw7FYrL+/vz40nU6XSqXu7m4AwPv376empsxms8/nm56epmlakqTFxUUURScnJz0ez9u3bycmJhRoIpGo5vzLfUmSaJoWBMFisYiimEqlSJJkWTYcDudyOYIgNBrN3t5eMBikadpisUQiEUEQzGYzACCTydR3XxRFAIBKpZJluVKpVG86DMNqtVqWZUEQIAj6x27AMARBKpVKMai+pSiKWiwWDMN2dnbUarXD4chkMkaj8eLFiyqVKpVKZbNZnU7n9XpbWlri8fiFCxcwDItGowCAmpD6ZfetVitBEKFQCABw9+7dQCCwuro6Pj7+6NEjAABJkg8fPrx58+b29rbf779//z5Jkj9//gQAtLW1NYR6PB6LxTI/Py8IwvDw8MDAgMlk0uv1Ho8HAKDT6VwuF0EQWq328uXLbrebpulQKKTT6Xp6ehpC29ranE4ny7Jfv37V6/VjY2NutxtBELVarawPhmEajcblck1OTmq12g8fPqAo2tPTY7Va628UAECr1Xq93kKhMD8/7/V6Ozo6IAgqFovVY5qampqamkRRpGn6y5cv4+Pjly5dUrarPhQA4HA4SJKcm5sDAEiSVDP6WJVKZX9/f2hoaHBwsLm5uaa3FqrYcuvWLRRFq/NIjTAM6+zsbGtrQ5A6hDpNSlQ2wilSIrSRH3/r4+T/0P9QdUKqWolEYmVl5fPnzwCAQqHw6dMnFEU9Ho/dbj9llurx48eN+gKBwLt3716/fu33+w8PDyuVSjabjcVihUKBJMmTP9KZLJ2bm5ueno5GoxRFoSh67tw5mqZ9Pt/a2hrDML29vQ1nyg3Ecdz169chCDp//vyDBw+8Xu/MzMyTJ0+GhoYwDBsdHVVO/7pzG1q6vb1dKBRQFCUIwuVy3blzR6VSlUolHMd5ns/n8zRNkyRZNz80hG5ububzeavVajKZNjc3fT6fSqVqaWkBAKjVap7nf/786fF4MAz7bWhTU9PAwMDIyEgmk4EgiKIoDMPW19d5no/H406n8/egOzs7xWLRbrc7nc7h4WGNRiOKIsdx4XDYYDCwLBuPxyuVSt25DYM/lUqVy2WKooxGY3U7RVEmk4njuFgs9tvQo6MjjuMoilLKhWMZjUar1crzfDQa/W1osVisVCqKXdXtNputvb2d5/mdnZ1G0DprKklSpVLheR6GYYIgcByv7jWbzXa7XRCERCLxG5byPB8Oh3me1+v1er2+5hRSq9U4jsuynMvllNrrTFCGYRYXF3meVyqJ2gkwjGGYEqrpdPpkbV4fWi6X19bWeJ43GAwEQZwcgGEYSZIAgGQyyTDMmaAcx4VCIaVMpCjq5ACNRmMwGMA/Y/lMUEEQdnd3RVE0m80n3QcAEATR2toKANjb22NZ9qzQdDqtQOtaSpKkUuYlEomzui+KYi6XkySp0ZpSFNXV1aVYWi6X/xyq/OAsyyIIYjAYaoJUkV6vdzgcAIDd3d1sNsuybE3A1kIZhtnf35dlmSRJkiTrJiFlo2AYPjg4SKfTJ7m10IODA+VSZDKZGlVUx6EqiuLR0dHBwUEul2MYRkn7daD5fD4WiwEAbDabRqOpC1W4FEXBMKxYyvN8oVAolUr1oblcLhKJAACam5tPgaIoarPZVCpVJpOhaRoAIAiCsr11oMViMZlMAgDsdrtWq20ERRCkBirLMs/zgiBIklQLLZfLh4eHivunQNVqdVdXF4Ig2WxWgSqqD+U4TnkXUC6gjaAajaavrw9F0aOjo2po/TWVJEnJZhaL5ZR6GsMwh8OBIMjh4WE+nz9uV66BtVAURZWAZxhGuVieLo7jqlOqclOohR7/gjMzMxsbG3XzBcuyoVDo+fPnNE27XC4lD8AwjOO4cqOtPU66u7tv3LgRDof9fr8gCEtLSz09PR0dHa2trZIkZbPZSCSyvr6+sbGxsLCAIMjIyIjb7YYgSEmyivtQzWOX8gjx9OnThYWFVCpFUZTT6VSgyltHJBIJBALZbNZutw8PD09NTfX19eE4rtPpcByHFJ18QeN5fm9v7+XLl9++fUskEjRNl0olJRthGIbjOEVRdrt9dHT09u3bZrMZRVEEQapDpQ70WIlEYmNjY3Fx8cePH8FgEABgs9n6+/vHxsYGBweVuqquToP+2/r7XCT+K9A/AN6eWQAzvN+SAAAAAElFTkSuQmCC",
					"ports": [],
					"background-fit": "none",
					"background-position-x": "50%",
					"background-position-y": "50%",
					"background-width": "100%",
					"background-height": "100%",
					"infoboxCalculated": true,
					"auxunitlayouts": {}
				},
				"position": {
					"x": 565.19952068921,
					"y": 371.0304133211462
				},
				"group": "nodes",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "039bc70a-1d3c-4274-f0fa-dbf75aede9b7",
					"bbox": {
						"x": 563.2080221894744,
						"y": 319.91528516126857,
						"w": 20,
						"h": 40
					},
					"class": "macromolecule",
					"label": "u52",
					"statesandinfos": [],
					"language": "PD",
					"border-width": 0.001,
					"border-color": "#555555",
					"background-color": "#ffffff",
					"background-opacity": 1,
					"background-image-opacity": "1 1",
					"text-wrap": "wrap",
					"font-size": 11,
					"font-family": "Helvetica",
					"font-style": "normal",
					"font-weight": "normal",
					"color": "#000",
					"background-image": "data:image/png;base64,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",
					"ports": [],
					"background-fit": "none",
					"background-position-x": "50%",
					"background-position-y": "50%",
					"background-width": "100%",
					"background-height": "100%",
					"infoboxCalculated": true,
					"auxunitlayouts": {}
				},
				"position": {
					"x": 563.2080221894744,
					"y": 319.91528516126857
				},
				"group": "nodes",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "fb9ad239-d112-d0f9-ed9e-90db5f147e54",
					"bbox": {
						"x": 563.8718550227195,
						"y": 282.7406464995393,
						"w": 20,
						"h": 40
					},
					"class": "macromolecule",
					"label": "u53",
					"statesandinfos": [],
					"language": "PD",
					"border-width": 0.001,
					"border-color": "#555555",
					"background-color": "#ffffff",
					"background-opacity": 1,
					"background-image-opacity": "1 1",
					"text-wrap": "wrap",
					"font-size": 11,
					"font-family": "Helvetica",
					"font-style": "normal",
					"font-weight": "normal",
					"color": "#000",
					"background-image": "data:image/png;base64,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",
					"ports": [],
					"background-fit": "none",
					"background-position-x": "50%",
					"background-position-y": "50%",
					"background-width": "100%",
					"background-height": "100%",
					"infoboxCalculated": true,
					"auxunitlayouts": {}
				},
				"position": {
					"x": 563.8718550227195,
					"y": 282.7406464995393
				},
				"group": "nodes",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "3c910e69-2f8b-7beb-159c-da99ed4f6907",
					"bbox": {
						"x": 557.2335266902679,
						"y": 246.89367350430035,
						"w": 20,
						"h": 40
					},
					"class": "macromolecule",
					"label": "u54",
					"statesandinfos": [],
					"language": "PD",
					"border-width": 0.001,
					"border-color": "#555555",
					"background-color": "#ffffff",
					"background-opacity": 1,
					"background-image-opacity": "1 1",
					"text-wrap": "wrap",
					"font-size": 11,
					"font-family": "Helvetica",
					"font-style": "normal",
					"font-weight": "normal",
					"color": "#000",
					"background-image": "data:image/png;base64,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",
					"ports": [],
					"background-fit": "none",
					"background-position-x": "50%",
					"background-position-y": "50%",
					"background-width": "100%",
					"background-height": "100%",
					"infoboxCalculated": true,
					"auxunitlayouts": {}
				},
				"position": {
					"x": 557.2335266902679,
					"y": 246.89367350430035
				},
				"group": "nodes",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "0998ddcc-de7b-792a-5b2e-c53317128a7c",
					"bbox": {
						"x": 565.19952068921,
						"y": 193.12321401144197,
						"w": 20,
						"h": 40
					},
					"class": "macromolecule",
					"label": "u55",
					"statesandinfos": [],
					"language": "PD",
					"border-width": 0.001,
					"border-color": "#555555",
					"background-color": "#ffffff",
					"background-opacity": 1,
					"background-image-opacity": "1 1",
					"text-wrap": "wrap",
					"font-size": 11,
					"font-family": "Helvetica",
					"font-style": "normal",
					"font-weight": "normal",
					"color": "#000",
					"background-image": "data:image/png;base64,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",
					"ports": [],
					"background-fit": "none",
					"background-position-x": "50%",
					"background-position-y": "50%",
					"background-width": "100%",
					"background-height": "100%",
					"infoboxCalculated": true,
					"auxunitlayouts": {}
				},
				"position": {
					"x": 565.19952068921,
					"y": 193.12321401144197
				},
				"group": "nodes",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "b51264f6-8497-2eff-8d96-1264b5650804",
					"bbox": {
						"x": 524.8916916534773,
						"y": 432.64343313504395,
						"w": 20,
						"h": 40
					},
					"class": "macromolecule",
					"label": "u56",
					"statesandinfos": [],
					"language": "PD",
					"border-width": 0.001,
					"border-color": "#555555",
					"background-color": "#ffffff",
					"background-opacity": 1,
					"background-image-opacity": "1 1",
					"text-wrap": "wrap",
					"font-size": 11,
					"font-family": "Helvetica",
					"font-style": "normal",
					"font-weight": "normal",
					"color": "#000",
					"background-image": "data:image/png;base64,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",
					"ports": [],
					"background-fit": "none",
					"background-position-x": "50%",
					"background-position-y": "50%",
					"background-width": "100%",
					"background-height": "100%",
					"infoboxCalculated": true,
					"auxunitlayouts": {}
				},
				"position": {
					"x": 524.8916916534773,
					"y": 432.64343313504395
				},
				"group": "nodes",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "bc0420e3-9b6e-4c97-74c6-61278dbc18d4",
					"bbox": {
						"x": 737.4715268266505,
						"y": 237.29197362621204,
						"w": 20,
						"h": 40
					},
					"class": "macromolecule",
					"label": "a4",
					"statesandinfos": [],
					"language": "PD",
					"border-width": 0.001,
					"border-color": "#555555",
					"background-color": "#ffffff",
					"background-opacity": 1,
					"background-image-opacity": "1 1",
					"text-wrap": "wrap",
					"font-size": 11,
					"font-family": "Helvetica",
					"font-style": "normal",
					"font-weight": "normal",
					"color": "#000",
					"background-image": "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABYAAAAyCAYAAABYiSsbAAAABHNCSVQICAgIfAhkiAAABA5JREFUWIXtmM9LI2cYxz9KCOlWcOpqjew2zYK1Uy00tLDMoTShFISePOptLwvpf5C7B28rCCVKDwUv8b6H4M01oBEPsXjQ6iFx3RqruA4eHAkl3x6aGYyZSWLZFgr9wsv78j7zfvLM+zzvj0mPJPEPqNevs1KpsL+/3xWgWCxi23arQXfkOI7i8bgsy7prapHjOAI0PT3dYmsBp9NpAcrn83IcR3t7e77Qzc1NSVImkxGgXC4XDC6VSk0epFIpGYbRAnWfm5ub894wGo3KcRx/8NzcnADt7e0pm80KUCaTkSTNzs5qcnJShUJBkmRZliKRiMrlsubn5wWoVCr5g6empjwP3bbjOJqZmRHglZWVFW1ubgrQ/Py8185ms/5g0zS9oN1u9/X1KQz6qQGenJz0ApdOp5varprSLRqNcnp6CoBhGF4axWIxasAPjefGxsY8m2EY3pjh4WH/PE4kElQqFWzbxrIs9vf3WVtbY2lpiXA4zB/AxMQECwsLLC4uApBMJtnZ2fHG++ZxLpfz5q1arcowDJmmKUlKJpMCVCgUVC6XFYlElEqlvHgAqlar/nPsOI5M0/Sinc/nvay4Db68vFQ6nVa5XPacuT2/LWBJXoSnpqaa+m+DbzsSjUYVj8ebcrgleACWZZHNZjFNs3X9+yiRSJDL5YhEIs2Gux4Hyc/jdvLd3d6F/gf/h8Ed0y2fzyuVSnlb5sjIiKanpwNPFldtwevr6wqFQvpwaEifPX4sQNb4uAD19/e3rLauwe7m8olh6EdQBPQr6NHAgAAtLy8Hjm07x0dHRwAc2jazQ0NYiQRfhMP89vYtANvb24Fj24KPj48JAT8D5vk57OyQqtV40bDv7u7+veCFw2ENguRTekCjo6P3nwrbtqnVanwUYH/Q00O1Wr3/VGxsbADwcYD9Awnn+vr+4EKhAMBXAfY4UJc4ODi4H9i9FH4ZYP+0UW9tbd0P7HryfYDd/UF3yroGn52dEQ4yAt816sDrbmC69PZqJCDVbqdcLBbrPt1s26ZerxNt4zHAA+Di4sLX5gteXV0FoNM5/RC4Dkg5X7B7ZRrvAI4Bknj98iXUap3BpVIJgFQH8OeNevfFCwg3h9oXfHx8DMDXHcDu4lktFuHmpjP45OSkbaq5+qZRl25uoFjsDL66uuJhF+AxoAd4DfDqVXvw0dER9Xo9cPO5q/eBc4A3b9qDi41XetIleAC4AXj+vKk/dPfBw8NDoHOquXoCfPvsGTx92my4uxRXVlb+Oo07LGe3PDKMppu8K9+9wjAMAUqCKgHAX0Cjjc8KP/mCK5WK+vr6vEuK0XiDZKO81+hPJBJBe1j7e0Umk9Hg4KBCoVDTB2Rvb6/G43H9XqkEju2R/sX/K96F/gTllaEEcp1NCgAAAABJRU5ErkJggg==",
					"ports": [],
					"background-fit": "none",
					"background-position-x": "50%",
					"background-position-y": "50%",
					"background-width": "100%",
					"background-height": "100%",
					"infoboxCalculated": true,
					"auxunitlayouts": {}
				},
				"position": {
					"x": 737.4715268266505,
					"y": 237.29197362621204
				},
				"group": "nodes",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "f6ded9c4-6e94-ee99-6d4e-aebba05882db",
					"bbox": {
						"x": 513.3252115266342,
						"y": 268.0435236376609,
						"w": 20,
						"h": 40
					},
					"class": "macromolecule",
					"label": "u57",
					"statesandinfos": [],
					"language": "PD",
					"border-width": 0.001,
					"border-color": "#555555",
					"background-color": "#ffffff",
					"background-opacity": 1,
					"background-image-opacity": "1 1",
					"text-wrap": "wrap",
					"font-size": 11,
					"font-family": "Helvetica",
					"font-style": "normal",
					"font-weight": "normal",
					"color": "#000",
					"background-image": "data:image/png;base64,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",
					"ports": [],
					"background-fit": "none",
					"background-position-x": "50%",
					"background-position-y": "50%",
					"background-width": "100%",
					"background-height": "100%",
					"infoboxCalculated": true,
					"auxunitlayouts": {}
				},
				"position": {
					"x": 513.3252115266342,
					"y": 268.0435236376609
				},
				"group": "nodes",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "3b233452-0a1c-6c51-703a-b62ca9951f2b",
					"bbox": {
						"x": 603.1878648198002,
						"y": 156.82736857186146,
						"w": 20,
						"h": 40
					},
					"class": "macromolecule",
					"label": "u58",
					"statesandinfos": [],
					"language": "PD",
					"border-width": 0.001,
					"border-color": "#555555",
					"background-color": "#ffffff",
					"background-opacity": 1,
					"background-image-opacity": "1 1",
					"text-wrap": "wrap",
					"font-size": 11,
					"font-family": "Helvetica",
					"font-style": "normal",
					"font-weight": "normal",
					"color": "#000",
					"background-image": "data:image/png;base64,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",
					"ports": [],
					"background-fit": "none",
					"background-position-x": "50%",
					"background-position-y": "50%",
					"background-width": "100%",
					"background-height": "100%",
					"infoboxCalculated": true,
					"auxunitlayouts": {}
				},
				"position": {
					"x": 603.1878648198002,
					"y": 156.82736857186146
				},
				"group": "nodes",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "8e47cd39-5258-1c70-06ab-96f28782e065",
					"bbox": {
						"x": 680.5943087455965,
						"y": 151.4889931287031,
						"w": 20,
						"h": 40
					},
					"class": "macromolecule",
					"label": "u59",
					"statesandinfos": [],
					"language": "PD",
					"border-width": 0.001,
					"border-color": "#555555",
					"background-color": "#ffffff",
					"background-opacity": 1,
					"background-image-opacity": "1 1",
					"text-wrap": "wrap",
					"font-size": 11,
					"font-family": "Helvetica",
					"font-style": "normal",
					"font-weight": "normal",
					"color": "#000",
					"background-image": "data:image/png;base64,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",
					"ports": [],
					"background-fit": "none",
					"background-position-x": "50%",
					"background-position-y": "50%",
					"background-width": "100%",
					"background-height": "100%",
					"infoboxCalculated": true,
					"auxunitlayouts": {}
				},
				"position": {
					"x": 680.5943087455965,
					"y": 151.4889931287031
				},
				"group": "nodes",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "a97f8f48-6652-7e09-8eda-2d87eae7d20b",
					"bbox": {
						"x": 826.8960541470833,
						"y": 210.3854786802411,
						"w": 20,
						"h": 40
					},
					"class": "macromolecule",
					"label": "a3",
					"statesandinfos": [],
					"language": "PD",
					"border-width": 0.001,
					"border-color": "#555555",
					"background-color": "#ffffff",
					"background-opacity": 1,
					"background-image-opacity": "1 1",
					"text-wrap": "wrap",
					"font-size": 11,
					"font-family": "Helvetica",
					"font-style": "normal",
					"font-weight": "normal",
					"color": "#000",
					"background-image": "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABYAAAAyCAYAAABYiSsbAAAABHNCSVQICAgIfAhkiAAABA5JREFUWIXtmM9LI2cYxz9KCOlWcOpqjew2zYK1Uy00tLDMoTShFISePOptLwvpf5C7B28rCCVKDwUv8b6H4M01oBEPsXjQ6iFx3RqruA4eHAkl3x6aGYyZSWLZFgr9wsv78j7zfvLM+zzvj0mPJPEPqNevs1KpsL+/3xWgWCxi23arQXfkOI7i8bgsy7prapHjOAI0PT3dYmsBp9NpAcrn83IcR3t7e77Qzc1NSVImkxGgXC4XDC6VSk0epFIpGYbRAnWfm5ub894wGo3KcRx/8NzcnADt7e0pm80KUCaTkSTNzs5qcnJShUJBkmRZliKRiMrlsubn5wWoVCr5g6empjwP3bbjOJqZmRHglZWVFW1ubgrQ/Py8185ms/5g0zS9oN1u9/X1KQz6qQGenJz0ApdOp5varprSLRqNcnp6CoBhGF4axWIxasAPjefGxsY8m2EY3pjh4WH/PE4kElQqFWzbxrIs9vf3WVtbY2lpiXA4zB/AxMQECwsLLC4uApBMJtnZ2fHG++ZxLpfz5q1arcowDJmmKUlKJpMCVCgUVC6XFYlElEqlvHgAqlar/nPsOI5M0/Sinc/nvay4Db68vFQ6nVa5XPacuT2/LWBJXoSnpqaa+m+DbzsSjUYVj8ebcrgleACWZZHNZjFNs3X9+yiRSJDL5YhEIs2Gux4Hyc/jdvLd3d6F/gf/h8Ed0y2fzyuVSnlb5sjIiKanpwNPFldtwevr6wqFQvpwaEifPX4sQNb4uAD19/e3rLauwe7m8olh6EdQBPQr6NHAgAAtLy8Hjm07x0dHRwAc2jazQ0NYiQRfhMP89vYtANvb24Fj24KPj48JAT8D5vk57OyQqtV40bDv7u7+veCFw2ENguRTekCjo6P3nwrbtqnVanwUYH/Q00O1Wr3/VGxsbADwcYD9Awnn+vr+4EKhAMBXAfY4UJc4ODi4H9i9FH4ZYP+0UW9tbd0P7HryfYDd/UF3yroGn52dEQ4yAt816sDrbmC69PZqJCDVbqdcLBbrPt1s26ZerxNt4zHAA+Di4sLX5gteXV0FoNM5/RC4Dkg5X7B7ZRrvAI4Bknj98iXUap3BpVIJgFQH8OeNevfFCwg3h9oXfHx8DMDXHcDu4lktFuHmpjP45OSkbaq5+qZRl25uoFjsDL66uuJhF+AxoAd4DfDqVXvw0dER9Xo9cPO5q/eBc4A3b9qDi41XetIleAC4AXj+vKk/dPfBw8NDoHOquXoCfPvsGTx92my4uxRXVlb+Oo07LGe3PDKMppu8K9+9wjAMAUqCKgHAX0Cjjc8KP/mCK5WK+vr6vEuK0XiDZKO81+hPJBJBe1j7e0Umk9Hg4KBCoVDTB2Rvb6/G43H9XqkEju2R/sX/K96F/gTllaEEcp1NCgAAAABJRU5ErkJggg==",
					"ports": [],
					"background-fit": "none",
					"background-position-x": "50%",
					"background-position-y": "50%",
					"background-width": "100%",
					"background-height": "100%",
					"infoboxCalculated": true,
					"auxunitlayouts": {}
				},
				"position": {
					"x": 826.8960541470833,
					"y": 210.3854786802411
				},
				"group": "nodes",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "7b23c6ae-4256-a918-0c9b-0254d83a908b",
					"bbox": {
						"x": 782.0234421656056,
						"y": 162.16574401501987,
						"w": 20,
						"h": 40
					},
					"class": "macromolecule",
					"label": "u60",
					"statesandinfos": [],
					"language": "PD",
					"border-width": 0.001,
					"border-color": "#555555",
					"background-color": "#ffffff",
					"background-opacity": 1,
					"background-image-opacity": "1 1",
					"text-wrap": "wrap",
					"font-size": 11,
					"font-family": "Helvetica",
					"font-style": "normal",
					"font-weight": "normal",
					"color": "#000",
					"background-image": "data:image/png;base64,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",
					"ports": [],
					"background-fit": "none",
					"background-position-x": "50%",
					"background-position-y": "50%",
					"background-width": "100%",
					"background-height": "100%",
					"infoboxCalculated": true,
					"auxunitlayouts": {}
				},
				"position": {
					"x": 782.0234421656056,
					"y": 162.16574401501987
				},
				"group": "nodes",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "3f913ee3-7737-5405-968d-312653a7c318",
					"bbox": {
						"x": 847.8634059645589,
						"y": 177.29114110396856,
						"w": 20,
						"h": 40
					},
					"class": "macromolecule",
					"label": "u61",
					"statesandinfos": [],
					"language": "PD",
					"border-width": 0.001,
					"border-color": "#555555",
					"background-color": "#ffffff",
					"background-opacity": 1,
					"background-image-opacity": "1 1",
					"text-wrap": "wrap",
					"font-size": 11,
					"font-family": "Helvetica",
					"font-style": "normal",
					"font-weight": "normal",
					"color": "#000",
					"background-image": "data:image/png;base64,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",
					"ports": [],
					"background-fit": "none",
					"background-position-x": "50%",
					"background-position-y": "50%",
					"background-width": "100%",
					"background-height": "100%",
					"infoboxCalculated": true,
					"auxunitlayouts": {}
				},
				"position": {
					"x": 847.8634059645589,
					"y": 177.29114110396856
				},
				"group": "nodes",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "9190744c-1571-616b-e75e-1c00d977a78d",
					"bbox": {
						"x": 816.7228825461351,
						"y": 548.3082344034754,
						"w": 20,
						"h": 40
					},
					"class": "macromolecule",
					"label": "u62",
					"statesandinfos": [],
					"language": "PD",
					"border-width": 0.001,
					"border-color": "#555555",
					"background-color": "#ffffff",
					"background-opacity": 1,
					"background-image-opacity": "1 1",
					"text-wrap": "wrap",
					"font-size": 11,
					"font-family": "Helvetica",
					"font-style": "normal",
					"font-weight": "normal",
					"color": "#000",
					"background-image": "data:image/png;base64,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",
					"ports": [],
					"background-fit": "none",
					"background-position-x": "50%",
					"background-position-y": "50%",
					"background-width": "100%",
					"background-height": "100%",
					"infoboxCalculated": true,
					"auxunitlayouts": {}
				},
				"position": {
					"x": 816.7228825461351,
					"y": 548.3082344034754
				},
				"group": "nodes",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "aed099f2-5b0a-d59c-c297-9bac5ded0736",
					"bbox": {
						"x": 740.2061678608651,
						"y": 545.6390466818962,
						"w": 20,
						"h": 40
					},
					"class": "macromolecule",
					"label": "u63",
					"statesandinfos": [],
					"language": "PD",
					"border-width": 0.001,
					"border-color": "#555555",
					"background-color": "#ffffff",
					"background-opacity": 1,
					"background-image-opacity": "1 1",
					"text-wrap": "wrap",
					"font-size": 11,
					"font-family": "Helvetica",
					"font-style": "normal",
					"font-weight": "normal",
					"color": "#000",
					"background-image": "data:image/png;base64,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",
					"ports": [],
					"background-fit": "none",
					"background-position-x": "50%",
					"background-position-y": "50%",
					"background-width": "100%",
					"background-height": "100%",
					"infoboxCalculated": true,
					"auxunitlayouts": {}
				},
				"position": {
					"x": 740.2061678608651,
					"y": 545.6390466818962
				},
				"group": "nodes",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "d9eeb201-2c9a-5afb-82a7-bc583b0f6628",
					"bbox": {
						"x": 686.8224134292814,
						"y": 548.3082344034754,
						"w": 20,
						"h": 40
					},
					"class": "macromolecule",
					"label": "u64",
					"statesandinfos": [],
					"language": "PD",
					"border-width": 0.001,
					"border-color": "#555555",
					"background-color": "#ffffff",
					"background-opacity": 1,
					"background-image-opacity": "1 1",
					"text-wrap": "wrap",
					"font-size": 11,
					"font-family": "Helvetica",
					"font-style": "normal",
					"font-weight": "normal",
					"color": "#000",
					"background-image": "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABwAAABACAIAAACGI4BPAAAAA3NCSVQICAjb4U/gAAAAGXRFWHRTb2Z0d2FyZQBnbm9tZS1zY3JlZW5zaG907wO/PgAAB8dJREFUWIXtmMtPE+8ax9+ZzkwvM9OhN9pyK5jSlgCNgsRAICYQw8LoQl2gKxcmLv0HjDFu3bhz4YYYVhJjTEyoJpqI0WC5JYCU0gu1NC3l0tu007l0Zn6LOYdTS8sPz/mdk/yS812+l888z/s+87zP+0KyLIO/WvBfTvwfQhmGWVpaYhhGkqRG00RRLBaLW1tbhULhz6GlUikcDvt8vlKpdIotsixzHOfz+aLRKMdxNb1IzdB4PP7x48dkMgnDsCAIMAwjCAJB0PEYSZJEUZQkiSAIv99PEITRaOzo6Kj95rHK5fLMzMzVq1dTqVSlUlleXg4EAjzPV4/JZrPBYHBra0uW5ZWVlXv37r148UL+Vb+4v7q6GovFJiYmTCZTMpl89erV9+/fAQAsywaDwWg0qqzJ8vLys2fPOI5zu92dnZ3pdHp9fb2h+4lEIpfLDQ0NoSg6OzuL43h7e/vKysrs7Oz29rZKpert7b1y5YrVatVoNG/evLl27ZrD4QiHw7FYrL+/vz40nU6XSqXu7m4AwPv376empsxms8/nm56epmlakqTFxUUURScnJz0ez9u3bycmJhRoIpGo5vzLfUmSaJoWBMFisYiimEqlSJJkWTYcDudyOYIgNBrN3t5eMBikadpisUQiEUEQzGYzACCTydR3XxRFAIBKpZJluVKpVG86DMNqtVqWZUEQIAj6x27AMARBKpVKMai+pSiKWiwWDMN2dnbUarXD4chkMkaj8eLFiyqVKpVKZbNZnU7n9XpbWlri8fiFCxcwDItGowCAmpD6ZfetVitBEKFQCABw9+7dQCCwuro6Pj7+6NEjAABJkg8fPrx58+b29rbf779//z5Jkj9//gQAtLW1NYR6PB6LxTI/Py8IwvDw8MDAgMlk0uv1Ho8HAKDT6VwuF0EQWq328uXLbrebpulQKKTT6Xp6ehpC29ranE4ny7Jfv37V6/VjY2NutxtBELVarawPhmEajcblck1OTmq12g8fPqAo2tPTY7Va628UAECr1Xq93kKhMD8/7/V6Ozo6IAgqFovVY5qampqamkRRpGn6y5cv4+Pjly5dUrarPhQA4HA4SJKcm5sDAEiSVDP6WJVKZX9/f2hoaHBwsLm5uaa3FqrYcuvWLRRFq/NIjTAM6+zsbGtrQ5A6hDpNSlQ2wilSIrSRH3/r4+T/0P9QdUKqWolEYmVl5fPnzwCAQqHw6dMnFEU9Ho/dbj9llurx48eN+gKBwLt3716/fu33+w8PDyuVSjabjcVihUKBJMmTP9KZLJ2bm5ueno5GoxRFoSh67tw5mqZ9Pt/a2hrDML29vQ1nyg3Ecdz169chCDp//vyDBw+8Xu/MzMyTJ0+GhoYwDBsdHVVO/7pzG1q6vb1dKBRQFCUIwuVy3blzR6VSlUolHMd5ns/n8zRNkyRZNz80hG5ububzeavVajKZNjc3fT6fSqVqaWkBAKjVap7nf/786fF4MAz7bWhTU9PAwMDIyEgmk4EgiKIoDMPW19d5no/H406n8/egOzs7xWLRbrc7nc7h4WGNRiOKIsdx4XDYYDCwLBuPxyuVSt25DYM/lUqVy2WKooxGY3U7RVEmk4njuFgs9tvQo6MjjuMoilLKhWMZjUar1crzfDQa/W1osVisVCqKXdXtNputvb2d5/mdnZ1G0DprKklSpVLheR6GYYIgcByv7jWbzXa7XRCERCLxG5byPB8Oh3me1+v1er2+5hRSq9U4jsuynMvllNrrTFCGYRYXF3meVyqJ2gkwjGGYEqrpdPpkbV4fWi6X19bWeJ43GAwEQZwcgGEYSZIAgGQyyTDMmaAcx4VCIaVMpCjq5ACNRmMwGMA/Y/lMUEEQdnd3RVE0m80n3QcAEATR2toKANjb22NZ9qzQdDqtQOtaSpKkUuYlEomzui+KYi6XkySp0ZpSFNXV1aVYWi6X/xyq/OAsyyIIYjAYaoJUkV6vdzgcAIDd3d1sNsuybE3A1kIZhtnf35dlmSRJkiTrJiFlo2AYPjg4SKfTJ7m10IODA+VSZDKZGlVUx6EqiuLR0dHBwUEul2MYRkn7daD5fD4WiwEAbDabRqOpC1W4FEXBMKxYyvN8oVAolUr1oblcLhKJAACam5tPgaIoarPZVCpVJpOhaRoAIAiCsr11oMViMZlMAgDsdrtWq20ERRCkBirLMs/zgiBIklQLLZfLh4eHivunQNVqdVdXF4Ig2WxWgSqqD+U4TnkXUC6gjaAajaavrw9F0aOjo2po/TWVJEnJZhaL5ZR6GsMwh8OBIMjh4WE+nz9uV66BtVAURZWAZxhGuVieLo7jqlOqclOohR7/gjMzMxsbG3XzBcuyoVDo+fPnNE27XC4lD8AwjOO4cqOtPU66u7tv3LgRDof9fr8gCEtLSz09PR0dHa2trZIkZbPZSCSyvr6+sbGxsLCAIMjIyIjb7YYgSEmyivtQzWOX8gjx9OnThYWFVCpFUZTT6VSgyltHJBIJBALZbNZutw8PD09NTfX19eE4rtPpcByHFJ18QeN5fm9v7+XLl9++fUskEjRNl0olJRthGIbjOEVRdrt9dHT09u3bZrMZRVEEQapDpQ70WIlEYmNjY3Fx8cePH8FgEABgs9n6+/vHxsYGBweVuqquToP+2/r7XCT+K9A/AN6eWQAzvN+SAAAAAElFTkSuQmCC",
					"ports": [],
					"background-fit": "none",
					"background-position-x": "50%",
					"background-position-y": "50%",
					"background-width": "100%",
					"background-height": "100%",
					"infoboxCalculated": true,
					"auxunitlayouts": {}
				},
				"position": {
					"x": 686.8224134292814,
					"y": 548.3082344034754
				},
				"group": "nodes",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "67ff3c4c-e646-5c50-0e37-16e9a39da28a",
					"bbox": {
						"x": 611.1954279845379,
						"y": 543.8595882008434,
						"w": 20,
						"h": 40
					},
					"class": "macromolecule",
					"label": "u65",
					"statesandinfos": [],
					"language": "PD",
					"border-width": 0.001,
					"border-color": "#555555",
					"background-color": "#ffffff",
					"background-opacity": 1,
					"background-image-opacity": "1 1",
					"text-wrap": "wrap",
					"font-size": 11,
					"font-family": "Helvetica",
					"font-style": "normal",
					"font-weight": "normal",
					"color": "#000",
					"background-image": "data:image/png;base64,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",
					"ports": [],
					"background-fit": "none",
					"background-position-x": "50%",
					"background-position-y": "50%",
					"background-width": "100%",
					"background-height": "100%",
					"infoboxCalculated": true,
					"auxunitlayouts": {}
				},
				"position": {
					"x": 611.1954279845379,
					"y": 543.8595882008434
				},
				"group": "nodes",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "889eedb3-8cb8-b906-8beb-904cd499c4f6",
					"bbox": {
						"x": 653.5865719950941,
						"y": 498.4432481018122,
						"w": 20,
						"h": 40
					},
					"class": "macromolecule",
					"label": "a13",
					"statesandinfos": [],
					"language": "PD",
					"border-width": 0.001,
					"border-color": "#555555",
					"background-color": "#ffffff",
					"background-opacity": 1,
					"background-image-opacity": "1 1",
					"text-wrap": "wrap",
					"font-size": 11,
					"font-family": "Helvetica",
					"font-style": "normal",
					"font-weight": "normal",
					"color": "#000",
					"background-image": "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABYAAAAyCAYAAABYiSsbAAAABHNCSVQICAgIfAhkiAAABA5JREFUWIXtmM9LI2cYxz9KCOlWcOpqjew2zYK1Uy00tLDMoTShFISePOptLwvpf5C7B28rCCVKDwUv8b6H4M01oBEPsXjQ6iFx3RqruA4eHAkl3x6aGYyZSWLZFgr9wsv78j7zfvLM+zzvj0mPJPEPqNevs1KpsL+/3xWgWCxi23arQXfkOI7i8bgsy7prapHjOAI0PT3dYmsBp9NpAcrn83IcR3t7e77Qzc1NSVImkxGgXC4XDC6VSk0epFIpGYbRAnWfm5ub894wGo3KcRx/8NzcnADt7e0pm80KUCaTkSTNzs5qcnJShUJBkmRZliKRiMrlsubn5wWoVCr5g6empjwP3bbjOJqZmRHglZWVFW1ubgrQ/Py8185ms/5g0zS9oN1u9/X1KQz6qQGenJz0ApdOp5varprSLRqNcnp6CoBhGF4axWIxasAPjefGxsY8m2EY3pjh4WH/PE4kElQqFWzbxrIs9vf3WVtbY2lpiXA4zB/AxMQECwsLLC4uApBMJtnZ2fHG++ZxLpfz5q1arcowDJmmKUlKJpMCVCgUVC6XFYlElEqlvHgAqlar/nPsOI5M0/Sinc/nvay4Db68vFQ6nVa5XPacuT2/LWBJXoSnpqaa+m+DbzsSjUYVj8ebcrgleACWZZHNZjFNs3X9+yiRSJDL5YhEIs2Gux4Hyc/jdvLd3d6F/gf/h8Ed0y2fzyuVSnlb5sjIiKanpwNPFldtwevr6wqFQvpwaEifPX4sQNb4uAD19/e3rLauwe7m8olh6EdQBPQr6NHAgAAtLy8Hjm07x0dHRwAc2jazQ0NYiQRfhMP89vYtANvb24Fj24KPj48JAT8D5vk57OyQqtV40bDv7u7+veCFw2ENguRTekCjo6P3nwrbtqnVanwUYH/Q00O1Wr3/VGxsbADwcYD9Awnn+vr+4EKhAMBXAfY4UJc4ODi4H9i9FH4ZYP+0UW9tbd0P7HryfYDd/UF3yroGn52dEQ4yAt816sDrbmC69PZqJCDVbqdcLBbrPt1s26ZerxNt4zHAA+Di4sLX5gteXV0FoNM5/RC4Dkg5X7B7ZRrvAI4Bknj98iXUap3BpVIJgFQH8OeNevfFCwg3h9oXfHx8DMDXHcDu4lktFuHmpjP45OSkbaq5+qZRl25uoFjsDL66uuJhF+AxoAd4DfDqVXvw0dER9Xo9cPO5q/eBc4A3b9qDi41XetIleAC4AXj+vKk/dPfBw8NDoHOquXoCfPvsGTx92my4uxRXVlb+Oo07LGe3PDKMppu8K9+9wjAMAUqCKgHAX0Cjjc8KP/mCK5WK+vr6vEuK0XiDZKO81+hPJBJBe1j7e0Umk9Hg4KBCoVDTB2Rvb6/G43H9XqkEju2R/sX/K96F/gTllaEEcp1NCgAAAABJRU5ErkJggg==",
					"ports": [],
					"background-fit": "none",
					"background-position-x": "50%",
					"background-position-y": "50%",
					"background-width": "100%",
					"background-height": "100%",
					"infoboxCalculated": true,
					"auxunitlayouts": {}
				},
				"position": {
					"x": 653.5865719950941,
					"y": 498.4432481018122
				},
				"group": "nodes",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "bd77a77c-4627-ad77-1c5a-2c390ba21959",
					"bbox": {
						"x": 515.097259773185,
						"y": 349.6661584005612,
						"w": 20,
						"h": 40
					},
					"class": "macromolecule",
					"label": "a8",
					"statesandinfos": [],
					"language": "PD",
					"border-width": 0.001,
					"border-color": "#555555",
					"background-color": "#ffffff",
					"background-opacity": 1,
					"background-image-opacity": "1 1",
					"text-wrap": "wrap",
					"font-size": 11,
					"font-family": "Helvetica",
					"font-style": "normal",
					"font-weight": "normal",
					"color": "#000",
					"background-image": "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABYAAAAyCAYAAABYiSsbAAAABHNCSVQICAgIfAhkiAAABA5JREFUWIXtmM9LI2cYxz9KCOlWcOpqjew2zYK1Uy00tLDMoTShFISePOptLwvpf5C7B28rCCVKDwUv8b6H4M01oBEPsXjQ6iFx3RqruA4eHAkl3x6aGYyZSWLZFgr9wsv78j7zfvLM+zzvj0mPJPEPqNevs1KpsL+/3xWgWCxi23arQXfkOI7i8bgsy7prapHjOAI0PT3dYmsBp9NpAcrn83IcR3t7e77Qzc1NSVImkxGgXC4XDC6VSk0epFIpGYbRAnWfm5ub894wGo3KcRx/8NzcnADt7e0pm80KUCaTkSTNzs5qcnJShUJBkmRZliKRiMrlsubn5wWoVCr5g6empjwP3bbjOJqZmRHglZWVFW1ubgrQ/Py8185ms/5g0zS9oN1u9/X1KQz6qQGenJz0ApdOp5varprSLRqNcnp6CoBhGF4axWIxasAPjefGxsY8m2EY3pjh4WH/PE4kElQqFWzbxrIs9vf3WVtbY2lpiXA4zB/AxMQECwsLLC4uApBMJtnZ2fHG++ZxLpfz5q1arcowDJmmKUlKJpMCVCgUVC6XFYlElEqlvHgAqlar/nPsOI5M0/Sinc/nvay4Db68vFQ6nVa5XPacuT2/LWBJXoSnpqaa+m+DbzsSjUYVj8ebcrgleACWZZHNZjFNs3X9+yiRSJDL5YhEIs2Gux4Hyc/jdvLd3d6F/gf/h8Ed0y2fzyuVSnlb5sjIiKanpwNPFldtwevr6wqFQvpwaEifPX4sQNb4uAD19/e3rLauwe7m8olh6EdQBPQr6NHAgAAtLy8Hjm07x0dHRwAc2jazQ0NYiQRfhMP89vYtANvb24Fj24KPj48JAT8D5vk57OyQqtV40bDv7u7+veCFw2ENguRTekCjo6P3nwrbtqnVanwUYH/Q00O1Wr3/VGxsbADwcYD9Awnn+vr+4EKhAMBXAfY4UJc4ODi4H9i9FH4ZYP+0UW9tbd0P7HryfYDd/UF3yroGn52dEQ4yAt816sDrbmC69PZqJCDVbqdcLBbrPt1s26ZerxNt4zHAA+Di4sLX5gteXV0FoNM5/RC4Dkg5X7B7ZRrvAI4Bknj98iXUap3BpVIJgFQH8OeNevfFCwg3h9oXfHx8DMDXHcDu4lktFuHmpjP45OSkbaq5+qZRl25uoFjsDL66uuJhF+AxoAd4DfDqVXvw0dER9Xo9cPO5q/eBc4A3b9qDi41XetIleAC4AXj+vKk/dPfBw8NDoHOquXoCfPvsGTx92my4uxRXVlb+Oo07LGe3PDKMppu8K9+9wjAMAUqCKgHAX0Cjjc8KP/mCK5WK+vr6vEuK0XiDZKO81+hPJBJBe1j7e0Umk9Hg4KBCoVDTB2Rvb6/G43H9XqkEju2R/sX/K96F/gTllaEEcp1NCgAAAABJRU5ErkJggg==",
					"ports": [],
					"background-fit": "none",
					"background-position-x": "50%",
					"background-position-y": "50%",
					"background-width": "100%",
					"background-height": "100%",
					"infoboxCalculated": true,
					"auxunitlayouts": {}
				},
				"position": {
					"x": 515.097259773185,
					"y": 349.6661584005612
				},
				"group": "nodes",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "ffbd69bf-481f-faa8-73db-1489f3175b75",
					"bbox": {
						"x": 657.5434094871487,
						"y": 283.19128853404476,
						"w": 20,
						"h": 40
					},
					"class": "macromolecule",
					"label": "a5",
					"statesandinfos": [],
					"language": "PD",
					"border-width": 0.001,
					"border-color": "#555555",
					"background-color": "#ffffff",
					"background-opacity": 1,
					"background-image-opacity": "1 1",
					"text-wrap": "wrap",
					"font-size": 11,
					"font-family": "Helvetica",
					"font-style": "normal",
					"font-weight": "normal",
					"color": "#000",
					"background-image": "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABYAAAAyCAYAAABYiSsbAAAABHNCSVQICAgIfAhkiAAABA5JREFUWIXtmM9LI2cYxz9KCOlWcOpqjew2zYK1Uy00tLDMoTShFISePOptLwvpf5C7B28rCCVKDwUv8b6H4M01oBEPsXjQ6iFx3RqruA4eHAkl3x6aGYyZSWLZFgr9wsv78j7zfvLM+zzvj0mPJPEPqNevs1KpsL+/3xWgWCxi23arQXfkOI7i8bgsy7prapHjOAI0PT3dYmsBp9NpAcrn83IcR3t7e77Qzc1NSVImkxGgXC4XDC6VSk0epFIpGYbRAnWfm5ub894wGo3KcRx/8NzcnADt7e0pm80KUCaTkSTNzs5qcnJShUJBkmRZliKRiMrlsubn5wWoVCr5g6empjwP3bbjOJqZmRHglZWVFW1ubgrQ/Py8185ms/5g0zS9oN1u9/X1KQz6qQGenJz0ApdOp5varprSLRqNcnp6CoBhGF4axWIxasAPjefGxsY8m2EY3pjh4WH/PE4kElQqFWzbxrIs9vf3WVtbY2lpiXA4zB/AxMQECwsLLC4uApBMJtnZ2fHG++ZxLpfz5q1arcowDJmmKUlKJpMCVCgUVC6XFYlElEqlvHgAqlar/nPsOI5M0/Sinc/nvay4Db68vFQ6nVa5XPacuT2/LWBJXoSnpqaa+m+DbzsSjUYVj8ebcrgleACWZZHNZjFNs3X9+yiRSJDL5YhEIs2Gux4Hyc/jdvLd3d6F/gf/h8Ed0y2fzyuVSnlb5sjIiKanpwNPFldtwevr6wqFQvpwaEifPX4sQNb4uAD19/e3rLauwe7m8olh6EdQBPQr6NHAgAAtLy8Hjm07x0dHRwAc2jazQ0NYiQRfhMP89vYtANvb24Fj24KPj48JAT8D5vk57OyQqtV40bDv7u7+veCFw2ENguRTekCjo6P3nwrbtqnVanwUYH/Q00O1Wr3/VGxsbADwcYD9Awnn+vr+4EKhAMBXAfY4UJc4ODi4H9i9FH4ZYP+0UW9tbd0P7HryfYDd/UF3yroGn52dEQ4yAt816sDrbmC69PZqJCDVbqdcLBbrPt1s26ZerxNt4zHAA+Di4sLX5gteXV0FoNM5/RC4Dkg5X7B7ZRrvAI4Bknj98iXUap3BpVIJgFQH8OeNevfFCwg3h9oXfHx8DMDXHcDu4lktFuHmpjP45OSkbaq5+qZRl25uoFjsDL66uuJhF+AxoAd4DfDqVXvw0dER9Xo9cPO5q/eBc4A3b9qDi41XetIleAC4AXj+vKk/dPfBw8NDoHOquXoCfPvsGTx92my4uxRXVlb+Oo07LGe3PDKMppu8K9+9wjAMAUqCKgHAX0Cjjc8KP/mCK5WK+vr6vEuK0XiDZKO81+hPJBJBe1j7e0Umk9Hg4KBCoVDTB2Rvb6/G43H9XqkEju2R/sX/K96F/gTllaEEcp1NCgAAAABJRU5ErkJggg==",
					"ports": [],
					"background-fit": "none",
					"background-position-x": "50%",
					"background-position-y": "50%",
					"background-width": "100%",
					"background-height": "100%",
					"infoboxCalculated": true,
					"auxunitlayouts": {}
				},
				"position": {
					"x": 657.5434094871487,
					"y": 283.19128853404476
				},
				"group": "nodes",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "5fdc6150-63bb-18e8-1f03-33bb8d6b7529",
					"bbox": {
						"x": 606.1045220904394,
						"y": 197.72359870566655,
						"w": 20,
						"h": 40
					},
					"class": "macromolecule",
					"label": "a2",
					"statesandinfos": [],
					"language": "PD",
					"border-width": 0.001,
					"border-color": "#555555",
					"background-color": "#ffffff",
					"background-opacity": 1,
					"background-image-opacity": "1 1",
					"text-wrap": "wrap",
					"font-size": 11,
					"font-family": "Helvetica",
					"font-style": "normal",
					"font-weight": "normal",
					"color": "#000",
					"background-image": "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABYAAAAyCAYAAABYiSsbAAAABHNCSVQICAgIfAhkiAAABA5JREFUWIXtmM9LI2cYxz9KCOlWcOpqjew2zYK1Uy00tLDMoTShFISePOptLwvpf5C7B28rCCVKDwUv8b6H4M01oBEPsXjQ6iFx3RqruA4eHAkl3x6aGYyZSWLZFgr9wsv78j7zfvLM+zzvj0mPJPEPqNevs1KpsL+/3xWgWCxi23arQXfkOI7i8bgsy7prapHjOAI0PT3dYmsBp9NpAcrn83IcR3t7e77Qzc1NSVImkxGgXC4XDC6VSk0epFIpGYbRAnWfm5ub894wGo3KcRx/8NzcnADt7e0pm80KUCaTkSTNzs5qcnJShUJBkmRZliKRiMrlsubn5wWoVCr5g6empjwP3bbjOJqZmRHglZWVFW1ubgrQ/Py8185ms/5g0zS9oN1u9/X1KQz6qQGenJz0ApdOp5varprSLRqNcnp6CoBhGF4axWIxasAPjefGxsY8m2EY3pjh4WH/PE4kElQqFWzbxrIs9vf3WVtbY2lpiXA4zB/AxMQECwsLLC4uApBMJtnZ2fHG++ZxLpfz5q1arcowDJmmKUlKJpMCVCgUVC6XFYlElEqlvHgAqlar/nPsOI5M0/Sinc/nvay4Db68vFQ6nVa5XPacuT2/LWBJXoSnpqaa+m+DbzsSjUYVj8ebcrgleACWZZHNZjFNs3X9+yiRSJDL5YhEIs2Gux4Hyc/jdvLd3d6F/gf/h8Ed0y2fzyuVSnlb5sjIiKanpwNPFldtwevr6wqFQvpwaEifPX4sQNb4uAD19/e3rLauwe7m8olh6EdQBPQr6NHAgAAtLy8Hjm07x0dHRwAc2jazQ0NYiQRfhMP89vYtANvb24Fj24KPj48JAT8D5vk57OyQqtV40bDv7u7+veCFw2ENguRTekCjo6P3nwrbtqnVanwUYH/Q00O1Wr3/VGxsbADwcYD9Awnn+vr+4EKhAMBXAfY4UJc4ODi4H9i9FH4ZYP+0UW9tbd0P7HryfYDd/UF3yroGn52dEQ4yAt816sDrbmC69PZqJCDVbqdcLBbrPt1s26ZerxNt4zHAA+Di4sLX5gteXV0FoNM5/RC4Dkg5X7B7ZRrvAI4Bknj98iXUap3BpVIJgFQH8OeNevfFCwg3h9oXfHx8DMDXHcDu4lktFuHmpjP45OSkbaq5+qZRl25uoFjsDL66uuJhF+AxoAd4DfDqVXvw0dER9Xo9cPO5q/eBc4A3b9qDi41XetIleAC4AXj+vKk/dPfBw8NDoHOquXoCfPvsGTx92my4uxRXVlb+Oo07LGe3PDKMppu8K9+9wjAMAUqCKgHAX0Cjjc8KP/mCK5WK+vr6vEuK0XiDZKO81+hPJBJBe1j7e0Umk9Hg4KBCoVDTB2Rvb6/G43H9XqkEju2R/sX/K96F/gTllaEEcp1NCgAAAABJRU5ErkJggg==",
					"ports": [],
					"background-fit": "none",
					"background-position-x": "50%",
					"background-position-y": "50%",
					"background-width": "100%",
					"background-height": "100%",
					"infoboxCalculated": true,
					"auxunitlayouts": {}
				},
				"position": {
					"x": 606.1045220904394,
					"y": 197.72359870566655
				},
				"group": "nodes",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			}
		],
		"edges": [
			{
				"data": {
					"id": "nwtE_1c1c1ca1-decb-4ebd-854c-90fe60be467c",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "0998ddcc-de7b-792a-5b2e-c53317128a7c",
					"target": "3c910e69-2f8b-7beb-159c-da99ed4f6907",
					"portsource": "0998ddcc-de7b-792a-5b2e-c53317128a7c",
					"porttarget": "3c910e69-2f8b-7beb-159c-da99ed4f6907"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_96d9570f-b273-4050-a646-82af79f255d9",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "3c910e69-2f8b-7beb-159c-da99ed4f6907",
					"target": "f6ded9c4-6e94-ee99-6d4e-aebba05882db",
					"portsource": "3c910e69-2f8b-7beb-159c-da99ed4f6907",
					"porttarget": "f6ded9c4-6e94-ee99-6d4e-aebba05882db"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_d65ce814-8761-42a2-a662-c254e827ea42",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "f6ded9c4-6e94-ee99-6d4e-aebba05882db",
					"target": "fb9ad239-d112-d0f9-ed9e-90db5f147e54",
					"portsource": "f6ded9c4-6e94-ee99-6d4e-aebba05882db",
					"porttarget": "fb9ad239-d112-d0f9-ed9e-90db5f147e54"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_2c491a02-a8b4-4f6b-bfa3-fd05e1a2338d",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "0998ddcc-de7b-792a-5b2e-c53317128a7c",
					"target": "5fdc6150-63bb-18e8-1f03-33bb8d6b7529",
					"portsource": "0998ddcc-de7b-792a-5b2e-c53317128a7c",
					"porttarget": "5fdc6150-63bb-18e8-1f03-33bb8d6b7529"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_6d445ac6-5105-493d-9632-e56b7a9d374d",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "5fdc6150-63bb-18e8-1f03-33bb8d6b7529",
					"target": "3b233452-0a1c-6c51-703a-b62ca9951f2b",
					"portsource": "5fdc6150-63bb-18e8-1f03-33bb8d6b7529",
					"porttarget": "3b233452-0a1c-6c51-703a-b62ca9951f2b"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_8c77c946-7d52-4ce2-90d1-12b56ae4a0a0",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "3b233452-0a1c-6c51-703a-b62ca9951f2b",
					"target": "73eceeb1-0069-9139-4398-5dffeb19bddf",
					"portsource": "3b233452-0a1c-6c51-703a-b62ca9951f2b",
					"porttarget": "73eceeb1-0069-9139-4398-5dffeb19bddf"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_b0373815-c68f-4510-a26d-92a6035a8dae",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "73eceeb1-0069-9139-4398-5dffeb19bddf",
					"target": "8e47cd39-5258-1c70-06ab-96f28782e065",
					"portsource": "73eceeb1-0069-9139-4398-5dffeb19bddf",
					"porttarget": "8e47cd39-5258-1c70-06ab-96f28782e065"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_8d4eb83c-7880-41b9-b0ba-67e879a820e1",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "8e47cd39-5258-1c70-06ab-96f28782e065",
					"target": "25f4cc48-4e4e-e80e-174f-fa4ba64616da",
					"portsource": "8e47cd39-5258-1c70-06ab-96f28782e065",
					"porttarget": "25f4cc48-4e4e-e80e-174f-fa4ba64616da"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_8a0abf51-ca91-4211-ab18-551c485ef634",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "25f4cc48-4e4e-e80e-174f-fa4ba64616da",
					"target": "2b855d36-0c89-996d-9281-ea54f711cc8e",
					"portsource": "25f4cc48-4e4e-e80e-174f-fa4ba64616da",
					"porttarget": "2b855d36-0c89-996d-9281-ea54f711cc8e"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_4be2fe1d-18da-4e5a-bb19-9731c5fd536c",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "73eceeb1-0069-9139-4398-5dffeb19bddf",
					"target": "25f4cc48-4e4e-e80e-174f-fa4ba64616da",
					"portsource": "73eceeb1-0069-9139-4398-5dffeb19bddf",
					"porttarget": "25f4cc48-4e4e-e80e-174f-fa4ba64616da"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_8da7756e-963f-4d2d-8eaf-7397cfbf354e",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "73eceeb1-0069-9139-4398-5dffeb19bddf",
					"target": "9e04da58-86d5-7fc8-e79e-3883f25b5c2d",
					"portsource": "73eceeb1-0069-9139-4398-5dffeb19bddf",
					"porttarget": "9e04da58-86d5-7fc8-e79e-3883f25b5c2d"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_89863f47-0f02-40f4-b1ff-b355a4e9f1d7",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "9e04da58-86d5-7fc8-e79e-3883f25b5c2d",
					"target": "464bae1c-0c35-3b4a-3af2-371ef03a0dcb",
					"portsource": "9e04da58-86d5-7fc8-e79e-3883f25b5c2d",
					"porttarget": "464bae1c-0c35-3b4a-3af2-371ef03a0dcb"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_2f53a32d-4059-423e-8396-85d542b20085",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "464bae1c-0c35-3b4a-3af2-371ef03a0dcb",
					"target": "25f4cc48-4e4e-e80e-174f-fa4ba64616da",
					"portsource": "464bae1c-0c35-3b4a-3af2-371ef03a0dcb",
					"porttarget": "25f4cc48-4e4e-e80e-174f-fa4ba64616da"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_3d6bb730-cf78-48a7-b832-28eb2bce2b80",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "25f4cc48-4e4e-e80e-174f-fa4ba64616da",
					"target": "d4e4f860-ffb4-cbf6-80b7-675c821ed4d2",
					"portsource": "25f4cc48-4e4e-e80e-174f-fa4ba64616da",
					"porttarget": "d4e4f860-ffb4-cbf6-80b7-675c821ed4d2"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_30435d07-810b-4899-8fc3-8f4ba0d01b3c",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "464bae1c-0c35-3b4a-3af2-371ef03a0dcb",
					"target": "bc0420e3-9b6e-4c97-74c6-61278dbc18d4",
					"portsource": "464bae1c-0c35-3b4a-3af2-371ef03a0dcb",
					"porttarget": "bc0420e3-9b6e-4c97-74c6-61278dbc18d4"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_bf58b874-f1dc-4198-bc72-34105cd2b746",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "d4e4f860-ffb4-cbf6-80b7-675c821ed4d2",
					"target": "bc0420e3-9b6e-4c97-74c6-61278dbc18d4",
					"portsource": "d4e4f860-ffb4-cbf6-80b7-675c821ed4d2",
					"porttarget": "bc0420e3-9b6e-4c97-74c6-61278dbc18d4"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_35a97b29-458f-4388-95e5-8bb61ed547ff",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "d4e4f860-ffb4-cbf6-80b7-675c821ed4d2",
					"target": "c54786e2-bbea-d15b-3e21-7cf32b9338ca",
					"portsource": "d4e4f860-ffb4-cbf6-80b7-675c821ed4d2",
					"porttarget": "c54786e2-bbea-d15b-3e21-7cf32b9338ca"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_da45116e-91b9-473b-872f-b9004fad988b",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "2b855d36-0c89-996d-9281-ea54f711cc8e",
					"target": "c54786e2-bbea-d15b-3e21-7cf32b9338ca",
					"portsource": "2b855d36-0c89-996d-9281-ea54f711cc8e",
					"porttarget": "c54786e2-bbea-d15b-3e21-7cf32b9338ca"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_3526eb14-26ce-4a67-b14f-a9fab2460e9f",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "d4e4f860-ffb4-cbf6-80b7-675c821ed4d2",
					"target": "2b855d36-0c89-996d-9281-ea54f711cc8e",
					"portsource": "d4e4f860-ffb4-cbf6-80b7-675c821ed4d2",
					"porttarget": "2b855d36-0c89-996d-9281-ea54f711cc8e"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_a7e27295-8c9c-48dc-b801-35c2f89ae1de",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "c54786e2-bbea-d15b-3e21-7cf32b9338ca",
					"target": "7b23c6ae-4256-a918-0c9b-0254d83a908b",
					"portsource": "c54786e2-bbea-d15b-3e21-7cf32b9338ca",
					"porttarget": "7b23c6ae-4256-a918-0c9b-0254d83a908b"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_5ddca385-5164-4157-bcdf-9f4d7ee9b877",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "7b23c6ae-4256-a918-0c9b-0254d83a908b",
					"target": "a97f8f48-6652-7e09-8eda-2d87eae7d20b",
					"portsource": "7b23c6ae-4256-a918-0c9b-0254d83a908b",
					"porttarget": "a97f8f48-6652-7e09-8eda-2d87eae7d20b"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_c6cae78a-29c8-47ac-a95f-ef0db67c5f34",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "a97f8f48-6652-7e09-8eda-2d87eae7d20b",
					"target": "3f913ee3-7737-5405-968d-312653a7c318",
					"portsource": "a97f8f48-6652-7e09-8eda-2d87eae7d20b",
					"porttarget": "3f913ee3-7737-5405-968d-312653a7c318"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_3a301c6b-2f56-42a1-985e-5476cf722c9f",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "a97f8f48-6652-7e09-8eda-2d87eae7d20b",
					"target": "97a17094-822f-fc65-78f3-fc5b8aca0b23",
					"portsource": "a97f8f48-6652-7e09-8eda-2d87eae7d20b",
					"porttarget": "97a17094-822f-fc65-78f3-fc5b8aca0b23"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_fec71d1a-e60b-4433-87b0-f7542007c560",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "97a17094-822f-fc65-78f3-fc5b8aca0b23",
					"target": "67add58f-1a8c-17d9-8cfa-ff468527f6c9",
					"portsource": "97a17094-822f-fc65-78f3-fc5b8aca0b23",
					"porttarget": "67add58f-1a8c-17d9-8cfa-ff468527f6c9"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_c52a213f-22d9-49b6-9032-c0fdd99c373a",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "97a17094-822f-fc65-78f3-fc5b8aca0b23",
					"target": "86f48f58-145d-92cc-0d33-aaf639984733",
					"portsource": "97a17094-822f-fc65-78f3-fc5b8aca0b23",
					"porttarget": "86f48f58-145d-92cc-0d33-aaf639984733"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_58b3a3d1-e717-4247-b980-0a57dd715b02",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "97a17094-822f-fc65-78f3-fc5b8aca0b23",
					"target": "8c9ccb35-a1e8-1772-cbad-6e5f46b95b8a",
					"portsource": "97a17094-822f-fc65-78f3-fc5b8aca0b23",
					"porttarget": "8c9ccb35-a1e8-1772-cbad-6e5f46b95b8a"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_c79340a6-bdbd-438f-8838-57735eff5329",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "8c9ccb35-a1e8-1772-cbad-6e5f46b95b8a",
					"target": "c21a716f-9ce2-4976-bdc3-320395e5ed97",
					"portsource": "8c9ccb35-a1e8-1772-cbad-6e5f46b95b8a",
					"porttarget": "c21a716f-9ce2-4976-bdc3-320395e5ed97"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_8550f45c-f84b-45c8-8f8e-57ad32a1fe31",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "c21a716f-9ce2-4976-bdc3-320395e5ed97",
					"target": "88642a3e-3f7a-60a3-9c61-425f1f3cf2d7",
					"portsource": "c21a716f-9ce2-4976-bdc3-320395e5ed97",
					"porttarget": "88642a3e-3f7a-60a3-9c61-425f1f3cf2d7"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_e8176741-3adc-48e4-8cf2-344b1353a5d9",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "88642a3e-3f7a-60a3-9c61-425f1f3cf2d7",
					"target": "e98b25fb-7352-b78a-de16-240d09bda830",
					"portsource": "88642a3e-3f7a-60a3-9c61-425f1f3cf2d7",
					"porttarget": "e98b25fb-7352-b78a-de16-240d09bda830"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_dd78df2c-4e48-466e-a19e-baea9c58ee7e",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "e98b25fb-7352-b78a-de16-240d09bda830",
					"target": "8c9ccb35-a1e8-1772-cbad-6e5f46b95b8a",
					"portsource": "e98b25fb-7352-b78a-de16-240d09bda830",
					"porttarget": "8c9ccb35-a1e8-1772-cbad-6e5f46b95b8a"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_c94b7aa8-c93c-453d-8c4d-b2212b3beafc",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "c21a716f-9ce2-4976-bdc3-320395e5ed97",
					"target": "a97f8f48-6652-7e09-8eda-2d87eae7d20b",
					"portsource": "c21a716f-9ce2-4976-bdc3-320395e5ed97",
					"porttarget": "a97f8f48-6652-7e09-8eda-2d87eae7d20b"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_f7483a56-4f02-4ec3-9109-eadddc4f887b",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "88642a3e-3f7a-60a3-9c61-425f1f3cf2d7",
					"target": "3ffdee99-d217-2dc6-5b0e-1229ee1d1bd4",
					"portsource": "88642a3e-3f7a-60a3-9c61-425f1f3cf2d7",
					"porttarget": "3ffdee99-d217-2dc6-5b0e-1229ee1d1bd4"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_4bbf5c50-af52-4ac2-b36a-5ef9a3192fb7",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "c21a716f-9ce2-4976-bdc3-320395e5ed97",
					"target": "97a17094-822f-fc65-78f3-fc5b8aca0b23",
					"portsource": "c21a716f-9ce2-4976-bdc3-320395e5ed97",
					"porttarget": "97a17094-822f-fc65-78f3-fc5b8aca0b23"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_7ec7f0fb-f15a-4501-a802-2c9006f76f7e",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "3ffdee99-d217-2dc6-5b0e-1229ee1d1bd4",
					"target": "a3218cf9-fd48-f0b4-4c45-99cf2e52a0e8",
					"portsource": "3ffdee99-d217-2dc6-5b0e-1229ee1d1bd4",
					"porttarget": "a3218cf9-fd48-f0b4-4c45-99cf2e52a0e8"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_278001ac-9e8f-4bc5-a968-9773c8b1caf1",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "5678f1a3-0919-aecd-fb70-613a8a55c4d7",
					"target": "e98b25fb-7352-b78a-de16-240d09bda830",
					"portsource": "5678f1a3-0919-aecd-fb70-613a8a55c4d7",
					"porttarget": "e98b25fb-7352-b78a-de16-240d09bda830"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_3d13ccc4-4960-4e1b-a11a-3d9f517d736d",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "5678f1a3-0919-aecd-fb70-613a8a55c4d7",
					"target": "a3218cf9-fd48-f0b4-4c45-99cf2e52a0e8",
					"portsource": "5678f1a3-0919-aecd-fb70-613a8a55c4d7",
					"porttarget": "a3218cf9-fd48-f0b4-4c45-99cf2e52a0e8"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_397654f0-801f-4bda-8f03-a988121e7550",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "3ffdee99-d217-2dc6-5b0e-1229ee1d1bd4",
					"target": "5678f1a3-0919-aecd-fb70-613a8a55c4d7",
					"portsource": "3ffdee99-d217-2dc6-5b0e-1229ee1d1bd4",
					"porttarget": "5678f1a3-0919-aecd-fb70-613a8a55c4d7"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_c666ca08-8e52-4832-8722-c0ba56a947f3",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "5678f1a3-0919-aecd-fb70-613a8a55c4d7",
					"target": "1ebc687b-0b6a-eb35-4ac7-9b6d57a784da",
					"portsource": "5678f1a3-0919-aecd-fb70-613a8a55c4d7",
					"porttarget": "1ebc687b-0b6a-eb35-4ac7-9b6d57a784da"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_e678ea21-1b85-4871-bcdd-db372711f8a1",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "1ebc687b-0b6a-eb35-4ac7-9b6d57a784da",
					"target": "e98b25fb-7352-b78a-de16-240d09bda830",
					"portsource": "1ebc687b-0b6a-eb35-4ac7-9b6d57a784da",
					"porttarget": "e98b25fb-7352-b78a-de16-240d09bda830"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_6a4d0bec-0139-46e0-89ec-ae98eeed3683",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "86f48f58-145d-92cc-0d33-aaf639984733",
					"target": "8c9ccb35-a1e8-1772-cbad-6e5f46b95b8a",
					"portsource": "86f48f58-145d-92cc-0d33-aaf639984733",
					"porttarget": "8c9ccb35-a1e8-1772-cbad-6e5f46b95b8a"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_c85cd9be-301b-4b00-96b0-0b74923ab35c",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "86f48f58-145d-92cc-0d33-aaf639984733",
					"target": "1ebc687b-0b6a-eb35-4ac7-9b6d57a784da",
					"portsource": "86f48f58-145d-92cc-0d33-aaf639984733",
					"porttarget": "1ebc687b-0b6a-eb35-4ac7-9b6d57a784da"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_569f5cbc-6f04-45c3-8c78-84cd6692ff00",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "8edd562b-196b-4f7e-37bf-a9e2072917b0",
					"target": "1ebc687b-0b6a-eb35-4ac7-9b6d57a784da",
					"portsource": "8edd562b-196b-4f7e-37bf-a9e2072917b0",
					"porttarget": "1ebc687b-0b6a-eb35-4ac7-9b6d57a784da"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_b4a8f16b-9be5-4a2f-a397-660346cd5095",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "8edd562b-196b-4f7e-37bf-a9e2072917b0",
					"target": "0ddcc98c-7b7c-ac2e-2207-081c5ffc9921",
					"portsource": "8edd562b-196b-4f7e-37bf-a9e2072917b0",
					"porttarget": "0ddcc98c-7b7c-ac2e-2207-081c5ffc9921"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_163e8ac8-9a4f-4441-a596-3583fc3a77cc",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "0ddcc98c-7b7c-ac2e-2207-081c5ffc9921",
					"target": "5678f1a3-0919-aecd-fb70-613a8a55c4d7",
					"portsource": "0ddcc98c-7b7c-ac2e-2207-081c5ffc9921",
					"porttarget": "5678f1a3-0919-aecd-fb70-613a8a55c4d7"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_5812454f-3b40-49eb-a9e3-cafa29ecd0be",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "4ca3044f-9b82-020b-e1cb-bbb45e4b0088",
					"target": "3ffdee99-d217-2dc6-5b0e-1229ee1d1bd4",
					"portsource": "4ca3044f-9b82-020b-e1cb-bbb45e4b0088",
					"porttarget": "3ffdee99-d217-2dc6-5b0e-1229ee1d1bd4"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_c6f3a512-0f2b-4b19-8032-402945881d9b",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "4ca3044f-9b82-020b-e1cb-bbb45e4b0088",
					"target": "88642a3e-3f7a-60a3-9c61-425f1f3cf2d7",
					"portsource": "4ca3044f-9b82-020b-e1cb-bbb45e4b0088",
					"porttarget": "88642a3e-3f7a-60a3-9c61-425f1f3cf2d7"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_5a673304-468c-4227-beca-a7677a68b478",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "4ca3044f-9b82-020b-e1cb-bbb45e4b0088",
					"target": "9bf069c9-034b-1bee-35e5-2d2addaeaf38",
					"portsource": "4ca3044f-9b82-020b-e1cb-bbb45e4b0088",
					"porttarget": "9bf069c9-034b-1bee-35e5-2d2addaeaf38"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_7263b061-b6c0-454a-a47c-22f9cd4ddf7f",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "9bf069c9-034b-1bee-35e5-2d2addaeaf38",
					"target": "c21a716f-9ce2-4976-bdc3-320395e5ed97",
					"portsource": "9bf069c9-034b-1bee-35e5-2d2addaeaf38",
					"porttarget": "c21a716f-9ce2-4976-bdc3-320395e5ed97"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_ca069b99-e61c-42c9-a1ee-33287f5ca637",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "7c1292d7-1feb-63b9-65a6-fb9db2547eb3",
					"target": "c21a716f-9ce2-4976-bdc3-320395e5ed97",
					"portsource": "7c1292d7-1feb-63b9-65a6-fb9db2547eb3",
					"porttarget": "c21a716f-9ce2-4976-bdc3-320395e5ed97"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_af287463-cdbb-47c8-af68-0ebd1ea7774a",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "9bf069c9-034b-1bee-35e5-2d2addaeaf38",
					"target": "7c1292d7-1feb-63b9-65a6-fb9db2547eb3",
					"portsource": "9bf069c9-034b-1bee-35e5-2d2addaeaf38",
					"porttarget": "7c1292d7-1feb-63b9-65a6-fb9db2547eb3"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_c20aa39b-d909-4e3a-ac16-0fb2d059c730",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "7c1292d7-1feb-63b9-65a6-fb9db2547eb3",
					"target": "a97f8f48-6652-7e09-8eda-2d87eae7d20b",
					"portsource": "7c1292d7-1feb-63b9-65a6-fb9db2547eb3",
					"porttarget": "a97f8f48-6652-7e09-8eda-2d87eae7d20b"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_c63d2aab-281f-483b-89de-ea2a764cb437",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "7c1292d7-1feb-63b9-65a6-fb9db2547eb3",
					"target": "c54786e2-bbea-d15b-3e21-7cf32b9338ca",
					"portsource": "7c1292d7-1feb-63b9-65a6-fb9db2547eb3",
					"porttarget": "c54786e2-bbea-d15b-3e21-7cf32b9338ca"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_cdb68f09-3b2b-4456-bff4-48694b6006bf",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "67add58f-1a8c-17d9-8cfa-ff468527f6c9",
					"target": "3f913ee3-7737-5405-968d-312653a7c318",
					"portsource": "67add58f-1a8c-17d9-8cfa-ff468527f6c9",
					"porttarget": "3f913ee3-7737-5405-968d-312653a7c318"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_a70317b5-2004-49e9-8e42-f79016235b49",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "0ddcc98c-7b7c-ac2e-2207-081c5ffc9921",
					"target": "a3218cf9-fd48-f0b4-4c45-99cf2e52a0e8",
					"portsource": "0ddcc98c-7b7c-ac2e-2207-081c5ffc9921",
					"porttarget": "a3218cf9-fd48-f0b4-4c45-99cf2e52a0e8"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_74d7b89b-8f5b-424f-af0f-095a417db95a",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "a3218cf9-fd48-f0b4-4c45-99cf2e52a0e8",
					"target": "16102c94-c326-51c3-8636-3ae19b603483",
					"portsource": "a3218cf9-fd48-f0b4-4c45-99cf2e52a0e8",
					"porttarget": "16102c94-c326-51c3-8636-3ae19b603483"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_59de5fb2-3115-4cb2-aac6-a0df1f5f7099",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "16102c94-c326-51c3-8636-3ae19b603483",
					"target": "e833b238-0bb7-c5d2-ebec-aa0604bcd484",
					"portsource": "16102c94-c326-51c3-8636-3ae19b603483",
					"porttarget": "e833b238-0bb7-c5d2-ebec-aa0604bcd484"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_d543d912-04d7-4f9f-9222-2b9d6c46ff16",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "e53126c9-70fe-ca8a-3b85-bab123a93d70",
					"target": "e833b238-0bb7-c5d2-ebec-aa0604bcd484",
					"portsource": "e53126c9-70fe-ca8a-3b85-bab123a93d70",
					"porttarget": "e833b238-0bb7-c5d2-ebec-aa0604bcd484"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_aa30b478-2606-47e0-82c5-16a930978b86",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "e53126c9-70fe-ca8a-3b85-bab123a93d70",
					"target": "a1be056e-0b97-5a8e-56e9-8c3e08e9c24b",
					"portsource": "e53126c9-70fe-ca8a-3b85-bab123a93d70",
					"porttarget": "a1be056e-0b97-5a8e-56e9-8c3e08e9c24b"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_07786f94-90f4-43e9-90e8-b5c8392b0edc",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "267b649b-6d09-255c-67b4-46bd2c40375e",
					"target": "7435cbfb-9e49-d44e-4357-c413a22e188a",
					"portsource": "267b649b-6d09-255c-67b4-46bd2c40375e",
					"porttarget": "7435cbfb-9e49-d44e-4357-c413a22e188a"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_831e41d3-c942-4973-ac4a-f80514230710",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "7435cbfb-9e49-d44e-4357-c413a22e188a",
					"target": "d036dd9f-8368-bfac-a080-87b82544be20",
					"portsource": "7435cbfb-9e49-d44e-4357-c413a22e188a",
					"porttarget": "d036dd9f-8368-bfac-a080-87b82544be20"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_d3adddc0-7f9e-4ffa-a6a2-499e8185517c",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "d036dd9f-8368-bfac-a080-87b82544be20",
					"target": "a1be056e-0b97-5a8e-56e9-8c3e08e9c24b",
					"portsource": "d036dd9f-8368-bfac-a080-87b82544be20",
					"porttarget": "a1be056e-0b97-5a8e-56e9-8c3e08e9c24b"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_f83afce6-0c18-4b03-b8d5-eb4e52be3634",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "a1be056e-0b97-5a8e-56e9-8c3e08e9c24b",
					"target": "267b649b-6d09-255c-67b4-46bd2c40375e",
					"portsource": "a1be056e-0b97-5a8e-56e9-8c3e08e9c24b",
					"porttarget": "267b649b-6d09-255c-67b4-46bd2c40375e"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_260554e5-bc2f-4e71-b1a0-5331b19fcf76",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "7435cbfb-9e49-d44e-4357-c413a22e188a",
					"target": "4ca3044f-9b82-020b-e1cb-bbb45e4b0088",
					"portsource": "7435cbfb-9e49-d44e-4357-c413a22e188a",
					"porttarget": "4ca3044f-9b82-020b-e1cb-bbb45e4b0088"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_7874e5ca-6fcc-4cb5-b011-7a37bbc88099",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "4ca3044f-9b82-020b-e1cb-bbb45e4b0088",
					"target": "96f4c006-33d1-a00e-a389-782f23c38a65",
					"portsource": "4ca3044f-9b82-020b-e1cb-bbb45e4b0088",
					"porttarget": "96f4c006-33d1-a00e-a389-782f23c38a65"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_1bc5bd7a-5f0d-46aa-8e52-563e3e8eb1c9",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "267b649b-6d09-255c-67b4-46bd2c40375e",
					"target": "4ca3044f-9b82-020b-e1cb-bbb45e4b0088",
					"portsource": "267b649b-6d09-255c-67b4-46bd2c40375e",
					"porttarget": "4ca3044f-9b82-020b-e1cb-bbb45e4b0088"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_d0645132-bc57-4a6e-8ae2-d7b85975063d",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "96f4c006-33d1-a00e-a389-782f23c38a65",
					"target": "267b649b-6d09-255c-67b4-46bd2c40375e",
					"portsource": "96f4c006-33d1-a00e-a389-782f23c38a65",
					"porttarget": "267b649b-6d09-255c-67b4-46bd2c40375e"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_062dc392-a570-4473-9b2b-052b207ec261",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "7435cbfb-9e49-d44e-4357-c413a22e188a",
					"target": "d64b38d9-db3d-4128-1ec4-ddf1e5648c72",
					"portsource": "7435cbfb-9e49-d44e-4357-c413a22e188a",
					"porttarget": "d64b38d9-db3d-4128-1ec4-ddf1e5648c72"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_f48bbc29-fbcd-4de8-a35b-2b06f8af7a20",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "d64b38d9-db3d-4128-1ec4-ddf1e5648c72",
					"target": "a44fe57b-d4e6-a062-6b2a-bf6f5f92c5f1",
					"portsource": "d64b38d9-db3d-4128-1ec4-ddf1e5648c72",
					"porttarget": "a44fe57b-d4e6-a062-6b2a-bf6f5f92c5f1"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_f410ba16-544f-4ec1-b371-3d14e0faee2b",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "464bae1c-0c35-3b4a-3af2-371ef03a0dcb",
					"target": "a44fe57b-d4e6-a062-6b2a-bf6f5f92c5f1",
					"portsource": "464bae1c-0c35-3b4a-3af2-371ef03a0dcb",
					"porttarget": "a44fe57b-d4e6-a062-6b2a-bf6f5f92c5f1"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_82b407d2-5559-4386-8e97-44f4dbb184df",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "d64b38d9-db3d-4128-1ec4-ddf1e5648c72",
					"target": "bc0420e3-9b6e-4c97-74c6-61278dbc18d4",
					"portsource": "d64b38d9-db3d-4128-1ec4-ddf1e5648c72",
					"porttarget": "bc0420e3-9b6e-4c97-74c6-61278dbc18d4"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_318fb561-4823-430e-91eb-f533134f3f1a",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "d64b38d9-db3d-4128-1ec4-ddf1e5648c72",
					"target": "9bf069c9-034b-1bee-35e5-2d2addaeaf38",
					"portsource": "d64b38d9-db3d-4128-1ec4-ddf1e5648c72",
					"porttarget": "9bf069c9-034b-1bee-35e5-2d2addaeaf38"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_468b8322-a6fe-432d-aca2-ae3a921618d5",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "d64b38d9-db3d-4128-1ec4-ddf1e5648c72",
					"target": "4ca3044f-9b82-020b-e1cb-bbb45e4b0088",
					"portsource": "d64b38d9-db3d-4128-1ec4-ddf1e5648c72",
					"porttarget": "4ca3044f-9b82-020b-e1cb-bbb45e4b0088"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_c0707117-f935-4c11-8d01-1bcb52e21f5d",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "bc0420e3-9b6e-4c97-74c6-61278dbc18d4",
					"target": "7c1292d7-1feb-63b9-65a6-fb9db2547eb3",
					"portsource": "bc0420e3-9b6e-4c97-74c6-61278dbc18d4",
					"porttarget": "7c1292d7-1feb-63b9-65a6-fb9db2547eb3"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_31ff41b0-99eb-4e4e-9a72-a6fa5df61284",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "a44fe57b-d4e6-a062-6b2a-bf6f5f92c5f1",
					"target": "ffbd69bf-481f-faa8-73db-1489f3175b75",
					"portsource": "a44fe57b-d4e6-a062-6b2a-bf6f5f92c5f1",
					"porttarget": "ffbd69bf-481f-faa8-73db-1489f3175b75"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_900bd3fc-60d1-4c1b-82b7-8f73cad5536d",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "ffbd69bf-481f-faa8-73db-1489f3175b75",
					"target": "9e04da58-86d5-7fc8-e79e-3883f25b5c2d",
					"portsource": "ffbd69bf-481f-faa8-73db-1489f3175b75",
					"porttarget": "9e04da58-86d5-7fc8-e79e-3883f25b5c2d"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_a88789b7-9e4e-4c68-b863-76b180feb28e",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "ffbd69bf-481f-faa8-73db-1489f3175b75",
					"target": "d036dd9f-8368-bfac-a080-87b82544be20",
					"portsource": "ffbd69bf-481f-faa8-73db-1489f3175b75",
					"porttarget": "d036dd9f-8368-bfac-a080-87b82544be20"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_a1558907-c8d7-42c2-af07-a1005a6ca545",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "a44fe57b-d4e6-a062-6b2a-bf6f5f92c5f1",
					"target": "d036dd9f-8368-bfac-a080-87b82544be20",
					"portsource": "a44fe57b-d4e6-a062-6b2a-bf6f5f92c5f1",
					"porttarget": "d036dd9f-8368-bfac-a080-87b82544be20"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_ac395be3-d2fd-4521-8b51-5f4a19863afa",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "d036dd9f-8368-bfac-a080-87b82544be20",
					"target": "b45bf870-2439-dc1d-38f2-fc491752ff05",
					"portsource": "d036dd9f-8368-bfac-a080-87b82544be20",
					"porttarget": "b45bf870-2439-dc1d-38f2-fc491752ff05"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_ce0a1ca9-9045-4bfe-a1a3-2bfe070b8116",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "b45bf870-2439-dc1d-38f2-fc491752ff05",
					"target": "ffbd69bf-481f-faa8-73db-1489f3175b75",
					"portsource": "b45bf870-2439-dc1d-38f2-fc491752ff05",
					"porttarget": "ffbd69bf-481f-faa8-73db-1489f3175b75"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_b110eb00-eb99-4ccc-8946-820f05bcef96",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "b45bf870-2439-dc1d-38f2-fc491752ff05",
					"target": "f91d914e-6ab7-92cf-b16d-b9a7661e0044",
					"portsource": "b45bf870-2439-dc1d-38f2-fc491752ff05",
					"porttarget": "f91d914e-6ab7-92cf-b16d-b9a7661e0044"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_7036a59b-4088-4edc-a28f-82a6ce94d08f",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "f91d914e-6ab7-92cf-b16d-b9a7661e0044",
					"target": "a1be056e-0b97-5a8e-56e9-8c3e08e9c24b",
					"portsource": "f91d914e-6ab7-92cf-b16d-b9a7661e0044",
					"porttarget": "a1be056e-0b97-5a8e-56e9-8c3e08e9c24b"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_5a4167be-8239-4509-b96b-0c51fa5a6c8c",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "f91d914e-6ab7-92cf-b16d-b9a7661e0044",
					"target": "115069e9-e7e3-51e4-da42-481b318e5f1f",
					"portsource": "f91d914e-6ab7-92cf-b16d-b9a7661e0044",
					"porttarget": "115069e9-e7e3-51e4-da42-481b318e5f1f"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_197e0fc8-374e-444e-a24f-605d72b7d145",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "115069e9-e7e3-51e4-da42-481b318e5f1f",
					"target": "11284cd9-d716-52f7-20c7-5d1750de5309",
					"portsource": "115069e9-e7e3-51e4-da42-481b318e5f1f",
					"porttarget": "11284cd9-d716-52f7-20c7-5d1750de5309"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_da383a68-b3a3-4c42-b317-022669976139",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "11284cd9-d716-52f7-20c7-5d1750de5309",
					"target": "a1be056e-0b97-5a8e-56e9-8c3e08e9c24b",
					"portsource": "11284cd9-d716-52f7-20c7-5d1750de5309",
					"porttarget": "a1be056e-0b97-5a8e-56e9-8c3e08e9c24b"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_b7093d0f-e49d-4f84-9d12-70959ce71588",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "11284cd9-d716-52f7-20c7-5d1750de5309",
					"target": "e53126c9-70fe-ca8a-3b85-bab123a93d70",
					"portsource": "11284cd9-d716-52f7-20c7-5d1750de5309",
					"porttarget": "e53126c9-70fe-ca8a-3b85-bab123a93d70"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_6aad44bb-dc1b-4737-8334-8a853e9896a9",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "267b649b-6d09-255c-67b4-46bd2c40375e",
					"target": "e53126c9-70fe-ca8a-3b85-bab123a93d70",
					"portsource": "267b649b-6d09-255c-67b4-46bd2c40375e",
					"porttarget": "e53126c9-70fe-ca8a-3b85-bab123a93d70"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_b5c6a24d-c270-4b63-82d9-f658997e671f",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "96f4c006-33d1-a00e-a389-782f23c38a65",
					"target": "e833b238-0bb7-c5d2-ebec-aa0604bcd484",
					"portsource": "96f4c006-33d1-a00e-a389-782f23c38a65",
					"porttarget": "e833b238-0bb7-c5d2-ebec-aa0604bcd484"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_5c62e3d8-1514-4e67-ba16-6bf7dfa520e0",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "96f4c006-33d1-a00e-a389-782f23c38a65",
					"target": "a3218cf9-fd48-f0b4-4c45-99cf2e52a0e8",
					"portsource": "96f4c006-33d1-a00e-a389-782f23c38a65",
					"porttarget": "a3218cf9-fd48-f0b4-4c45-99cf2e52a0e8"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_0b3510cf-51a5-45cf-8d28-2f5ffcba2edf",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "5ea74092-08ec-6937-33c9-9f6fbe9226a2",
					"target": "16102c94-c326-51c3-8636-3ae19b603483",
					"portsource": "5ea74092-08ec-6937-33c9-9f6fbe9226a2",
					"porttarget": "16102c94-c326-51c3-8636-3ae19b603483"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_234d2bc5-727b-4214-a288-bca488a8ac11",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "e833b238-0bb7-c5d2-ebec-aa0604bcd484",
					"target": "5ea74092-08ec-6937-33c9-9f6fbe9226a2",
					"portsource": "e833b238-0bb7-c5d2-ebec-aa0604bcd484",
					"porttarget": "5ea74092-08ec-6937-33c9-9f6fbe9226a2"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_227dea7e-9867-47d8-abb3-d5e6520daefb",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "5ea74092-08ec-6937-33c9-9f6fbe9226a2",
					"target": "97f86367-eafd-54f7-4951-8360862b846f",
					"portsource": "5ea74092-08ec-6937-33c9-9f6fbe9226a2",
					"porttarget": "97f86367-eafd-54f7-4951-8360862b846f"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_a6dcf746-0421-403a-a2c2-422b46f496e8",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "97f86367-eafd-54f7-4951-8360862b846f",
					"target": "06fddad6-2abd-3413-6e24-a955f0763c53",
					"portsource": "97f86367-eafd-54f7-4951-8360862b846f",
					"porttarget": "06fddad6-2abd-3413-6e24-a955f0763c53"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_74fc39e5-e3a6-4d45-aba3-47a4f3ebefdd",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "06fddad6-2abd-3413-6e24-a955f0763c53",
					"target": "16102c94-c326-51c3-8636-3ae19b603483",
					"portsource": "06fddad6-2abd-3413-6e24-a955f0763c53",
					"porttarget": "16102c94-c326-51c3-8636-3ae19b603483"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_babcc71d-a57d-4eab-8a7d-00ed3ebace4d",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "06fddad6-2abd-3413-6e24-a955f0763c53",
					"target": "0ddcc98c-7b7c-ac2e-2207-081c5ffc9921",
					"portsource": "06fddad6-2abd-3413-6e24-a955f0763c53",
					"porttarget": "0ddcc98c-7b7c-ac2e-2207-081c5ffc9921"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_4748dd11-8b9e-4711-ad2c-559fa08b434c",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "06fddad6-2abd-3413-6e24-a955f0763c53",
					"target": "99f5cbe5-2c57-75ff-52b8-99e2baad068b",
					"portsource": "06fddad6-2abd-3413-6e24-a955f0763c53",
					"porttarget": "99f5cbe5-2c57-75ff-52b8-99e2baad068b"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_3d6abac3-210b-4911-b611-c4da62eac373",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "99f5cbe5-2c57-75ff-52b8-99e2baad068b",
					"target": "8edd562b-196b-4f7e-37bf-a9e2072917b0",
					"portsource": "99f5cbe5-2c57-75ff-52b8-99e2baad068b",
					"porttarget": "8edd562b-196b-4f7e-37bf-a9e2072917b0"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_b1c1226d-07a8-430b-b51e-ff5acc6b31b9",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "06fddad6-2abd-3413-6e24-a955f0763c53",
					"target": "b386ca2b-81a7-e365-4706-f955f13db03f",
					"portsource": "06fddad6-2abd-3413-6e24-a955f0763c53",
					"porttarget": "b386ca2b-81a7-e365-4706-f955f13db03f"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_64aacce4-61c0-4fb0-ae2c-98ac16b7a1ba",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "b386ca2b-81a7-e365-4706-f955f13db03f",
					"target": "9190744c-1571-616b-e75e-1c00d977a78d",
					"portsource": "b386ca2b-81a7-e365-4706-f955f13db03f",
					"porttarget": "9190744c-1571-616b-e75e-1c00d977a78d"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_140f3876-d51d-49a0-8264-77916172591e",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "b386ca2b-81a7-e365-4706-f955f13db03f",
					"target": "97f86367-eafd-54f7-4951-8360862b846f",
					"portsource": "b386ca2b-81a7-e365-4706-f955f13db03f",
					"porttarget": "97f86367-eafd-54f7-4951-8360862b846f"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_c24786d8-4a57-4381-91dd-33a4f6f4bc75",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "b386ca2b-81a7-e365-4706-f955f13db03f",
					"target": "30c49899-09d0-818a-a71d-fd15346f65e5",
					"portsource": "b386ca2b-81a7-e365-4706-f955f13db03f",
					"porttarget": "30c49899-09d0-818a-a71d-fd15346f65e5"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_046f7232-2034-4cb4-867a-944e7f49cb33",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "30c49899-09d0-818a-a71d-fd15346f65e5",
					"target": "5ea74092-08ec-6937-33c9-9f6fbe9226a2",
					"portsource": "30c49899-09d0-818a-a71d-fd15346f65e5",
					"porttarget": "5ea74092-08ec-6937-33c9-9f6fbe9226a2"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_848bd96f-a552-4328-a00b-507a4306e45a",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "30c49899-09d0-818a-a71d-fd15346f65e5",
					"target": "9190744c-1571-616b-e75e-1c00d977a78d",
					"portsource": "30c49899-09d0-818a-a71d-fd15346f65e5",
					"porttarget": "9190744c-1571-616b-e75e-1c00d977a78d"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_3cf7fd91-0f93-419c-9282-53057b8e54b2",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "9190744c-1571-616b-e75e-1c00d977a78d",
					"target": "aed099f2-5b0a-d59c-c297-9bac5ded0736",
					"portsource": "9190744c-1571-616b-e75e-1c00d977a78d",
					"porttarget": "aed099f2-5b0a-d59c-c297-9bac5ded0736"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_772832b9-1911-4c87-9aae-9223c893cd6b",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "aed099f2-5b0a-d59c-c297-9bac5ded0736",
					"target": "ed36ef56-dd89-40e1-251c-09f13686eb66",
					"portsource": "aed099f2-5b0a-d59c-c297-9bac5ded0736",
					"porttarget": "ed36ef56-dd89-40e1-251c-09f13686eb66"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_cc0e8a61-15b5-42d9-a802-df79315915b2",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "ed36ef56-dd89-40e1-251c-09f13686eb66",
					"target": "30c49899-09d0-818a-a71d-fd15346f65e5",
					"portsource": "ed36ef56-dd89-40e1-251c-09f13686eb66",
					"porttarget": "30c49899-09d0-818a-a71d-fd15346f65e5"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_b9a3e640-3adb-4dee-90b7-e55daa281fe1",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "ed36ef56-dd89-40e1-251c-09f13686eb66",
					"target": "5ea74092-08ec-6937-33c9-9f6fbe9226a2",
					"portsource": "ed36ef56-dd89-40e1-251c-09f13686eb66",
					"porttarget": "5ea74092-08ec-6937-33c9-9f6fbe9226a2"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_ee5e0e03-9a31-4295-80fe-89e84be54c8d",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "e53126c9-70fe-ca8a-3b85-bab123a93d70",
					"target": "7e30e3e1-7f31-1080-0970-22d019957584",
					"portsource": "e53126c9-70fe-ca8a-3b85-bab123a93d70",
					"porttarget": "7e30e3e1-7f31-1080-0970-22d019957584"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_895891e6-a989-41d8-b68f-98b569265445",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "7e30e3e1-7f31-1080-0970-22d019957584",
					"target": "5ea74092-08ec-6937-33c9-9f6fbe9226a2",
					"portsource": "7e30e3e1-7f31-1080-0970-22d019957584",
					"porttarget": "5ea74092-08ec-6937-33c9-9f6fbe9226a2"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_b467800e-59de-4641-bf6a-be3961bef494",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "7e30e3e1-7f31-1080-0970-22d019957584",
					"target": "ed36ef56-dd89-40e1-251c-09f13686eb66",
					"portsource": "7e30e3e1-7f31-1080-0970-22d019957584",
					"porttarget": "ed36ef56-dd89-40e1-251c-09f13686eb66"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_b7b70e38-ed91-4617-9348-e8876326415d",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "d9eeb201-2c9a-5afb-82a7-bc583b0f6628",
					"target": "aed099f2-5b0a-d59c-c297-9bac5ded0736",
					"portsource": "d9eeb201-2c9a-5afb-82a7-bc583b0f6628",
					"porttarget": "aed099f2-5b0a-d59c-c297-9bac5ded0736"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_55c5a1f9-a0f3-4b6d-b503-e6b1dadfd9e1",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "d9eeb201-2c9a-5afb-82a7-bc583b0f6628",
					"target": "889eedb3-8cb8-b906-8beb-904cd499c4f6",
					"portsource": "d9eeb201-2c9a-5afb-82a7-bc583b0f6628",
					"porttarget": "889eedb3-8cb8-b906-8beb-904cd499c4f6"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_7cd42c50-3ab0-4b02-b0f5-47195320cbc0",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "889eedb3-8cb8-b906-8beb-904cd499c4f6",
					"target": "67ff3c4c-e646-5c50-0e37-16e9a39da28a",
					"portsource": "889eedb3-8cb8-b906-8beb-904cd499c4f6",
					"porttarget": "67ff3c4c-e646-5c50-0e37-16e9a39da28a"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_b510951f-f195-49f5-bc4b-581d44254fd2",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "67ff3c4c-e646-5c50-0e37-16e9a39da28a",
					"target": "1eee479d-d3a1-44d9-316e-b70bc4556169",
					"portsource": "67ff3c4c-e646-5c50-0e37-16e9a39da28a",
					"porttarget": "1eee479d-d3a1-44d9-316e-b70bc4556169"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_6f43cab5-aa77-4014-9ca7-38f3c90022c3",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "1eee479d-d3a1-44d9-316e-b70bc4556169",
					"target": "979162a0-08fc-54e2-0ba2-b54b2eb59266",
					"portsource": "1eee479d-d3a1-44d9-316e-b70bc4556169",
					"porttarget": "979162a0-08fc-54e2-0ba2-b54b2eb59266"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_9c9b7b95-2e0e-4b27-a512-8241a7248d0a",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "979162a0-08fc-54e2-0ba2-b54b2eb59266",
					"target": "33f80abd-028e-ad1c-068b-33d5b40d9a93",
					"portsource": "979162a0-08fc-54e2-0ba2-b54b2eb59266",
					"porttarget": "33f80abd-028e-ad1c-068b-33d5b40d9a93"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_5791e1d8-3177-475b-81be-421244e2b109",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "33f80abd-028e-ad1c-068b-33d5b40d9a93",
					"target": "607d3097-a2d2-ed9d-39dc-b5c8a12ea7eb",
					"portsource": "33f80abd-028e-ad1c-068b-33d5b40d9a93",
					"porttarget": "607d3097-a2d2-ed9d-39dc-b5c8a12ea7eb"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_3c041c55-63f9-493e-93df-a6cbf152df7a",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "607d3097-a2d2-ed9d-39dc-b5c8a12ea7eb",
					"target": "1eee479d-d3a1-44d9-316e-b70bc4556169",
					"portsource": "607d3097-a2d2-ed9d-39dc-b5c8a12ea7eb",
					"porttarget": "1eee479d-d3a1-44d9-316e-b70bc4556169"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_fca7681c-7e66-4ba9-a221-bb5b5c1eb1d4",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "607d3097-a2d2-ed9d-39dc-b5c8a12ea7eb",
					"target": "3a85e050-463c-f484-c100-9d39adb1a23e",
					"portsource": "607d3097-a2d2-ed9d-39dc-b5c8a12ea7eb",
					"porttarget": "3a85e050-463c-f484-c100-9d39adb1a23e"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_161660fb-270a-4504-b7af-e9b51ccb2ee7",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "3a85e050-463c-f484-c100-9d39adb1a23e",
					"target": "f3fc754e-1421-a039-0ef0-c2d989db228e",
					"portsource": "3a85e050-463c-f484-c100-9d39adb1a23e",
					"porttarget": "f3fc754e-1421-a039-0ef0-c2d989db228e"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_e5c036c9-ecb1-49c4-ac47-60e35191eda0",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "f3fc754e-1421-a039-0ef0-c2d989db228e",
					"target": "11284cd9-d716-52f7-20c7-5d1750de5309",
					"portsource": "f3fc754e-1421-a039-0ef0-c2d989db228e",
					"porttarget": "11284cd9-d716-52f7-20c7-5d1750de5309"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_c169a1c3-79a2-4f5c-91d2-87f193fa7fa4",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "f3fc754e-1421-a039-0ef0-c2d989db228e",
					"target": "7078c4e8-4b4c-0563-9938-8af2c753f92c",
					"portsource": "f3fc754e-1421-a039-0ef0-c2d989db228e",
					"porttarget": "7078c4e8-4b4c-0563-9938-8af2c753f92c"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_e999105a-c621-46f5-a581-472950b8ec1f",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "889eedb3-8cb8-b906-8beb-904cd499c4f6",
					"target": "7078c4e8-4b4c-0563-9938-8af2c753f92c",
					"portsource": "889eedb3-8cb8-b906-8beb-904cd499c4f6",
					"porttarget": "7078c4e8-4b4c-0563-9938-8af2c753f92c"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_f04db46d-e7cf-4a54-9534-085e72b3c60e",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "7078c4e8-4b4c-0563-9938-8af2c753f92c",
					"target": "ed36ef56-dd89-40e1-251c-09f13686eb66",
					"portsource": "7078c4e8-4b4c-0563-9938-8af2c753f92c",
					"porttarget": "ed36ef56-dd89-40e1-251c-09f13686eb66"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_d3d7497f-a491-4f6a-8210-247cdd620d14",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "f3fc754e-1421-a039-0ef0-c2d989db228e",
					"target": "7e30e3e1-7f31-1080-0970-22d019957584",
					"portsource": "f3fc754e-1421-a039-0ef0-c2d989db228e",
					"porttarget": "7e30e3e1-7f31-1080-0970-22d019957584"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_e87f1864-d675-4727-ae5c-2c03f411a895",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "115069e9-e7e3-51e4-da42-481b318e5f1f",
					"target": "3a85e050-463c-f484-c100-9d39adb1a23e",
					"portsource": "115069e9-e7e3-51e4-da42-481b318e5f1f",
					"porttarget": "3a85e050-463c-f484-c100-9d39adb1a23e"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_c0293968-50cc-481a-8bc3-746d199ea0cc",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "3a85e050-463c-f484-c100-9d39adb1a23e",
					"target": "889eedb3-8cb8-b906-8beb-904cd499c4f6",
					"portsource": "3a85e050-463c-f484-c100-9d39adb1a23e",
					"porttarget": "889eedb3-8cb8-b906-8beb-904cd499c4f6"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_4a31fca3-37cd-4ba4-820b-29995b074d4a",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "1eee479d-d3a1-44d9-316e-b70bc4556169",
					"target": "889eedb3-8cb8-b906-8beb-904cd499c4f6",
					"portsource": "1eee479d-d3a1-44d9-316e-b70bc4556169",
					"porttarget": "889eedb3-8cb8-b906-8beb-904cd499c4f6"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_907db6cd-a798-4053-93e1-7ff0542248eb",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "889eedb3-8cb8-b906-8beb-904cd499c4f6",
					"target": "607d3097-a2d2-ed9d-39dc-b5c8a12ea7eb",
					"portsource": "889eedb3-8cb8-b906-8beb-904cd499c4f6",
					"porttarget": "607d3097-a2d2-ed9d-39dc-b5c8a12ea7eb"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_be712e1f-3214-44c9-85ad-d7c6fb8388f3",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "607d3097-a2d2-ed9d-39dc-b5c8a12ea7eb",
					"target": "db182fe4-ce6c-7869-72ce-7a4b11327e3a",
					"portsource": "607d3097-a2d2-ed9d-39dc-b5c8a12ea7eb",
					"porttarget": "db182fe4-ce6c-7869-72ce-7a4b11327e3a"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_824318ef-7b9d-41a5-acbe-2c606b22b933",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "db182fe4-ce6c-7869-72ce-7a4b11327e3a",
					"target": "115069e9-e7e3-51e4-da42-481b318e5f1f",
					"portsource": "db182fe4-ce6c-7869-72ce-7a4b11327e3a",
					"porttarget": "115069e9-e7e3-51e4-da42-481b318e5f1f"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_8bdc25c9-1298-4f43-bf00-0eefa7248efb",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "f91d914e-6ab7-92cf-b16d-b9a7661e0044",
					"target": "db182fe4-ce6c-7869-72ce-7a4b11327e3a",
					"portsource": "f91d914e-6ab7-92cf-b16d-b9a7661e0044",
					"porttarget": "db182fe4-ce6c-7869-72ce-7a4b11327e3a"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_42f52cd8-e4da-4678-9177-31f68e58e475",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "97d3df31-9033-96c4-359d-08ed397b29c4",
					"target": "f91d914e-6ab7-92cf-b16d-b9a7661e0044",
					"portsource": "97d3df31-9033-96c4-359d-08ed397b29c4",
					"porttarget": "f91d914e-6ab7-92cf-b16d-b9a7661e0044"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_a075cf09-86b4-4f2f-a74e-b43f71d63e45",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "97d3df31-9033-96c4-359d-08ed397b29c4",
					"target": "db182fe4-ce6c-7869-72ce-7a4b11327e3a",
					"portsource": "97d3df31-9033-96c4-359d-08ed397b29c4",
					"porttarget": "db182fe4-ce6c-7869-72ce-7a4b11327e3a"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_d8916a24-67a2-47c1-826d-c2b1c5420891",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "97d3df31-9033-96c4-359d-08ed397b29c4",
					"target": "91966017-4d7f-7634-6823-1a405da45139",
					"portsource": "97d3df31-9033-96c4-359d-08ed397b29c4",
					"porttarget": "91966017-4d7f-7634-6823-1a405da45139"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_da3e69d1-815a-43af-b58c-29b6c553a2cc",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "91966017-4d7f-7634-6823-1a405da45139",
					"target": "b45bf870-2439-dc1d-38f2-fc491752ff05",
					"portsource": "91966017-4d7f-7634-6823-1a405da45139",
					"porttarget": "b45bf870-2439-dc1d-38f2-fc491752ff05"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_293d250e-a942-4989-8b0e-e2ca124d7ada",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "91966017-4d7f-7634-6823-1a405da45139",
					"target": "1998dad6-f944-21b8-11dc-05d4cebd39e6",
					"portsource": "91966017-4d7f-7634-6823-1a405da45139",
					"porttarget": "1998dad6-f944-21b8-11dc-05d4cebd39e6"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_9907d7b9-5c4d-4f76-81b0-1046a894669f",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "1998dad6-f944-21b8-11dc-05d4cebd39e6",
					"target": "ffbd69bf-481f-faa8-73db-1489f3175b75",
					"portsource": "1998dad6-f944-21b8-11dc-05d4cebd39e6",
					"porttarget": "ffbd69bf-481f-faa8-73db-1489f3175b75"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_15a2f86b-c8be-42c1-b386-1a4a5a5b66d3",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "1998dad6-f944-21b8-11dc-05d4cebd39e6",
					"target": "b45bf870-2439-dc1d-38f2-fc491752ff05",
					"portsource": "1998dad6-f944-21b8-11dc-05d4cebd39e6",
					"porttarget": "b45bf870-2439-dc1d-38f2-fc491752ff05"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_0e0092c8-cd77-440f-9c5c-4dfa34cf8cf5",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "1998dad6-f944-21b8-11dc-05d4cebd39e6",
					"target": "45d5101e-e0a1-821c-37d6-378cbd632d55",
					"portsource": "1998dad6-f944-21b8-11dc-05d4cebd39e6",
					"porttarget": "45d5101e-e0a1-821c-37d6-378cbd632d55"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_18097a11-63cb-4cbb-bda4-49680f5e4784",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "45d5101e-e0a1-821c-37d6-378cbd632d55",
					"target": "9e04da58-86d5-7fc8-e79e-3883f25b5c2d",
					"portsource": "45d5101e-e0a1-821c-37d6-378cbd632d55",
					"porttarget": "9e04da58-86d5-7fc8-e79e-3883f25b5c2d"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_0abf1634-c437-4682-8134-a97c8eebc475",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "9e04da58-86d5-7fc8-e79e-3883f25b5c2d",
					"target": "5fdc6150-63bb-18e8-1f03-33bb8d6b7529",
					"portsource": "9e04da58-86d5-7fc8-e79e-3883f25b5c2d",
					"porttarget": "5fdc6150-63bb-18e8-1f03-33bb8d6b7529"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_70230b02-a73a-409f-902e-25781ffb57b8",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "5fdc6150-63bb-18e8-1f03-33bb8d6b7529",
					"target": "45d5101e-e0a1-821c-37d6-378cbd632d55",
					"portsource": "5fdc6150-63bb-18e8-1f03-33bb8d6b7529",
					"porttarget": "45d5101e-e0a1-821c-37d6-378cbd632d55"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_af0dc488-8a4b-4832-8fc1-82e1bdaaeba7",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "5fdc6150-63bb-18e8-1f03-33bb8d6b7529",
					"target": "73eceeb1-0069-9139-4398-5dffeb19bddf",
					"portsource": "5fdc6150-63bb-18e8-1f03-33bb8d6b7529",
					"porttarget": "73eceeb1-0069-9139-4398-5dffeb19bddf"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_aa962f4e-be54-4257-a0f1-69bcaa641958",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "3c910e69-2f8b-7beb-159c-da99ed4f6907",
					"target": "45d5101e-e0a1-821c-37d6-378cbd632d55",
					"portsource": "3c910e69-2f8b-7beb-159c-da99ed4f6907",
					"porttarget": "45d5101e-e0a1-821c-37d6-378cbd632d55"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_6586f863-5bc9-4fd6-b6b8-786959eb8d0d",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "3c910e69-2f8b-7beb-159c-da99ed4f6907",
					"target": "fb9ad239-d112-d0f9-ed9e-90db5f147e54",
					"portsource": "3c910e69-2f8b-7beb-159c-da99ed4f6907",
					"porttarget": "fb9ad239-d112-d0f9-ed9e-90db5f147e54"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_c4e0504c-890b-4d69-a54e-c28b0dbc8cd4",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "039bc70a-1d3c-4274-f0fa-dbf75aede9b7",
					"target": "91966017-4d7f-7634-6823-1a405da45139",
					"portsource": "039bc70a-1d3c-4274-f0fa-dbf75aede9b7",
					"porttarget": "91966017-4d7f-7634-6823-1a405da45139"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_77b1eba9-d238-4e19-ab36-4e9c08189d1e",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "039bc70a-1d3c-4274-f0fa-dbf75aede9b7",
					"target": "fb9ad239-d112-d0f9-ed9e-90db5f147e54",
					"portsource": "039bc70a-1d3c-4274-f0fa-dbf75aede9b7",
					"porttarget": "fb9ad239-d112-d0f9-ed9e-90db5f147e54"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_417e01b9-9d65-4e48-8b08-40237628227e",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "039bc70a-1d3c-4274-f0fa-dbf75aede9b7",
					"target": "bd77a77c-4627-ad77-1c5a-2c390ba21959",
					"portsource": "039bc70a-1d3c-4274-f0fa-dbf75aede9b7",
					"porttarget": "bd77a77c-4627-ad77-1c5a-2c390ba21959"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_15a8b27e-0ae6-46ed-8c52-ecb79c67195c",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "bd77a77c-4627-ad77-1c5a-2c390ba21959",
					"target": "7c4ed529-4da9-7eed-59fe-4590b57b2dfc",
					"portsource": "bd77a77c-4627-ad77-1c5a-2c390ba21959",
					"porttarget": "7c4ed529-4da9-7eed-59fe-4590b57b2dfc"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_0ab4d935-2d6c-4ae0-b758-9dbe91d0dfdb",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "7c4ed529-4da9-7eed-59fe-4590b57b2dfc",
					"target": "73cc39db-10c0-542a-7d9f-198fa3e0975e",
					"portsource": "7c4ed529-4da9-7eed-59fe-4590b57b2dfc",
					"porttarget": "73cc39db-10c0-542a-7d9f-198fa3e0975e"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_afbff892-f334-4740-95cd-3a8ff0b7b2a4",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "73cc39db-10c0-542a-7d9f-198fa3e0975e",
					"target": "b51264f6-8497-2eff-8d96-1264b5650804",
					"portsource": "73cc39db-10c0-542a-7d9f-198fa3e0975e",
					"porttarget": "b51264f6-8497-2eff-8d96-1264b5650804"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_b21ae3b2-0961-47e6-a915-c135932e11fa",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "b51264f6-8497-2eff-8d96-1264b5650804",
					"target": "33f80abd-028e-ad1c-068b-33d5b40d9a93",
					"portsource": "b51264f6-8497-2eff-8d96-1264b5650804",
					"porttarget": "33f80abd-028e-ad1c-068b-33d5b40d9a93"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_9532405c-b438-4875-bbb2-70a4fcc3ef05",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "73cc39db-10c0-542a-7d9f-198fa3e0975e",
					"target": "db182fe4-ce6c-7869-72ce-7a4b11327e3a",
					"portsource": "73cc39db-10c0-542a-7d9f-198fa3e0975e",
					"porttarget": "db182fe4-ce6c-7869-72ce-7a4b11327e3a"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_f15382bf-899f-46f0-894b-a00ce4c30dcd",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "039bc70a-1d3c-4274-f0fa-dbf75aede9b7",
					"target": "7c4ed529-4da9-7eed-59fe-4590b57b2dfc",
					"portsource": "039bc70a-1d3c-4274-f0fa-dbf75aede9b7",
					"porttarget": "7c4ed529-4da9-7eed-59fe-4590b57b2dfc"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_b6679629-6f08-49ef-b35f-c71cbf1e72b0",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "7c4ed529-4da9-7eed-59fe-4590b57b2dfc",
					"target": "97d3df31-9033-96c4-359d-08ed397b29c4",
					"portsource": "7c4ed529-4da9-7eed-59fe-4590b57b2dfc",
					"porttarget": "97d3df31-9033-96c4-359d-08ed397b29c4"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			},
			{
				"data": {
					"id": "nwtE_b6679629-6f08-49ef-b35f-c71cbf7b8er5",
					"class": "consumption",
					"bendPointPositions": [],
					"language": "PD",
					"line-color": "#555555",
					"width": 1.25,
					"background-image": "",
					"background-color": "#ffffff",
					"cardinality": 0,
					"source": "3c910e69-2f8b-7beb-159c-da99ed4f6907",
					"target": "91966017-4d7f-7634-6823-1a405da45139",
					"portsource": "3c910e69-2f8b-7beb-159c-da99ed4f6907",
					"porttarget": "91966017-4d7f-7634-6823-1a405da45139"
				},
				"position": {},
				"group": "edges",
				"removed": false,
				"selected": false,
				"selectable": true,
				"locked": false,
				"grabbable": true,
				"classes": ""
			}
		]
	},
	"style": [
	    {
	      "selector": "node",
	      "style": {
	        "shape": "rectangle",
	        "text-halign": "center",
	        "text-valign": "bottom",
	        "background-color": "#ffffff",
	        "opacity": "1",
	        "border-color": "#ffffff",
	        "border-width": "0px"
	      }
	    },
	    {
	      "selector": "node[class = 'simple chemical']",
	      "style": {
	        "shape": "ellipse",
	        "background-color": "#c7eae5"
	      }
	    },
	    {
	      "selector": "node[class = 'macromolecule']",
	      "style": {
	        "shape": "roundrectangle",
	      }
	    },
	    {
	      "selector": "node[class = 'unspecified entity']",
	      "style": {
	        "shape": "ellipse",
	        "background-color": "#f5f5f5"
	      }
	    },	    
	    {
	      "selector": ":parent",
	      "style": {
	        "background-opacity": "0.333",
	        "text-valign": "bottom",
	        "shape": "barrel",
	        "text-margin-y": "2px",
	        "font-weight" : "bold",
	        "border-color": "#555555"
	      }
	    },
	    {
	      "selector": "node:selected",
	      "style": {
	        "background-color": "#33ff00",
	        "border-color": "#22ee00"
	      }
	    },
	    {
	      "selector": "edge",
	      "style": {
	        "curve-style": "bezier",
	        "width": "2px",
	        "line-color": "rgb(0,0,0)",
	        "opacity": "1",
        	"target-arrow-shape": "triangle",
        	"target-arrow-color": "rgb(0,0,0)",
        	"source-arrow-shape": "triangle",
        	"source-arrow-color": "rgb(0,0,0)",
	      }
	    },
	    {
	      "selector": "edge:selected",
	      "style": {
	        "line-color": "#33ff00",
	        "font-size": "13px",
	        "text-opacity": "1",
	        "text-rotation": "autorotate",
	        "color": "#33ff00",
	        "font-weight": "bold",
	        "text-background-shape": "roundrectangle",
	        "text-background-opacity": "1",
	        "text-background-padding": "2px",
	        "target-arrow-color": "#33ff00",
	        "target-arrow-shape": "triangle",
	      }
	    }
	  ],
	"zoomingEnabled": true,
	"userZoomingEnabled": true,
	"zoom": 1.4731857231207923,
	"minZoom": 0.125,
	"maxZoom": 16,
	"panningEnabled": true,
	"userPanningEnabled": true,
	"pan": {
		"x": -419.9201536258538,
		"y": -186.965642339959
	},
	"boxSelectionEnabled": true,
	"renderer": {
		"name": "canvas"
	},
	"wheelSensitivity": 0.1,
	"motionBlur": true
}