/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.reactive.streams.operators;

import java.util.Objects;
import java.util.concurrent.CompletionStage;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public interface CompletionSubscriber<T, R>
extends Subscriber<T> {
    public CompletionStage<R> getCompletion();

    public static <T, R> CompletionSubscriber<T, R> of(Subscriber<T> subscriber, CompletionStage<R> completion) {
        class DefaultCompletionSubscriber
        implements CompletionSubscriber<T, R> {
            private final Subscriber<T> subscriber;
            private final CompletionStage<R> completion;

            DefaultCompletionSubscriber(Subscriber<T> subscriber, CompletionStage<R> completion) {
                this.subscriber = Objects.requireNonNull(subscriber, "Subscriber must not be null");
                this.completion = Objects.requireNonNull(completion, "CompletionStage must not be null");
            }

            @Override
            public CompletionStage<R> getCompletion() {
                return this.completion;
            }

            public void onSubscribe(Subscription subscription) {
                this.subscriber.onSubscribe(subscription);
            }

            public void onNext(T t) {
                this.subscriber.onNext(t);
            }

            public void onError(Throwable throwable) {
                this.subscriber.onError(throwable);
            }

            public void onComplete() {
                this.subscriber.onComplete();
            }

            public String toString() {
                return "CompletionSubscriber(" + this.subscriber + ", " + this.completion + ")";
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                DefaultCompletionSubscriber that = (DefaultCompletionSubscriber)o;
                return Objects.equals(this.subscriber, that.subscriber) && Objects.equals(this.completion, that.completion);
            }

            public int hashCode() {
                return Objects.hash(this.subscriber, this.completion);
            }
        }
        return new DefaultCompletionSubscriber(subscriber, completion);
    }
}

