/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.util.io.ByteBufferUtil;
import org.jetbrains.kotlin.com.intellij.util.io.DirectByteBufferAllocator;
import org.jetbrains.kotlin.com.intellij.util.io.PagedFileStorage;
import org.jetbrains.kotlin.com.intellij.util.io.StorageLockContext;

@ApiStatus.Internal
public final class DirectBufferWrapper {
    private static final AtomicIntegerFieldUpdater<DirectBufferWrapper> REF_UPDATER = AtomicIntegerFieldUpdater.newUpdater(DirectBufferWrapper.class, "myReferences");
    @NotNull
    private final PagedFileStorage myFile;
    private volatile ByteBuffer myBuffer;
    private final long myPosition;
    private volatile int myBufferDataEndPos;
    private volatile boolean myDirty;
    private volatile int myReferences;

    DirectBufferWrapper(@NotNull PagedFileStorage file, long positionInFile) throws IOException {
        if (file == null) {
            DirectBufferWrapper.$$$reportNull$$$0(0);
        }
        this.myReferences = 0;
        file.getStorageLockContext().assertUnderSegmentAllocationLock();
        this.myFile = file;
        this.myPosition = positionInFile;
        this.myBuffer = this.allocateAndLoadFileContent();
    }

    public void markDirty() throws IOException {
        if (!this.myDirty) {
            if (this.myFile.isReadOnly()) {
                throw new IOException("Read-only byte buffer can't be modified. File: " + this.myFile);
            }
            this.myDirty = true;
            this.myFile.markDirty();
        }
    }

    public void fileSizeMayChanged(int bufferDataEndPos) {
        if (bufferDataEndPos > this.myBufferDataEndPos) {
            this.myBufferDataEndPos = bufferDataEndPos;
            this.myFile.ensureCachedSizeAtLeast(this.myPosition + (long)this.myBufferDataEndPos);
        }
    }

    public boolean isDirty() {
        return this.myDirty;
    }

    public ByteBuffer copy() {
        ByteBuffer duplicate = this.myBuffer.duplicate();
        duplicate.order(this.myBuffer.order());
        return duplicate;
    }

    public byte get(int index, boolean checkAccess) {
        if (checkAccess) {
            StorageLockContext context2 = this.myFile.getStorageLockContext();
            context2.checkReadAccess();
        }
        return this.myBuffer.get(index);
    }

    public long getLong(int index) {
        StorageLockContext context2 = this.myFile.getStorageLockContext();
        context2.checkReadAccess();
        return this.myBuffer.getLong(index);
    }

    public void putLong(int index, long value2) throws IOException {
        StorageLockContext context2 = this.myFile.getStorageLockContext();
        context2.checkWriteAccess();
        this.markDirty();
        this.myBuffer.putLong(index, value2);
        this.fileSizeMayChanged(index + 8);
    }

    public int getInt(int index) {
        StorageLockContext context2 = this.myFile.getStorageLockContext();
        context2.checkReadAccess();
        return this.myBuffer.getInt(index);
    }

    public void putInt(int index, int value2) throws IOException {
        StorageLockContext context2 = this.myFile.getStorageLockContext();
        context2.checkWriteAccess();
        this.markDirty();
        this.myBuffer.putInt(index, value2);
        this.fileSizeMayChanged(index + 4);
    }

    public void position(int newPosition) {
        StorageLockContext context2 = this.myFile.getStorageLockContext();
        context2.checkWriteAccess();
        this.myBuffer.position(newPosition);
    }

    public void put(ByteBuffer src) throws IOException {
        StorageLockContext context2 = this.myFile.getStorageLockContext();
        context2.checkWriteAccess();
        this.markDirty();
        this.myBuffer.put(src);
        this.fileSizeMayChanged(this.myBuffer.position());
    }

    public void readToArray(byte[] dst, int o2, int page_offset, int page_len, boolean checkAccess) throws IllegalArgumentException {
        if (checkAccess) {
            StorageLockContext context2 = this.myFile.getStorageLockContext();
            context2.checkReadAccess();
        }
        ByteBufferUtil.copyMemory(this.myBuffer, page_offset, dst, o2, page_len);
    }

    public void putFromArray(byte[] src, int o2, int page_offset, int page_len) throws IOException, IllegalArgumentException {
        StorageLockContext context2 = this.myFile.getStorageLockContext();
        context2.checkWriteAccess();
        this.markDirty();
        ByteBuffer buf = this.myBuffer.duplicate();
        buf.position(page_offset);
        buf.put(src, o2, page_len);
        this.fileSizeMayChanged(buf.position());
    }

    public boolean tryLock() {
        return REF_UPDATER.updateAndGet(this, refCount -> refCount >= 0 ? refCount + 1 : refCount) >= 0;
    }

    public void unlock() {
        int currentRefs = REF_UPDATER.decrementAndGet(this);
        assert (currentRefs >= 0);
    }

    public boolean isReleased() {
        return this.myReferences == -1;
    }

    public int getLength() {
        return this.myFile.getPageSize();
    }

    private ByteBuffer allocateAndLoadFileContent() throws IOException {
        int bufferSize = this.myFile.getPageSize();
        ByteBuffer buffer = DirectByteBufferAllocator.ALLOCATOR.allocate(bufferSize);
        buffer.order(this.myFile.isNativeBytesOrder() ? ByteOrder.nativeOrder() : ByteOrder.BIG_ENDIAN);
        assert (buffer.limit() > 0);
        return this.myFile.executeIdempotentOp(ch -> {
            int readBytes = ch.read(buffer, this.myPosition);
            if (readBytes < bufferSize) {
                for (int i2 = Math.max(0, readBytes); i2 < bufferSize; ++i2) {
                    buffer.put(i2, (byte)0);
                }
            }
            return buffer;
        }, this.myFile.isReadOnly());
    }

    boolean tryRelease(boolean force) throws IOException {
        boolean releaseState;
        boolean bl = releaseState = REF_UPDATER.updateAndGet(this, operand -> operand == 0 ? -1 : operand) == -1;
        if (releaseState || force) {
            this.myFile.getStorageLockContext().assertUnderSegmentAllocationLock();
            if (this.isDirty()) {
                this.force();
            }
            if (this.myBuffer != null) {
                DirectByteBufferAllocator.ALLOCATOR.release(this.myBuffer);
                this.myBuffer = null;
            }
            if (force && !releaseState) {
                PagedFileStorage.LOG.error("Page buffer is referenced but was forcibly released for file " + this.myFile.getFile());
            }
            return true;
        }
        return false;
    }

    void force() throws IOException {
        this.myFile.getStorageLockContext().assertUnderSegmentAllocationLock();
        if (this.myFile.isReadOnly()) {
            throw new IllegalStateException("Can't flush .readOnly page: " + this);
        }
        if (this.isDirty()) {
            ByteBuffer buffer = this.myBuffer.duplicate();
            buffer.rewind();
            buffer.limit(this.myBufferDataEndPos);
            this.myFile.executeIdempotentOp(ch -> {
                ch.write(buffer, this.myPosition);
                return null;
            }, false);
            this.myDirty = false;
        }
    }

    @NotNull
    PagedFileStorage getFile() {
        PagedFileStorage pagedFileStorage = this.myFile;
        if (pagedFileStorage == null) {
            DirectBufferWrapper.$$$reportNull$$$0(2);
        }
        return pagedFileStorage;
    }

    public String toString() {
        return "Buffer for " + this.myFile + ", offset:" + this.myPosition + ", size: " + this.myFile.getPageSize();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/io/DirectBufferWrapper";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/io/DirectBufferWrapper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "putFromBuffer";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

