/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.configurations;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import groovy.lang.Closure;
import java.io.File;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import org.apache.commons.lang3.text.WordUtils;
import org.gradle.api.Action;
import org.gradle.api.Describable;
import org.gradle.api.DomainObjectCollection;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.GradleException;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Named;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.ArtifactView;
import org.gradle.api.artifacts.ConfigurablePublishArtifact;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationPublications;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencyConstraint;
import org.gradle.api.artifacts.DependencyConstraintSet;
import org.gradle.api.artifacts.DependencyResolutionListener;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.ExcludeRule;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.PublishArtifactSet;
import org.gradle.api.artifacts.ResolutionStrategy;
import org.gradle.api.artifacts.ResolvableDependencies;
import org.gradle.api.artifacts.ResolvedConfiguration;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolutionResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.CompositeDomainObjectSet;
import org.gradle.api.internal.ConfigurationServicesBundle;
import org.gradle.api.internal.DefaultDomainObjectSet;
import org.gradle.api.internal.DomainObjectContext;
import org.gradle.api.internal.artifacts.ConfigurationResolver;
import org.gradle.api.internal.artifacts.DefaultDependencyConstraintSet;
import org.gradle.api.internal.artifacts.DefaultDependencySet;
import org.gradle.api.internal.artifacts.DefaultExcludeRule;
import org.gradle.api.internal.artifacts.DefaultPublishArtifactSet;
import org.gradle.api.internal.artifacts.ExcludeRuleNotationConverter;
import org.gradle.api.internal.artifacts.ResolveExceptionMapper;
import org.gradle.api.internal.artifacts.ResolverResults;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.configurations.ConfigurationRole;
import org.gradle.api.internal.artifacts.configurations.ConfigurationRoles;
import org.gradle.api.internal.artifacts.configurations.DefaultConfigurationFactory;
import org.gradle.api.internal.artifacts.configurations.DefaultConfigurationPublications;
import org.gradle.api.internal.artifacts.configurations.MutationValidator;
import org.gradle.api.internal.artifacts.configurations.PublishArtifactSetProvider;
import org.gradle.api.internal.artifacts.configurations.ResolutionHost;
import org.gradle.api.internal.artifacts.configurations.ResolutionResultProvider;
import org.gradle.api.internal.artifacts.configurations.ResolutionStrategyInternal;
import org.gradle.api.internal.artifacts.configurations.ResolveConfigurationResolutionBuildOperationDetails;
import org.gradle.api.internal.artifacts.configurations.ResolveConfigurationResolutionBuildOperationResult;
import org.gradle.api.internal.artifacts.configurations.TasksFromDependentProjects;
import org.gradle.api.internal.artifacts.configurations.TasksFromProjectDependencies;
import org.gradle.api.internal.artifacts.configurations.UsageDescriber;
import org.gradle.api.internal.artifacts.dependencies.DependencyConstraintInternal;
import org.gradle.api.internal.artifacts.ivyservice.ResolutionParameters;
import org.gradle.api.internal.artifacts.ivyservice.TypedResolveException;
import org.gradle.api.internal.artifacts.resolver.DefaultResolutionOutputs;
import org.gradle.api.internal.artifacts.resolver.ResolutionAccess;
import org.gradle.api.internal.artifacts.resolver.ResolutionOutputsInternal;
import org.gradle.api.internal.artifacts.result.DefaultResolutionResult;
import org.gradle.api.internal.artifacts.result.DefaultResolvedComponentResult;
import org.gradle.api.internal.artifacts.result.MinimalResolutionResult;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.FreezableAttributeContainer;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.file.AbstractFileCollection;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileCollectionStructureVisitor;
import org.gradle.api.internal.initialization.ResettableConfiguration;
import org.gradle.api.internal.project.ProjectIdentity;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.problems.ProblemGroup;
import org.gradle.api.problems.ProblemId;
import org.gradle.api.problems.Severity;
import org.gradle.api.problems.internal.GradleCoreProblemGroup;
import org.gradle.api.problems.internal.InternalProblems;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.internal.Actions;
import org.gradle.internal.Cast;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.internal.Factories;
import org.gradle.internal.Factory;
import org.gradle.internal.ImmutableActionSet;
import org.gradle.internal.code.UserCodeApplicationContext;
import org.gradle.internal.deprecation.DeprecatableConfiguration;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.deprecation.Documentation;
import org.gradle.internal.event.ListenerBroadcast;
import org.gradle.internal.exceptions.ResolutionProvider;
import org.gradle.internal.logging.text.TreeFormatter;
import org.gradle.internal.model.CalculatedModelValue;
import org.gradle.internal.model.CalculatedValue;
import org.gradle.internal.model.CalculatedValueContainer;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.operations.dependencies.configurations.ConfigurationIdentity;
import org.gradle.util.Path;
import org.gradle.util.internal.CollectionUtils;
import org.gradle.util.internal.ConfigureUtil;
import org.gradle.util.internal.WrapUtil;
import org.jspecify.annotations.Nullable;

public abstract class DefaultConfiguration
extends AbstractFileCollection
implements ConfigurationInternal,
MutationValidator,
ResettableConfiguration {
    private final ConfigurationResolver resolver;
    private final DefaultDependencySet dependencies;
    private final DefaultDependencyConstraintSet dependencyConstraints;
    private final DefaultDomainObjectSet<Dependency> ownDependencies;
    private final DefaultDomainObjectSet<DependencyConstraint> ownDependencyConstraints;
    private @Nullable CompositeDomainObjectSet<Dependency> inheritedDependencies;
    private @Nullable CompositeDomainObjectSet<DependencyConstraint> inheritedDependencyConstraints;
    private @Nullable DefaultDependencySet allDependencies;
    private @Nullable DefaultDependencyConstraintSet allDependencyConstraints;
    private ImmutableActionSet<DependencySet> defaultDependencyActions = ImmutableActionSet.empty();
    private ImmutableActionSet<DependencySet> withDependencyActions = ImmutableActionSet.empty();
    private final DefaultPublishArtifactSet artifacts;
    private final DefaultDomainObjectSet<PublishArtifact> ownArtifacts;
    private @Nullable CompositeDomainObjectSet<PublishArtifact> inheritedArtifacts;
    private @Nullable DefaultPublishArtifactSet allArtifacts;
    private final ConfigurationResolvableDependencies resolvableDependencies;
    private ListenerBroadcast<DependencyResolutionListener> dependencyResolutionListeners;
    private final Path identityPath;
    private final Path projectPath;
    private final String name;
    private final boolean isDetached;
    private final DefaultConfigurationPublications outgoing;
    private boolean visible = true;
    private boolean transitive = true;
    private Set<Configuration> extendsFrom = new LinkedHashSet<Configuration>();
    private @Nullable String description;
    private final Set<Object> excludeRules = new LinkedHashSet<Object>();
    private @Nullable Set<ExcludeRule> parsedExcludeRules;
    private boolean canBeConsumed;
    private boolean canBeResolved;
    private boolean canBeDeclaredAgainst;
    private final boolean consumptionDeprecated;
    private final boolean resolutionDeprecated;
    private final boolean declarationDeprecated;
    private boolean usageCanBeMutated = true;
    private final ConfigurationRole roleAtCreation;
    private ConfigurationInternal.InternalState observedState = ConfigurationInternal.InternalState.UNRESOLVED;
    private @Nullable Supplier<String> observationReason = null;
    boolean dependenciesObserved = false;
    private final FreezableAttributeContainer configurationAttributes;
    private final DomainObjectContext domainObjectContext;
    private final ResolutionAccess resolutionAccess;
    private @Nullable FileCollectionInternal intrinsicFiles;
    private final DisplayName displayName;
    private final UserCodeApplicationContext userCodeApplicationContext;
    private final AtomicInteger copyCount = new AtomicInteger();
    private List<String> declarationAlternatives = ImmutableList.of();
    private List<String> resolutionAlternatives = ImmutableList.of();
    private final CalculatedModelValue<Optional<ResolverResults>> currentResolveState;
    private @Nullable ConfigurationInternal consistentResolutionSource;
    private @Nullable String consistentResolutionReason;
    private final DefaultConfigurationFactory defaultConfigurationFactory;
    private Factory<ResolutionStrategyInternal> resolutionStrategyFactory;
    private @Nullable ResolutionStrategyInternal resolutionStrategy;
    private final ConfigurationServicesBundle configurationServices;

    public DefaultConfiguration(ConfigurationServicesBundle configurationServices, DomainObjectContext domainObjectContext, String name, boolean isDetached, ConfigurationResolver resolver, ListenerBroadcast<DependencyResolutionListener> dependencyResolutionListeners, Factory<ResolutionStrategyInternal> resolutionStrategyFactory, NotationParser<Object, ConfigurablePublishArtifact> artifactNotationParser, NotationParser<Object, Capability> capabilityNotationParser, UserCodeApplicationContext userCodeApplicationContext, DefaultConfigurationFactory defaultConfigurationFactory, ConfigurationRole roleAtCreation, boolean lockUsage) {
        super(configurationServices.getTaskDependencyFactory());
        this.userCodeApplicationContext = userCodeApplicationContext;
        this.identityPath = domainObjectContext.identityPath(name);
        this.projectPath = domainObjectContext.projectPath(name);
        this.name = name;
        this.isDetached = isDetached;
        this.resolver = resolver;
        this.resolutionStrategyFactory = resolutionStrategyFactory;
        this.dependencyResolutionListeners = dependencyResolutionListeners;
        this.domainObjectContext = domainObjectContext;
        this.displayName = Describables.memoize((Describable)new ConfigurationDescription(this.identityPath));
        this.configurationAttributes = new FreezableAttributeContainer(configurationServices.getAttributesFactory().mutable(), (Describable)this.displayName);
        this.resolutionAccess = new ConfigurationResolutionAccess();
        this.resolvableDependencies = (ConfigurationResolvableDependencies)configurationServices.getObjectFactory().newInstance(ConfigurationResolvableDependencies.class, new Object[]{this});
        this.ownDependencies = (DefaultDomainObjectSet)configurationServices.getDomainObjectCollectionFactory().newDomainObjectSet(Dependency.class);
        this.ownDependencies.beforeCollectionChanges(DefaultConfiguration.validateMutationType(this, MutationValidator.MutationType.DEPENDENCIES));
        this.ownDependencyConstraints = (DefaultDomainObjectSet)configurationServices.getDomainObjectCollectionFactory().newDomainObjectSet(DependencyConstraint.class);
        this.ownDependencyConstraints.beforeCollectionChanges(DefaultConfiguration.validateMutationType(this, MutationValidator.MutationType.DEPENDENCIES));
        this.dependencies = new DefaultDependencySet((Describable)Describables.of((Object)this.displayName, (Object)"dependencies"), this, (DomainObjectSet<Dependency>)this.ownDependencies);
        this.dependencyConstraints = new DefaultDependencyConstraintSet((Describable)Describables.of((Object)this.displayName, (Object)"dependency constraints"), this, (DomainObjectSet<DependencyConstraint>)this.ownDependencyConstraints);
        this.ownArtifacts = (DefaultDomainObjectSet)configurationServices.getDomainObjectCollectionFactory().newDomainObjectSet(PublishArtifact.class);
        this.ownArtifacts.beforeCollectionChanges(DefaultConfiguration.validateMutationType(this, MutationValidator.MutationType.ARTIFACTS));
        this.artifacts = new DefaultPublishArtifactSet((Describable)Describables.of((Object)this.displayName, (Object)"artifacts"), (DomainObjectSet<PublishArtifact>)this.ownArtifacts, configurationServices.getFileCollectionFactory(), this.taskDependencyFactory);
        this.outgoing = (DefaultConfigurationPublications)configurationServices.getObjectFactory().newInstance(DefaultConfigurationPublications.class, new Object[]{this.displayName, this.artifacts, new AllArtifactsProvider(), this.configurationAttributes, artifactNotationParser, capabilityNotationParser, configurationServices.getFileCollectionFactory(), configurationServices.getAttributesFactory(), configurationServices.getDomainObjectCollectionFactory(), this.taskDependencyFactory});
        this.currentResolveState = domainObjectContext.getModel().newCalculatedValue(Optional.empty());
        this.defaultConfigurationFactory = defaultConfigurationFactory;
        this.canBeConsumed = roleAtCreation.isConsumable();
        this.canBeResolved = roleAtCreation.isResolvable();
        this.canBeDeclaredAgainst = roleAtCreation.isDeclarable();
        this.consumptionDeprecated = roleAtCreation.isConsumptionDeprecated();
        this.resolutionDeprecated = roleAtCreation.isResolutionDeprecated();
        this.declarationDeprecated = roleAtCreation.isDeclarationAgainstDeprecated();
        this.usageCanBeMutated = !lockUsage;
        this.roleAtCreation = roleAtCreation;
        this.configurationServices = configurationServices;
    }

    private static Action<String> validateMutationType(MutationValidator mutationValidator, MutationValidator.MutationType type) {
        return arg -> mutationValidator.validateMutation(type);
    }

    public String getName() {
        return this.name;
    }

    public Configuration.State getState() {
        Optional currentState = (Optional)this.currentResolveState.get();
        if (!currentState.isPresent()) {
            return Configuration.State.UNRESOLVED;
        }
        ResolverResults resolvedState = (ResolverResults)currentState.get();
        if (resolvedState.getVisitedGraph().hasAnyFailure()) {
            return Configuration.State.RESOLVED_WITH_FAILURES;
        }
        if (resolvedState.isFullyResolved()) {
            return Configuration.State.RESOLVED;
        }
        return Configuration.State.UNRESOLVED;
    }

    @Deprecated
    public boolean isVisible() {
        ((DeprecationMessageBuilder.WithDocumentation)DeprecationLogger.deprecateMethod(Configuration.class, (String)"isVisible").willBeRemovedInGradle10().withUpgradeGuideSection(9, "deprecate-visible-property")).nagUser();
        return this.visible;
    }

    @Deprecated
    public Configuration setVisible(boolean visible) {
        this.validateMutation(MutationValidator.MutationType.BASIC_STATE);
        this.visible = visible;
        return this;
    }

    public Set<Configuration> getExtendsFrom() {
        return Collections.unmodifiableSet(this.extendsFrom);
    }

    public Configuration setExtendsFrom(Iterable<Configuration> extendsFrom) {
        this.validateMutation(MutationValidator.MutationType.HIERARCHY);
        this.assertNotDetachedExtensionDoingExtending(extendsFrom);
        for (Configuration configuration : this.extendsFrom) {
            if (this.inheritedArtifacts != null) {
                this.inheritedArtifacts.removeCollection((DomainObjectCollection)configuration.getAllArtifacts());
            }
            if (this.inheritedDependencies != null) {
                this.inheritedDependencies.removeCollection((DomainObjectCollection)configuration.getAllDependencies());
            }
            if (this.inheritedDependencyConstraints == null) continue;
            this.inheritedDependencyConstraints.removeCollection((DomainObjectCollection)configuration.getAllDependencyConstraints());
        }
        this.extendsFrom = new LinkedHashSet<Configuration>();
        for (Configuration configuration : extendsFrom) {
            this.extendsFrom(configuration);
        }
        return this;
    }

    public Configuration extendsFrom(Configuration ... extendsFrom) {
        this.validateMutation(MutationValidator.MutationType.HIERARCHY);
        this.assertNotDetachedExtensionDoingExtending(Arrays.asList(extendsFrom));
        for (Configuration extended : extendsFrom) {
            ConfigurationInternal other = Objects.requireNonNull((ConfigurationInternal)Cast.uncheckedCast((Object)extended));
            if (!this.domainObjectContext.equals(other.getDomainObjectContext())) {
                throw new InvalidUserDataException(String.format("%s in %s cannot extend %s from %s. Configurations can only extend from configurations in the same context.", this.displayName.getCapitalizedDisplayName(), this.domainObjectContext.getDisplayName(), other.getDisplayName(), other.getDomainObjectContext().getDisplayName()));
            }
            if (other.getHierarchy().contains(this)) {
                throw new InvalidUserDataException(String.format("Cyclic extendsFrom from %s and %s is not allowed. See existing hierarchy: %s", this, other, other.getHierarchy()));
            }
            if (!this.extendsFrom.add(other)) continue;
            if (this.inheritedArtifacts != null) {
                this.inheritedArtifacts.addCollection((DomainObjectCollection)other.getAllArtifacts());
            }
            if (this.inheritedDependencies != null) {
                this.inheritedDependencies.addCollection((DomainObjectCollection)other.getAllDependencies());
            }
            if (this.inheritedDependencyConstraints == null) continue;
            this.inheritedDependencyConstraints.addCollection((DomainObjectCollection)other.getAllDependencyConstraints());
        }
        return this;
    }

    public boolean isTransitive() {
        return this.transitive;
    }

    public Configuration setTransitive(boolean transitive) {
        this.validateMutation(MutationValidator.MutationType.BASIC_STATE);
        this.transitive = transitive;
        return this;
    }

    public @Nullable String getDescription() {
        return this.description;
    }

    public Configuration setDescription(@Nullable String description) {
        this.description = description;
        return this;
    }

    public Set<Configuration> getHierarchy() {
        if (this.extendsFrom.isEmpty()) {
            return Collections.singleton(this);
        }
        Set result = WrapUtil.toLinkedSet((Object[])new Configuration[]{this});
        this.collectSuperConfigs(this, result);
        return result;
    }

    private void collectSuperConfigs(Configuration configuration, Set<Configuration> result) {
        for (Configuration superConfig : configuration.getExtendsFrom()) {
            result.remove(superConfig);
            result.add(superConfig);
            this.collectSuperConfigs(superConfig, result);
        }
    }

    public Configuration defaultDependencies(Action<? super DependencySet> action) {
        this.warnOrFailOnInvalidUsage("defaultDependencies(Action)", ProperMethodUsage.DECLARABLE_AGAINST);
        this.validateMutation(MutationValidator.MutationType.BASIC_STATE);
        this.defaultDependencyActions = this.defaultDependencyActions.add(this.configurationServices.getCollectionCallbackActionDecorator().decorate(dependencies -> {
            if (dependencies.isEmpty()) {
                action.execute(dependencies);
            }
        }));
        return this;
    }

    public Configuration withDependencies(Action<? super DependencySet> action) {
        this.validateMutation(MutationValidator.MutationType.BASIC_STATE);
        this.withDependencyActions = this.withDependencyActions.add(this.configurationServices.getCollectionCallbackActionDecorator().decorate(action));
        return this;
    }

    @Override
    public void runDependencyActions() {
        this.runActionInHierarchy((Action<DefaultConfiguration>)((Action)conf -> {
            conf.defaultDependencyActions.execute((Object)conf.dependencies);
            conf.withDependencyActions.execute((Object)conf.dependencies);
            conf.defaultDependencyActions = ImmutableActionSet.empty();
            conf.withDependencyActions = ImmutableActionSet.empty();
        }));
    }

    private FileCollectionInternal getIntrinsicFiles() {
        if (this.intrinsicFiles == null) {
            this.assertIsResolvable();
            this.intrinsicFiles = this.resolutionAccess.getPublicView().getFiles();
        }
        return this.intrinsicFiles;
    }

    public Set<File> resolve() {
        this.warnOrFailOnInvalidUsage("resolve()", ProperMethodUsage.RESOLVABLE);
        return this.getFiles();
    }

    public Iterator<File> iterator() {
        return this.getIntrinsicFiles().iterator();
    }

    protected void visitContents(FileCollectionStructureVisitor visitor) {
        this.getIntrinsicFiles().visitStructure(visitor);
    }

    protected void appendContents(TreeFormatter formatter) {
        formatter.node("configuration: " + this.identityPath);
    }

    public boolean contains(File file) {
        this.warnOrFailOnInvalidUsage("contains(File)", ProperMethodUsage.RESOLVABLE);
        return this.getIntrinsicFiles().contains(file);
    }

    public boolean isEmpty() {
        return this.getIntrinsicFiles().isEmpty();
    }

    public ResolvedConfiguration getResolvedConfiguration() {
        this.warnOrFailOnInvalidUsage("getResolvedConfiguration()", ProperMethodUsage.RESOLVABLE);
        return this.resolutionAccess.getResults().getValue().getLegacyResults().getResolvedConfiguration();
    }

    private static Boolean isFullyResolved(Optional<ResolverResults> currentState) {
        return currentState.map(ResolverResults::isFullyResolved).orElse(false);
    }

    private ResolverResults resolveGraphIfRequired() {
        this.assertIsResolvable();
        this.maybeEmitResolutionDeprecation();
        Optional currentState = (Optional)this.currentResolveState.get();
        if (DefaultConfiguration.isFullyResolved(currentState).booleanValue()) {
            return (ResolverResults)currentState.get();
        }
        if (!this.domainObjectContext.getModel().hasMutableState()) {
            throw new IllegalResolutionException("Resolution of the " + this.displayName.getDisplayName() + " was attempted without an exclusive lock. This is unsafe and not allowed.");
        }
        ResolverResults newState = this.resolveExclusivelyIfRequired();
        return newState;
    }

    private ResolverResults resolveExclusivelyIfRequired() {
        return (ResolverResults)((Optional)this.currentResolveState.update(currentState -> {
            if (DefaultConfiguration.isFullyResolved(currentState).booleanValue()) {
                return currentState;
            }
            return Optional.of(this.resolveGraphInBuildOperation());
        })).get();
    }

    private ResolverResults resolveGraphInBuildOperation() {
        return (ResolverResults)this.configurationServices.getBuildOperationRunner().call((CallableBuildOperation)new CallableBuildOperation<ResolverResults>(){

            public ResolverResults call(BuildOperationContext context) {
                ResolverResults results;
                DefaultConfiguration.this.runDependencyActions();
                ((DependencyResolutionListener)DefaultConfiguration.this.dependencyResolutionListeners.getSource()).beforeResolve(DefaultConfiguration.this.getIncoming());
                try {
                    results = DefaultConfiguration.this.resolver.resolveGraph(DefaultConfiguration.this);
                }
                catch (Exception e) {
                    throw DefaultConfiguration.this.configurationServices.getExceptionMapper().mapFailure(e, "dependencies", DefaultConfiguration.this.displayName.getDisplayName());
                }
                DefaultConfiguration.this.currentResolveState.set(Optional.of(results));
                ((DependencyResolutionListener)DefaultConfiguration.this.dependencyResolutionListeners.getSource()).afterResolve(DefaultConfiguration.this.getIncoming());
                DefaultConfiguration.this.dependencyResolutionListeners.removeAll();
                if (DefaultConfiguration.this.resolutionStrategy != null) {
                    DefaultConfiguration.this.resolutionStrategy.maybeDiscardStateRequiredForGraphResolution();
                }
                this.captureBuildOperationResult(context, results);
                return results;
            }

            private void captureBuildOperationResult(BuildOperationContext context, ResolverResults results) {
                MinimalResolutionResult resolutionResult = results.getVisitedGraph().getResolutionResult();
                context.setResult((Object)new ResolveConfigurationResolutionBuildOperationResult(resolutionResult.getRootSource(), resolutionResult.getRequestedAttributes(), DefaultConfiguration.this.configurationServices.getAttributesFactory()));
            }

            public BuildOperationDescriptor.Builder description() {
                String displayName = "Resolve dependencies of " + DefaultConfiguration.this.identityPath;
                ProjectIdentity projectId = DefaultConfiguration.this.domainObjectContext.getProjectIdentity();
                String projectPathString = null;
                if (!DefaultConfiguration.this.domainObjectContext.isScript() && projectId != null) {
                    projectPathString = projectId.getProjectPath().asString();
                }
                return BuildOperationDescriptor.displayName((String)displayName).progressDisplayName(displayName).details((Object)new ResolveConfigurationResolutionBuildOperationDetails(DefaultConfiguration.this.getName(), DefaultConfiguration.this.domainObjectContext.isScript(), DefaultConfiguration.this.getDescription(), DefaultConfiguration.this.domainObjectContext.getBuildPath().asString(), projectPathString, DefaultConfiguration.this.visible, DefaultConfiguration.this.isTransitive(), DefaultConfiguration.this.resolver.getAllRepositories()));
            }
        });
    }

    @Override
    public ConfigurationInternal getConsistentResolutionSource() {
        this.warnOrFailOnInvalidInternalAPIUsage("getConsistentResolutionSource()", ProperMethodUsage.RESOLVABLE);
        return this.consistentResolutionSource;
    }

    @Override
    public ImmutableList<ResolutionParameters.ModuleVersionLock> getConsistentResolutionVersionLocks() {
        if (this.consistentResolutionSource == null) {
            return ImmutableList.of();
        }
        this.assertThatConsistentResolutionIsPropertyConfigured();
        ResolvedComponentResult root = this.consistentResolutionSource.getIncoming().getResolutionResult().getRoot();
        ImmutableList.Builder locks = ImmutableList.builder();
        DefaultResolvedComponentResult.eachElement(root, (Action<? super ResolvedComponentResult>)((Action)component -> {
            if (component.getId() instanceof ModuleComponentIdentifier) {
                ModuleComponentIdentifier moduleId = (ModuleComponentIdentifier)component.getId();
                locks.add((Object)new ResolutionParameters.ModuleVersionLock(moduleId.getModuleIdentifier(), moduleId.getVersion(), this.consistentResolutionReason, true));
            }
        }), (Action<? super DependencyResult>)Actions.doNothing(), new HashSet<ResolvedComponentResult>());
        return locks.build();
    }

    private void assertThatConsistentResolutionIsPropertyConfigured() {
        if (!this.consistentResolutionSource.isCanBeResolved()) {
            throw new InvalidUserCodeException("You can't use " + this.consistentResolutionSource + " as a consistent resolution source for " + this + " because it isn't a resolvable configuration.");
        }
        LinkedHashSet<DefaultConfiguration> sources = new LinkedHashSet<DefaultConfiguration>();
        for (ConfigurationInternal src = this; src != null; src = src.getConsistentResolutionSource()) {
            if (sources.add((DefaultConfiguration)src)) continue;
            String cycle = sources.stream().map(Named::getName).collect(Collectors.joining(" -> ")) + " -> " + this.getName();
            throw new InvalidUserDataException("Cycle detected in consistent resolution sources: " + cycle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T callAndResetResolutionState(Factory<T> factory) {
        this.warnOrFailOnInvalidInternalAPIUsage("callAndResetResolutionState(Factory)", ProperMethodUsage.RESOLVABLE);
        try {
            this.getResolutionStrategy().setKeepStateRequiredForGraphResolution(true);
            Object value = factory.create();
            this.currentResolveState.set(Optional.empty());
            Object object = value;
            return (T)object;
        }
        finally {
            this.getResolutionStrategy().setKeepStateRequiredForGraphResolution(false);
        }
    }

    private ResolverResults resolveGraphForBuildDependenciesIfRequired() {
        this.assertIsResolvable();
        return (ResolverResults)((Optional)this.currentResolveState.update(initial -> {
            if (!initial.isPresent()) {
                CalculatedValueContainer futureCompleteResults = this.configurationServices.getCalculatedValueContainerFactory().create(Describables.of((Object)"Full results for", (Object)this.getName()), context -> {
                    Optional currentState = (Optional)this.currentResolveState.get();
                    if (!DefaultConfiguration.isFullyResolved(currentState).booleanValue()) {
                        return this.resolveExclusivelyIfRequired();
                    }
                    return (ResolverResults)currentState.get();
                });
                try {
                    return Optional.of(this.resolver.resolveBuildDependencies(this, (CalculatedValue<ResolverResults>)futureCompleteResults));
                }
                catch (Exception e) {
                    throw this.configurationServices.getExceptionMapper().mapFailure(e, "dependencies", this.displayName.getDisplayName());
                }
            }
            return initial;
        })).get();
    }

    public void visitDependencies(TaskDependencyResolveContext context) {
        context.add((Object)this.getIntrinsicFiles());
    }

    public TaskDependency getTaskDependencyFromProjectDependency(boolean useDependedOn, String taskName) {
        if (useDependedOn) {
            return new TasksFromProjectDependencies(taskName, () -> this.getAllDependencies().withType(ProjectDependency.class), this.taskDependencyFactory, this.configurationServices.getProjectStateRegistry());
        }
        return new TasksFromDependentProjects(taskName, this.getName(), this.taskDependencyFactory);
    }

    public DependencySet getDependencies() {
        return this.dependencies;
    }

    public DependencySet getAllDependencies() {
        if (this.allDependencies == null) {
            this.initAllDependencies();
        }
        return this.allDependencies;
    }

    private synchronized void initAllDependencies() {
        if (this.allDependencies != null) {
            return;
        }
        this.inheritedDependencies = this.configurationServices.getDomainObjectCollectionFactory().newDomainObjectSet(Dependency.class, this.ownDependencies);
        for (Configuration configuration : this.extendsFrom) {
            this.inheritedDependencies.addCollection((DomainObjectCollection)configuration.getAllDependencies());
        }
        this.allDependencies = new DefaultDependencySet((Describable)Describables.of((Object)this.displayName, (Object)"all dependencies"), this, (DomainObjectSet<Dependency>)this.inheritedDependencies);
    }

    public DependencyConstraintSet getDependencyConstraints() {
        return this.dependencyConstraints;
    }

    public DependencyConstraintSet getAllDependencyConstraints() {
        if (this.allDependencyConstraints == null) {
            this.initAllDependencyConstraints();
        }
        return this.allDependencyConstraints;
    }

    private synchronized void initAllDependencyConstraints() {
        if (this.allDependencyConstraints != null) {
            return;
        }
        this.inheritedDependencyConstraints = this.configurationServices.getDomainObjectCollectionFactory().newDomainObjectSet(DependencyConstraint.class, this.ownDependencyConstraints);
        for (Configuration configuration : this.extendsFrom) {
            this.inheritedDependencyConstraints.addCollection((DomainObjectCollection)configuration.getAllDependencyConstraints());
        }
        this.allDependencyConstraints = new DefaultDependencyConstraintSet((Describable)Describables.of((Object)this.displayName, (Object)"all dependency constraints"), this, (DomainObjectSet<DependencyConstraint>)this.inheritedDependencyConstraints);
    }

    public PublishArtifactSet getArtifacts() {
        return this.artifacts;
    }

    public PublishArtifactSet getAllArtifacts() {
        this.initAllArtifacts();
        return this.allArtifacts;
    }

    private synchronized void initAllArtifacts() {
        if (this.allArtifacts != null) {
            return;
        }
        DisplayName displayName = Describables.of((Object)this.displayName, (Object)"all artifacts");
        if (this.isObserved() && this.extendsFrom.isEmpty()) {
            this.allArtifacts = new DefaultPublishArtifactSet((Describable)displayName, (DomainObjectSet<PublishArtifact>)this.ownArtifacts, this.configurationServices.getFileCollectionFactory(), this.taskDependencyFactory);
            return;
        }
        if (!this.isObserved()) {
            this.inheritedArtifacts = this.configurationServices.getDomainObjectCollectionFactory().newDomainObjectSet(PublishArtifact.class, this.ownArtifacts);
        }
        for (Configuration configuration : this.extendsFrom) {
            PublishArtifactSet allArtifacts = configuration.getAllArtifacts();
            if (this.inheritedArtifacts == null && allArtifacts.isEmpty()) continue;
            if (this.inheritedArtifacts == null) {
                this.inheritedArtifacts = this.configurationServices.getDomainObjectCollectionFactory().newDomainObjectSet(PublishArtifact.class, this.ownArtifacts);
            }
            this.inheritedArtifacts.addCollection((DomainObjectCollection)allArtifacts);
        }
        this.allArtifacts = this.inheritedArtifacts != null ? new DefaultPublishArtifactSet((Describable)displayName, (DomainObjectSet<PublishArtifact>)this.inheritedArtifacts, this.configurationServices.getFileCollectionFactory(), this.taskDependencyFactory) : new DefaultPublishArtifactSet((Describable)displayName, (DomainObjectSet<PublishArtifact>)this.ownArtifacts, this.configurationServices.getFileCollectionFactory(), this.taskDependencyFactory);
    }

    public Set<ExcludeRule> getExcludeRules() {
        this.initExcludeRules();
        return Collections.unmodifiableSet(this.parsedExcludeRules);
    }

    @Override
    public Set<ExcludeRule> getAllExcludeRules() {
        LinkedHashSet<ExcludeRule> result = new LinkedHashSet<ExcludeRule>();
        result.addAll(this.getExcludeRules());
        for (Configuration config : this.extendsFrom) {
            result.addAll(((ConfigurationInternal)config).getAllExcludeRules());
        }
        return result;
    }

    private synchronized void initExcludeRules() {
        if (this.parsedExcludeRules == null) {
            NotationParser parser = ExcludeRuleNotationConverter.parser();
            this.parsedExcludeRules = new LinkedHashSet<ExcludeRule>();
            for (Object excludeRule : this.excludeRules) {
                this.parsedExcludeRules.add((ExcludeRule)parser.parseNotation(excludeRule));
            }
        }
    }

    public DefaultConfiguration exclude(Map<String, String> excludeRuleArgs) {
        this.validateMutation(MutationValidator.MutationType.DEPENDENCIES);
        this.parsedExcludeRules = null;
        this.excludeRules.add(excludeRuleArgs);
        return this;
    }

    @Override
    public String getDisplayName() {
        return this.displayName.getDisplayName();
    }

    @Override
    public DisplayName asDescribable() {
        return this.displayName;
    }

    public ResolvableDependencies getIncoming() {
        return this.resolvableDependencies;
    }

    public ConfigurationPublications getOutgoing() {
        return this.outgoing;
    }

    @Override
    public void collectVariants(ConfigurationInternal.VariantVisitor visitor) {
        this.outgoing.collectVariants(visitor);
    }

    @Override
    public boolean isCanBeMutated() {
        boolean immutable = this.isObserved() || ((Optional)this.currentResolveState.get()).isPresent();
        return !immutable;
    }

    @Override
    public void markAsObserved(String reason) {
        if (this.isObserved()) {
            return;
        }
        this.runActionInHierarchy((Action<DefaultConfiguration>)((Action)conf -> {
            if (!conf.isObserved()) {
                conf.observationReason = () -> {
                    String target = conf == this ? "the configuration" : "the configuration's child " + this.getDisplayName();
                    return target + " was " + reason;
                };
                conf.observedState = ConfigurationInternal.InternalState.OBSERVED;
                conf.configurationAttributes.freeze();
                conf.outgoing.preventFromFurtherMutation(conf.observationReason);
                conf.preventUsageMutation();
            }
        }));
    }

    @Override
    public void markDependenciesObserved() {
        if (!this.isObserved()) {
            throw new IllegalStateException("Cannot observe dependencies before markAsObserved(String) has been called.");
        }
        this.dependenciesObserved = true;
    }

    private boolean isObserved() {
        return this.observationReason != null;
    }

    private void runActionInHierarchy(Action<DefaultConfiguration> action) {
        HashSet<Configuration> seen = new HashSet<Configuration>();
        ArrayDeque<Configuration> remaining = new ArrayDeque<Configuration>();
        remaining.add(this);
        while (!remaining.isEmpty()) {
            Configuration current = (Configuration)remaining.remove();
            action.execute((Object)((DefaultConfiguration)current));
            for (Configuration parent : current.getExtendsFrom()) {
                if (!seen.add(parent)) continue;
                remaining.add(parent);
            }
        }
    }

    public void outgoing(Action<? super ConfigurationPublications> action) {
        action.execute((Object)this.outgoing);
    }

    public ConfigurationInternal copy() {
        this.warnOrFailOnInvalidUsage("copy()", ProperMethodUsage.RESOLVABLE);
        return this.createCopy((Set<Dependency>)this.getDependencies(), (Set<DependencyConstraint>)this.getDependencyConstraints());
    }

    public Configuration copyRecursive() {
        this.warnOrFailOnInvalidUsage("copyRecursive()", ProperMethodUsage.RESOLVABLE);
        return this.createCopy((Set<Dependency>)this.getAllDependencies(), (Set<DependencyConstraint>)this.getAllDependencyConstraints());
    }

    public Configuration copy(Spec<? super Dependency> dependencySpec) {
        this.warnOrFailOnInvalidUsage("copy(Spec)", ProperMethodUsage.RESOLVABLE);
        return this.createCopy(CollectionUtils.filter((Set)this.getDependencies(), dependencySpec), (Set<DependencyConstraint>)this.getDependencyConstraints());
    }

    public Configuration copyRecursive(Spec<? super Dependency> dependencySpec) {
        this.warnOrFailOnInvalidUsage("copyRecursive(Spec)", ProperMethodUsage.RESOLVABLE);
        return this.createCopy(CollectionUtils.filter((Set)this.getAllDependencies(), dependencySpec), (Set<DependencyConstraint>)this.getAllDependencyConstraints());
    }

    private DefaultConfiguration createCopy(Set<Dependency> dependencies, Set<DependencyConstraint> dependencyConstraints) {
        DefaultConfiguration copiedConfiguration = this.copyAsDetached();
        copiedConfiguration.visible = this.visible;
        copiedConfiguration.transitive = this.transitive;
        copiedConfiguration.description = this.description;
        copiedConfiguration.defaultDependencyActions = this.defaultDependencyActions;
        copiedConfiguration.withDependencyActions = this.withDependencyActions;
        copiedConfiguration.dependencyResolutionListeners = this.dependencyResolutionListeners.copy();
        copiedConfiguration.declarationAlternatives = this.declarationAlternatives;
        copiedConfiguration.resolutionAlternatives = this.resolutionAlternatives;
        copiedConfiguration.getArtifacts().addAll((Collection)this.getAllArtifacts());
        if (!this.configurationAttributes.isEmpty()) {
            for (Attribute attribute : this.configurationAttributes.keySet()) {
                Object value = this.configurationAttributes.getAttribute(attribute);
                copiedConfiguration.getAttributes().attribute((Attribute)Cast.uncheckedNonnullCast((Object)attribute), value);
            }
        }
        for (ExcludeRule excludeRule : this.getAllExcludeRules()) {
            copiedConfiguration.excludeRules.add(new DefaultExcludeRule(excludeRule.getGroup(), excludeRule.getModule()));
        }
        DependencySet copiedDependencies = copiedConfiguration.getDependencies();
        for (Dependency dependency : dependencies) {
            copiedDependencies.add((Object)dependency.copy());
        }
        DependencyConstraintSet dependencyConstraintSet = copiedConfiguration.getDependencyConstraints();
        for (DependencyConstraint dependencyConstraint : dependencyConstraints) {
            dependencyConstraintSet.add((Object)((DependencyConstraintInternal)dependencyConstraint).copy());
        }
        return copiedConfiguration;
    }

    private DefaultConfiguration copyAsDetached() {
        String newName = this.getNameWithCopySuffix();
        Factory childResolutionStrategy = this.resolutionStrategy != null ? Factories.constant((Object)this.resolutionStrategy.copy()) : this.resolutionStrategyFactory;
        ConfigurationRole role = ConfigurationRoles.RESOLVABLE_DEPENDENCY_SCOPE;
        return this.defaultConfigurationFactory.create(newName, true, this.resolver, (Factory<ResolutionStrategyInternal>)childResolutionStrategy, role);
    }

    private String getNameWithCopySuffix() {
        int count = this.copyCount.incrementAndGet();
        String copyName = this.name + "Copy";
        return count == 1 ? copyName : copyName + count;
    }

    public Configuration copy(Closure dependencySpec) {
        return this.copy((Spec<? super Dependency>)Specs.convertClosureToSpec((Closure)dependencySpec));
    }

    public Configuration copyRecursive(Closure dependencySpec) {
        return this.copyRecursive((Spec<? super Dependency>)Specs.convertClosureToSpec((Closure)dependencySpec));
    }

    @Override
    public ResolutionStrategyInternal getResolutionStrategy() {
        if (this.resolutionStrategy == null) {
            this.resolutionStrategy = (ResolutionStrategyInternal)this.resolutionStrategyFactory.create();
            this.resolutionStrategy.setMutationValidator(this);
            this.resolutionStrategyFactory = null;
        }
        return this.resolutionStrategy;
    }

    @Override
    public DomainObjectContext getDomainObjectContext() {
        return this.domainObjectContext;
    }

    public Configuration resolutionStrategy(Closure closure) {
        ConfigureUtil.configure((Closure)closure, (Object)this.getResolutionStrategy());
        return this;
    }

    public Configuration resolutionStrategy(Action<? super ResolutionStrategy> action) {
        action.execute((Object)this.getResolutionStrategy());
        return this;
    }

    @Override
    public void validateMutation(MutationValidator.MutationType type) {
        if (this.isMutationForbidden(type)) {
            throw new InvalidUserCodeException(String.format("Cannot mutate the %s of %s after %s. ", new Object[]{type, this.getDisplayName(), this.observationReason.get()}) + "After a configuration has been observed, it should not be modified.");
        }
        if (type == MutationValidator.MutationType.USAGE) {
            this.assertUsageIsMutable();
        }
    }

    private boolean isMutationForbidden(MutationValidator.MutationType type) {
        if (this.observationReason == null) {
            return false;
        }
        if (type == MutationValidator.MutationType.STRATEGY && !DefaultConfiguration.isFullyResolved((Optional)this.currentResolveState.get()).booleanValue()) {
            return false;
        }
        if (type == MutationValidator.MutationType.DEPENDENCIES || type == MutationValidator.MutationType.DEPENDENCY_ATTRIBUTES || type == MutationValidator.MutationType.DEPENDENCY_CONSTRAINT_ATTRIBUTES) {
            return this.dependenciesObserved;
        }
        return true;
    }

    @Override
    public ConfigurationIdentity getConfigurationIdentity() {
        String name = this.getName();
        ProjectIdentity projectId = this.domainObjectContext.getProjectIdentity();
        String projectPath = projectId == null ? null : projectId.getProjectPath().asString();
        String buildPath = this.domainObjectContext.getBuildPath().toString();
        return new DefaultConfigurationIdentity(buildPath, projectPath, name);
    }

    private boolean isProperUsage(ProperMethodUsage ... properUsages) {
        DefaultConfiguration conf = this;
        return Arrays.stream(properUsages).anyMatch(pu -> pu.isAllowed(conf));
    }

    private boolean isExclusivelyDeprecatedUsage(ProperMethodUsage ... properUsages) {
        DefaultConfiguration conf = this;
        return Arrays.stream(properUsages).filter(pu -> pu.isAllowed(conf)).allMatch(pu -> pu.isDeprecated(conf));
    }

    private void warnOrFailOnInvalidInternalAPIUsage(String methodName, ProperMethodUsage ... properUsages) {
        this.warnOrFailOnInvalidUsage(methodName, true, properUsages);
    }

    private void warnOrFailOnInvalidUsage(String methodName, ProperMethodUsage ... properUsages) {
        this.warnOrFailOnInvalidUsage(methodName, false, properUsages);
    }

    private void warnOrFailOnInvalidUsage(String methodName, boolean allowDeprecated, ProperMethodUsage ... properUsages) {
        if (!this.isProperUsage(properUsages)) {
            String currentUsageDesc = UsageDescriber.describeCurrentUsage((DeprecatableConfiguration)this);
            String properUsageDesc = ProperMethodUsage.summarizeProperUsage(properUsages);
            String msgTemplate = "Calling configuration method '%s' is not allowed for configuration '%s', which has permitted usage(s):\n%s\nThis method is only meant to be called on configurations which allow the %susage(s): '%s'.";
            GradleException ex = new GradleException(String.format(msgTemplate, methodName, this.getName(), currentUsageDesc, allowDeprecated ? "" : "(non-deprecated) ", properUsageDesc));
            ProblemId id = ProblemId.create((String)"method-not-allowed", (String)"Method call not allowed", (ProblemGroup)GradleCoreProblemGroup.configurationUsage());
            throw this.configurationServices.getProblems().getInternalReporter().throwing((Throwable)ex, id, spec -> {
                spec.contextualLabel(ex.getMessage());
                spec.severity(Severity.ERROR);
            });
        }
        if (this.isExclusivelyDeprecatedUsage(properUsages)) {
            ((DeprecationMessageBuilder.WithDocumentation)((DeprecationMessageBuilder.DeprecateAction)DeprecationLogger.deprecateAction((String)String.format("Calling %s on %s", methodName, this)).withContext("This configuration does not allow this method to be called.")).willBecomeAnErrorInGradle10().withUpgradeGuideSection(8, "configurations_allowed_usage")).nagUser();
        }
    }

    private void assertIsResolvable() {
        if (!this.canBeResolved) {
            throw new IllegalStateException("Resolving dependency configuration '" + this.name + "' is not allowed as it is defined as 'canBeResolved=false'.\nInstead, a resolvable ('canBeResolved=true') dependency configuration that extends '" + this.name + "' should be resolved.");
        }
    }

    protected void assertCanCarryBuildDependencies() {
        this.assertIsResolvable();
    }

    @Override
    public AttributeContainerInternal getAttributes() {
        return this.configurationAttributes;
    }

    public Configuration attributes(Action<? super AttributeContainer> action) {
        this.warnOrFailOnInvalidUsage("attributes(Action)", ProperMethodUsage.CONSUMABLE, ProperMethodUsage.RESOLVABLE);
        action.execute((Object)this.configurationAttributes);
        return this;
    }

    public void preventUsageMutation() {
        this.usageCanBeMutated = false;
    }

    private void assertUsageIsMutable() {
        if (!this.usageCanBeMutated) {
            if (this.roleAtCreation != ConfigurationRoles.ALL) {
                throw new GradleException(String.format("Cannot change the allowed usage of %s, as it was locked upon creation to the role: '%s'.\nThis role permits the following usage:\n%s\nIdeally, each configuration should be used for a single purpose.", this.getDisplayName(), this.roleAtCreation.getName(), this.roleAtCreation.describeUsage()));
            }
            throw new GradleException(String.format("Cannot change the allowed usage of %s, as it has been locked.", this.getDisplayName()));
        }
    }

    private void checkChangingUsage(String methodName, boolean current, boolean newValue) {
        boolean redundantChange;
        if (this.hasAllUsages()) {
            return;
        }
        boolean bl = redundantChange = current == newValue;
        if (!this.usageCanBeMutated && !redundantChange) {
            return;
        }
        boolean extraWarningsEnabled = Boolean.getBoolean("org.gradle.internal.deprecation.preliminary.Configuration.redundantUsageChangeWarning.enabled");
        if (redundantChange) {
            if (extraWarningsEnabled) {
                this.warnAboutChangingUsage(methodName, newValue);
            }
        } else if (this.isDetachedConfiguration() && !newValue) {
            if (extraWarningsEnabled) {
                this.warnAboutChangingUsage(methodName, newValue);
            }
        } else {
            this.failDueToChangingUsage(methodName, newValue);
        }
    }

    private void warnAboutChangingUsage(String methodName, boolean newValue) {
        ((DeprecationMessageBuilder.WithDocumentation)((DeprecationMessageBuilder.DeprecateAction)DeprecationLogger.deprecateAction((String)String.format("Calling %s(%b) on %s", methodName, newValue, this)).withContext("This configuration's role was set upon creation and its usage should not be changed.")).willBecomeAnErrorInGradle10().withUpgradeGuideSection(8, "configurations_allowed_usage")).nagUser();
    }

    private void failDueToChangingUsage(String methodName, boolean newValue) {
        GradleException ex = new GradleException(String.format("Calling %s(%b) on %s is not allowed.  This configuration's role was set upon creation and its usage should not be changed.", methodName, newValue, this));
        ProblemId id = ProblemId.create((String)"method-not-allowed", (String)"Method call not allowed", (ProblemGroup)GradleCoreProblemGroup.configurationUsage());
        throw this.configurationServices.getProblems().getInternalReporter().throwing((Throwable)ex, id, spec -> {
            spec.contextualLabel(ex.getMessage());
            spec.severity(Severity.ERROR);
        });
    }

    @Override
    public boolean isDetachedConfiguration() {
        return this.isDetached;
    }

    private boolean hasAllUsages() {
        return this.roleAtCreation == ConfigurationRoles.ALL;
    }

    public boolean isDeprecatedForConsumption() {
        return this.consumptionDeprecated;
    }

    public boolean isDeprecatedForResolution() {
        return this.resolutionDeprecated;
    }

    public boolean isDeprecatedForDeclarationAgainst() {
        return this.declarationDeprecated;
    }

    public boolean isCanBeConsumed() {
        return this.canBeConsumed;
    }

    public void setCanBeConsumed(boolean allowed) {
        this.checkChangingUsage("setCanBeConsumed", this.canBeConsumed, allowed);
        if (this.canBeConsumed != allowed) {
            this.validateMutation(MutationValidator.MutationType.USAGE);
            this.canBeConsumed = allowed;
        }
    }

    public boolean isCanBeResolved() {
        return this.canBeResolved;
    }

    public void setCanBeResolved(boolean allowed) {
        this.checkChangingUsage("setCanBeResolved", this.canBeResolved, allowed);
        if (this.canBeResolved != allowed) {
            this.validateMutation(MutationValidator.MutationType.USAGE);
            this.canBeResolved = allowed;
        }
    }

    public boolean isCanBeDeclared() {
        return this.canBeDeclaredAgainst;
    }

    public void setCanBeDeclared(boolean allowed) {
        this.checkChangingUsage("setCanBeDeclared", this.canBeDeclaredAgainst, allowed);
        if (this.canBeDeclaredAgainst != allowed) {
            this.validateMutation(MutationValidator.MutationType.USAGE);
            this.canBeDeclaredAgainst = allowed;
        }
    }

    @VisibleForTesting
    ListenerBroadcast<DependencyResolutionListener> getDependencyResolutionListeners() {
        return this.dependencyResolutionListeners;
    }

    public List<String> getDeclarationAlternatives() {
        return this.declarationAlternatives;
    }

    public List<String> getResolutionAlternatives() {
        return this.resolutionAlternatives;
    }

    public void addDeclarationAlternatives(String ... alternativesForDeclaring) {
        this.declarationAlternatives = ImmutableList.builder().addAll(this.declarationAlternatives).addAll(Arrays.asList(alternativesForDeclaring)).build();
    }

    public void addResolutionAlternatives(String ... alternativesForResolving) {
        this.resolutionAlternatives = ImmutableList.builder().addAll(this.resolutionAlternatives).addAll(Arrays.asList(alternativesForResolving)).build();
    }

    public Configuration shouldResolveConsistentlyWith(Configuration versionsSource) {
        this.warnOrFailOnInvalidUsage("shouldResolveConsistentlyWith(Configuration)", ProperMethodUsage.RESOLVABLE);
        this.consistentResolutionSource = (ConfigurationInternal)versionsSource;
        this.consistentResolutionReason = "version resolved in " + versionsSource + " by consistent resolution";
        return this;
    }

    public Configuration disableConsistentResolution() {
        this.warnOrFailOnInvalidUsage("disableConsistentResolution()", ProperMethodUsage.RESOLVABLE);
        this.consistentResolutionSource = null;
        this.consistentResolutionReason = null;
        return this;
    }

    @Override
    public ConfigurationRole getRoleAtCreation() {
        return this.roleAtCreation;
    }

    public InternalProblems getProblems() {
        return this.configurationServices.getProblems();
    }

    private void assertNotDetachedExtensionDoingExtending(Iterable<Configuration> extendsFrom) {
        if (this.isDetachedConfiguration()) {
            String summarizedExtensionTargets = StreamSupport.stream(extendsFrom.spliterator(), false).map(ConfigurationInternal.class::cast).map(ConfigurationInternal::getDisplayName).collect(Collectors.joining(", "));
            GradleException ex = new GradleException(this.getDisplayName() + " cannot extend " + summarizedExtensionTargets);
            ProblemId id = ProblemId.create((String)"extend-detached-not-allowed", (String)"Extending a detachedConfiguration is not allowed", (ProblemGroup)GradleCoreProblemGroup.configurationUsage());
            throw this.configurationServices.getProblems().getInternalReporter().throwing((Throwable)ex, id, spec -> {
                spec.contextualLabel(ex.getMessage());
                spec.severity(Severity.ERROR);
            });
        }
    }

    @Override
    public ResolutionHost getResolutionHost() {
        return this.resolutionAccess.getHost();
    }

    private static class ConfigurationDescription
    implements Describable {
        private final Path identityPath;

        ConfigurationDescription(Path identityPath) {
            this.identityPath = identityPath;
        }

        public String getDisplayName() {
            return "configuration '" + this.identityPath + "'";
        }
    }

    private class ConfigurationResolutionAccess
    implements ResolutionAccess {
        private ConfigurationResolutionAccess() {
        }

        @Override
        public ResolutionHost getHost() {
            return new DefaultResolutionHost(DefaultConfiguration.this.identityPath, DefaultConfiguration.this.displayName, DefaultConfiguration.this.configurationServices.getProblems(), DefaultConfiguration.this.configurationServices.getExceptionMapper());
        }

        @Override
        public ImmutableAttributes getAttributes() {
            DefaultConfiguration.this.configurationAttributes.freeze();
            return DefaultConfiguration.this.configurationAttributes.asImmutable();
        }

        @Override
        public ResolutionStrategy.SortOrder getDefaultSortOrder() {
            return DefaultConfiguration.this.getResolutionStrategy().getSortOrder();
        }

        @Override
        public ResolutionResultProvider<ResolverResults> getResults() {
            return new ResolverResultsResolutionResultProvider();
        }

        @Override
        public ResolutionOutputsInternal getPublicView() {
            return new DefaultResolutionOutputs(this, DefaultConfiguration.this.taskDependencyFactory, DefaultConfiguration.this.configurationServices.getCalculatedValueContainerFactory(), DefaultConfiguration.this.configurationServices.getAttributesFactory(), DefaultConfiguration.this.configurationServices.getAttributeDesugaring(), DefaultConfiguration.this.configurationServices.getObjectFactory());
        }
    }

    public static class ConfigurationResolvableDependencies
    implements ResolvableDependencies {
        private final DefaultConfiguration configuration;

        @Inject
        public ConfigurationResolvableDependencies(DefaultConfiguration configuration) {
            this.configuration = configuration;
        }

        public String getName() {
            return this.configuration.name;
        }

        public String getPath() {
            return this.configuration.projectPath.asString();
        }

        public String toString() {
            return "dependencies '" + this.configuration.identityPath + "'";
        }

        public FileCollection getFiles() {
            return this.configuration.getIntrinsicFiles();
        }

        public DependencySet getDependencies() {
            this.configuration.runDependencyActions();
            return this.configuration.getAllDependencies();
        }

        public DependencyConstraintSet getDependencyConstraints() {
            this.configuration.runDependencyActions();
            return this.configuration.getAllDependencyConstraints();
        }

        public void beforeResolve(Action<? super ResolvableDependencies> action) {
            this.configuration.dependencyResolutionListeners.add("beforeResolve", this.configuration.userCodeApplicationContext.reapplyCurrentLater(action));
        }

        public void beforeResolve(Closure action) {
            this.beforeResolve((Action<? super ResolvableDependencies>)ConfigureUtil.configureUsing((Closure)action));
        }

        public void afterResolve(Action<? super ResolvableDependencies> action) {
            this.configuration.dependencyResolutionListeners.add("afterResolve", this.configuration.userCodeApplicationContext.reapplyCurrentLater(action));
        }

        public void afterResolve(Closure action) {
            this.afterResolve((Action<? super ResolvableDependencies>)ConfigureUtil.configureUsing((Closure)action));
        }

        public ResolutionResult getResolutionResult() {
            this.configuration.assertIsResolvable();
            return new DefaultResolutionResult(this.configuration.resolutionAccess, this.configuration.configurationServices.getAttributeDesugaring());
        }

        public ArtifactCollection getArtifacts() {
            return this.configuration.resolutionAccess.getPublicView().getArtifacts();
        }

        public ArtifactView artifactView(Action<? super ArtifactView.ViewConfiguration> configAction) {
            return this.configuration.resolutionAccess.getPublicView().artifactView(configAction);
        }

        public AttributeContainer getAttributes() {
            return this.configuration.configurationAttributes;
        }
    }

    private class AllArtifactsProvider
    implements PublishArtifactSetProvider {
        private AllArtifactsProvider() {
        }

        @Override
        public PublishArtifactSet getPublishArtifactSet() {
            return DefaultConfiguration.this.getAllArtifacts();
        }
    }

    private static enum ProperMethodUsage {
        CONSUMABLE{

            @Override
            boolean isAllowed(ConfigurationInternal configuration) {
                return configuration.isCanBeConsumed();
            }

            @Override
            boolean isDeprecated(ConfigurationInternal configuration) {
                return configuration.isDeprecatedForConsumption();
            }
        }
        ,
        RESOLVABLE{

            @Override
            boolean isAllowed(ConfigurationInternal configuration) {
                return configuration.isCanBeResolved();
            }

            @Override
            boolean isDeprecated(ConfigurationInternal configuration) {
                return configuration.isDeprecatedForResolution();
            }
        }
        ,
        DECLARABLE_AGAINST{

            @Override
            boolean isAllowed(ConfigurationInternal configuration) {
                return configuration.isCanBeDeclared();
            }

            @Override
            boolean isDeprecated(ConfigurationInternal configuration) {
                return configuration.isDeprecatedForDeclarationAgainst();
            }
        };


        abstract boolean isAllowed(ConfigurationInternal var1);

        abstract boolean isDeprecated(ConfigurationInternal var1);

        public static String buildProperName(ProperMethodUsage usage) {
            String capitalizedName = WordUtils.capitalizeFully((String)usage.name().replace('_', ' '));
            return capitalizedName;
        }

        public static String summarizeProperUsage(ProperMethodUsage ... properUsages) {
            return Arrays.stream(properUsages).map(ProperMethodUsage::buildProperName).collect(Collectors.joining(", "));
        }
    }

    private static final class IllegalResolutionException
    extends GradleException
    implements ResolutionProvider {
        private final String resolution;

        public IllegalResolutionException(String message) {
            super(message);
            Documentation userGuideLink = Documentation.userManual((String)"viewing_debugging_dependencies", (String)"sub:resolving-unsafe-configuration-resolution-errors");
            this.resolution = "For more information, please refer to " + userGuideLink.getUrl() + " in the Gradle documentation.";
        }

        public List<String> getResolutions() {
            return Collections.singletonList(this.resolution);
        }
    }

    private static class DefaultConfigurationIdentity
    implements ConfigurationIdentity {
        private final String buildPath;
        private final String projectPath;
        private final String name;

        public DefaultConfigurationIdentity(String buildPath, @Nullable String projectPath, String name) {
            this.buildPath = buildPath;
            this.projectPath = projectPath;
            this.name = name;
        }

        public String getBuildPath() {
            return this.buildPath;
        }

        public @Nullable String getProjectPath() {
            return this.projectPath;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            Path path = Path.path((String)this.buildPath);
            if (this.projectPath != null) {
                path = path.append(Path.path((String)this.projectPath));
            }
            path = path.child(this.name);
            return "Configuration '" + path.toString() + "'";
        }
    }

    private static class DefaultResolutionHost
    implements ResolutionHost {
        private final Path buildTreePath;
        private final DisplayName displayName;
        private final InternalProblems problems;
        private final ResolveExceptionMapper exceptionMapper;

        public DefaultResolutionHost(Path buildTreePath, DisplayName displayName, InternalProblems problems, ResolveExceptionMapper exceptionMapper) {
            this.buildTreePath = buildTreePath;
            this.displayName = displayName;
            this.problems = problems;
            this.exceptionMapper = exceptionMapper;
        }

        @Override
        public InternalProblems getProblems() {
            return this.problems;
        }

        @Override
        public DisplayName displayName() {
            return this.displayName;
        }

        @Override
        public Optional<TypedResolveException> consolidateFailures(String resolutionType, Collection<Throwable> failures) {
            return Optional.ofNullable(this.exceptionMapper.mapFailures(failures, resolutionType, this.displayName));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DefaultResolutionHost that = (DefaultResolutionHost)o;
            return this.buildTreePath.equals((Object)that.buildTreePath);
        }

        public int hashCode() {
            return this.buildTreePath.hashCode();
        }
    }

    private class ResolverResultsResolutionResultProvider
    implements ResolutionResultProvider<ResolverResults> {
        private ResolverResultsResolutionResultProvider() {
        }

        @Override
        public ResolverResults getTaskDependencyValue() {
            if (DefaultConfiguration.this.getResolutionStrategy().resolveGraphToDetermineTaskDependencies()) {
                return this.getValue();
            }
            return DefaultConfiguration.this.resolveGraphForBuildDependenciesIfRequired();
        }

        @Override
        public ResolverResults getValue() {
            return DefaultConfiguration.this.resolveGraphIfRequired();
        }
    }
}

