---
stage: Fulfillment
group: Provision
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: Seat assignment, GitLab Duo subscription add-on.
title: GitLab Duo trials
---

{{< details >}}

- Tier: Premium, Ultimate
- Offering: GitLab.com, GitLab Self-Managed, GitLab Dedicated

{{< /details >}}

To try GitLab Duo, you can get access for a limited time with a free trial.

During the trial period, you'll have access to the full feature set for whichever add-on you chose.
When the trial period is over, to maintain your access, you can purchase the add-on.

Trials of the GitLab Duo add-ons last 30 days.

## Start GitLab Duo Pro trial

Get a trial of GitLab Duo Pro to test the [GitLab Duo Pro features](../user/gitlab_duo/feature_summary.md)
for a limited time.

You can get a trial of GitLab Duo Pro if you have the Premium tier on GitLab.com, GitLab Self-Managed, or GitLab Dedicated.

### On GitLab.com

Prerequisites:

- You must have the Owner role for a top-level group that has an active paid Premium subscription. Indirect ownership through group membership is not sufficient.

To start a GitLab Duo Pro trial on GitLab.com:

1. On the left sidebar, select **Search or go to** and find your group. If you've [turned on the new navigation](../user/interface_redesign.md#turn-new-navigation-on-or-off), this field is on the top bar.
1. Select **Settings** > **Billing**.
1. Select **Start a free GitLab Duo Pro trial**.
1. Complete the fields.
1. Select **Continue**.
1. If prompted, select the group that the trial should be applied to.
1. Select **Activate my trial**.
1. [Assign seats](subscription-add-ons.md#assign-gitlab-duo-seats) to the users who need access.

### On GitLab Self-Managed

Prerequisites:

- You must have an active paid Premium subscription.
- You must have GitLab 16.8 or later and your instance must be able to [synchronize your subscription data](manage_subscription.md#subscription-data-synchronization) with GitLab.
- GitLab Duo requires GitLab 17.2 and later for the best user experience and results. Earlier versions might continue to work, however the experience may be degraded.

To start a GitLab Duo Pro trial on GitLab Self-Managed or GitLab Dedicated:

1. Go to the [GitLab Duo Pro trial page](https://about.gitlab.com/solutions/gitlab-duo-pro/sales/?toggle=gitlab-duo-pro).
1. Complete the fields.

   - To find your subscription name:
     1. In the Customers Portal, on the **Subscriptions & purchases** page, find the subscription you want to apply the trial to.
     1. At the top of the page, the subscription name appears in a badge.

        ![Subscription name](img/subscription_name_v17_0.png)
   - Ensure the email address you submit for trial registration matches the email address of the [subscription contact](billing_account.md#change-your-subscription-contact).
1. Select **Submit**.

The trial automatically synchronizes to your instance within 24 hours. After the trial has synchronized, [assign seats](subscription-add-ons.md#assign-gitlab-duo-seats) to users that you want to access GitLab Duo.

### On GitLab Dedicated

Reach out to your Sales contact if you are interested in a trial.

## Start GitLab Duo Enterprise trial

Get a trial of GitLab Duo Enterprise to test the [GitLab Duo Enterprise features](../user/gitlab_duo/feature_summary.md)
for a limited time.

You can get a trial of GitLab Duo Enterprise if:

- You have the Free tier on GitLab.com. In that case, you can try Ultimate tier with GitLab Duo Enterprise.
- You have the Premium or Ultimate tier on GitLab.com, GitLab Self-Managed, or GitLab Dedicated.

If you have the Free tier on GitLab Self-Managed, no trial is available.

### On GitLab.com

Prerequisites:

- You must have the Owner role for a top-level group that has an active paid Ultimate subscription.

To start a GitLab Duo Enterprise trial on GitLab.com:

1. On the left sidebar, select **Search or go to** and find your group. If you've [turned on the new navigation](../user/interface_redesign.md#turn-new-navigation-on-or-off), this field is on the top bar.
1. Select **Settings** > **Billing**.
1. Select **Start a free GitLab Duo Enterprise trial**.
1. Complete the fields.
1. Select **Continue**.
1. If prompted, select the group that the trial should be applied to.
1. Select **Activate my trial**.
1. [Assign seats](subscription-add-ons.md#assign-gitlab-duo-seats) to the users who need access.

### On GitLab Self-Managed

Prerequisites:

- You must have an active paid Ultimate subscription.
- You must have GitLab 17.3 or later and your instance must be able to [synchronize your subscription data](manage_subscription.md#subscription-data-synchronization) with GitLab.

To start a GitLab Duo Enterprise trial on GitLab Self-Managed or GitLab Dedicated:

1. Go to the [GitLab Duo Enterprise trial page](https://about.gitlab.com/solutions/gitlab-duo-pro/sales/?toggle=gitlab-duo-enterprise).
1. Complete the fields.

   - To find your subscription name:
     1. In the Customers Portal, on the **Subscriptions & purchases** page, find the subscription you want to apply the trial to.
     1. At the top of the page, the subscription name appears in a badge.

        ![Subscription name](img/subscription_name_v17_0.png)
   - Ensure the email address you submit for trial registration matches the email address of the [subscription contact](billing_account.md#change-your-subscription-contact).
1. Select **Submit**.

The trial automatically synchronizes to your instance within 24 hours. After the trial has synchronized, [assign seats](subscription-add-ons.md#assign-gitlab-duo-seats) to users that you want to access GitLab Duo.

### On GitLab Dedicated

Reach out to your Sales contact if you are interested in a trial.
