/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.jpeg;

import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.imaging.jpeg.JpegSegmentReader;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.MetadataReader;
import com.drew.metadata.jpeg.JpegComponent;
import com.drew.metadata.jpeg.JpegDirectory;
import java.io.File;
import java.io.InputStream;

public class JpegReader
implements MetadataReader {
    private final byte[] _data;

    public JpegReader(File jpegFile) throws JpegProcessingException {
        this(new JpegSegmentReader(jpegFile).readSegment((byte)-64));
    }

    public JpegReader(InputStream is) throws JpegProcessingException {
        this(new JpegSegmentReader(is).readSegment((byte)-19));
    }

    public JpegReader(byte[] data) {
        this._data = data;
    }

    @Override
    public Metadata extract() {
        return this.extract(new Metadata());
    }

    @Override
    public Metadata extract(Metadata metadata) {
        if (this._data == null) {
            return metadata;
        }
        JpegDirectory directory = (JpegDirectory)metadata.getDirectory(JpegDirectory.class);
        try {
            int dataPrecision = this.get16Bits(0);
            directory.setInt(0, dataPrecision);
            int height = this.get32Bits(1);
            directory.setInt(1, height);
            int width = this.get32Bits(3);
            directory.setInt(3, width);
            int numberOfComponents = this.get16Bits(5);
            directory.setInt(5, numberOfComponents);
            int offset = 6;
            int i = 0;
            while (i < numberOfComponents) {
                int componentId = this.get16Bits(offset++);
                int samplingFactorByte = this.get16Bits(offset++);
                int quantizationTableNumber = this.get16Bits(offset++);
                JpegComponent component = new JpegComponent(componentId, samplingFactorByte, quantizationTableNumber);
                directory.setObject(6 + i, component);
                ++i;
            }
        }
        catch (MetadataException me) {
            directory.addError("MetadataException: " + me);
        }
        return metadata;
    }

    private int get32Bits(int offset) throws MetadataException {
        if (offset + 1 >= this._data.length) {
            throw new MetadataException("Attempt to read bytes from outside Jpeg segment data buffer");
        }
        return (this._data[offset] & 0xFF) << 8 | this._data[offset + 1] & 0xFF;
    }

    private int get16Bits(int offset) throws MetadataException {
        if (offset >= this._data.length) {
            throw new MetadataException("Attempt to read bytes from outside Jpeg segment data buffer");
        }
        return this._data[offset] & 0xFF;
    }
}

