/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine.value;

import io.sf.carte.doc.style.css.CSSMathValue;
import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.property.Evaluator;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.CSSStylableElement;
import io.sf.carte.echosvg.css.engine.StyleMap;
import io.sf.carte.echosvg.css.engine.value.FloatValue;
import io.sf.carte.echosvg.css.engine.value.NumericValue;
import org.w3c.css.om.typed.CSSUnitValue;
import org.w3c.css.om.unit.CSSUnit;
import org.w3c.dom.DOMException;

public abstract class NumericDelegateValue<D extends CSSMathValue>
extends NumericValue {
    private static final long serialVersionUID = 1L;
    private D delegate;

    protected NumericDelegateValue(D expr) {
        this.delegate = expr;
    }

    public String getCssText() {
        return this.delegate.getCssText();
    }

    @Override
    short getCSSUnit() {
        return this.delegate.computeUnitType();
    }

    public D getNumericDelegate() {
        return this.delegate;
    }

    @Override
    public CSSValueSyntax.Match matches(CSSValueSyntax syntax) {
        return this.delegate.matches(syntax);
    }

    public FloatValue evaluate(final CSSStylableElement elt, final String pseudo, final CSSEngine engine, final int idx, final StyleMap sm, final short unit) throws DOMException {
        float f;
        short u;
        Evaluator eval = new Evaluator(unit){

            protected CSSTypedValue absoluteTypedValue(CSSTypedValue typed) {
                if (CSSUnit.isRelativeLengthUnitType((short)typed.getUnitType())) {
                    FloatValue relative = new FloatValue(typed.getUnitType(), typed.getFloatValue(typed.getUnitType()));
                    FloatValue abs = NumericDelegateValue.this.absoluteValue(elt, pseudo, engine, idx, sm, relative);
                    short u = abs.getUnitType() != 0 ? abs.getUnitType() : unit;
                    return NumberValue.createCSSNumberValue((short)u, (float)abs.getFloatValue());
                }
                return typed;
            }

            protected float percentage(CSSTypedValue typed, short resultType) throws DOMException {
                FloatValue relative = new FloatValue(typed.getUnitType(), typed.getFloatValue(typed.getUnitType()));
                FloatValue abs = NumericDelegateValue.this.absoluteValue(elt, pseudo, engine, idx, sm, relative);
                return NumberValue.floatValueConversion((float)abs.getFloatValue(), (short)abs.getUnitType(), (short)resultType);
            }
        };
        CSSTypedValue typed = this.evaluate(eval);
        if (typed.getPrimitiveType() != CSSValue.Type.NUMERIC) {
            throw new DOMException(11, "Unexpected calc() result: " + typed.getCssText());
        }
        if (typed.getUnitType() == 0) {
            u = 0;
            f = typed.getFloatValue((short)0);
        } else {
            u = unit;
            f = typed.getFloatValue(unit);
        }
        return new FloatValue(u, f);
    }

    protected abstract CSSTypedValue evaluate(Evaluator var1);

    protected FloatValue absoluteValue(CSSStylableElement elt, String pseudo, CSSEngine engine, int idx, StyleMap sm, FloatValue relative) throws DOMException {
        return relative;
    }

    public CSSUnitValue to(String unit) {
        throw new DOMException(9, "Not supported.");
    }

    @Override
    public NumericDelegateValue<D> clone() {
        NumericDelegateValue clon = (NumericDelegateValue)super.clone();
        clon.delegate = this.delegate;
        return clon;
    }
}

