/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.CSSVarValue;
import io.sf.carte.doc.style.css.nsac.CSSParseException;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.parser.CSSParser;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.ProxyValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.io.StringReader;
import org.w3c.dom.DOMException;

@Deprecated(forRemoval=true)
public class VarValue
extends ProxyValue
implements CSSVarValue {
    private static final long serialVersionUID = 1L;
    private String name = null;
    private LexicalUnit fallback = null;

    VarValue() {
        super(CSSValue.Type.VAR);
        this.fallback = null;
    }

    protected VarValue(VarValue copied) {
        super(copied);
        this.name = copied.name;
        this.fallback = copied.fallback;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public LexicalUnit getFallback() {
        return this.fallback;
    }

    public void setFallback(LexicalUnit fallback) {
        this.fallback = fallback;
    }

    @Override
    public String getCssText() {
        String ftext;
        int sz = this.name.length();
        if (this.fallback == null) {
            sz += 2;
            ftext = null;
        } else {
            ftext = this.fallback.toString();
            sz += 4 + ftext.length();
        }
        StringBuilder buf = new StringBuilder(sz);
        buf.append("var(");
        buf.append(this.name);
        if (ftext != null) {
            buf.append(", ");
            buf.append(ftext);
        }
        buf.append(')');
        return buf.toString();
    }

    @Override
    public void writeCssText(SimpleWriter wri) throws IOException {
        wri.write((CharSequence)"var(");
        wri.write((CharSequence)this.name);
        if (this.fallback != null) {
            wri.write((CharSequence)", ");
            this.writeFallback(wri);
        }
        wri.write(')');
    }

    private void writeFallback(SimpleWriter wri) throws IOException {
        ValueFactory vf = new ValueFactory();
        try {
            StyleValue cssval = vf.createCSSValue(this.fallback);
            cssval.writeCssText(wri);
        }
        catch (DOMException e) {
            wri.write((CharSequence)this.fallback.toString());
        }
    }

    @Override
    public String getMinifiedCssText(String propertyName) {
        int sz = this.name.length() + 5;
        if (this.fallback != null) {
            sz += 80;
        }
        StringBuilder buf = new StringBuilder(sz);
        buf.append("var(");
        buf.append(this.name);
        if (this.fallback != null) {
            buf.append(',');
            this.appendMinifiedFallback(buf);
        }
        buf.append(')');
        return buf.toString();
    }

    private void appendMinifiedFallback(StringBuilder buf) {
        String text;
        ValueFactory vf = new ValueFactory();
        try {
            StyleValue cssval = vf.createCSSValue(this.fallback);
            text = cssval.getMinifiedCssText(this.name);
        }
        catch (DOMException e) {
            text = this.fallback.toString();
        }
        buf.append(text);
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        LexicalUnit lunit;
        this.checkModifiableProperty();
        CSSParser parser = new CSSParser();
        try {
            lunit = parser.parsePropertyValue(new StringReader(cssText));
        }
        catch (CSSParseException e) {
            DOMException ex = new DOMException(12, e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        catch (IOException e) {
            return;
        }
        if (lunit == null || lunit.getLexicalUnitType() != LexicalUnit.LexicalType.VAR) {
            throw new DOMException(13, "Not a var() function.");
        }
        PrimitiveValue.LexicalSetter setter = this.newLexicalSetter();
        setter.setLexicalUnit(lunit);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.fallback == null ? 0 : this.fallback.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VarValue other = (VarValue)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.fallback == null) {
            return other.fallback == null;
        }
        return this.fallback.equals(other.fallback);
    }

    @Override
    PrimitiveValue.LexicalSetter newLexicalSetter() {
        return new MyLexicalSetter();
    }

    @Override
    public VarValue clone() {
        return new VarValue(this);
    }

    class MyLexicalSetter
    extends PrimitiveValue.LexicalSetter {
        MyLexicalSetter() {
        }

        @Override
        void setLexicalUnit(LexicalUnit lunit) {
            LexicalUnit lu = lunit.getParameters();
            if (lu == null || lu.getLexicalUnitType() != LexicalUnit.LexicalType.IDENT) {
                throw new DOMException(17, "Variable name must be an identifier");
            }
            String name = lu.getStringValue();
            if ((lu = lu.getNextLexicalUnit()) != null) {
                if (lu.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_COMMA) {
                    throw new DOMException(12, "Fallback must be separated by comma");
                }
                if ((lu = lu.getNextLexicalUnit()) != null) {
                    VarValue.this.fallback = lu.clone();
                } else {
                    VarValue.this.fallback = null;
                }
            }
            VarValue.this.name = name;
            this.nextLexicalUnit = lunit.getNextLexicalUnit();
        }
    }
}

