/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.DOMTokenSetImpl;
import io.sf.carte.doc.DirectionalityHelper;
import io.sf.carte.doc.style.css.CSSDocument;
import io.sf.carte.doc.style.css.SelectorMatcher;
import io.sf.carte.doc.style.css.nsac.ArgumentCondition;
import io.sf.carte.doc.style.css.nsac.AttributeCondition;
import io.sf.carte.doc.style.css.nsac.CombinatorCondition;
import io.sf.carte.doc.style.css.nsac.CombinatorSelector;
import io.sf.carte.doc.style.css.nsac.Condition;
import io.sf.carte.doc.style.css.nsac.ConditionalSelector;
import io.sf.carte.doc.style.css.nsac.ElementSelector;
import io.sf.carte.doc.style.css.nsac.LangCondition;
import io.sf.carte.doc.style.css.nsac.PositionalCondition;
import io.sf.carte.doc.style.css.nsac.PseudoCondition;
import io.sf.carte.doc.style.css.nsac.Selector;
import io.sf.carte.doc.style.css.nsac.SelectorList;
import io.sf.carte.doc.style.css.nsac.SimpleSelector;
import io.sf.carte.doc.style.css.om.Specificity;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;

public abstract class AbstractSelectorMatcher
implements SelectorMatcher,
Serializable {
    private static final long serialVersionUID = 2L;
    private String localName = null;
    private Condition pseudoElt = null;

    public String getLocalName() {
        return this.localName;
    }

    protected void setLocalName(String localname) {
        this.localName = localname;
    }

    protected String getClassAttribute(CSSDocument.ComplianceMode mode) {
        String classAttr = this.getAttributeValue("class");
        if (mode != CSSDocument.ComplianceMode.STRICT) {
            if (classAttr.length() == 0 && (classAttr = this.getAttributeValue("CLASS")).length() == 0) {
                classAttr = this.getAttributeValue("Class");
            }
            if (classAttr.length() != 0) {
                classAttr = classAttr.toLowerCase(Locale.ROOT);
            }
        }
        return classAttr;
    }

    @Override
    public Condition getPseudoElement() {
        return this.pseudoElt;
    }

    @Override
    public void setPseudoElement(Condition pseudoElt) {
        this.pseudoElt = pseudoElt;
    }

    protected boolean isActivePseudoClass(String pseudoclassName) {
        return false;
    }

    @Override
    public int matches(SelectorList selist) {
        int sz = selist.getLength();
        Specificity matchedsp = null;
        int matchedIdx = -1;
        for (int i = 0; i < sz; ++i) {
            Selector sel = selist.item(i);
            if (!this.matches(sel)) continue;
            Specificity sp = new Specificity(sel, this);
            if (matchedsp != null && Specificity.selectorCompare(matchedsp, sp) >= 0) continue;
            matchedsp = sp;
            matchedIdx = i;
        }
        return matchedIdx;
    }

    @Override
    public boolean matches(Selector selector) {
        switch (selector.getSelectorType()) {
            case ELEMENT: {
                String elname = ((ElementSelector)selector).getLocalName();
                String nsuri = ((ElementSelector)selector).getNamespaceURI();
                if (nsuri == null || nsuri.equals(this.getNamespaceURI())) {
                    return elname == null || this.localName.equalsIgnoreCase(elname) || elname.equals("*");
                }
                if (nsuri.length() != 0 || this.getNamespaceURI() != null) break;
                return true;
            }
            case CONDITIONAL: {
                ConditionalSelector condsel = (ConditionalSelector)selector;
                return this.matchCondition(condsel.getCondition(), condsel.getSimpleSelector());
            }
            case UNIVERSAL: 
            case SCOPE_MARKER: {
                return true;
            }
            case CHILD: {
                SimpleSelector desc = ((CombinatorSelector)selector).getSecondSelector();
                if (!this.matches(desc)) break;
                Selector ancestor = ((CombinatorSelector)selector).getSelector();
                AbstractSelectorMatcher parentSM = this.getParentSelectorMatcher();
                if (parentSM == null || !parentSM.matches(ancestor)) break;
                return true;
            }
            case DESCENDANT: {
                SimpleSelector desc = ((CombinatorSelector)selector).getSecondSelector();
                if (!this.matches(desc)) break;
                Selector ancestor = ((CombinatorSelector)selector).getSelector();
                for (AbstractSelectorMatcher parentSM = this.getParentSelectorMatcher(); parentSM != null; parentSM = parentSM.getParentSelectorMatcher()) {
                    if (!parentSM.matches(ancestor)) continue;
                    return true;
                }
                break;
            }
            case DIRECT_ADJACENT: {
                if (!this.matches(((CombinatorSelector)selector).getSecondSelector())) break;
                Selector sel = ((CombinatorSelector)selector).getSelector();
                AbstractSelectorMatcher siblingSM = this.getPreviousSiblingSelectorMatcher();
                return siblingSM != null && siblingSM.matches(sel);
            }
            case SUBSEQUENT_SIBLING: {
                CombinatorSelector sibling = (CombinatorSelector)selector;
                if (!this.matches(sibling.getSecondSelector())) break;
                Selector sel = sibling.getSelector();
                for (AbstractSelectorMatcher siblingSM = this.getPreviousSiblingSelectorMatcher(); siblingSM != null; siblingSM = siblingSM.getPreviousSiblingSelectorMatcher()) {
                    if (!siblingSM.matches(sel)) continue;
                    return true;
                }
                break;
            }
        }
        return false;
    }

    boolean matchCondition(Condition cond, SimpleSelector simple) {
        switch (cond.getConditionType()) {
            case CLASS: {
                AttributeCondition attrcond = (AttributeCondition)cond;
                String cond_value = attrcond.getValue();
                return this.matchesClass(cond_value) && this.matches(simple);
            }
            case ID: {
                return this.matchesId(((AttributeCondition)cond).getValue()) && this.matches(simple);
            }
            case ATTRIBUTE: {
                return this.matchesAttribute((AttributeCondition)cond, simple);
            }
            case ONE_OF_ATTRIBUTE: {
                return this.matchesOneOfAttribute((AttributeCondition)cond, simple);
            }
            case BEGIN_HYPHEN_ATTRIBUTE: {
                return this.matchesBeginHyphenAttribute((AttributeCondition)cond, simple);
            }
            case BEGINS_ATTRIBUTE: {
                return this.matchesBeginsAttribute((AttributeCondition)cond, simple);
            }
            case ENDS_ATTRIBUTE: {
                return this.matchesEndsAttribute((AttributeCondition)cond, simple);
            }
            case SUBSTRING_ATTRIBUTE: {
                return this.matchesSubstringAttribute((AttributeCondition)cond, simple);
            }
            case LANG: {
                return this.matchesLang((LangCondition)cond, simple);
            }
            case PSEUDO_CLASS: {
                if (!this.matches(simple)) break;
                PseudoCondition pseudocond = (PseudoCondition)cond;
                String pseudoClassName = pseudocond.getName();
                if ("only-child".equals(pseudoClassName = pseudoClassName.toLowerCase(Locale.ROOT).intern())) {
                    return this.isOnlyChild();
                }
                if ("only-of-type".equals(pseudoClassName)) {
                    return this.isOnlyOfType();
                }
                if ("any-link".equals(pseudoClassName)) {
                    return this.isAnyLink();
                }
                if ("link".equals(pseudoClassName)) {
                    return this.isNotVisitedLink();
                }
                if ("visited".equals(pseudoClassName)) {
                    return this.isVisitedLink();
                }
                if ("target".equals(pseudoClassName)) {
                    return this.isTarget();
                }
                if ("root".equals(pseudoClassName)) {
                    return this.isRoot();
                }
                if ("empty".equals(pseudoClassName)) {
                    return this.isEmpty();
                }
                if ("blank".equals(pseudoClassName)) {
                    return this.isBlank();
                }
                if ("disabled".equals(pseudoClassName)) {
                    return this.isDisabled();
                }
                if ("enabled".equals(pseudoClassName)) {
                    return this.isEnabled();
                }
                if ("read-write".equals(pseudoClassName)) {
                    return this.isReadWrite();
                }
                if ("read-only".equals(pseudoClassName)) {
                    return !this.isReadWrite();
                }
                if ("placeholder-shown".equals(pseudoClassName)) {
                    return this.isPlaceholderShown();
                }
                if ("default".equals(pseudoClassName)) {
                    return this.isUIDefault();
                }
                if ("checked".equals(pseudoClassName)) {
                    return this.isChecked();
                }
                if ("indeterminate".equals(pseudoClassName)) {
                    return this.isIndeterminate();
                }
                if ("dir".equals(pseudoClassName)) {
                    return this.isDir(pseudocond.getArgument());
                }
                return this.isActivePseudoClass(pseudoClassName);
            }
            case PSEUDO_ELEMENT: {
                return this.matches(simple) && this.matchesPseudoelement((PseudoCondition)cond);
            }
            case AND: {
                CombinatorCondition comb = (CombinatorCondition)cond;
                return this.matchCondition(comb.getFirstCondition(), simple) && this.matchCondition(comb.getSecondCondition(), simple);
            }
            case ONLY_CHILD: {
                return this.matches(simple) && this.isOnlyChild();
            }
            case ONLY_TYPE: {
                return this.matches(simple) && this.isOnlyOfType();
            }
            case POSITIONAL: {
                return this.matches(simple) && this.matchesPositional((PositionalCondition)cond);
            }
            case SELECTOR_ARGUMENT: {
                return this.matches(simple) && this.matchesArgument((ArgumentCondition)cond, simple);
            }
        }
        return false;
    }

    protected boolean matchesId(String value) {
        CSSDocument.ComplianceMode mode = this.getComplianceMode();
        String idAttr = this.getId();
        if (mode != CSSDocument.ComplianceMode.STRICT) {
            if (idAttr.length() == 0) {
                idAttr = this.getQuirksId();
            }
            return idAttr.equalsIgnoreCase(value);
        }
        return idAttr.equals(value);
    }

    private String getQuirksId() {
        String idAttr = this.getAttributeValue("id");
        if (idAttr.length() == 0 && (idAttr = this.getAttributeValue("ID")).length() == 0) {
            idAttr = this.getAttributeValue("Id");
        }
        return idAttr;
    }

    private boolean matchesClass(String cond_value) {
        CSSDocument.ComplianceMode mode = this.getComplianceMode();
        String classAttr = this.getClassAttribute(mode);
        if (!DOMTokenSetImpl.checkMultipleToken(classAttr)) {
            classAttr = classAttr.trim();
            if (mode != CSSDocument.ComplianceMode.STRICT) {
                return classAttr.equalsIgnoreCase(cond_value);
            }
            return classAttr.equals(cond_value);
        }
        if (mode != CSSDocument.ComplianceMode.STRICT) {
            StringTokenizer st = new StringTokenizer(classAttr);
            while (st.hasMoreTokens()) {
                classAttr = st.nextToken();
                if (!classAttr.equalsIgnoreCase(cond_value)) continue;
                return true;
            }
        } else {
            StringTokenizer st = new StringTokenizer(classAttr);
            while (st.hasMoreTokens()) {
                classAttr = st.nextToken();
                if (!classAttr.equals(cond_value)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matchesAttribute(AttributeCondition attrcond, SimpleSelector simple) {
        String attrName = attrcond.getLocalName();
        if (this.hasAttribute(attrName) && this.matches(simple)) {
            String cond_value = attrcond.getValue();
            if (cond_value != null) {
                String attribValue = this.getAttributeValue(attrName);
                if (attrcond.hasFlag(AttributeCondition.Flag.CASE_I)) {
                    return attribValue.equalsIgnoreCase(cond_value);
                }
                return attribValue.equals(cond_value);
            }
            return true;
        }
        return false;
    }

    private boolean matchesOneOfAttribute(AttributeCondition attrcond, SimpleSelector simple) {
        block4: {
            String attrName = attrcond.getLocalName();
            if (!this.hasAttribute(attrName) || !this.matches(simple)) break block4;
            boolean ignoreCase = attrcond.hasFlag(AttributeCondition.Flag.CASE_I);
            String cond_value = attrcond.getValue();
            String attrValue = this.getAttributeValue(attrName);
            StringTokenizer tok = new StringTokenizer(attrValue, " ");
            if (ignoreCase) {
                while (tok.hasMoreElements()) {
                    String token = tok.nextToken();
                    if (!token.equalsIgnoreCase(cond_value)) continue;
                    return true;
                }
            } else {
                while (tok.hasMoreElements()) {
                    String token = tok.nextToken();
                    if (!token.equals(cond_value)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean matchesBeginHyphenAttribute(AttributeCondition attrcond, SimpleSelector simple) {
        String attrName = attrcond.getLocalName();
        if (this.hasAttribute(attrName) && this.matches(simple)) {
            String attrValue = this.getAttributeValue(attrName);
            int attrlen = attrValue.length();
            String condValue = attrcond.getValue();
            int condLen = condValue.length();
            boolean ignoreCase = attrcond.hasFlag(AttributeCondition.Flag.CASE_I);
            if (condLen == attrlen) {
                return ignoreCase ? attrValue.equalsIgnoreCase(condValue) : attrValue.equals(condValue);
            }
            if (condLen < attrlen) {
                return attrValue.regionMatches(ignoreCase, 0, condValue, 0, condLen) && attrValue.charAt(condLen) == '-';
            }
        }
        return false;
    }

    private boolean matchesBeginsAttribute(AttributeCondition attrcond, SimpleSelector simple) {
        String attrName = attrcond.getLocalName();
        if (this.hasAttribute(attrName)) {
            String value = this.getAttributeValue(attrName);
            if (this.matches(simple)) {
                boolean ignoreCase = attrcond.hasFlag(AttributeCondition.Flag.CASE_I);
                String condValue = attrcond.getValue();
                return value.regionMatches(ignoreCase, 0, condValue, 0, condValue.length());
            }
        }
        return false;
    }

    private boolean matchesEndsAttribute(AttributeCondition attrcond, SimpleSelector simple) {
        String attrName = attrcond.getLocalName();
        if (this.hasAttribute(attrName)) {
            String value = this.getAttributeValue(attrName);
            if (this.matches(simple)) {
                boolean ignoreCase = attrcond.hasFlag(AttributeCondition.Flag.CASE_I);
                String condValue = attrcond.getValue();
                int len = value.length();
                int condLen = condValue.length();
                return value.regionMatches(ignoreCase, len - condLen, condValue, 0, condLen);
            }
        }
        return false;
    }

    private boolean matchesSubstringAttribute(AttributeCondition attrcond, SimpleSelector simple) {
        String attrName = attrcond.getLocalName();
        if (this.hasAttribute(attrName) && this.matches(simple)) {
            int condLen;
            String value = this.getAttributeValue(attrName);
            boolean ignoreCase = attrcond.hasFlag(AttributeCondition.Flag.CASE_I);
            String condValue = attrcond.getValue();
            if (!ignoreCase) {
                return value.contains(condValue);
            }
            int len = value.length();
            int startLimit = len - (condLen = condValue.length());
            if (startLimit >= 0) {
                for (int i = 0; i <= startLimit; ++i) {
                    if (!value.regionMatches(ignoreCase, i, condValue, 0, condLen)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean matchesLang(LangCondition cond, SimpleSelector simple) {
        String[] specArray;
        if (!this.matches(simple)) {
            return false;
        }
        String lang = this.getLanguage();
        String value = cond.getLang();
        if (value.indexOf(44) == -1) {
            return this.matchesLangSpec(value, lang);
        }
        for (String spec : specArray = value.split(",")) {
            if ((spec = spec.trim()).length() == 0 || !this.matchesLangSpec(spec, lang)) continue;
            return true;
        }
        return false;
    }

    private boolean matchesLangSpec(String spec, String lang) {
        int specLen;
        char c0 = spec.charAt(0);
        if (c0 == '\'') {
            int specLen2 = spec.length();
            if (spec.charAt(specLen2 - 1) == '\'') {
                spec = spec.substring(1, specLen2 - 1);
            }
        } else if (c0 == '\"' && spec.charAt((specLen = spec.length()) - 1) == '\"') {
            spec = spec.substring(1, specLen - 1);
        }
        if (spec.indexOf(42) == -1) {
            return lang.startsWith(spec);
        }
        return this.matchesLangRange(spec, lang);
    }

    private boolean matchesLangRange(String spec, String lang) {
        if ((spec = spec.replaceAll("\\*", ".*")).charAt(spec.length() - 1) != '*') {
            spec = spec + ".*";
        }
        return lang.matches(spec);
    }

    protected boolean isDir(String argument) {
        if (argument != null) {
            DirectionalityHelper.Directionality dir = this.getDirectionality();
            if ("rtl".equalsIgnoreCase(argument)) {
                return dir == DirectionalityHelper.Directionality.RTL;
            }
            if ("ltr".equalsIgnoreCase(argument)) {
                return dir == DirectionalityHelper.Directionality.LTR;
            }
        }
        return false;
    }

    private boolean matchesPositional(PositionalCondition pcond) {
        int pos = pcond.getOffset();
        int factor = pcond.getFactor();
        if (pcond.isOfType()) {
            if (pcond.isForwardCondition()) {
                return this.isNthOfType(factor, pos);
            }
            return this.isNthLastOfType(factor, pos);
        }
        int idx = pcond.isForwardCondition() ? this.indexOf(pcond.getOfList()) : this.reverseIndexOf(pcond.getOfList());
        if (idx == -1) {
            return false;
        }
        return factor == 0 ? idx == 0 : Math.floorMod(idx -= pos, factor) == 0;
    }

    private boolean matchesPseudoelement(PseudoCondition pseudo) {
        Condition pe = this.getPseudoElement();
        if (pe != null) {
            if (pe.getConditionType() == Condition.ConditionType.PSEUDO_ELEMENT) {
                return pseudo.getName().equals(((PseudoCondition)pe).getName());
            }
            if (pe.getConditionType() == Condition.ConditionType.AND) {
                CombinatorCondition comb = (CombinatorCondition)pe;
                return pseudo.getName().equals(((PseudoCondition)comb.getFirstCondition()).getName()) || pseudo.getName().equals(((PseudoCondition)comb.getSecondCondition()).getName());
            }
        }
        return false;
    }

    private boolean matchesArgument(ArgumentCondition cond, SimpleSelector simple) {
        String name = cond.getName();
        SelectorList selist = cond.getSelectors();
        if ("not".equals(name)) {
            for (int i = 0; i < selist.getLength(); ++i) {
                if (!this.matches(selist.item(i))) continue;
                return false;
            }
            return true;
        }
        if ("has".equals(name)) {
            for (int i = 0; i < selist.getLength(); ++i) {
                if (!this.scopeMatch(selist.item(i), simple)) continue;
                return true;
            }
            return false;
        }
        if ("is".equals(name) || "where".equals(name)) {
            return this.matches(selist) >= 0;
        }
        return false;
    }

    private boolean scopeMatch(Selector selector, SimpleSelector scope) {
        switch (selector.getSelectorType()) {
            case ELEMENT: 
            case CONDITIONAL: {
                return this.scopeMatch(new CombinatorSelectorImpl(scope, (SimpleSelector)selector), scope);
            }
            case CHILD: 
            case DESCENDANT: {
                CombinatorSelector comb = (CombinatorSelector)selector;
                if (comb.getSelector().getSelectorType() == Selector.SelectorType.SCOPE_MARKER) {
                    return this.scopeMatchChild(comb);
                }
                return this.scopeMatchDescendant(comb);
            }
            case DIRECT_ADJACENT: 
            case SUBSEQUENT_SIBLING: {
                CombinatorSelector comb = (CombinatorSelector)selector;
                if (comb.getSelector().getSelectorType() == Selector.SelectorType.SCOPE_MARKER) {
                    return this.scopeMatchDirectAdjacent(comb);
                }
                return this.scopeMatchDescendant(comb);
            }
        }
        return false;
    }

    protected boolean isChecked() {
        String tagname = this.getLocalName();
        if ("input".equals(tagname)) {
            String type = this.getAttributeValue("type");
            return ("checkbox".equalsIgnoreCase(type) || "radio".equalsIgnoreCase(type)) && this.hasAttribute("checked");
        }
        if ("option".equals(tagname)) {
            return this.hasAttribute("selected");
        }
        return false;
    }

    protected boolean isEnabled() {
        return this.isFormElement() && !this.isDisabled();
    }

    protected boolean isFormElement() {
        String tagname = this.getLocalName();
        return tagname.equals("input") || tagname.equals("button") || tagname.equals("select") || tagname.equals("optgroup") || tagname.equals("option") || tagname.equals("textarea") || tagname.equals("keygen") || tagname.equals("fieldset");
    }

    protected boolean isIndeterminate() {
        String s = this.getAttributeValue("indeterminate");
        return s.length() != 0 && !s.equalsIgnoreCase("false");
    }

    protected boolean isAnyLink() {
        String href = this.getLinkHrefAttribute();
        return href.length() != 0;
    }

    protected boolean isNotVisitedLink() {
        String href = this.getLinkHrefAttribute();
        if (href.length() != 0) {
            return !this.isVisitedURI(href);
        }
        return false;
    }

    protected boolean isVisitedLink() {
        String href = this.getLinkHrefAttribute();
        if (href.length() != 0) {
            return this.isVisitedURI(href);
        }
        return false;
    }

    private String getLinkHrefAttribute() {
        String href = this.getAttributeValue("href");
        if (href.length() == 0 || !"a".equals(this.localName) && !"link".equals(this.localName) && !"area".equals(this.localName)) {
            href = this.getAttributeValue("xlink:href");
        }
        return href;
    }

    protected boolean isOnlyChild() {
        return this.isFirstChild() && this.isLastChild();
    }

    protected boolean isOnlyOfType() {
        return this.isFirstOfType() && this.isLastOfType();
    }

    protected boolean isPlaceholderShown() {
        return this.hasAttribute("placeholder");
    }

    protected boolean isReadWrite() {
        if ("true".equalsIgnoreCase(this.getAttributeValue("contenteditable"))) {
            return true;
        }
        return this.isEnabled();
    }

    protected boolean isUIDefault() {
        String tagname = this.getLocalName();
        if ("button".equals(tagname)) {
            return "submit".equalsIgnoreCase(this.getAttributeValue("type")) && this.isDefaultButton();
        }
        if ("option".equals(tagname)) {
            return this.hasAttribute("selected");
        }
        if ("input".equals(tagname)) {
            if (this.hasAttribute("checked")) {
                return true;
            }
            String type = this.getAttributeValue("type").toLowerCase(Locale.ROOT);
            if ("submit".equals(type) || "image".equals(type)) {
                return this.isDefaultButton();
            }
        }
        return false;
    }

    protected abstract CSSDocument.ComplianceMode getComplianceMode();

    protected abstract String getNamespaceURI();

    protected abstract boolean scopeMatchChild(CombinatorSelector var1);

    protected abstract boolean scopeMatchDescendant(CombinatorSelector var1);

    protected abstract boolean scopeMatchDirectAdjacent(CombinatorSelector var1);

    protected abstract AbstractSelectorMatcher getParentSelectorMatcher();

    protected abstract AbstractSelectorMatcher getPreviousSiblingSelectorMatcher();

    protected abstract String getAttributeValue(String var1);

    protected abstract boolean hasAttribute(String var1);

    protected abstract String getId();

    protected abstract String getLanguage();

    protected abstract DirectionalityHelper.Directionality getDirectionality();

    protected abstract boolean isFirstChild();

    protected abstract boolean isLastChild();

    protected abstract boolean isFirstOfType();

    protected abstract boolean isLastOfType();

    protected abstract int indexOf(SelectorList var1);

    protected abstract int reverseIndexOf(SelectorList var1);

    protected abstract boolean isNthOfType(int var1, int var2);

    protected abstract boolean isNthLastOfType(int var1, int var2);

    protected abstract boolean isTarget();

    protected abstract boolean isRoot();

    protected abstract boolean isEmpty();

    protected abstract boolean isBlank();

    protected abstract boolean isDisabled();

    protected abstract boolean isDefaultButton();

    protected abstract boolean isVisitedURI(String var1);

    public static void findStatePseudoClasses(Selector selector, List<String> statePseudoClasses) {
        switch (selector.getSelectorType()) {
            case CONDITIONAL: {
                Condition condition = ((ConditionalSelector)selector).getCondition();
                if (condition.getConditionType() == Condition.ConditionType.PSEUDO_CLASS) {
                    String pseudoClass = ((PseudoCondition)condition).getName();
                    int idxp = pseudoClass.indexOf(40);
                    if (idxp != -1) {
                        pseudoClass = pseudoClass.substring(0, idxp);
                    }
                    if ((pseudoClass = pseudoClass.toLowerCase(Locale.ROOT).intern()) != "first-child" && pseudoClass != "last-child" && pseudoClass != "only-child" && pseudoClass != "any-link" && pseudoClass != "link" && pseudoClass != "visited" && pseudoClass != "target" && pseudoClass != "root" && pseudoClass != "empty" && pseudoClass != "blank" && pseudoClass != "is" && pseudoClass != "not" && pseudoClass != "has" && pseudoClass != "dir" && pseudoClass != "lang" && pseudoClass != "scope" && pseudoClass != "empty" && pseudoClass != "blank" && pseudoClass != "valid" && pseudoClass != "invalid" && pseudoClass != "in-range" && pseudoClass != "out-of-range" && pseudoClass != "required" && pseudoClass != "optional" && pseudoClass != "user-invalid" && pseudoClass != "nth-child" && pseudoClass != "nth-last-child" && pseudoClass != "nth-of-type" && pseudoClass != "nth-last-of-type" && pseudoClass != "disabled" && pseudoClass != "enabled" && pseudoClass != "read-write" && pseudoClass != "read-only" && pseudoClass != "placeholder-shown" && pseudoClass != "default" && pseudoClass != "checked" && pseudoClass != "indeterminate" && pseudoClass != "nth-col" && pseudoClass != "nth-last-col") {
                        statePseudoClasses.add(pseudoClass);
                        break;
                    }
                }
                AbstractSelectorMatcher.findStatePseudoClasses(((ConditionalSelector)selector).getSimpleSelector(), statePseudoClasses);
                break;
            }
            case CHILD: 
            case DESCENDANT: {
                AbstractSelectorMatcher.findStatePseudoClasses(((CombinatorSelector)selector).getSecondSelector(), statePseudoClasses);
                AbstractSelectorMatcher.findStatePseudoClasses(((CombinatorSelector)selector).getSelector(), statePseudoClasses);
                break;
            }
            case DIRECT_ADJACENT: {
                AbstractSelectorMatcher.findStatePseudoClasses(((CombinatorSelector)selector).getSecondSelector(), statePseudoClasses);
            }
        }
    }

    public String toString() {
        CSSDocument.ComplianceMode mode;
        String classAttr;
        StringBuilder sb = new StringBuilder();
        AbstractSelectorMatcher parentSM = this.getParentSelectorMatcher();
        if (parentSM != null) {
            sb.append(parentSM.getLocalName()).append(' ').append('>').append(' ');
        }
        if (this.localName != null) {
            sb.append(this.localName);
        }
        if ((classAttr = this.getClassAttribute(mode = this.getComplianceMode())).length() != 0) {
            sb.append('.').append(classAttr);
        } else if (this.getId().length() != 0) {
            sb.append('#').append(this.getId());
        }
        if (this.pseudoElt != null) {
            sb.append(':').append(this.pseudoElt);
        }
        return sb.toString();
    }

    private static class CombinatorSelectorImpl
    implements CombinatorSelector {
        SimpleSelector simpleSelector;
        Selector scope;

        CombinatorSelectorImpl(Selector scope, SimpleSelector simpleSelector) {
            this.scope = scope;
            this.simpleSelector = simpleSelector;
        }

        @Override
        public Selector.SelectorType getSelectorType() {
            return Selector.SelectorType.DESCENDANT;
        }

        @Override
        public Selector getSelector() {
            return this.scope;
        }

        @Override
        public SimpleSelector getSecondSelector() {
            return this.simpleSelector;
        }
    }
}

