# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


@register_command(
    "network watcher connection-monitor endpoint remove",
    is_preview=True,
)
class Remove(AAZCommand):
    """Remove an endpoint from a connection monitor.

    :example: Remove endpoint from all test groups of a connection monitor
        az network watcher connection-monitor endpoint remove --connection-monitor MyConnectionMonitor --location westus --name MyEndpoint

    :example: Remove endpoint from two test groups of a connection monitor
        az network watcher connection-monitor endpoint remove --connection-monitor MyConnectionMonitor --location westus --name MyEndpoint --test-groups DefaultTestGroup HealthCheckTestGroup
    """

    _aaz_info = {
        "version": "2022-01-01",
        "resources": [
            ["mgmt-plane", "/subscriptions/{}/resourcegroups/{}/providers/microsoft.network/networkwatchers/{}/connectionmonitors/{}", "2022-01-01", "properties.endpoints[]"],
        ]
    }

    AZ_SUPPORT_NO_WAIT = True

    def _handler(self, command_args):
        super()._handler(command_args)
        self.SubresourceSelector(ctx=self.ctx, name="subresource")
        return self.build_lro_poller(self._execute_operations, None)

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.connection_monitor = AAZStrArg(
            options=["--connection-monitor"],
            help="Connection monitor name.",
            required=True,
        )
        _args_schema.watcher_name = AAZStrArg(
            options=["--watcher-name"],
            help="Name of the network watcher.",
            required=True,
        )
        _args_schema.watcher_rg = AAZResourceGroupNameArg(
            options=["-g", "--watcher-rg"],
            help="Name of the resource group the watcher is in.",
            required=True,
        )
        _args_schema.endpoint_name = AAZStrArg(
            options=["-n", "--name", "--endpoint-name"],
            help="Name of the connection monitor endpoint.",
            required=True,
        )
        return cls._args_schema

    def _execute_operations(self):
        self.pre_operations()
        self.ConnectionMonitorsGet(ctx=self.ctx)()
        self.pre_instance_delete()
        self.InstanceDeleteByJson(ctx=self.ctx)()
        self.post_instance_delete()
        yield self.ConnectionMonitorsCreateOrUpdate(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    @register_callback
    def pre_instance_delete(self):
        pass

    @register_callback
    def post_instance_delete(self):
        pass

    class SubresourceSelector(AAZJsonSelector):

        def _get(self):
            result = self.ctx.vars.instance
            result = result.properties.endpoints
            filters = enumerate(result)
            filters = filter(
                lambda e: e[1].name == self.ctx.args.endpoint_name,
                filters
            )
            idx = next(filters)[0]
            return result[idx]

        def _set(self, value):
            result = self.ctx.vars.instance
            result = result.properties.endpoints
            filters = enumerate(result)
            filters = filter(
                lambda e: e[1].name == self.ctx.args.endpoint_name,
                filters
            )
            idx = next(filters, [len(result)])[0]
            result[idx] = value
            return

    class ConnectionMonitorsGet(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [200]:
                return self.on_200(session)

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/connectionMonitors/{connectionMonitorName}",
                **self.url_parameters
            )

        @property
        def method(self):
            return "GET"

        @property
        def error_format(self):
            return "ODataV4Format"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "connectionMonitorName", self.ctx.args.connection_monitor,
                    required=True,
                ),
                **self.serialize_url_param(
                    "networkWatcherName", self.ctx.args.watcher_name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.watcher_rg,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2022-01-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        def on_200(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200
            )

        _schema_on_200 = None

        @classmethod
        def _build_schema_on_200(cls):
            if cls._schema_on_200 is not None:
                return cls._schema_on_200

            cls._schema_on_200 = AAZObjectType()
            _RemoveHelper._build_schema_connection_monitor_result_read(cls._schema_on_200)

            return cls._schema_on_200

    class ConnectionMonitorsCreateOrUpdate(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [202]:
                return self.client.build_lro_polling(
                    self.ctx.args.no_wait,
                    session,
                    self.on_200_201,
                    self.on_error,
                    lro_options={"final-state-via": "azure-async-operation"},
                    path_format_arguments=self.url_parameters,
                )
            if session.http_response.status_code in [200, 201]:
                return self.client.build_lro_polling(
                    self.ctx.args.no_wait,
                    session,
                    self.on_200_201,
                    self.on_error,
                    lro_options={"final-state-via": "azure-async-operation"},
                    path_format_arguments=self.url_parameters,
                )

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/connectionMonitors/{connectionMonitorName}",
                **self.url_parameters
            )

        @property
        def method(self):
            return "PUT"

        @property
        def error_format(self):
            return "ODataV4Format"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "connectionMonitorName", self.ctx.args.connection_monitor,
                    required=True,
                ),
                **self.serialize_url_param(
                    "networkWatcherName", self.ctx.args.watcher_name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.watcher_rg,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2022-01-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Content-Type", "application/json",
                ),
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        @property
        def content(self):
            _content_value, _builder = self.new_content_builder(
                self.ctx.args,
                value=self.ctx.vars.instance,
            )

            return self.serialize_content(_content_value)

        def on_200_201(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200_201
            )

        _schema_on_200_201 = None

        @classmethod
        def _build_schema_on_200_201(cls):
            if cls._schema_on_200_201 is not None:
                return cls._schema_on_200_201

            cls._schema_on_200_201 = AAZObjectType()
            _RemoveHelper._build_schema_connection_monitor_result_read(cls._schema_on_200_201)

            return cls._schema_on_200_201

    class InstanceDeleteByJson(AAZJsonInstanceDeleteOperation):

        def __call__(self, *args, **kwargs):
            self.ctx.selectors.subresource.set(self._delete_instance())


class _RemoveHelper:
    """Helper class for Remove"""

    _schema_connection_monitor_endpoint_scope_item_read = None

    @classmethod
    def _build_schema_connection_monitor_endpoint_scope_item_read(cls, _schema):
        if cls._schema_connection_monitor_endpoint_scope_item_read is not None:
            _schema.address = cls._schema_connection_monitor_endpoint_scope_item_read.address
            return

        cls._schema_connection_monitor_endpoint_scope_item_read = _schema_connection_monitor_endpoint_scope_item_read = AAZObjectType()

        connection_monitor_endpoint_scope_item_read = _schema_connection_monitor_endpoint_scope_item_read
        connection_monitor_endpoint_scope_item_read.address = AAZStrType()

        _schema.address = cls._schema_connection_monitor_endpoint_scope_item_read.address

    _schema_connection_monitor_result_read = None

    @classmethod
    def _build_schema_connection_monitor_result_read(cls, _schema):
        if cls._schema_connection_monitor_result_read is not None:
            _schema.etag = cls._schema_connection_monitor_result_read.etag
            _schema.id = cls._schema_connection_monitor_result_read.id
            _schema.location = cls._schema_connection_monitor_result_read.location
            _schema.name = cls._schema_connection_monitor_result_read.name
            _schema.properties = cls._schema_connection_monitor_result_read.properties
            _schema.tags = cls._schema_connection_monitor_result_read.tags
            _schema.type = cls._schema_connection_monitor_result_read.type
            return

        cls._schema_connection_monitor_result_read = _schema_connection_monitor_result_read = AAZObjectType()

        connection_monitor_result_read = _schema_connection_monitor_result_read
        connection_monitor_result_read.etag = AAZStrType(
            flags={"read_only": True},
        )
        connection_monitor_result_read.id = AAZStrType(
            flags={"read_only": True},
        )
        connection_monitor_result_read.location = AAZStrType()
        connection_monitor_result_read.name = AAZStrType(
            flags={"read_only": True},
        )
        connection_monitor_result_read.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        connection_monitor_result_read.tags = AAZDictType()
        connection_monitor_result_read.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_connection_monitor_result_read.properties
        properties.auto_start = AAZBoolType(
            serialized_name="autoStart",
        )
        properties.connection_monitor_type = AAZStrType(
            serialized_name="connectionMonitorType",
            flags={"read_only": True},
        )
        properties.destination = AAZObjectType()
        properties.endpoints = AAZListType()
        properties.monitoring_interval_in_seconds = AAZIntType(
            serialized_name="monitoringIntervalInSeconds",
        )
        properties.monitoring_status = AAZStrType(
            serialized_name="monitoringStatus",
            flags={"read_only": True},
        )
        properties.notes = AAZStrType()
        properties.outputs = AAZListType()
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        properties.source = AAZObjectType()
        properties.start_time = AAZStrType(
            serialized_name="startTime",
            flags={"read_only": True},
        )
        properties.test_configurations = AAZListType(
            serialized_name="testConfigurations",
        )
        properties.test_groups = AAZListType(
            serialized_name="testGroups",
        )

        destination = _schema_connection_monitor_result_read.properties.destination
        destination.address = AAZStrType()
        destination.port = AAZIntType()
        destination.resource_id = AAZStrType(
            serialized_name="resourceId",
        )

        endpoints = _schema_connection_monitor_result_read.properties.endpoints
        endpoints.Element = AAZObjectType()

        _element = _schema_connection_monitor_result_read.properties.endpoints.Element
        _element.address = AAZStrType()
        _element.coverage_level = AAZStrType(
            serialized_name="coverageLevel",
        )
        _element.filter = AAZObjectType()
        _element.name = AAZStrType(
            flags={"required": True},
        )
        _element.resource_id = AAZStrType(
            serialized_name="resourceId",
        )
        _element.scope = AAZObjectType()
        _element.type = AAZStrType()

        filter = _schema_connection_monitor_result_read.properties.endpoints.Element.filter
        filter.items = AAZListType()
        filter.type = AAZStrType()

        items = _schema_connection_monitor_result_read.properties.endpoints.Element.filter.items
        items.Element = AAZObjectType()

        _element = _schema_connection_monitor_result_read.properties.endpoints.Element.filter.items.Element
        _element.address = AAZStrType()
        _element.type = AAZStrType()

        scope = _schema_connection_monitor_result_read.properties.endpoints.Element.scope
        scope.exclude = AAZListType()
        scope.include = AAZListType()

        exclude = _schema_connection_monitor_result_read.properties.endpoints.Element.scope.exclude
        exclude.Element = AAZObjectType()
        cls._build_schema_connection_monitor_endpoint_scope_item_read(exclude.Element)

        include = _schema_connection_monitor_result_read.properties.endpoints.Element.scope.include
        include.Element = AAZObjectType()
        cls._build_schema_connection_monitor_endpoint_scope_item_read(include.Element)

        outputs = _schema_connection_monitor_result_read.properties.outputs
        outputs.Element = AAZObjectType()

        _element = _schema_connection_monitor_result_read.properties.outputs.Element
        _element.type = AAZStrType()
        _element.workspace_settings = AAZObjectType(
            serialized_name="workspaceSettings",
        )

        workspace_settings = _schema_connection_monitor_result_read.properties.outputs.Element.workspace_settings
        workspace_settings.workspace_resource_id = AAZStrType(
            serialized_name="workspaceResourceId",
        )

        source = _schema_connection_monitor_result_read.properties.source
        source.port = AAZIntType()
        source.resource_id = AAZStrType(
            serialized_name="resourceId",
            flags={"required": True},
        )

        test_configurations = _schema_connection_monitor_result_read.properties.test_configurations
        test_configurations.Element = AAZObjectType()

        _element = _schema_connection_monitor_result_read.properties.test_configurations.Element
        _element.http_configuration = AAZObjectType(
            serialized_name="httpConfiguration",
        )
        _element.icmp_configuration = AAZObjectType(
            serialized_name="icmpConfiguration",
        )
        _element.name = AAZStrType(
            flags={"required": True},
        )
        _element.preferred_ip_version = AAZStrType(
            serialized_name="preferredIPVersion",
        )
        _element.protocol = AAZStrType(
            flags={"required": True},
        )
        _element.success_threshold = AAZObjectType(
            serialized_name="successThreshold",
        )
        _element.tcp_configuration = AAZObjectType(
            serialized_name="tcpConfiguration",
        )
        _element.test_frequency_sec = AAZIntType(
            serialized_name="testFrequencySec",
        )

        http_configuration = _schema_connection_monitor_result_read.properties.test_configurations.Element.http_configuration
        http_configuration.method = AAZStrType()
        http_configuration.path = AAZStrType()
        http_configuration.port = AAZIntType()
        http_configuration.prefer_https = AAZBoolType(
            serialized_name="preferHTTPS",
        )
        http_configuration.request_headers = AAZListType(
            serialized_name="requestHeaders",
        )
        http_configuration.valid_status_code_ranges = AAZListType(
            serialized_name="validStatusCodeRanges",
        )

        request_headers = _schema_connection_monitor_result_read.properties.test_configurations.Element.http_configuration.request_headers
        request_headers.Element = AAZObjectType()

        _element = _schema_connection_monitor_result_read.properties.test_configurations.Element.http_configuration.request_headers.Element
        _element.name = AAZStrType()
        _element.value = AAZStrType()

        valid_status_code_ranges = _schema_connection_monitor_result_read.properties.test_configurations.Element.http_configuration.valid_status_code_ranges
        valid_status_code_ranges.Element = AAZStrType()

        icmp_configuration = _schema_connection_monitor_result_read.properties.test_configurations.Element.icmp_configuration
        icmp_configuration.disable_trace_route = AAZBoolType(
            serialized_name="disableTraceRoute",
        )

        success_threshold = _schema_connection_monitor_result_read.properties.test_configurations.Element.success_threshold
        success_threshold.checks_failed_percent = AAZIntType(
            serialized_name="checksFailedPercent",
        )
        success_threshold.round_trip_time_ms = AAZFloatType(
            serialized_name="roundTripTimeMs",
        )

        tcp_configuration = _schema_connection_monitor_result_read.properties.test_configurations.Element.tcp_configuration
        tcp_configuration.destination_port_behavior = AAZStrType(
            serialized_name="destinationPortBehavior",
        )
        tcp_configuration.disable_trace_route = AAZBoolType(
            serialized_name="disableTraceRoute",
        )
        tcp_configuration.port = AAZIntType()

        test_groups = _schema_connection_monitor_result_read.properties.test_groups
        test_groups.Element = AAZObjectType()

        _element = _schema_connection_monitor_result_read.properties.test_groups.Element
        _element.destinations = AAZListType(
            flags={"required": True},
        )
        _element.disable = AAZBoolType()
        _element.name = AAZStrType(
            flags={"required": True},
        )
        _element.sources = AAZListType(
            flags={"required": True},
        )
        _element.test_configurations = AAZListType(
            serialized_name="testConfigurations",
            flags={"required": True},
        )

        destinations = _schema_connection_monitor_result_read.properties.test_groups.Element.destinations
        destinations.Element = AAZStrType()

        sources = _schema_connection_monitor_result_read.properties.test_groups.Element.sources
        sources.Element = AAZStrType()

        test_configurations = _schema_connection_monitor_result_read.properties.test_groups.Element.test_configurations
        test_configurations.Element = AAZStrType()

        tags = _schema_connection_monitor_result_read.tags
        tags.Element = AAZStrType()

        _schema.etag = cls._schema_connection_monitor_result_read.etag
        _schema.id = cls._schema_connection_monitor_result_read.id
        _schema.location = cls._schema_connection_monitor_result_read.location
        _schema.name = cls._schema_connection_monitor_result_read.name
        _schema.properties = cls._schema_connection_monitor_result_read.properties
        _schema.tags = cls._schema_connection_monitor_result_read.tags
        _schema.type = cls._schema_connection_monitor_result_read.type


__all__ = ["Remove"]
