/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.language;

import java.io.IOException;
import java.io.Reader;

public final class ExtendedWhitespaceTokenizerImpl {
    public static final int YYEOF = -1;
    private static final int ZZ_BUFFERSIZE = 16384;
    public static final int YYINITIAL = 0;
    private static final int[] ZZ_LEXSTATE = new int[]{0, 0};
    private static final int[] ZZ_CMAP_TOP = ExtendedWhitespaceTokenizerImpl.zzUnpackcmap_top();
    private static final String ZZ_CMAP_TOP_PACKED_0 = "\u0001\u0000\u0005\u0100\u0001\u0200\u0002\u0100\u0001\u0300\u0001\u0400\u0001\u0500\u0001\u0400\u0001\u0600\u0001\u0700\u0001\u0100\u0001\u0800\u000f\u0100\u0001\u0900\u000f\u0a00\u0001\u0b00\u0001\u0c00\u0001\u0a00\u0001\u0d00\t\u0100\u0001\u0e00\u0010\u0a00R\u0100\f\u0a00+\u0100\u0001\u0f00\b\u1000\u0019\u0a00\u0002\u0100\u1005\u0a00";
    private static final int[] ZZ_CMAP_BLOCKS = ExtendedWhitespaceTokenizerImpl.zzUnpackcmap_blocks();
    private static final String ZZ_CMAP_BLOCKS_PACKED_0 = "\n\u0000\u0001\u0001\u0002\u0000\u0001\u0002\u0013\u0000\u0001\u0003\u0001\u0000\u0001\u0004\u0002\u0005\u0001\u0006\u0001\u0007\u0004\u0005\u0001\b\u0001\t\u0001\n\u0001\u000b\n\f\u0001\r\u0001\u000e\u0001\u0000\u0001\u0005\u0001\u0000\u0001\u0003\u0001\u000f\u001a\u0010\u0001\u0005\u0001\u0000\u0001\u0005\u0001\u0000\u0001\u0011\u0001\u0012\u0001\u0013\u0001\u0014\u0001\u0015\u0001\u0016\u0001\u0017\u0001\u0018\u0001\u0019\u0001\u001a\u0001\u001b\u0002\u0010\u0001\u001c\u0001\u001d\u0001\u001e\u0001\u001f\u0001 \u0001\u0010\u0001!\u0001\"\u0001#\u0001$\u0001%\u0003\u0010\u0001&\u0003\u0000\u0001\u00058\u0000\u0001'\b\u0000\u0017(\u0001\u0000\u001f(\u0001\u0000\u0168(\n)\u0086(\n)j(\u0002'\n)v(\n)v(\n)v(\n)v(\n)w(\t)v(\n)\u00e0(\n)v(\n)f(\n)\u00b6(\u0240\u0000\u0150(p\u0000\u0080(\u0080\u0000.(\u00d2\u0000\u00a4(\\\u0000\u0100*";
    private static final int[] ZZ_ACTION = ExtendedWhitespaceTokenizerImpl.zzUnpackAction();
    private static final String ZZ_ACTION_PACKED_0 = "\u0001\u0000\u0002\u0001\u0001\u0002\u0001\u0001\u0001\u0003\u0001\u0004\u0004\u0005\u0001\u0004\u0002\u0000\u0001\u0006\u0002\u0000\u0001\u0005\u0001\u0006\u0001\u0004\u0002\u0000\u0001\u0006\u0005\u0005\u0001\u0006\u0001\u0005\u0001\u0007\u0001\u0004\u0001\u0000\u0001\u0004\n\u0006\u0001\u0004\u0001\b\u0001\t\u0001\u0005\u0001\n\n\u0006\u0004\u0005\u0003\u0004\n\u000b\u0001\u0004\u0002\u0000\u0001\u0005\u0001\u0000\u0001\t\u0001\u0000\u0002\u0005\u0001\t\u0001\f\u0001\u0006\u0002\f\u0002\u0006\u0001\f\u0001\u0006\u0001\f\u0001\n\u0001\u0000\u0002\u0005\n\u0006\u0001\b\u0002\u0004\u0001\u0000\u0001\u0005\u0005\u0000";
    private static final int[] ZZ_ROWMAP = ExtendedWhitespaceTokenizerImpl.zzUnpackRowMap();
    private static final String ZZ_ROWMAP_PACKED_0 = "\u0000\u0000\u0000+\u0000V\u0000\u0081\u0000\u00ac\u0000+\u0000\u00d7\u0000\u0102\u0000\u012d\u0000\u0158\u0000\u0183\u0000\u01ae\u0000\u01d9\u0000\u0204\u0000\u022f\u0000\u025a\u0000\u0285\u0000\u02b0\u0000\u02db\u0000\u0306\u0000\u0331\u0000\u035c\u0000\u0387\u0000\u03b2\u0000\u03dd\u0000\u0408\u0000\u0433\u0000\u045e\u0000\u0489\u0000\u04b4\u0000+\u0000\u04df\u0000\u050a\u0000\u0535\u0000\u0560\u0000\u058b\u0000\u05b6\u0000\u05e1\u0000\u060c\u0000\u0637\u0000\u0662\u0000\u068d\u0000\u06b8\u0000\u06e3\u0000\u070e\u0000\u0739\u0000\u0764\u0000\u078f\u0000\u07ba\u0000\u07e5\u0000\u0810\u0000\u083b\u0000\u0866\u0000\u0891\u0000\u08bc\u0000\u08e7\u0000\u0912\u0000\u093d\u0000\u0968\u0000\u035c\u0000\u0993\u0000\u09be\u0000\u09e9\u0000\u0a14\u0000\u0a3f\u0000\u0a6a\u0000\u0a95\u0000\u0ac0\u0000\u0aeb\u0000\u0b16\u0000\u0b41\u0000\u0b6c\u0000\u0b97\u0000\u0bc2\u0000\u0bed\u0000\u0c18\u0000\u0c43\u0000\u0c6e\u0000\u0c99\u0000\u0cc4\u0000\u0cef\u0000\u03b2\u0000\u0d1a\u0000\u0d45\u0000\u0d70\u0000\u04b4\u0000\u0d9b\u0000\u0a95\u0000\u0dc6\u0000\u0df1\u0000\u0e1c\u0000\u0e47\u0000\u0e72\u0000\u0e9d\u0000\u0ec8\u0000\u0ef3\u0000\u0f1e\u0000\u0f49\u0000\u0f74\u0000\u0f9f\u0000\u0fca\u0000\u0ff5\u0000\u1020\u0000\u104b\u0000\u1076\u0000\u10a1\u0000\u10cc\u0000\u10f7\u0000\u1122\u0000\u114d\u0000\u1178\u0000\u11a3\u0000\u11ce\u0000\u11f9\u0000\u1224\u0000\u124f\u0000\u127a\u0000\u12a5\u0000\u12d0";
    private static final int[] ZZ_TRANS = ExtendedWhitespaceTokenizerImpl.zzUnpackTrans();
    private static final String ZZ_TRANS_PACKED_0 = "\u0002\u0002\u0001\u0003\u0001\u0004\u0002\u0002\u0001\u0005\u0003\u0006\u0001\u0004\u0001\u0002\u0001\u0007\u0001\u0006\u0001\u0004\u0001\u0002\u0001\b\u0001\u0002\u0001\u0006\u0005\b\u0001\t\u0001\b\u0001\n\u0002\b\u0001\u000b\t\b\u0001\u0004\u0001\b\u0001\f-\u0000\u0001\u0002,\u0000\u0001\u0004\u0006\u0000\u0001\u0004\u0003\u0000\u0001\u0004\u0018\u0000\u0001\u0004\u0007\u0000\u0001\r\u0007\u0000\u0001\r\u0003\u0000\u0001\r\u0002\u0000\u0014\r\f\u0000\u0001\u000e\u0001\u000f\u0001\u0010\u0001\u000e\u0001\u0007\u0001\u000e\u0001\u0000\u0001\u0011\u0001\u0012\u0001\u0013\u0001\u0000\u0014\u0012\u0001\u0000\u0001\u0012\u0001\u0014\u0007\u0000\u0001\u0015\u0001\u0016\u0001\u0000\u0001\u0017\u0001\u0018\u0001\u0000\u0001\u0012\u0002\u0000\u0001\u0011\u0001\u0012\u0001\u0013\u0001\u0016\u000f\u0012\u0001\u0019\u0004\u0012\u0001\u0000\u0002\u0012\u0007\u0000\u0001\u0015\u0001\u0016\u0001\u0000\u0001\u0017\u0001\u0018\u0001\u0000\u0001\u0012\u0002\u0000\u0001\u0011\u0001\u0012\u0001\u0013\u0001\u0016\u000f\u0012\u0001\u0019\u0001\u001a\u0003\u0012\u0001\u0000\u0002\u0012\u0007\u0000\u0001\u0015\u0001\u0016\u0001\u0000\u0001\u0017\u0001\u0018\u0001\u0000\u0001\u0012\u0002\u0000\u0001\u0011\u0001\u0012\u0001\u0013\u0001\u0016\u000f\u0012\u0001\u0019\u0001\u001b\u0003\u0012\u0001\u0000\u0002\u0012\u0007\u0000\u0001\u0015\u0001\u0016\u0001\u0000\u0001\u0017\u0001\u0018\u0001\u0000\u0001\u0012\u0002\u0000\u0001\u0011\u0001\u0012\u0001\u0013\u0001\u0016\u0001\u001c\u000e\u0012\u0001\u0019\u0004\u0012\u0001\u0000\u0002\u0012\u0007\u0000\u0001\u0015\u0001\u0016\u0001\u000e\u0001\u001d\u0001\u001e\u0001\u000e\u0001\u0014\u0001\u000e\u0001\u0000\u0001\u0011\u0001\u0012\u0001\u0013\u0001\u0016\u000f\u0012\u0001\u0019\u0004\u0012\u0001\u0000\u0001\u0012\u0001\u0014\u0005\u0000\u0001\r\u0007\u0000\u0001\r\u0001\u0000\u0001\u001f\u0001\u0000\u0001\r\u0002\u0000\u0014\r\u0010\u0000\u0001 \u001c\u0000\u0001 \n\u0000\u0001\u0013\u0001!\u0001\u0000\u0001\"\u0002\u0000\u0001\u0011\u0002\u0013\u0001\u0000\u0014\u0013\u0001\u0000\u0001\u0013\u0001\"\r\u0000\u0001\"\u0003\u0000\u0001#\u0002\u0000\u0001$\u0001%\u0001&\u0001#\u0001'\u0001#\u0001(\u0001#\u0001)\u0001#\u0001*\u0001+\u0001,\u0007#\u0001\u0000\u0001#\u0001-\r\u0000\u0001.\u0003\u0000\u0001.\u0002\u0000\u0014.\u0001\u0000\u0002.\u0007\u0000\u0001\u0015\u0001\u0016\u0001\u0000\u0001\u0017\u0001!\u0001\u0000\u0001\u0012\u0002\u0000\u0001\u0011\u0001\u0012\u0001\u0013\u0001\u0016\u000f\u0012\u0001\u0019\u0004\u0012\u0001\u0000\u0002\u0012\n\u0000\u0001\u0013\u0001!\u0001\u0000\u0001\u0013\u0002\u0000\u0001\u0011\u0002\u0013\u0001\u0000\u0014\u0013\u0001\u0000\u0002\u0013\u0007\u0000\u0001\u0015\u0001\u0016\u0001\u000e\u0001\u001d\u0001\u0010\u0001\u000e\u0001\u0014\u0001\u000e\u0001\u0000\u0001\u0011\u0001\u0012\u0001\u0013\u0001\u0016\u000f\u0012\u0001\u0019\u0004\u0012\u0001\u0000\u0001\u0012\u0001\u0014\r\u0000\u0001\u0015\u0003\u0000\u0001/\u0002\u0000\u0014/\u0001\u0000\u0002/\u0011\u0000\u00010\u0002\u0000\u00140\u0001\u0000\u00020\n\u0000\u0001\u0013\u0001!\u0001\u0000\u0001\u0017\u0002\u0000\u0001\u0011\u00011\u0001\u0013\u0001\u0000\u00141\u0001\u0000\u00021\r\u0000\u0001\u0013\u0003\u0000\u00012\u0002\u0000\u00013\u00014\u00015\u00012\u00016\u00012\u00017\u00012\u00018\u00012\u00019\u0001:\u0001;\u00072\u0001\u0000\u00022\u0007\u0000\u0001\u0015\u0001<\u0001\u0000\u0001\u0017\u0001!\u0001\u0000\u0001\u0012\u0002\u0000\u0001\u0011\u0001\u0012\u0001\u0013\u0001<\u000f\u0012\u0001\u0019\u0004\u0012\u0001\u0000\u0002\u0012\u0007\u0000\u0001\u0015\u0001\u0016\u0001\u0000\u0001\u0017\u0001!\u0001\u0000\u0001\u0012\u0002\u0000\u0001\u0011\u0001\u0012\u0001\u0013\u0001\u0016\r\u0012\u0001=\u0001\u0012\u0001\u0019\u0004\u0012\u0001\u0000\u0002\u0012\u0007\u0000\u0001\u0015\u0001\u0016\u0001\u0000\u0001\u0017\u0001!\u0001\u0000\u0001\u0012\u0002\u0000\u0001\u0011\u0001\u0012\u0001\u0013\u0001\u0016\u000f\u0012\u0001\u0019\u0001>\u0003\u0012\u0001\u0000\u0002\u0012\u0007\u0000\u0001\u0015\u0001\u0016\u0001\u0000\u0001\u0017\u0001!\u0001\u0000\u0001\u0012\u0002\u0000\u0001\u0011\u0001\u0012\u0001\u0013\u0001\u0016\b\u0012\u0001?\u0006\u0012\u0001\u0019\u0004\u0012\u0001\u0000\u0002\u0012\n\u0000\u0001\u0013\u0001!\u0001\u0000\u0001@\u0002\u0000\u0001\u0011\u00011\u0001\u0013\u0001\u0000\u00141\u0001\u0000\u00011\u0001A\r\u0000\u0001\"\u0003\u0000\u00012\u0002\u0000\u00013\u00014\u00015\u00012\u00016\u00012\u00017\u00012\u00018\u00012\u00019\u0001:\u0001;\u00072\u0001\u0000\u00012\u0001B\t\u0000\u0004\u000e\u0001 \u0001\u000e\u001b\u0000\u0001 \r\u0000\u0001\u0013\u0003\u0000\u0001#\u0002\u0000\u0001$\u0001%\u0001&\u0001#\u0001'\u0001#\u0001(\u0001#\u0001)\u0001#\u0001*\u0001+\u0001,\u0007#\u0001\u0000\u0002#\t\u0000\u0001\u000e\u0001\u000f\u0001\u0010\u0001\u000e\u0001\"\u0001\u000e\u0001\u0000\u0001\u0011\u0002\u0013\u0001\u0000\u0014\u0013\u0001\u0000\u0001\u0013\u0001\"\n\u0000\u0001\u0013\u0001!\u0001\u0000\u0001\u0013\u0002\u0000\u0001\u0011\u0001C\u0001\u0013\u0001\u0000\u0014C\u0001\u0000\u0002C\n\u0000\u0001\u0013\u0001!\u0001\u0000\u0001\u0013\u0002\u0000\u0001\u0011\u0001C\u0001\u0013\u0001\u0000\u000eC\u0001D\u0005C\u0001\u0000\u0002C\n\u0000\u0001\u0013\u0001!\u0001\u0000\u0001\u0013\u0002\u0000\u0001\u0011\u0001C\u0001\u0013\u0001\u0000\bC\u0001E\u000bC\u0001\u0000\u0002C\n\u0000\u0001\u0013\u0001!\u0001\u0000\u0001\u0013\u0002\u0000\u0001\u0011\u0001C\u0001\u0013\u0001\u0000\fC\u0001F\u0007C\u0001\u0000\u0002C\n\u0000\u0001\u0013\u0001!\u0001\u0000\u0001\u0013\u0002\u0000\u0001\u0011\u0001C\u0001\u0013\u0001\u0000\u0003C\u0001G\u0010C\u0001\u0000\u0002C\n\u0000\u0001\u0013\u0001!\u0001\u0000\u0001\u0013\u0002\u0000\u0001\u0011\u0001C\u0001\u0013\u0001\u0000\fC\u0001H\u0007C\u0001\u0000\u0002C\n\u0000\u0001\u0013\u0001!\u0001\u0000\u0001\u0013\u0002\u0000\u0001\u0011\u0001C\u0001\u0013\u0001\u0000\u000bC\u0001I\bC\u0001\u0000\u0002C\n\u0000\u0001\u0013\u0001!\u0001\u0000\u0001\u0013\u0002\u0000\u0001\u0011\u0001C\u0001\u0013\u0001\u0000\bC\u0001J\u000bC\u0001\u0000\u0002C\n\u0000\u0001\u0013\u0001!\u0001\u0000\u0001\u0013\u0002\u0000\u0001\u0011\u0001C\u0001\u0013\u0001\u0000\u0004C\u0001K\u000fC\u0001\u0000\u0002C\n\u0000\u0001\u0013\u0001!\u0001\u0000\u0001\u0013\u0002\u0000\u0001\u0011\u0001C\u0001\u0013\u0001\u0000\u000eC\u0001L\u0005C\u0001\u0000\u0002C\t\u0000\u0001\u000e\u0001\u000f\u0001\u0010\u0001\u000e\u0001\"\u0001\u000e\u0001\u0000\u0001\u0011\u0001C\u0001\u0013\u0001\u0000\u0014C\u0001\u0000\u0001C\u0001M\n\u0000\u0001.\u0001\u0011\u0001\u0000\u0001.\u0003\u0000\u0002.\u0001\u0000\u0014.\u0001\u0000\u0002.\u0007\u0000\u0001\u0015\u0001N\u0004\u0000\u0001/\u0003\u0000\u0001/\u0001\u0000\u0001N\u0014/\u0001\u0000\u0002/\u0007\u0000\u0001\u0015\u0001\u0016\u0001\u0000\u0001O\u0002\u0000\u00010\u0003\u0000\u00010\u0001\u0000\u0001\u0016\u000f0\u0001P\u00040\u0001\u0000\u00020\b\u0000\u0001Q\u0001\u0000\u0001\u0017\u0001!\u0001\u0000\u00011\u0002\u0000\u0001\u0011\u00011\u0001\u0013\u0001Q\u00141\u0001\u0000\u00021\n\u0000\u0001\u0013\u0001R\u0001\u0000\u0001\u0013\u0002\u0000\u0001\u0011\u0001C\u0001\u0013\u0001\u0000\u0014C\u0001\u0000\u0002C\n\u0000\u0001\u0013\u0001R\u0001\u0000\u0001\u0013\u0002\u0000\u0001\u0011\u0001C\u0001\u0013\u0001\u0000\u000eC\u0001D\u0005C\u0001\u0000\u0002C\n\u0000\u0001\u0013\u0001R\u0001\u0000\u0001\u0013\u0002\u0000\u0001\u0011\u0001C\u0001\u0013\u0001\u0000\bC\u0001E\u000bC\u0001\u0000\u0002C\n\u0000\u0001\u0013\u0001R\u0001\u0000\u0001\u0013\u0002\u0000\u0001\u0011\u0001C\u0001\u0013\u0001\u0000\fC\u0001F\u0007C\u0001\u0000\u0002C\n\u0000\u0001\u0013\u0001R\u0001\u0000\u0001\u0013\u0002\u0000\u0001\u0011\u0001C\u0001\u0013\u0001\u0000\u0003C\u0001G\u0010C\u0001\u0000\u0002C\n\u0000\u0001\u0013\u0001R\u0001\u0000\u0001\u0013\u0002\u0000\u0001\u0011\u0001C\u0001\u0013\u0001\u0000\fC\u0001H\u0007C\u0001\u0000\u0002C\n\u0000\u0001\u0013\u0001R\u0001\u0000\u0001\u0013\u0002\u0000\u0001\u0011\u0001C\u0001\u0013\u0001\u0000\u000bC\u0001I\bC\u0001\u0000\u0002C\n\u0000\u0001\u0013\u0001R\u0001\u0000\u0001\u0013\u0002\u0000\u0001\u0011\u0001C\u0001\u0013\u0001\u0000\bC\u0001J\u000bC\u0001\u0000\u0002C\n\u0000\u0001\u0013\u0001R\u0001\u0000\u0001\u0013\u0002\u0000\u0001\u0011\u0001C\u0001\u0013\u0001\u0000\u0004C\u0001K\u000fC\u0001\u0000\u0002C\n\u0000\u0001\u0013\u0001R\u0001\u0000\u0001\u0013\u0002\u0000\u0001\u0011\u0001C\u0001\u0013\u0001\u0000\u000eC\u0001L\u0005C\u0001\u0000\u0002C\u0007\u0000\u0001\u0015\u0001\u0016\u0001\u0000\u0001\u0017\u0001!\u0001\u0000\u0001\u0012\u0001S\u0001\u0000\u0001\u0011\u0001\u0012\u0001\u0013\u0001\u0016\u000f\u0012\u0001\u0019\u0004\u0012\u0001\u0000\u0002\u0012\u0007\u0000\u0001\u0015\u0001\u0016\u0001\u0000\u0001\u0017\u0001!\u0001\u0000\u0001\u0012\u0002\u0000\u0001\u0011\u0001\u0012\u0001\u0013\u0001\u0016\r\u0012\u0001T\u0001\u0012\u0001\u0019\u0004\u0012\u0001\u0000\u0002\u0012\u0007\u0000\u0001\u0015\u0001\u0016\u0001\u0000\u0001\u0017\u0001!\u0001\u0000\u0001\u0012\u0002\u0000\u0001\u0011\u0001\u0012\u0001\u0013\u0001\u0016\t\u0012\u0001U\u0005\u0012\u0001\u0019\u0004\u0012\u0001\u0000\u0002\u0012\t\u0000\u0001\u000e\u0001\u000f\u0001\u0010\u0001\u000e\u0001@\u0001\u000e\u0001\u0000\u0001\u0011\u00011\u0001\u0013\u0001\u0000\u00141\u0001\u0000\u00011\u0001A\b\u0000\u0001Q\u0001\u000e\u0001\u001d\u0001\u0010\u0001\u000e\u0001A\u0001\u000e\u0001\u0000\u0001\u0011\u00011\u0001\u0013\u0001Q\u00141\u0001\u0000\u00011\u0001A\t\u0000\u0001\u000e\u0001\u000f\u0001V\u0001\u000e\u0001\"\u0001\u000e\u0001\u0000\u0001\u0011\u0001C\u0001\u0013\u0001\u0000\u0014C\u0001\u0000\u0001C\u0001M\u0004\u0000\u0006W\u0001X\u0001Y\u0001W\u0001X\u0002W\u0001Z\u0002X\u0001\u0000\u0014X\u0001\u0000\u0002X\u0004\u0000\u0006W\u0001X\u0001Y\u0001W\u0001X\u0002W\u0001Z\u0002X\u0001\u0000\rX\u0001[\u0006X\u0001\u0000\u0002X\u0004\u0000\u0006W\u0001X\u0001Y\u0001W\u0001X\u0002W\u0001Z\u0002X\u0001\u0000\u0013X\u0001C\u0001\u0000\u0002X\u0004\u0000\u0006W\u0001X\u0001Y\u0001W\u0001X\u0002W\u0001Z\u0002X\u0001\u0000\nX\u0001C\tX\u0001\u0000\u0002X\u0004\u0000\u0006W\u0001X\u0001Y\u0001W\u0001X\u0002W\u0001Z\u0002X\u0001\u0000\u0011X\u0001C\u0002X\u0001\u0000\u0002X\u0004\u0000\u0006W\u0001X\u0001Y\u0001W\u0001X\u0002W\u0001Z\u0002X\u0001\u0000\u0012X\u0001C\u0001X\u0001\u0000\u0002X\u0004\u0000\u0006W\u0001X\u0001Y\u0001W\u0001X\u0002W\u0001Z\u0002X\u0001\u0000\u0005X\u0001\\\u000eX\u0001\u0000\u0002X\u0004\u0000\u0006W\u0001X\u0001Y\u0001W\u0001X\u0002W\u0001Z\u0002X\u0001\u0000\tX\u0001C\nX\u0001\u0000\u0002X\u0004\u0000\u0006W\u0001X\u0001Y\u0001W\u0001X\u0002W\u0001Z\u0002X\u0001\u0000\u0010X\u0001C\u0003X\u0001\u0000\u0002X\u0004\u0000\u0006W\u0001X\u0001Y\u0001W\u0001X\u0002W\u0001Z\u0002X\u0001\u0000\u0006X\u0001C\rX\u0001\u0000\u0002X\u0004\u0000\u0005W\u0001]\u0001^\u0001_\u0001]\u0001M\u0001]\u0001W\u0001Z\u0002X\u0001\u0000\u0014X\u0001\u0000\u0001X\u0001M\u0011\u0000\u0001/\u0002\u0000\u0014/\u0001\u0000\u0002/\r\u0000\u0001O\u0003\u0000\u0001`\u0002\u0000\u0014`\u0001\u0000\u0002`\u0007\u0000\u0001\u0015\u0001<\u0001\u0000\u0001O\u0002\u0000\u00010\u0003\u0000\u00010\u0001\u0000\u0001<\u000f0\u0001P\u00040\u0001\u0000\u00020\u0011\u0000\u0001`\u0002\u0000\u0014`\u0001\u0000\u0002`\f\u0000\u0001a%\u0000\u0001\u0015\u0001\u0016\u0001\u0000\u0001\u0017\u0001!\u0001\u0000\u0001\u0012\u0001S\u0001\u0000\u0001\u0011\u0001\u0012\u0001\u0013\u0001\u0016\u000f\u0012\u0001b\u0004\u0012\u0001\u0000\u0002\u0012\u0007\u0000\u0001\u0015\u0001\u0016\u0001\u0000\u0001\u0017\u0001!\u0001\u0000\u0001\u0012\u0002\u0000\u0001\u0011\u0001\u0012\u0001\u0013\u0001\u0016\u000f\u0012\u0001\u0019\u0001c\u0003\u0012\u0001\u0000\u0002\u0012\u0004\u0000\u000fW\u0001\u0000\u0014W\u0001\u0000\u0002W\u0004\u0000\tW\u0001X\u0003W\u0001d\u0001W\u0001\u0000\u0001e\u0001f\u0001g\u0001d\u0001h\u0001d\u0001i\u0001d\u0001j\u0001d\u0001k\u0001l\u0001m\u0007d\u0001\u0000\u0002d\u0004\u0000\tW\u0001n\u0003W\u0001n\u0001W\u0001\u0000\u0014n\u0001\u0000\u0002n\u0004\u0000\u0006W\u0001X\u0001Y\u0001W\u0001X\u0002W\u0001Z\u0002X\u0001\u0000\u0001C\u0013X\u0001\u0000\u0002X\u0004\u0000\u0006W\u0001X\u0001Y\u0001W\u0001X\u0002W\u0001Z\u0002X\u0001\u0000\fX\u0001C\u0007X\u0001\u0000\u0002X\u0004\u0000\tW\u0001o\u0005W\u0001\u0000\u0014W\u0001\u0000\u0001W\u0001o\u0004\u0000\u0006W\u0001X\u0001Y\u0001W\u0001M\u0002W\u0001Z\u0002X\u0001\u0000\u0014X\u0001\u0000\u0001X\u0001M\u0004\u0000\tW\u0001M\u0003W\u0001d\u0001W\u0001\u0000\u0001e\u0001f\u0001g\u0001d\u0001h\u0001d\u0001i\u0001d\u0001j\u0001d\u0001k\u0001l\u0001m\u0007d\u0001\u0000\u0001d\u0001p\b\u0000\u0001Q\u0001\u0000\u0001O\u0002\u0000\u0001`\u0003\u0000\u0001`\u0001\u0000\u0001Q\u0014`\u0001\u0000\u0002`\f\u0000\u0001q%\u0000\u0001\u0015\u0001<\u0001\u0000\u0001\u0017\u0001!\u0001\u0000\u0001\u0012\u0001S\u0001\u0000\u0001\u0011\u0001\u0012\u0001\u0013\u0001<\u000f\u0012\u0001\u0019\u0004\u0012\u0001\u0000\u0002\u0012\u0007\u0000\u0001\u0015\u0001\u0016\u0001\u0000\u0001\u0017\u0001!\u0001\u0000\u0001\u0012\u0002\u0000\u0001\u0011\u0001\u0012\u0001\u0013\u0001\u0016\f\u0012\u0001r\u0002\u0012\u0001\u0019\u0004\u0012\u0001\u0000\u0002\u0012\u0004\u0000\u0006W\u0001X\u0001Y\u0001W\u0001X\u0002W\u0001Z\u0001C\u0001X\u0001\u0000\u0014C\u0001\u0000\u0002C\u0004\u0000\u0006W\u0001X\u0001Y\u0001W\u0001X\u0002W\u0001Z\u0001C\u0001X\u0001\u0000\u000eC\u0001D\u0005C\u0001\u0000\u0002C\u0004\u0000\u0006W\u0001X\u0001Y\u0001W\u0001X\u0002W\u0001Z\u0001C\u0001X\u0001\u0000\bC\u0001E\u000bC\u0001\u0000\u0002C\u0004\u0000\u0006W\u0001X\u0001Y\u0001W\u0001X\u0002W\u0001Z\u0001C\u0001X\u0001\u0000\fC\u0001F\u0007C\u0001\u0000\u0002C\u0004\u0000\u0006W\u0001X\u0001Y\u0001W\u0001X\u0002W\u0001Z\u0001C\u0001X\u0001\u0000\u0003C\u0001G\u0010C\u0001\u0000\u0002C\u0004\u0000\u0006W\u0001X\u0001Y\u0001W\u0001X\u0002W\u0001Z\u0001C\u0001X\u0001\u0000\fC\u0001H\u0007C\u0001\u0000\u0002C\u0004\u0000\u0006W\u0001X\u0001Y\u0001W\u0001X\u0002W\u0001Z\u0001C\u0001X\u0001\u0000\u000bC\u0001I\bC\u0001\u0000\u0002C\u0004\u0000\u0006W\u0001X\u0001Y\u0001W\u0001X\u0002W\u0001Z\u0001C\u0001X\u0001\u0000\bC\u0001J\u000bC\u0001\u0000\u0002C\u0004\u0000\u0006W\u0001X\u0001Y\u0001W\u0001X\u0002W\u0001Z\u0001C\u0001X\u0001\u0000\u0004C\u0001K\u000fC\u0001\u0000\u0002C\u0004\u0000\u0006W\u0001X\u0001Y\u0001W\u0001X\u0002W\u0001Z\u0001C\u0001X\u0001\u0000\u000eC\u0001L\u0005C\u0001\u0000\u0002C\u0004\u0000\u0006W\u0001n\u0001Z\u0001W\u0001n\u0003W\u0002n\u0001\u0000\u0014n\u0001\u0000\u0002n\u0004\u0000\u0005W\u0004]\u0001o\u0001]\u0004W\u0001\u0000\u0014W\u0001\u0000\u0001W\u0001o\u0004\u0000\u0005W\u0001]\u0001^\u0001_\u0001]\u0001M\u0001]\u0001W\u0001Z\u0001C\u0001X\u0001\u0000\u0014C\u0001\u0000\u0001C\u0001M\r\u0000\u0001s\u0003\u0000\u0001s\u0002\u0000\u0014s\u0001\u0000\u0002s\u0007\u0000\u0001\u0015\u0001\u0016\u0001\u0000\u0001\u0017\u0001!\u0001\u0000\u0001\u0012\u0001t\u0001\u0000\u0001\u0011\u0001\u0012\u0001\u0013\u0001\u0016\u000f\u0012\u0001\u0019\u0004\u0012\u0001\u0000\u0002\u0012\n\u0000\u0001s\u0001u\u0001\u0000\u0001s\u0003\u0000\u0002s\u0001\u0000\u0014s\u0001\u0000\u0002s\r\u0000\u0001v\u0003\u0000\u0001v\u0002\u0000\u0014v\u0001\u0000\u0002v\r\u0000\u0001s\u0003\u0000\u0001w\u0002\u0000\u0014w\u0001\u0000\u0002w\n\u0000\u0001v\u0001t\u0001\u0000\u0001v\u0002\u0000\u0001\u0011\u0002v\u0001\u0000\u0014v\u0001\u0000\u0002v\n\u0000\u0001s\u0001u\u0001\u0000\u0001s\u0003\u0000\u0001W\u0001s\u0001\u0000\u0014W\u0001\u0000\u0002W\u0001\u0000";
    private static final int ZZ_UNKNOWN_ERROR = 0;
    private static final int ZZ_NO_MATCH = 1;
    private static final int ZZ_PUSHBACK_2BIG = 2;
    private static final String[] ZZ_ERROR_MSG = new String[]{"Unknown internal scanner error", "Error: could not match input", "Error: pushback value was too large"};
    private static final int[] ZZ_ATTRIBUTE = ExtendedWhitespaceTokenizerImpl.zzUnpackAttribute();
    private static final String ZZ_ATTRIBUTE_PACKED_0 = "\u0001\u0000\u0001\t\u0003\u0001\u0001\t\u0006\u0001\u0002\u0000\u0001\u0001\u0002\u0000\u0003\u0001\u0002\u0000\b\u0001\u0001\t\u0001\u0001\u0001\u0000,\u0001\u0002\u0000\u0001\u0001\u0001\u0000\u0001\u0001\u0001\u0000\r\u0001\u0001\u0000\u000f\u0001\u0001\u0000\u0001\u0001\u0005\u0000";
    private Reader zzReader;
    private int zzState;
    private int zzLexicalState = 0;
    private char[] zzBuffer = new char[16384];
    private int zzMarkedPos;
    private int zzCurrentPos;
    private int zzStartRead;
    private int zzEndRead;
    private boolean zzAtEOF;
    private int zzFinalHighSurrogate = 0;
    private int yyline;
    private int yycolumn;
    private long yychar;
    private boolean zzAtBOL = true;
    private boolean zzEOFDone;

    private static int[] zzUnpackcmap_top() {
        int[] result = new int[4352];
        int offset = 0;
        offset = ExtendedWhitespaceTokenizerImpl.zzUnpackcmap_top(ZZ_CMAP_TOP_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackcmap_top(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackcmap_blocks() {
        int[] result = new int[4352];
        int offset = 0;
        offset = ExtendedWhitespaceTokenizerImpl.zzUnpackcmap_blocks(ZZ_CMAP_BLOCKS_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackcmap_blocks(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackAction() {
        int[] result = new int[119];
        int offset = 0;
        offset = ExtendedWhitespaceTokenizerImpl.zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAction(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackRowMap() {
        int[] result = new int[119];
        int offset = 0;
        offset = ExtendedWhitespaceTokenizerImpl.zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackRowMap(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int high = packed.charAt(i++) << 16;
            result[j++] = high | packed.charAt(i++);
        }
        return j;
    }

    private static int[] zzUnpackTrans() {
        int[] result = new int[4859];
        int offset = 0;
        offset = ExtendedWhitespaceTokenizerImpl.zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackTrans(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            int value = packed.charAt(i++);
            do {
                result[j++] = --value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackAttribute() {
        int[] result = new int[119];
        int offset = 0;
        offset = ExtendedWhitespaceTokenizerImpl.zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAttribute(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    public final int yychar() {
        return Math.toIntExact(this.yychar);
    }

    final char[] yybuffer() {
        return this.zzBuffer;
    }

    final int yystart() {
        return this.zzStartRead;
    }

    public ExtendedWhitespaceTokenizerImpl(Reader in) {
        this.zzReader = in;
    }

    private static int zzCMap(int input) {
        int offset = input & 0xFF;
        return offset == input ? ZZ_CMAP_BLOCKS[offset] : ZZ_CMAP_BLOCKS[ZZ_CMAP_TOP[input >> 8] | offset];
    }

    private boolean zzRefill() throws IOException {
        int requested;
        int numRead;
        if (this.zzStartRead > 0) {
            this.zzEndRead += this.zzFinalHighSurrogate;
            this.zzFinalHighSurrogate = 0;
            System.arraycopy(this.zzBuffer, this.zzStartRead, this.zzBuffer, 0, this.zzEndRead - this.zzStartRead);
            this.zzEndRead -= this.zzStartRead;
            this.zzCurrentPos -= this.zzStartRead;
            this.zzMarkedPos -= this.zzStartRead;
            this.zzStartRead = 0;
        }
        if (this.zzCurrentPos >= this.zzBuffer.length - this.zzFinalHighSurrogate) {
            char[] newBuffer = new char[this.zzBuffer.length * 2];
            System.arraycopy(this.zzBuffer, 0, newBuffer, 0, this.zzBuffer.length);
            this.zzBuffer = newBuffer;
            this.zzEndRead += this.zzFinalHighSurrogate;
            this.zzFinalHighSurrogate = 0;
        }
        if ((numRead = this.zzReader.read(this.zzBuffer, this.zzEndRead, requested = this.zzBuffer.length - this.zzEndRead)) == 0) {
            throw new IOException("Reader returned 0 characters. See JFlex examples/zero-reader for a workaround.");
        }
        if (numRead > 0) {
            this.zzEndRead += numRead;
            if (Character.isHighSurrogate(this.zzBuffer[this.zzEndRead - 1])) {
                if (numRead == requested) {
                    --this.zzEndRead;
                    this.zzFinalHighSurrogate = 1;
                } else {
                    int c = this.zzReader.read();
                    if (c == -1) {
                        return true;
                    }
                    this.zzBuffer[this.zzEndRead++] = (char)c;
                }
            }
            return false;
        }
        return true;
    }

    public final void yyclose() throws IOException {
        this.zzAtEOF = true;
        this.zzEndRead = this.zzStartRead;
        if (this.zzReader != null) {
            this.zzReader.close();
        }
    }

    public final void yyreset(Reader reader) {
        this.zzReader = reader;
        this.zzEOFDone = false;
        this.yyResetPosition();
        this.zzLexicalState = 0;
        if (this.zzBuffer.length > 16384) {
            this.zzBuffer = new char[16384];
        }
    }

    private final void yyResetPosition() {
        this.zzAtBOL = true;
        this.zzAtEOF = false;
        this.zzCurrentPos = 0;
        this.zzMarkedPos = 0;
        this.zzStartRead = 0;
        this.zzEndRead = 0;
        this.zzFinalHighSurrogate = 0;
        this.yyline = 0;
        this.yycolumn = 0;
        this.yychar = 0L;
    }

    public final boolean yyatEOF() {
        return this.zzAtEOF;
    }

    public final int yystate() {
        return this.zzLexicalState;
    }

    public final void yybegin(int newState) {
        this.zzLexicalState = newState;
    }

    public final String yytext() {
        return new String(this.zzBuffer, this.zzStartRead, this.zzMarkedPos - this.zzStartRead);
    }

    public final char yycharat(int position) {
        return this.zzBuffer[this.zzStartRead + position];
    }

    public final int yylength() {
        return this.zzMarkedPos - this.zzStartRead;
    }

    private static void zzScanError(int errorCode) {
        String message;
        try {
            message = ZZ_ERROR_MSG[errorCode];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            message = ZZ_ERROR_MSG[0];
        }
        throw new Error(message);
    }

    public void yypushback(int number) {
        if (number > this.yylength()) {
            ExtendedWhitespaceTokenizerImpl.zzScanError(2);
        }
        this.zzMarkedPos -= number;
    }

    public int getNextToken() throws IOException {
        int zzEndReadL = this.zzEndRead;
        char[] zzBufferL = this.zzBuffer;
        int[] zzTransL = ZZ_TRANS;
        int[] zzRowMapL = ZZ_ROWMAP;
        int[] zzAttrL = ZZ_ATTRIBUTE;
        block26: while (true) {
            int zzInput;
            int zzMarkedPosL = this.zzMarkedPos;
            this.yychar += (long)(zzMarkedPosL - this.zzStartRead);
            int zzAction = -1;
            this.zzCurrentPos = this.zzStartRead = zzMarkedPosL;
            int zzCurrentPosL = this.zzStartRead;
            this.zzState = ZZ_LEXSTATE[this.zzLexicalState];
            int zzAttributes = zzAttrL[this.zzState];
            if ((zzAttributes & 1) == 1) {
                zzAction = this.zzState;
            }
            while (true) {
                if (zzCurrentPosL < zzEndReadL) {
                    zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
                    zzCurrentPosL += Character.charCount(zzInput);
                } else {
                    if (this.zzAtEOF) {
                        zzInput = -1;
                        break;
                    }
                    this.zzCurrentPos = zzCurrentPosL;
                    this.zzMarkedPos = zzMarkedPosL;
                    boolean eof = this.zzRefill();
                    zzCurrentPosL = this.zzCurrentPos;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    zzEndReadL = this.zzEndRead;
                    if (eof) {
                        zzInput = -1;
                        break;
                    }
                    zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
                    zzCurrentPosL += Character.charCount(zzInput);
                }
                int zzNext = zzTransL[zzRowMapL[this.zzState] + ExtendedWhitespaceTokenizerImpl.zzCMap(zzInput)];
                if (zzNext == -1) break;
                this.zzState = zzNext;
                zzAttributes = zzAttrL[this.zzState];
                if ((zzAttributes & 1) != 1) continue;
                zzAction = this.zzState;
                zzMarkedPosL = zzCurrentPosL;
                if ((zzAttributes & 8) == 8) break;
            }
            this.zzMarkedPos = zzMarkedPosL;
            if (zzInput == -1 && this.zzStartRead == this.zzCurrentPos) {
                this.zzAtEOF = true;
                return -1;
            }
            switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
                case 1: {
                    continue block26;
                }
                case 13: {
                    continue block26;
                }
                case 2: {
                    return 259;
                }
                case 14: {
                    continue block26;
                }
                case 3: {
                    return 3;
                }
                case 15: {
                    continue block26;
                }
                case 4: {
                    return 2;
                }
                case 16: {
                    continue block26;
                }
                case 5: {
                    return 1;
                }
                case 17: {
                    continue block26;
                }
                case 6: {
                    return 8;
                }
                case 18: {
                    continue block26;
                }
                case 7: {
                    continue block26;
                }
                case 19: {
                    continue block26;
                }
                case 8: {
                    return 4;
                }
                case 20: {
                    continue block26;
                }
                case 9: {
                    return 5;
                }
                case 21: {
                    continue block26;
                }
                case 10: {
                    return 9;
                }
                case 22: {
                    continue block26;
                }
                case 11: {
                    return 7;
                }
                case 23: {
                    continue block26;
                }
                case 12: {
                    return 6;
                }
                case 24: {
                    continue block26;
                }
            }
            ExtendedWhitespaceTokenizerImpl.zzScanError(1);
        }
    }
}

