/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.measure;

import java.math.RoundingMode;
import java.text.AttributedCharacterIterator;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Locale;
import java.util.Objects;
import org.apache.sis.internal.util.LocalizedParseException;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.math.DecimalFunctions;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.measure.Angle;
import org.apache.sis.measure.FormatField;
import org.apache.sis.measure.FormattedCharacterIterator;
import org.apache.sis.measure.Latitude;
import org.apache.sis.measure.Longitude;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Localized;
import org.apache.sis.util.resources.Errors;

public class AngleFormat
extends Format
implements Localized {
    private static final long serialVersionUID = 820524050016391537L;
    private static final char NORTH = 'N';
    private static final char SOUTH = 'S';
    private static final char EAST = 'E';
    private static final char WEST = 'W';
    private static final int PREFIX_FIELD = -1;
    static final int DEGREES_FIELD = 0;
    static final int MINUTES_FIELD = 1;
    static final int SECONDS_FIELD = 2;
    private static final int FRACTION_FIELD = 3;
    static final int HEMISPHERE_FIELD = 4;
    private static final int OPTIONAL_FIELD = 4;
    private static final int[] SYMBOLS = new int[]{68, 77, 83, 35, 63};
    private final Locale locale;
    private byte degreesFieldWidth;
    private byte minutesFieldWidth;
    private byte secondsFieldWidth;
    private byte fractionFieldWidth;
    private byte minimumFractionDigits;
    private byte maximumTotalWidth;
    private byte optionalFields;
    private String prefix;
    private String degreesSuffix;
    private String minutesSuffix;
    private String secondsSuffix;
    private RoundingMode roundingMode;
    private boolean isFallbackAllowed = true;
    private boolean useDecimalSeparator;
    private transient boolean showLeadingFields;
    private transient NumberFormat numberFormat;
    private transient FieldPosition dummyFieldPosition;
    private transient FormattedCharacterIterator characterIterator;

    private NumberFormat numberFormat() {
        if (this.numberFormat == null) {
            this.numberFormat = new DecimalFormat("#0", DecimalFormatSymbols.getInstance(this.locale));
        }
        return this.numberFormat;
    }

    private FieldPosition dummyFieldPosition() {
        if (this.dummyFieldPosition == null) {
            this.dummyFieldPosition = new FieldPosition(0);
        }
        return this.dummyFieldPosition;
    }

    public static AngleFormat getInstance() {
        return new AngleFormat();
    }

    public static AngleFormat getInstance(Locale locale) {
        return new AngleFormat(locale);
    }

    public AngleFormat() {
        this(Locale.getDefault(Locale.Category.FORMAT));
    }

    public AngleFormat(Locale locale) {
        ArgumentChecks.ensureNonNull("locale", locale);
        this.locale = locale;
        this.degreesFieldWidth = 1;
        this.minutesFieldWidth = (byte)2;
        this.secondsFieldWidth = (byte)2;
        this.fractionFieldWidth = (byte)16;
        this.optionalFields = (byte)7;
        this.degreesSuffix = "\u00b0";
        this.minutesSuffix = "\u2032";
        this.secondsSuffix = "\u2033";
        this.useDecimalSeparator = true;
    }

    public AngleFormat(String string) throws IllegalArgumentException {
        this(string, Locale.getDefault(Locale.Category.FORMAT));
    }

    public AngleFormat(String string, Locale locale) throws IllegalArgumentException {
        ArgumentChecks.ensureNonEmpty("pattern", string);
        ArgumentChecks.ensureNonNull("locale", locale);
        this.locale = locale;
        this.applyPattern(string, SYMBOLS, 46);
    }

    public void applyPattern(String string) throws IllegalArgumentException {
        ArgumentChecks.ensureNonEmpty("pattern", string);
        this.degreesFieldWidth = 0;
        this.minutesFieldWidth = 0;
        this.secondsFieldWidth = 0;
        this.fractionFieldWidth = 0;
        this.minimumFractionDigits = 0;
        this.maximumTotalWidth = 0;
        this.optionalFields = 0;
        this.prefix = null;
        this.degreesSuffix = null;
        this.minutesSuffix = null;
        this.secondsSuffix = null;
        this.useDecimalSeparator = false;
        this.applyPattern(string, SYMBOLS, 46);
    }

    private void applyPattern(String string, int[] nArray, int n) {
        this.degreesFieldWidth = 1;
        this.useDecimalSeparator = true;
        int n2 = -1;
        int n3 = 0;
        boolean bl = false;
        int n4 = string.length();
        int n5 = 0;
        while (n5 < n4) {
            int n6;
            boolean bl2;
            int n7 = string.codePointAt(n5);
            int n8 = Character.charCount(n7);
            int n9 = Character.toUpperCase(n7);
            int n10 = AngleFormat.fieldForSymbol(nArray, n9);
            if (n10 < 0) {
                n5 += n8;
                continue;
            }
            boolean bl3 = bl2 = n7 == n9 && n10 != 3;
            if (bl2) {
                ++n2;
            }
            if (bl || n10 != n2 && n10 != 3) {
                throw AngleFormat.illegalPattern(string);
            }
            if (bl2) {
                String string2 = null;
                if (n3 < n5) {
                    n6 = n5;
                    if (string.codePointBefore(n6) == nArray[4]) {
                        if (--n6 == n3) {
                            throw AngleFormat.illegalPattern(string);
                        }
                        this.optionalFields = (byte)(this.optionalFields | 1 << n10 - 1);
                    }
                    string2 = string.substring(n3, n6);
                }
                n6 = 1;
                while ((n5 += n8) < n4 && string.codePointAt(n5) == n7) {
                    ++n6;
                }
                byte by = AngleFormat.toByte(n6);
                switch (n10) {
                    case 0: {
                        this.prefix = string2;
                        this.degreesFieldWidth = by;
                        break;
                    }
                    case 1: {
                        this.degreesSuffix = string2;
                        this.minutesFieldWidth = by;
                        break;
                    }
                    case 2: {
                        this.minutesSuffix = string2;
                        this.secondsFieldWidth = by;
                        break;
                    }
                    default: {
                        throw new AssertionError(n10);
                    }
                }
            } else {
                if (n5 == n3) {
                    this.useDecimalSeparator = false;
                } else {
                    int n11 = string.codePointAt(n3);
                    if (n11 != n || n3 + Character.charCount(n11) != n5) {
                        throw AngleFormat.illegalPattern(string);
                    }
                }
                int n12 = 1;
                while ((n5 += n8) < n4) {
                    n6 = string.codePointAt(n5);
                    if (n6 != n7) {
                        if (n6 != nArray[3]) break;
                        this.minimumFractionDigits = AngleFormat.toByte(n12);
                        n7 = n6;
                        n8 = Character.charCount(n7);
                    }
                    ++n12;
                }
                this.fractionFieldWidth = AngleFormat.toByte(n12);
                if (n7 != nArray[3]) {
                    this.minimumFractionDigits = this.fractionFieldWidth;
                } else if (!this.useDecimalSeparator) {
                    throw new IllegalArgumentException(Errors.format((short)124));
                }
                bl = true;
            }
            n3 = n5;
        }
        if (n3 < n4) {
            n5 = n4;
            if (string.codePointBefore(n5) == nArray[4]) {
                if (--n5 == n3) {
                    throw AngleFormat.illegalPattern(string);
                }
                this.optionalFields = (byte)(this.optionalFields | 1 << n2);
            }
            String string3 = string.substring(n3, n5);
            switch (n2) {
                case 0: {
                    this.degreesSuffix = string3;
                    break;
                }
                case 1: {
                    this.minutesSuffix = string3;
                    break;
                }
                case 2: {
                    this.secondsSuffix = string3;
                    break;
                }
                default: {
                    throw AngleFormat.illegalPattern(string);
                }
            }
        }
    }

    private static int fieldForSymbol(int[] nArray, int n) {
        for (int i = 0; i <= 3; ++i) {
            if (n != nArray[i]) continue;
            return i;
        }
        return -1;
    }

    private static IllegalArgumentException illegalPattern(String string) {
        return new IllegalArgumentException(Errors.format((short)52, Angle.class, string));
    }

    public String toPattern() {
        return this.toPattern(SYMBOLS, 46);
    }

    private String toPattern(int[] nArray, int n) {
        int n2 = 0;
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i <= 3; ++i) {
            int n3;
            String string;
            switch (i) {
                case 0: {
                    string = this.prefix;
                    n3 = this.degreesFieldWidth;
                    break;
                }
                case 1: {
                    string = this.degreesSuffix;
                    n3 = this.minutesFieldWidth;
                    break;
                }
                case 2: {
                    string = this.minutesSuffix;
                    n3 = this.secondsFieldWidth;
                    break;
                }
                default: {
                    string = this.secondsSuffix;
                    n3 = 0;
                }
            }
            if (n3 == 0 && (n3 = this.fractionFieldWidth) > 0) {
                if (this.useDecimalSeparator) {
                    stringBuilder.appendCodePoint(n);
                }
                int n4 = n3 - this.minimumFractionDigits;
                n2 = Character.toLowerCase(n2);
                do {
                    if (n3 == n4) {
                        n2 = nArray[3];
                    }
                    stringBuilder.appendCodePoint(n2);
                } while (--n3 > 0);
            }
            if (string != null) {
                stringBuilder.append(string);
            }
            if (bl) {
                stringBuilder.appendCodePoint(nArray[4]);
            }
            if (n3 <= 0) break;
            n2 = nArray[i];
            do {
                stringBuilder.appendCodePoint(n2);
            } while (--n3 > 0);
            bl = (this.optionalFields & 1 << i) != 0;
        }
        return stringBuilder.toString();
    }

    private static byte toByte(int n) {
        return (byte)Math.min(n, 127);
    }

    public RoundingMode getRoundingMode() {
        return this.roundingMode != null ? this.roundingMode : RoundingMode.HALF_EVEN;
    }

    public void setRoundingMode(RoundingMode roundingMode) {
        ArgumentChecks.ensureNonNull("mode", (Object)roundingMode);
        if (roundingMode == RoundingMode.HALF_UP || roundingMode == RoundingMode.HALF_DOWN) {
            throw new IllegalArgumentException(Errors.format((short)170, (Object)roundingMode));
        }
        this.roundingMode = roundingMode;
    }

    private double round(double d, double d2) {
        if (this.roundingMode != null) {
            switch (this.roundingMode) {
                case UP: {
                    return Math.ceil(d2);
                }
                case DOWN: {
                    return Math.floor(d2);
                }
                case CEILING: {
                    return Math.abs(Math.ceil(Math.copySign(d2, d)));
                }
                case FLOOR: {
                    return Math.abs(Math.floor(Math.copySign(d2, d)));
                }
            }
        }
        return Math.rint(d2);
    }

    public double getPrecision() {
        double d = MathFunctions.pow10(-this.fractionFieldWidth);
        if (this.secondsFieldWidth != 0) {
            d /= 3600.0;
        } else if (this.minutesFieldWidth != 0) {
            d /= 60.0;
        }
        return d;
    }

    public void setPrecision(double d, boolean bl) {
        int n;
        ArgumentChecks.ensureFinite("resolution", d);
        d = Math.abs(d);
        if (d == 0.0) {
            d = 1.0E-16;
        }
        if (bl ? d >= 0.1 : this.minutesFieldWidth == 0) {
            n = 14;
            if (bl) {
                this.minutesFieldWidth = 0;
                this.secondsFieldWidth = 0;
                this.optionalFields = (byte)6;
            }
        } else {
            d = Math.nextUp(d * 60.0);
            if (bl ? d >= 0.1 : this.secondsFieldWidth == 0) {
                n = 12;
                if (bl) {
                    if (this.minutesFieldWidth == 0) {
                        this.minutesFieldWidth = (byte)2;
                    }
                    this.secondsFieldWidth = 0;
                    this.optionalFields = (byte)4;
                }
            } else {
                d = Math.nextUp(d * 60.0);
                n = 10;
                if (bl) {
                    if (this.minutesFieldWidth == 0) {
                        this.minutesFieldWidth = (byte)2;
                    }
                    if (this.secondsFieldWidth == 0) {
                        this.secondsFieldWidth = (byte)2;
                    }
                    this.optionalFields = 0;
                }
            }
        }
        int n2 = Math.max(0, DecimalFunctions.fractionDigitsForDelta(d, false));
        this.fractionFieldWidth = (byte)n2;
        this.minimumFractionDigits = (byte)Math.min(n, n2);
    }

    public int getMinimumFractionDigits() {
        return this.minimumFractionDigits;
    }

    public void setMinimumFractionDigits(int n) {
        ArgumentChecks.ensurePositive("count", n);
        if (!this.useDecimalSeparator) {
            throw new IllegalStateException(Errors.format((short)124));
        }
        this.maximumTotalWidth = 0;
        this.minimumFractionDigits = AngleFormat.toByte(n);
        if (this.minimumFractionDigits > this.fractionFieldWidth) {
            this.fractionFieldWidth = this.minimumFractionDigits;
        }
    }

    public int getMaximumFractionDigits() {
        return this.fractionFieldWidth;
    }

    public void setMaximumFractionDigits(int n) {
        ArgumentChecks.ensurePositive("count", n);
        if (!this.useDecimalSeparator) {
            throw new IllegalStateException(Errors.format((short)124));
        }
        this.maximumTotalWidth = 0;
        this.fractionFieldWidth = AngleFormat.toByte(n);
        if (this.fractionFieldWidth < this.minimumFractionDigits) {
            this.minimumFractionDigits = this.fractionFieldWidth;
        }
    }

    public void setMaximumWidth(int n) {
        ArgumentChecks.ensureStrictlyPositive("width", n);
        if (!this.useDecimalSeparator) {
            throw new IllegalStateException(Errors.format((short)124));
        }
        this.maximumTotalWidth = AngleFormat.toByte(n);
        for (int i = -1; i <= 2; ++i) {
            String string;
            int n2 = n;
            switch (i) {
                case -1: {
                    string = this.prefix;
                    break;
                }
                case 0: {
                    n -= this.degreesFieldWidth;
                    string = this.degreesSuffix;
                    break;
                }
                case 1: {
                    n -= this.minutesFieldWidth;
                    string = this.minutesSuffix;
                    break;
                }
                case 2: {
                    n -= this.secondsFieldWidth;
                    string = this.secondsSuffix;
                    break;
                }
                default: {
                    throw new AssertionError(i);
                }
            }
            if (string != null) {
                n -= string.length();
            }
            if (n >= 0) continue;
            switch (i) {
                default: {
                    n += this.degreesFieldWidth - 1;
                    this.degreesFieldWidth = 1;
                }
                case 1: {
                    this.minutesSuffix = null;
                    this.minutesFieldWidth = 0;
                }
                case 2: 
            }
            this.secondsSuffix = null;
            this.secondsFieldWidth = 0;
            if (i < 1) break;
            n = n2;
            break;
        }
        if (--n < this.fractionFieldWidth) {
            this.fractionFieldWidth = AngleFormat.toByte(Math.max(n, 0));
            if (this.fractionFieldWidth < this.minimumFractionDigits) {
                this.minimumFractionDigits = this.fractionFieldWidth;
            }
        }
    }

    private static int getField(FieldPosition fieldPosition) {
        if (fieldPosition != null) {
            Format.Field field = fieldPosition.getFieldAttribute();
            if (field instanceof Field) {
                return ((Field)field).field;
            }
            return fieldPosition.getField();
        }
        return -1;
    }

    public final String format(double d) {
        return this.format(d, new StringBuffer(), (FieldPosition)null).toString();
    }

    public StringBuffer format(double d, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        boolean bl;
        int n = stringBuffer.length();
        int n2 = AngleFormat.getField(fieldPosition);
        if (!Double.isFinite(d)) {
            stringBuffer = this.numberFormat().format(d, stringBuffer, this.dummyFieldPosition());
            if (n2 >= 0 && n2 <= 2) {
                fieldPosition.setBeginIndex(n);
                fieldPosition.setEndIndex(stringBuffer.length());
            }
            return stringBuffer;
        }
        double d2 = d;
        double d3 = Double.NaN;
        double d4 = Double.NaN;
        int n3 = this.fractionFieldWidth;
        if (this.minutesFieldWidth == 0) {
            double d5 = MathFunctions.pow10(n3);
            d2 = this.round(d, d2 * d5) / d5;
        } else {
            double d6 = d2;
            d2 = MathFunctions.truncate(d2);
            d3 = Math.abs(d6 - d2) * 60.0;
            int n4 = DecimalFunctions.fractionDigitsForDelta(Math.ulp(d) * (double)(this.secondsFieldWidth == 0 ? 60 : 3600), false);
            n3 = Math.max(this.minimumFractionDigits, Math.min(n3, n4 - 1));
            double d7 = MathFunctions.pow10(n3);
            if (this.secondsFieldWidth != 0) {
                double d8 = d3;
                d3 = MathFunctions.truncate(d3);
                d4 = (d8 - d3) * 60.0;
                if ((d4 = this.round(d, d4 * d7) / d7) >= 60.0) {
                    d4 = 0.0;
                    d3 += 1.0;
                }
            } else {
                d3 = this.round(d, d3 * d7) / d7;
            }
            if (d3 >= 60.0) {
                d3 = 0.0;
                d2 += Math.signum(d);
            }
        }
        byte by = this.optionalFields;
        if (this.showLeadingFields) {
            by = (byte)(by & 0xFFFFFFFE);
            if (d3 == 0.0 && ((by & 4) == 0 || d4 != 0.0)) {
                by = (byte)(by & 0xFFFFFFFD);
            }
        }
        int n5 = -1;
        if (this.prefix != null) {
            stringBuffer.append(this.prefix);
        }
        NumberFormat numberFormat = this.numberFormat();
        do {
            int n6;
            String string;
            int n7;
            double d9;
            switch (++n5) {
                case 0: {
                    d9 = d2;
                    n7 = this.degreesFieldWidth;
                    string = this.degreesSuffix;
                    bl = this.minutesFieldWidth != 0;
                    break;
                }
                case 1: {
                    d9 = d3;
                    n7 = this.minutesFieldWidth;
                    string = this.minutesSuffix;
                    bl = this.secondsFieldWidth != 0;
                    break;
                }
                case 2: {
                    d9 = d4;
                    n7 = this.secondsFieldWidth;
                    string = this.secondsSuffix;
                    bl = false;
                    break;
                }
                default: {
                    throw new AssertionError(n5);
                }
            }
            if (d9 == 0.0 && (by & 1 << n5) != 0) {
                switch (n5) {
                    case 0: {
                        d3 = Math.copySign(d3, d2);
                        break;
                    }
                    case 1: {
                        d4 = Math.copySign(d4, d3);
                    }
                }
                continue;
            }
            if (bl) {
                numberFormat.setMinimumIntegerDigits(n7);
                numberFormat.setMaximumFractionDigits(0);
            } else if (this.useDecimalSeparator) {
                numberFormat.setMinimumIntegerDigits(n7);
                if (this.maximumTotalWidth != 0) {
                    n6 = this.maximumTotalWidth - stringBuffer.codePointCount(n, stringBuffer.length());
                    n6 -= n7 + 1;
                    if (string != null) {
                        n7 -= string.length();
                    }
                    for (double d10 = MathFunctions.pow10(n7); d9 >= d10 && --n6 > 0; d10 *= 10.0) {
                    }
                    if (n6 < n3) {
                        n3 = Math.max(n6, 0);
                    }
                }
                numberFormat.setMinimumFractionDigits(this.minimumFractionDigits);
                numberFormat.setMaximumFractionDigits(n3);
            } else {
                d9 *= MathFunctions.pow10(this.fractionFieldWidth);
                numberFormat.setMaximumFractionDigits(0);
                numberFormat.setMinimumIntegerDigits(n7 + this.fractionFieldWidth);
            }
            n6 = stringBuffer.length();
            if (this.characterIterator != null) {
                FormattedCharacterIterator formattedCharacterIterator = this.characterIterator;
                formattedCharacterIterator.append(numberFormat.formatToCharacterIterator(d9), stringBuffer);
                if (string != null) {
                    stringBuffer.append(string);
                }
                Number number = bl ? (Number)Math.toIntExact(Math.round(d9)) : (Number)Float.valueOf((float)d9);
                formattedCharacterIterator.addFieldLimit(Field.forCode(n5), number, n6);
            } else {
                stringBuffer = numberFormat.format(d9, stringBuffer, this.dummyFieldPosition());
                if (string != null) {
                    stringBuffer.append(string);
                }
            }
            if (n5 != n2) continue;
            fieldPosition.setBeginIndex(n6);
            fieldPosition.setEndIndex(stringBuffer.length());
        } while (bl);
        return stringBuffer;
    }

    @Override
    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) throws IllegalArgumentException {
        if (object instanceof Latitude) {
            return this.format(((Latitude)object).degrees(), stringBuffer, fieldPosition, 'N', 'S');
        }
        if (object instanceof Longitude) {
            return this.format(((Longitude)object).degrees(), stringBuffer, fieldPosition, 'E', 'W');
        }
        if (object instanceof Angle) {
            return this.format(((Angle)object).degrees(), stringBuffer, fieldPosition);
        }
        ArgumentChecks.ensureNonNull("value", object);
        throw new IllegalArgumentException(Errors.format((short)43, "value", Angle.class, object.getClass()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuffer format(double d, StringBuffer stringBuffer, FieldPosition fieldPosition, char c, char c2) {
        try {
            this.showLeadingFields = true;
            stringBuffer = this.format(Math.abs(d), stringBuffer, fieldPosition);
        }
        finally {
            this.showLeadingFields = false;
        }
        int n = stringBuffer.length();
        char c3 = MathFunctions.isNegative(d) ? c2 : c;
        stringBuffer.append(c3);
        if (AngleFormat.getField(fieldPosition) == 4) {
            fieldPosition.setBeginIndex(n);
            fieldPosition.setEndIndex(stringBuffer.length());
        }
        if (this.characterIterator != null) {
            this.characterIterator.addFieldLimit(Field.HEMISPHERE, Character.valueOf(c3), n);
        }
        return stringBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AttributedCharacterIterator formatToCharacterIterator(Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        FormattedCharacterIterator formattedCharacterIterator = new FormattedCharacterIterator(stringBuffer);
        try {
            this.characterIterator = formattedCharacterIterator;
            this.format(object, stringBuffer, null);
        }
        finally {
            this.characterIterator = null;
        }
        return formattedCharacterIterator;
    }

    private int skipSuffix(String string, ParsePosition parsePosition, int n) {
        int n2;
        int n3 = n;
        int n4 = parsePosition.getIndex();
        int n5 = string.length();
        assert (n3 >= -1 && n3 <= 2) : n3;
        do {
            String string2;
            n2 = n4;
            switch (n3) {
                case -1: {
                    string2 = this.prefix;
                    break;
                }
                case 0: {
                    string2 = this.degreesSuffix;
                    break;
                }
                case 1: {
                    string2 = this.minutesSuffix;
                    break;
                }
                case 2: {
                    string2 = this.secondsSuffix;
                    break;
                }
                default: {
                    throw new AssertionError(n3);
                }
            }
            if (string2 != null) {
                int n6;
                do {
                    if (string.startsWith(string2, n2)) {
                        parsePosition.setIndex(n2 + string2.length());
                        return n3;
                    }
                    if (n2 >= n5) break;
                    n6 = string.codePointAt(n2);
                    n2 += Character.charCount(n6);
                } while (Character.isSpaceChar(n6));
            }
            if (++n3 <= 2) continue;
            n3 = -1;
        } while (n3 != n);
        if (this.isFallbackAllowed) {
            do {
                if (n4 >= n5) {
                    return Integer.MIN_VALUE;
                }
                n2 = string.codePointAt(n4);
                n4 += Character.charCount(n2);
            } while (Character.isSpaceChar(n2));
            switch (n2) {
                case 176: {
                    parsePosition.setIndex(n4);
                    return 0;
                }
                case 39: 
                case 8242: {
                    parsePosition.setIndex(n4);
                    return 1;
                }
                case 34: 
                case 8243: {
                    parsePosition.setIndex(n4);
                    return 2;
                }
            }
        }
        return Integer.MIN_VALUE;
    }

    private static int skipSpaces(String string, int n, int n2) {
        int n3;
        while (n < n2 && Character.isSpaceChar(n3 = string.codePointAt(n))) {
            n += Character.charCount(n3);
        }
        return n;
    }

    public Angle parse(String string, ParsePosition parsePosition) {
        return this.parse(string, parsePosition, false);
    }

    private Angle parse(String string, ParsePosition parsePosition, boolean bl) {
        double d = Double.NaN;
        double d2 = Double.NaN;
        int n = string.length();
        NumberFormat numberFormat = this.numberFormat();
        int n2 = parsePosition.getIndex();
        int n3 = this.skipSuffix(string, parsePosition, -1);
        if (n3 >= 0 && n3 <= 2) {
            parsePosition.setErrorIndex(n2);
            parsePosition.setIndex(n2);
            return null;
        }
        n3 = AngleFormat.skipSpaces(string, parsePosition.getIndex(), n);
        parsePosition.setIndex(n3);
        Number number = numberFormat.parse(string, parsePosition);
        if (number == null) {
            parsePosition.setIndex(n2);
            if (parsePosition.getErrorIndex() < n2) {
                parsePosition.setErrorIndex(n3);
            }
            return null;
        }
        double d3 = number.doubleValue();
        int n4 = parsePosition.getIndex();
        boolean bl2 = true;
        block0 : switch (this.skipSuffix(string, parsePosition, 0)) {
            case -1: {
                parsePosition.setIndex(n4);
                break;
            }
            case 2: {
                d2 = d3;
                d3 = Double.NaN;
                break;
            }
            default: {
                if (!bl || !this.isFallbackAllowed || this.minutesFieldWidth == 0) break;
            }
            case 0: {
                int n5 = parsePosition.getIndex();
                n3 = AngleFormat.skipSpaces(string, n5, n);
                if (!bl && n3 != n5) break;
                parsePosition.setIndex(n3);
                number = numberFormat.parse(string, parsePosition);
                if (number == null) {
                    parsePosition.setIndex(n5);
                    break;
                }
                n4 = parsePosition.getIndex();
                d = number.doubleValue();
                switch (this.skipSuffix(string, parsePosition, this.minutesFieldWidth != 0 ? 1 : -1)) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        d2 = d;
                        d = Double.NaN;
                        break block0;
                    }
                    default: {
                        if (bl && this.isFallbackAllowed && this.minutesFieldWidth != 0) break;
                    }
                    case 0: {
                        parsePosition.setIndex(n5);
                        d = Double.NaN;
                        break block0;
                    }
                    case -1: {
                        parsePosition.setIndex(n4);
                        break block0;
                    }
                }
                bl2 = false;
            }
            case 1: {
                if (bl2) {
                    d = d3;
                    d3 = Double.NaN;
                }
                int n5 = parsePosition.getIndex();
                n3 = AngleFormat.skipSpaces(string, n5, n);
                if (!bl && n3 != n5) break;
                parsePosition.setIndex(n3);
                number = numberFormat.parse(string, parsePosition);
                if (number == null) {
                    parsePosition.setIndex(n5);
                    break;
                }
                n4 = parsePosition.getIndex();
                d2 = number.doubleValue();
                switch (this.skipSuffix(string, parsePosition, this.secondsFieldWidth != 0 ? 1 : -1)) {
                    case 2: {
                        break block0;
                    }
                    default: {
                        if (this.isFallbackAllowed && this.secondsFieldWidth != 0) break block0;
                    }
                    case 0: 
                    case 1: {
                        parsePosition.setIndex(n5);
                        d2 = Double.NaN;
                        break block0;
                    }
                    case -1: {
                        parsePosition.setIndex(n4);
                        break block0;
                    }
                }
            }
        }
        if (MathFunctions.isNegative(d)) {
            d2 = -d2;
        }
        if (MathFunctions.isNegative(d3)) {
            d = -d;
            d2 = -d2;
        }
        if (!this.useDecimalSeparator) {
            double d4 = MathFunctions.pow10(this.fractionFieldWidth);
            if (this.secondsFieldWidth != 0) {
                if (this.minutesSuffix == null && Double.isNaN(d2)) {
                    if (this.degreesSuffix == null && Double.isNaN(d)) {
                        d3 /= d4;
                    } else {
                        d /= d4;
                    }
                } else {
                    d2 /= d4;
                }
            } else if (Double.isNaN(d2)) {
                if (this.minutesFieldWidth != 0) {
                    if (this.degreesSuffix == null && Double.isNaN(d)) {
                        d3 /= d4;
                    } else {
                        d /= d4;
                    }
                } else if (Double.isNaN(d)) {
                    d3 /= d4;
                }
            }
        }
        if (this.minutesSuffix == null && this.secondsFieldWidth != 0 && Double.isNaN(d2)) {
            double d5 = MathFunctions.pow10(this.secondsFieldWidth);
            if (this.degreesSuffix == null && this.minutesFieldWidth != 0 && Double.isNaN(d)) {
                d2 = d3;
                d = MathFunctions.truncate(d3 / d5);
                d2 -= d * d5;
                d5 = MathFunctions.pow10(this.minutesFieldWidth);
                d3 = MathFunctions.truncate(d / d5);
                d -= d3 * d5;
            } else {
                d2 = d;
                d = MathFunctions.truncate(d / d5);
                d2 -= d * d5;
            }
        } else if (this.degreesSuffix == null && this.minutesFieldWidth != 0 && Double.isNaN(d)) {
            double d6 = MathFunctions.pow10(this.minutesFieldWidth);
            d = d3;
            d3 = MathFunctions.truncate(d3 / d6);
            d -= d3 * d6;
        }
        parsePosition.setErrorIndex(-1);
        if (Double.isNaN(d3)) {
            d3 = 0.0;
        }
        if (!Double.isNaN(d)) {
            d3 += d / 60.0;
        }
        if (!Double.isNaN(d2)) {
            d3 += d2 / 3600.0;
        }
        for (int i = parsePosition.getIndex(); i < n; i += Character.charCount(n3)) {
            n3 = string.codePointAt(i);
            switch (Character.toUpperCase(n3)) {
                case 78: {
                    parsePosition.setIndex(i);
                    return new Latitude(d3);
                }
                case 83: {
                    parsePosition.setIndex(i);
                    return new Latitude(-d3);
                }
                case 69: {
                    parsePosition.setIndex(i);
                    return new Longitude(d3);
                }
                case 87: {
                    parsePosition.setIndex(i);
                    return new Longitude(-d3);
                }
            }
            if (Character.isSpaceChar(n3)) continue;
            break;
        }
        return new Angle(d3);
    }

    public Angle parse(String string) throws ParseException {
        int n;
        ParsePosition parsePosition = new ParsePosition(0);
        Angle angle = this.parse(string, parsePosition, true);
        int n2 = parsePosition.getIndex();
        if (AngleFormat.skipSpaces(string, n2, n = string.length()) < n) {
            throw new LocalizedParseException(this.locale, Angle.class, string, parsePosition);
        }
        return angle;
    }

    @Override
    public Object parseObject(String string, ParsePosition parsePosition) {
        return this.parse(string, parsePosition);
    }

    @Override
    public Object parseObject(String string) throws ParseException {
        return this.parse(string);
    }

    public boolean isFallbackAllowed() {
        return this.isFallbackAllowed;
    }

    public void setFallbackAllowed(boolean bl) {
        this.isFallbackAllowed = bl;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public AngleFormat clone() {
        AngleFormat angleFormat = (AngleFormat)super.clone();
        angleFormat.numberFormat = null;
        angleFormat.dummyFieldPosition = null;
        return angleFormat;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.degreesFieldWidth, this.minutesFieldWidth, this.secondsFieldWidth, this.fractionFieldWidth, this.minimumFractionDigits, this.useDecimalSeparator, this.isFallbackAllowed, this.optionalFields, this.roundingMode, this.locale, this.prefix, this.degreesSuffix, this.minutesSuffix, this.secondsSuffix}) ^ 0xB2E45171;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && this.getClass() == object.getClass()) {
            AngleFormat angleFormat = (AngleFormat)object;
            return this.degreesFieldWidth == angleFormat.degreesFieldWidth && this.minutesFieldWidth == angleFormat.minutesFieldWidth && this.secondsFieldWidth == angleFormat.secondsFieldWidth && this.fractionFieldWidth == angleFormat.fractionFieldWidth && this.minimumFractionDigits == angleFormat.minimumFractionDigits && this.useDecimalSeparator == angleFormat.useDecimalSeparator && this.isFallbackAllowed == angleFormat.isFallbackAllowed && this.optionalFields == angleFormat.optionalFields && this.roundingMode == angleFormat.roundingMode && Objects.equals(this.locale, angleFormat.locale) && Objects.equals(this.prefix, angleFormat.prefix) && Objects.equals(this.degreesSuffix, angleFormat.degreesSuffix) && Objects.equals(this.minutesSuffix, angleFormat.minutesSuffix) && Objects.equals(this.secondsSuffix, angleFormat.secondsSuffix);
        }
        return false;
    }

    public String toString() {
        return Strings.bracket(this.getClass(), (Object)this.toPattern());
    }

    public static final class Field
    extends FormatField {
        private static final long serialVersionUID = -5015489890305908251L;
        public static final Field DEGREES = new Field("DEGREES", 0);
        public static final Field MINUTES = new Field("MINUTES", 1);
        public static final Field SECONDS = new Field("SECONDS", 2);
        public static final Field HEMISPHERE = new Field("HEMISPHERE", 4);

        private Field(String string, int n) {
            super(string, n);
        }

        static Field forCode(int n) {
            switch (n) {
                case 0: {
                    return DEGREES;
                }
                case 1: {
                    return MINUTES;
                }
                case 2: {
                    return SECONDS;
                }
                case 4: {
                    return HEMISPHERE;
                }
            }
            throw new AssertionError(n);
        }
    }
}

