/*
 * Decompiled with CFR 0.152.
 */
package com.epam.parso.date;

import com.epam.parso.date.NotImplementedException;
import com.epam.parso.date.SasTemporalUtils;
import java.util.function.Function;

interface SasTemporalFormat {
    public int getDefaultWidth();

    default public int getActualWidth(int width) {
        return width == 0 ? this.getDefaultWidth() : width;
    }

    default public int getActualPrecision(int width, int precision) {
        return width > this.getDefaultWidth() + 1 ? Math.min(width - this.getDefaultWidth() - 1, precision) : 0;
    }

    public Function<Double, String> getInternalFormatFunction(int var1, int var2);

    public Function<Double, String> getFallbackFormatFunction(int var1, int var2);

    default public Function<Double, String> getFormatFunction(int width, int precision, boolean trim) {
        Function<Double, String> internalFormatFunction;
        int actualWidth = this.getActualWidth(width);
        int actualPrecision = this.getActualPrecision(actualWidth, precision);
        try {
            internalFormatFunction = this.getInternalFormatFunction(actualWidth, actualPrecision);
        }
        catch (NotImplementedException e) {
            return this.getFallbackFormatFunction(actualWidth, actualPrecision);
        }
        return seconds -> {
            if (seconds == null || seconds.isNaN()) {
                return ".";
            }
            String result = (String)internalFormatFunction.apply((Double)seconds);
            if (trim) {
                return result;
            }
            if (actualWidth > result.length()) {
                return SasTemporalUtils.nChars(' ', actualWidth - result.length()) + result;
            }
            return result;
        };
    }
}

