/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.util.Version;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.cloud.RecoveryStrategy;
import org.apache.solr.cloud.ZkSolrResourceLoader;
import org.apache.solr.common.ConfigNode;
import org.apache.solr.common.MapSerializable;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.EnvUtils;
import org.apache.solr.common.util.IOUtils;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.CodecFactory;
import org.apache.solr.core.ConfigOverlay;
import org.apache.solr.core.DirectoryFactory;
import org.apache.solr.core.IndexReaderFactory;
import org.apache.solr.core.InitParams;
import org.apache.solr.core.OverlaidConfigNode;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.RequestParams;
import org.apache.solr.core.SolrEventListener;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.core.XmlConfigFile;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.logging.DeprecationLog;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.response.QueryResponseWriter;
import org.apache.solr.response.transform.TransformerFactory;
import org.apache.solr.rest.RestManager;
import org.apache.solr.schema.IndexSchemaFactory;
import org.apache.solr.search.CacheConfig;
import org.apache.solr.search.CaffeineCache;
import org.apache.solr.search.QParserPlugin;
import org.apache.solr.search.SolrCache;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.ValueSourceParser;
import org.apache.solr.search.stats.StatsCache;
import org.apache.solr.servlet.SolrRequestParsers;
import org.apache.solr.spelling.QueryConverter;
import org.apache.solr.update.SolrIndexConfig;
import org.apache.solr.update.UpdateLog;
import org.apache.solr.update.processor.UpdateRequestProcessorChain;
import org.apache.solr.update.processor.UpdateRequestProcessorFactory;
import org.apache.solr.util.DOMConfigNode;
import org.apache.solr.util.DataConfigNode;
import org.apache.solr.util.circuitbreaker.CircuitBreaker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrConfig
implements MapSerializable {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String DEFAULT_CONF_FILE = "solrconfig.xml";
    public static final String MIN_PREFIX_QUERY_TERM_LENGTH = "minPrefixQueryTermLength";
    public static final int DEFAULT_MIN_PREFIX_QUERY_TERM_LENGTH = -1;
    private final String resourceName;
    private int znodeVersion;
    ConfigNode root;
    int rootDataHashCode;
    private final SolrResourceLoader resourceLoader;
    private Properties substituteProperties;
    private RequestParams requestParams;
    private int multipartUploadLimitKB;
    private int formUploadLimitKB;
    private boolean handleSelect;
    private boolean addHttpRequestToContext;
    private final SolrRequestParsers solrRequestParsers;
    private static final AtomicBoolean versionWarningAlreadyLogged = new AtomicBoolean(false);
    public static final List<SolrPluginInfo> plugins = List.of(new SolrPluginInfo(SolrRequestHandler.class, "requestHandler", PluginOpts.REQUIRE_NAME, PluginOpts.REQUIRE_CLASS, PluginOpts.MULTI_OK, PluginOpts.LAZY), new SolrPluginInfo(QParserPlugin.class, "queryParser", PluginOpts.REQUIRE_NAME, PluginOpts.REQUIRE_CLASS, PluginOpts.MULTI_OK), new SolrPluginInfo(Expressible.class, "expressible", PluginOpts.REQUIRE_NAME, PluginOpts.REQUIRE_CLASS, PluginOpts.MULTI_OK), new SolrPluginInfo(QueryResponseWriter.class, "queryResponseWriter", PluginOpts.REQUIRE_NAME, PluginOpts.REQUIRE_CLASS, PluginOpts.MULTI_OK, PluginOpts.LAZY), new SolrPluginInfo(ValueSourceParser.class, "valueSourceParser", PluginOpts.REQUIRE_NAME, PluginOpts.REQUIRE_CLASS, PluginOpts.MULTI_OK), new SolrPluginInfo(TransformerFactory.class, "transformer", PluginOpts.REQUIRE_NAME, PluginOpts.REQUIRE_CLASS, PluginOpts.MULTI_OK), new SolrPluginInfo(SearchComponent.class, "searchComponent", PluginOpts.REQUIRE_NAME, PluginOpts.REQUIRE_CLASS, PluginOpts.MULTI_OK), new SolrPluginInfo(UpdateRequestProcessorFactory.class, "updateProcessor", PluginOpts.REQUIRE_NAME, PluginOpts.REQUIRE_CLASS, PluginOpts.MULTI_OK), new SolrPluginInfo(SolrCache.class, "cache", PluginOpts.REQUIRE_NAME, PluginOpts.REQUIRE_CLASS, PluginOpts.MULTI_OK), new SolrPluginInfo(QueryConverter.class, "queryConverter", PluginOpts.REQUIRE_NAME, PluginOpts.REQUIRE_CLASS), new SolrPluginInfo(InitParams.class, "initParams", PluginOpts.MULTI_OK, PluginOpts.REQUIRE_NAME_IN_OVERLAY), new SolrPluginInfo(it -> {
        ArrayList result = new ArrayList();
        result.addAll(it.get("query").getAll("listener"));
        result.addAll(it.get("updateHandler").getAll("listener"));
        return result;
    }, SolrEventListener.class, "//listener", PluginOpts.REQUIRE_CLASS, PluginOpts.MULTI_OK, PluginOpts.REQUIRE_NAME_IN_OVERLAY), new SolrPluginInfo(DirectoryFactory.class, "directoryFactory", PluginOpts.REQUIRE_CLASS), new SolrPluginInfo(RecoveryStrategy.Builder.class, "recoveryStrategy", new PluginOpts[0]), new SolrPluginInfo(it -> it.get("indexConfig").getAll("deletionPolicy"), IndexDeletionPolicy.class, "indexConfig/deletionPolicy", PluginOpts.REQUIRE_CLASS), new SolrPluginInfo(CodecFactory.class, "codecFactory", PluginOpts.REQUIRE_CLASS), new SolrPluginInfo(IndexReaderFactory.class, "indexReaderFactory", PluginOpts.REQUIRE_CLASS), new SolrPluginInfo(UpdateRequestProcessorChain.class, "updateRequestProcessorChain", PluginOpts.MULTI_OK), new SolrPluginInfo(it -> it.get("updateHandler").getAll("updateLog"), UpdateLog.class, "updateHandler/updateLog", new PluginOpts[0]), new SolrPluginInfo(IndexSchemaFactory.class, "schemaFactory", PluginOpts.REQUIRE_CLASS), new SolrPluginInfo(RestManager.class, "restManager", new PluginOpts[0]), new SolrPluginInfo(StatsCache.class, "statsCache", PluginOpts.REQUIRE_CLASS), new SolrPluginInfo(CircuitBreaker.class, "circuitBreaker", PluginOpts.REQUIRE_CLASS, PluginOpts.MULTI_OK));
    public static final Map<String, SolrPluginInfo> classVsSolrPluginInfo;
    private Map<String, InitParams> initParams = Collections.emptyMap();
    public final int booleanQueryMaxClauseCount;
    public final int prefixQueryMinPrefixLength;
    public final CacheConfig filterCacheConfig;
    public final CacheConfig queryResultCacheConfig;
    public final CacheConfig documentCacheConfig;
    public final CacheConfig fieldValueCacheConfig;
    public final Map<String, CacheConfig> userCacheConfigs;
    public final boolean useFilterForSortedQuery;
    public final int queryResultWindowSize;
    public final int queryResultMaxDocsCached;
    public final boolean enableLazyFieldLoading;
    public final SolrIndexConfig indexConfig;
    protected UpdateHandlerInfo updateHandlerInfo;
    private Map<String, List<PluginInfo>> pluginStore = new LinkedHashMap<String, List<PluginInfo>>();
    public final int maxWarmingSearchers;
    public final boolean useColdSearcher;
    public final Version luceneMatchVersion;
    protected String dataDir;
    public final int slowQueryThresholdMillis;
    private final HttpCachingConfig httpCachingConfig;
    public static final String LIB_ENABLED_SYSPROP = "solr.config.lib.enabled";
    private ConfigOverlay overlay;

    public SolrConfig(Path instanceDir, String name) throws IOException {
        this(new SolrResourceLoader(instanceDir), name, true, null);
    }

    public static SolrConfig readFromResourceLoader(SolrResourceLoader loader, String name, boolean isConfigsetTrusted, Properties substitutableProperties) {
        try {
            return new SolrConfig(loader, name, isConfigsetTrusted, substitutableProperties);
        }
        catch (Exception e) {
            String resource = loader instanceof ZkSolrResourceLoader ? name : loader.getConfigPath().resolve(name).toString();
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error loading solr config from " + resource, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SolrConfig(SolrResourceLoader loader, String name, boolean isConfigsetTrusted, Properties substitutableProperties) {
        this.resourceLoader = loader;
        this.resourceName = name;
        this.substituteProperties = substitutableProperties;
        this.getOverlay();
        IndexSchemaFactory.VersionedConfig cfg = IndexSchemaFactory.getFromCache(name, loader, () -> {
            if (loader.getCoreContainer() == null) {
                return null;
            }
            return loader.getCoreContainer().getObjectCache();
        }, () -> this.readXml(loader, name));
        this.root = cfg.data;
        this.znodeVersion = cfg.version;
        ConfigNode.SUBSTITUTES.set(key -> {
            if (substitutableProperties != null && substitutableProperties.containsKey(key)) {
                return substitutableProperties.getProperty((String)key);
            }
            Object o = this.overlay.getUserProps().get(key);
            return o == null ? null : o.toString();
        });
        try {
            List<PluginInfo> argsInfos;
            boolean hasDeprecatedIndexConfig;
            this.rootDataHashCode = this.root.txt().hashCode();
            this.getRequestParams();
            this.initLibs(loader, isConfigsetTrusted);
            String val = this.root.childRequired("luceneMatchVersion", () -> new RuntimeException("Missing: luceneMatchVersion")).txt();
            this.luceneMatchVersion = SolrConfig.parseLuceneVersionString(val);
            log.info("Using Lucene MatchVersion: {}", (Object)this.luceneMatchVersion);
            boolean bl = hasDeprecatedIndexConfig = this.get("indexDefaults").exists() || this.get("mainIndex").exists();
            if (hasDeprecatedIndexConfig) {
                throw new SolrException(SolrException.ErrorCode.FORBIDDEN, "<indexDefaults> and <mainIndex> configuration sections are discontinued. Use <indexConfig> instead.");
            }
            String indexConfigPrefix = "indexConfig";
            XmlConfigFile.assertWarnOrFail("The <nrtMode> config has been discontinued and NRT mode is always used by Solr. This config will be removed in future versions.", this.get(indexConfigPrefix).get("nrtMode").isNull(), true);
            XmlConfigFile.assertWarnOrFail("Solr no longer supports forceful unlocking via the 'unlockOnStartup' option.  This is no longer necessary for the default lockType except in situations where it would be dangerous and should not be done.  For other lockTypes and/or directoryFactory options it may also be dangerous and users must resolve problematic locks manually.", !this.get(indexConfigPrefix).get("unlockOnStartup").exists(), true);
            this.indexConfig = new SolrIndexConfig(this.get("indexConfig"), null);
            this.booleanQueryMaxClauseCount = this.get("query").get("maxBooleanClauses").intVal(BooleanQuery.getMaxClauseCount());
            if (IndexSearcher.getMaxClauseCount() < this.booleanQueryMaxClauseCount) {
                log.warn("solrconfig.xml: <maxBooleanClauses> of {} is greater than global limit of {} and will have no effect {}", new Object[]{this.booleanQueryMaxClauseCount, BooleanQuery.getMaxClauseCount(), "set 'maxBooleanClauses' in solr.xml to increase global limit"});
            }
            this.prefixQueryMinPrefixLength = this.get("query").get(MIN_PREFIX_QUERY_TERM_LENGTH).intVal(-1);
            if (this.get("query").get("boolTofilterOptimizer").exists()) {
                log.warn("solrconfig.xml: <boolTofilterOptimizer> is currently not implemented and has no effect.");
            }
            if (this.get("query").get("HashDocSet").exists()) {
                log.warn("solrconfig.xml: <HashDocSet> is deprecated and no longer used.");
            }
            this.useFilterForSortedQuery = this.get("query").get("useFilterForSortedQuery").boolVal(false);
            this.queryResultWindowSize = Math.max(1, this.get("query").get("queryResultWindowSize").intVal(1));
            this.queryResultMaxDocsCached = this.get("query").get("queryResultMaxDocsCached").intVal(Integer.MAX_VALUE);
            this.enableLazyFieldLoading = this.get("query").get("enableLazyFieldLoading").boolVal(false);
            this.filterCacheConfig = CacheConfig.getConfig(this, this.get("query").get("filterCache"), "query/filterCache");
            this.queryResultCacheConfig = CacheConfig.getConfig(this, this.get("query").get("queryResultCache"), "query/queryResultCache");
            this.documentCacheConfig = CacheConfig.getConfig(this, this.get("query").get("documentCache"), "query/documentCache");
            CacheConfig conf = CacheConfig.getConfig(this, this.get("query").get("fieldValueCache"), "query/fieldValueCache");
            if (conf == null) {
                HashMap<String, String> args = new HashMap<String, String>();
                args.put("name", "fieldValueCache");
                args.put("size", "10000");
                args.put("initialSize", "10");
                conf = new CacheConfig(CaffeineCache.class, args, null);
            }
            this.fieldValueCacheConfig = conf;
            this.useColdSearcher = this.get("query").get("useColdSearcher").boolVal(false);
            this.dataDir = this.get("dataDir").txt();
            if (this.dataDir != null && this.dataDir.length() == 0) {
                this.dataDir = null;
            }
            SolrIndexSearcher.initRegenerators(this);
            if (this.get("jmx").exists()) {
                log.warn("solrconfig.xml: <jmx> is no longer supported, use solr.xml:/metrics/reporter section instead");
            }
            this.httpCachingConfig = new HttpCachingConfig(this);
            this.maxWarmingSearchers = this.get("query").get("maxWarmingSearchers").intVal(1);
            this.slowQueryThresholdMillis = this.get("query").get("slowQueryThresholdMillis").intVal(-1);
            for (SolrPluginInfo plugin : plugins) {
                this.loadPluginInfo(plugin);
            }
            Map<String, CacheConfig> userCacheConfigs = CacheConfig.getMultipleConfigs(this.getResourceLoader(), this, "query/cache", this.get("query").getAll("cache"));
            List<PluginInfo> caches = this.getPluginInfos(SolrCache.class.getName());
            if (!caches.isEmpty()) {
                for (PluginInfo c : caches) {
                    userCacheConfigs.put(c.name, CacheConfig.getConfig(this, "cache", c.attributes, null));
                }
            }
            this.userCacheConfigs = Collections.unmodifiableMap(userCacheConfigs);
            this.updateHandlerInfo = this.loadUpdatehandlerInfo();
            ConfigNode requestParsersNode = this.get("requestDispatcher").get("requestParsers");
            this.multipartUploadLimitKB = requestParsersNode.intAttr("multipartUploadLimitInKB", Integer.MAX_VALUE);
            if (this.multipartUploadLimitKB == -1) {
                this.multipartUploadLimitKB = Integer.MAX_VALUE;
            }
            this.formUploadLimitKB = requestParsersNode.intAttr("formdataUploadLimitInKB", Integer.MAX_VALUE);
            if (this.formUploadLimitKB == -1) {
                this.formUploadLimitKB = Integer.MAX_VALUE;
            }
            if (requestParsersNode.attr("enableRemoteStreaming") != null) {
                log.warn("Ignored deprecated enableRemoteStreaming in config; use sys-prop");
            }
            if (requestParsersNode.attr("enableStreamBody") != null) {
                log.warn("Ignored deprecated enableStreamBody in config; use sys-prop");
            }
            this.handleSelect = this.get("requestDispatcher").boolAttr("handleSelect", false);
            if (this.handleSelect) {
                DeprecationLog.log("handleSelect", "handleSelect is deprecated");
            }
            this.addHttpRequestToContext = requestParsersNode.boolAttr("addHttpRequestToContext", false);
            if (this.addHttpRequestToContext) {
                DeprecationLog.log("addHttpRequestToContext", "addHttpRequestToContext is deprecated");
            }
            if ((argsInfos = this.getPluginInfos(InitParams.class.getName())) != null) {
                HashMap<String, InitParams> argsMap = new HashMap<String, InitParams>();
                for (PluginInfo p : argsInfos) {
                    InitParams args = new InitParams(p);
                    argsMap.put(args.name == null ? String.valueOf(args.hashCode()) : args.name, args);
                }
                this.initParams = Collections.unmodifiableMap(argsMap);
            }
            this.solrRequestParsers = new SolrRequestParsers(this);
            log.debug("Loaded SolrConfig: {}", (Object)name);
            this.resourceLoader.setSolrConfig(this);
        }
        finally {
            ConfigNode.SUBSTITUTES.remove();
        }
    }

    private IndexSchemaFactory.VersionedConfig readXml(SolrResourceLoader loader, String name) {
        IndexSchemaFactory.VersionedConfig versionedConfig;
        block8: {
            InputStream in = loader.openResource(name);
            try {
                ResourceProvider rp = new ResourceProvider(in);
                XmlConfigFile xml = new XmlConfigFile(loader, rp, name, null, "/config/", null);
                versionedConfig = new IndexSchemaFactory.VersionedConfig(rp.zkVersion, new DataConfigNode(new DOMConfigNode(xml.getDocument().getDocumentElement())));
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
                }
            }
            in.close();
        }
        return versionedConfig;
    }

    public static final Version parseLuceneVersionString(String matchVersion) {
        Version version;
        try {
            version = Version.parseLeniently((String)matchVersion);
        }
        catch (ParseException pe) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Invalid luceneMatchVersion.  Should be of the form 'V.V.V' (e.g. 4.8.0)", (Throwable)pe);
        }
        if (version == Version.LATEST && !versionWarningAlreadyLogged.getAndSet(true)) {
            log.warn("You should not use LATEST as luceneMatchVersion property: if you use this setting, and then Solr upgrades to a newer release of Lucene, sizable changes may happen. If precise back compatibility is important then you should instead explicitly specify an actual Lucene version.");
        }
        return version;
    }

    public static ConfigOverlay getConfigOverlay(SolrResourceLoader loader) {
        InputStream in = null;
        Closeable isr = null;
        try {
            try {
                in = loader.openResource("configoverlay.json");
            }
            catch (IOException e) {
                ConfigOverlay configOverlay = new ConfigOverlay(Collections.emptyMap(), -1);
                IOUtils.closeQuietly(isr);
                IOUtils.closeQuietly((Closeable)in);
                return configOverlay;
            }
            int version = 0;
            if (in instanceof ZkSolrResourceLoader.ZkByteArrayInputStream) {
                version = ((ZkSolrResourceLoader.ZkByteArrayInputStream)in).getStat().getVersion();
                log.debug("Config overlay loaded. version : {} ", (Object)version);
            }
            if (in instanceof SolrResourceLoader.SolrFileInputStream) {
                version = (int)((SolrResourceLoader.SolrFileInputStream)in).getLastModified();
                log.debug("Config overlay loaded. version : {} ", (Object)version);
            }
            Map m = (Map)Utils.fromJSON((InputStream)in);
            ConfigOverlay configOverlay = new ConfigOverlay(m, version);
            return configOverlay;
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error reading config overlay", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly(isr);
            IOUtils.closeQuietly((Closeable)in);
        }
    }

    public Map<String, InitParams> getInitParams() {
        return this.initParams;
    }

    protected UpdateHandlerInfo loadUpdatehandlerInfo() {
        return new UpdateHandlerInfo(this.get("updateHandler"));
    }

    protected static long convertHeapOptionStyleConfigStringToBytes(String configStr) {
        if (configStr == null || configStr.isEmpty()) {
            return -1L;
        }
        long multiplier = 1L;
        String numericValueStr = configStr;
        char suffix = Character.toLowerCase(configStr.charAt(configStr.length() - 1));
        if (Character.isLetter(suffix)) {
            if (suffix == 'k') {
                multiplier = 1024L;
            } else if (suffix == 'm') {
                multiplier = 0x100000L;
            } else if (suffix == 'g') {
                multiplier = 0x40000000L;
            } else {
                throw new RuntimeException("Invalid suffix. Valid suffixes are 'k' (KB), 'm' (MB), 'g' (G). No suffix means the amount is in bytes. ");
            }
            numericValueStr = configStr.substring(0, configStr.length() - 1);
        }
        try {
            return Long.parseLong(numericValueStr) * multiplier;
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Invalid format. The config setting should be a long with an optional letter suffix. Valid suffixes are 'k' (KB), 'm' (MB), 'g' (G). No suffix means the amount is in bytes.");
        }
    }

    private void loadPluginInfo(SolrPluginInfo pluginInfo) {
        boolean requireClass;
        boolean requireName = pluginInfo.options.contains((Object)PluginOpts.REQUIRE_NAME);
        List<PluginInfo> result = this.readPluginInfos(pluginInfo, requireName, requireClass = pluginInfo.options.contains((Object)PluginOpts.REQUIRE_CLASS));
        if (1 < result.size() && !pluginInfo.options.contains((Object)PluginOpts.MULTI_OK)) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Found " + result.size() + " configuration sections when at most 1 is allowed matching expression: " + pluginInfo.getCleanTag());
        }
        if (!result.isEmpty()) {
            this.pluginStore.put(pluginInfo.clazz.getName(), result);
        }
    }

    public List<PluginInfo> readPluginInfos(SolrPluginInfo info, boolean requireName, boolean requireClass) {
        ArrayList<PluginInfo> result = new ArrayList<PluginInfo>();
        for (ConfigNode node : info.configReader.apply(this)) {
            PluginInfo pluginInfo = new PluginInfo(node, "[solrconfig.xml] " + info.tag, requireName, requireClass);
            if (!pluginInfo.isEnabled()) continue;
            result.add(pluginInfo);
        }
        return result;
    }

    public SolrRequestParsers getRequestParsers() {
        return this.solrRequestParsers;
    }

    public HttpCachingConfig getHttpCachingConfig() {
        return this.httpCachingConfig;
    }

    public UpdateHandlerInfo getUpdateHandlerInfo() {
        return this.updateHandlerInfo;
    }

    public String getDataDir() {
        return this.dataDir;
    }

    public List<PluginInfo> getPluginInfos(String type) {
        Map<String, Map<String, Object>> infos;
        List<PluginInfo> result = this.pluginStore.get(type);
        SolrPluginInfo info = classVsSolrPluginInfo.get(type);
        if (info != null && (info.options.contains((Object)PluginOpts.REQUIRE_NAME) || info.options.contains((Object)PluginOpts.REQUIRE_NAME_IN_OVERLAY)) && !(infos = this.overlay.getNamedPlugins(info.getCleanTag())).isEmpty()) {
            LinkedHashMap<String, PluginInfo> map = new LinkedHashMap<String, PluginInfo>();
            if (result != null) {
                for (PluginInfo pluginInfo : result) {
                    String name = pluginInfo.name == null ? UUID.randomUUID().toString().toLowerCase(Locale.ROOT) : pluginInfo.name;
                    map.put(name, pluginInfo);
                }
            }
            for (Map.Entry entry : infos.entrySet()) {
                map.put((String)entry.getKey(), new PluginInfo(info.getCleanTag(), (Map)entry.getValue()));
            }
            result = new ArrayList(map.values());
        }
        return result == null ? Collections.emptyList() : result;
    }

    public PluginInfo getPluginInfo(String type) {
        List<PluginInfo> result = this.pluginStore.get(type);
        if (result == null || result.isEmpty()) {
            return null;
        }
        if (1 == result.size()) {
            return result.get(0);
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Multiple plugins configured for type: " + type);
    }

    private void initLibs(SolrResourceLoader loader, boolean isConfigsetTrusted) {
        Path instancePath = loader.getInstancePath();
        ArrayList<URL> urls = new ArrayList<URL>();
        Path libPath = instancePath.resolve("lib");
        if (Files.exists(libPath, new LinkOption[0])) {
            try {
                urls.addAll(SolrResourceLoader.getURLs(libPath));
            }
            catch (IOException e) {
                log.warn("Couldn't add files from {} to classpath: {}", (Object)libPath, (Object)e);
            }
        }
        boolean libDirectiveAllowed = EnvUtils.getPropertyAsBool((String)LIB_ENABLED_SYSPROP, (Boolean)false);
        List nodes = this.root.getAll("lib");
        if (nodes != null && nodes.size() > 0) {
            if (!isConfigsetTrusted) {
                throw new SolrException(SolrException.ErrorCode.UNAUTHORIZED, "The configset for this collection was uploaded without any authentication in place, and use of <lib> is not available for collections with untrusted configsets. To use this component, re-upload the configset after enabling authentication and authorization.");
            }
            if (!libDirectiveAllowed) {
                log.warn("Configset references one or more <lib/> directives, but <lib/> usage is disabled on this Solr node.  Either remove all <lib/> tags from the relevant configset, or enable use of this feature by setting '{}=true'", (Object)LIB_ENABLED_SYSPROP);
            } else {
                urls.addAll(this.processLibDirectives(nodes, instancePath));
            }
        }
        if (!urls.isEmpty()) {
            loader.addToClassLoader(urls);
            loader.reloadLuceneSPI();
        }
    }

    private List<URL> processLibDirectives(List<ConfigNode> nodes, Path instancePath) {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (int i = 0; i < nodes.size(); ++i) {
            Path dir;
            ConfigNode node = nodes.get(i);
            String baseDir = node.attr("dir");
            String path = node.attr("path");
            if (null != baseDir) {
                dir = instancePath.resolve(baseDir);
                String regex = node.attr("regex");
                try {
                    if (regex == null) {
                        urls.addAll(SolrResourceLoader.getURLs(dir));
                        continue;
                    }
                    urls.addAll(SolrResourceLoader.getFilteredURLs(dir, regex));
                }
                catch (IOException e) {
                    log.warn("Couldn't add files from {} filtered by {} to classpath: {}", new Object[]{dir, regex, e});
                }
                continue;
            }
            if (null != path) {
                dir = instancePath.resolve(path);
                try {
                    urls.add(dir.toUri().toURL());
                }
                catch (MalformedURLException e) {
                    log.warn("Couldn't add file {} to classpath: {}", (Object)dir, (Object)e);
                }
                continue;
            }
            throw new RuntimeException("lib: missing mandatory attributes: 'dir' or 'path'");
        }
        return urls;
    }

    public int getMultipartUploadLimitKB() {
        return this.multipartUploadLimitKB;
    }

    public int getFormUploadLimitKB() {
        return this.formUploadLimitKB;
    }

    public boolean isHandleSelect() {
        return this.handleSelect;
    }

    public boolean isAddHttpRequestToContext() {
        return this.addHttpRequestToContext;
    }

    public Map<String, Object> toMap(Map<String, Object> result) {
        if (this.znodeVersion > -1) {
            result.put("znodeVersion", this.znodeVersion);
        }
        if (this.luceneMatchVersion != null) {
            result.put("luceneMatchVersion", this.luceneMatchVersion.toString());
        }
        result.put("updateHandler", this.getUpdateHandlerInfo());
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        result.put("query", m);
        m.put("useFilterForSortedQuery", this.useFilterForSortedQuery);
        m.put("queryResultWindowSize", this.queryResultWindowSize);
        m.put("queryResultMaxDocsCached", this.queryResultMaxDocsCached);
        m.put("enableLazyFieldLoading", this.enableLazyFieldLoading);
        m.put("maxBooleanClauses", this.booleanQueryMaxClauseCount);
        m.put(MIN_PREFIX_QUERY_TERM_LENGTH, this.prefixQueryMinPrefixLength);
        for (SolrPluginInfo plugin : plugins) {
            List<PluginInfo> infos = this.getPluginInfos(plugin.clazz.getName());
            if (infos == null || infos.isEmpty()) continue;
            String tag = plugin.getCleanTag();
            tag = tag.replace("/", "");
            if (plugin.options.contains((Object)PluginOpts.REQUIRE_NAME)) {
                LinkedHashMap<String, PluginInfo> items = new LinkedHashMap<String, PluginInfo>();
                for (PluginInfo pluginInfo : infos) {
                    if (pluginInfo.type.equals("searchComponent") && pluginInfo.name.equals("highlight")) continue;
                    items.put(pluginInfo.name, pluginInfo);
                }
                for (Map.Entry entry : this.overlay.getNamedPlugins(plugin.tag).entrySet()) {
                    items.put((String)entry.getKey(), (PluginInfo)entry.getValue());
                }
                result.put(tag, items);
                continue;
            }
            if (plugin.options.contains((Object)PluginOpts.MULTI_OK)) {
                ArrayList<PluginInfo> l = new ArrayList<PluginInfo>();
                for (PluginInfo pluginInfo : infos) {
                    l.add(pluginInfo);
                }
                result.put(tag, l);
                continue;
            }
            result.put(tag, infos.get(0));
        }
        this.addCacheConfig(m, this.filterCacheConfig, this.queryResultCacheConfig, this.documentCacheConfig, this.fieldValueCacheConfig);
        m = new LinkedHashMap();
        result.put("requestDispatcher", m);
        m.put("handleSelect", this.handleSelect);
        if (this.httpCachingConfig != null) {
            m.put("httpCaching", this.httpCachingConfig);
        }
        m.put("requestParsers", Map.of("multipartUploadLimitKB", this.multipartUploadLimitKB, "formUploadLimitKB", this.formUploadLimitKB, "addHttpRequestToContext", this.addHttpRequestToContext));
        if (this.indexConfig != null) {
            result.put("indexConfig", this.indexConfig);
        }
        return result;
    }

    private void addCacheConfig(Map<String, Object> queryMap, CacheConfig ... cache) {
        if (cache == null) {
            return;
        }
        for (CacheConfig config : cache) {
            if (config == null) continue;
            queryMap.put(config.getNodeName(), config);
        }
    }

    public Properties getSubstituteProperties() {
        Map<String, Object> p = this.getOverlay().getUserProps();
        if (p == null || p.isEmpty()) {
            return this.substituteProperties;
        }
        Properties result = new Properties(this.substituteProperties);
        result.putAll(p);
        return result;
    }

    public ConfigOverlay getOverlay() {
        if (this.overlay == null) {
            this.overlay = SolrConfig.getConfigOverlay(this.resourceLoader);
        }
        return this.overlay;
    }

    public RequestParams getRequestParams() {
        if (this.requestParams == null) {
            return this.refreshRequestParams();
        }
        return this.requestParams;
    }

    public String maxPackageVersion(String pkg) {
        RequestParams.ParamSet p = this.getRequestParams().getParams("PKG_VERSIONS");
        if (p == null) {
            return null;
        }
        Object o = p.get().get(pkg);
        if (o == null || "$LATEST".equals(o)) {
            return null;
        }
        return o.toString();
    }

    public RequestParams refreshRequestParams() {
        this.requestParams = RequestParams.getFreshRequestParams(this.resourceLoader, this.requestParams);
        if (log.isDebugEnabled()) {
            log.debug("current version of requestparams : {}", (Object)this.requestParams.getZnodeVersion());
        }
        return this.requestParams;
    }

    public SolrResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public int getZnodeVersion() {
        return this.znodeVersion;
    }

    public String getName() {
        return this.resourceName;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public ConfigNode get(String name) {
        if (!this.overlay.hasKey(name)) {
            return this.root.get(name);
        }
        return new OverlaidConfigNode(this.overlay, name, null, this.root.get(name));
    }

    public ConfigNode get(String name, Predicate<ConfigNode> test) {
        return this.root.get(name, test);
    }

    public String effectiveId() {
        return this.getName() + "-" + this.znodeVersion + "-" + this.rootDataHashCode;
    }

    static {
        HashMap<String, SolrPluginInfo> map = new HashMap<String, SolrPluginInfo>();
        for (SolrPluginInfo plugin : plugins) {
            map.put(plugin.clazz.getName(), plugin);
        }
        classVsSolrPluginInfo = Collections.unmodifiableMap(map);
    }

    public static class UpdateHandlerInfo
    implements MapSerializable {
        public final String className;
        public final int autoCommmitMaxDocs;
        public final int autoCommmitMaxTime;
        public final int autoSoftCommmitMaxDocs;
        public final int autoSoftCommmitMaxTime;
        public final long autoCommitMaxSizeBytes;
        public final boolean openSearcher;
        public final boolean commitWithinSoftCommit;
        public final String commitPollInterval;
        public final boolean aggregateNodeLevelMetricsEnabled;

        public UpdateHandlerInfo(String className, int autoCommmitMaxDocs, int autoCommmitMaxTime, long autoCommitMaxSize, boolean openSearcher, int autoSoftCommmitMaxDocs, int autoSoftCommmitMaxTime, boolean commitWithinSoftCommit, String commitPollInterval) {
            this.className = className;
            this.autoCommmitMaxDocs = autoCommmitMaxDocs;
            this.autoCommmitMaxTime = autoCommmitMaxTime;
            this.autoCommitMaxSizeBytes = autoCommitMaxSize;
            this.openSearcher = openSearcher;
            this.autoSoftCommmitMaxDocs = autoSoftCommmitMaxDocs;
            this.autoSoftCommmitMaxTime = autoSoftCommmitMaxTime;
            this.commitWithinSoftCommit = commitWithinSoftCommit;
            this.commitPollInterval = commitPollInterval;
            this.aggregateNodeLevelMetricsEnabled = false;
        }

        public UpdateHandlerInfo(ConfigNode updateHandler) {
            ConfigNode autoCommit = updateHandler.get("autoCommit");
            this.className = updateHandler.attr("class");
            this.autoCommmitMaxDocs = autoCommit.get("maxDocs").intVal(-1);
            this.autoCommmitMaxTime = autoCommit.get("maxTime").intVal(-1);
            this.autoCommitMaxSizeBytes = SolrConfig.convertHeapOptionStyleConfigStringToBytes(autoCommit.get("maxSize").txt());
            this.openSearcher = autoCommit.get("openSearcher").boolVal(true);
            this.autoSoftCommmitMaxDocs = updateHandler.get("autoSoftCommit").get("maxDocs").intVal(-1);
            this.autoSoftCommmitMaxTime = updateHandler.get("autoSoftCommit").get("maxTime").intVal(-1);
            this.commitWithinSoftCommit = updateHandler.get("commitWithin").get("softCommit").boolVal(true);
            this.commitPollInterval = updateHandler.get("commitPollInterval").txt();
            this.aggregateNodeLevelMetricsEnabled = updateHandler.boolAttr("aggregateNodeLevelMetricsEnabled", false);
        }

        public Map<String, Object> toMap(Map<String, Object> map) {
            map.put("commitWithin", Map.of("softCommit", this.commitWithinSoftCommit));
            map.put("autoCommit", Map.of("maxDocs", this.autoCommmitMaxDocs, "maxTime", this.autoCommmitMaxTime, "openSearcher", this.openSearcher));
            map.put("autoSoftCommit", Map.of("maxDocs", this.autoSoftCommmitMaxDocs, "maxTime", this.autoSoftCommmitMaxTime));
            map.put("commitPollInterval", this.commitPollInterval);
            return map;
        }
    }

    public static class HttpCachingConfig
    implements MapSerializable {
        private static final Pattern MAX_AGE = Pattern.compile("\\bmax-age=(\\d+)");
        private final boolean never304;
        private final String etagSeed;
        private final String cacheControlHeader;
        private final Long maxAge;
        private final LastModFrom lastModFrom;
        private ConfigNode configNode;

        public Map<String, Object> toMap(Map<String, Object> map) {
            return Utils.makeMap((Object[])new Object[]{"never304", this.never304, "etagSeed", this.etagSeed, "lastModFrom", this.lastModFrom.name().toLowerCase(Locale.ROOT), "cacheControl", this.cacheControlHeader});
        }

        private HttpCachingConfig(SolrConfig conf) {
            this.configNode = conf.root;
            ConfigNode httpCaching = this.get("requestDispatcher").get("httpCaching");
            this.never304 = httpCaching.boolAttr("never304", false);
            this.etagSeed = httpCaching.attr("etagSeed", "Solr");
            this.lastModFrom = LastModFrom.parse(httpCaching.attr("lastModFrom", "openTime"));
            this.cacheControlHeader = httpCaching.get("cacheControl").txt();
            Long tmp = null;
            if (null != this.cacheControlHeader) {
                try {
                    Matcher ttlMatcher = MAX_AGE.matcher(this.cacheControlHeader);
                    String ttlStr = ttlMatcher.find() ? ttlMatcher.group(1) : null;
                    tmp = null != ttlStr && !ttlStr.isEmpty() ? Long.valueOf(ttlStr) : null;
                }
                catch (Exception e) {
                    log.warn("Ignoring exception while attempting to extract max-age from cacheControl config: {}", (Object)this.cacheControlHeader, (Object)e);
                }
            }
            this.maxAge = tmp;
        }

        private ConfigNode get(String name) {
            return this.configNode.get(name);
        }

        public boolean isNever304() {
            return this.never304;
        }

        public String getEtagSeed() {
            return this.etagSeed;
        }

        public String getCacheControlHeader() {
            return this.cacheControlHeader;
        }

        public Long getMaxAge() {
            return this.maxAge;
        }

        public LastModFrom getLastModFrom() {
            return this.lastModFrom;
        }

        public static enum LastModFrom {
            OPENTIME,
            DIRLASTMOD,
            BOGUS;


            public static LastModFrom parse(String s) {
                try {
                    return LastModFrom.valueOf(s.toUpperCase(Locale.ROOT));
                }
                catch (Exception e) {
                    log.warn("Unrecognized value for lastModFrom: {}", (Object)s, (Object)e);
                    return BOGUS;
                }
            }
        }
    }

    public static class SolrPluginInfo {
        public final Class<?> clazz;
        public final String tag;
        public final Set<PluginOpts> options;
        final Function<SolrConfig, List<ConfigNode>> configReader;

        private SolrPluginInfo(Class<?> clz, String tag, PluginOpts ... opts) {
            this((SolrConfig solrConfig) -> solrConfig.root.getAll(tag), clz, tag, opts);
        }

        private SolrPluginInfo(Function<SolrConfig, List<ConfigNode>> configReader, Class<?> clz, String tag, PluginOpts ... opts) {
            this.configReader = configReader;
            this.clazz = clz;
            this.tag = tag;
            this.options = opts == null ? Collections.emptySet() : EnumSet.of(PluginOpts.NOOP, opts);
        }

        public String getCleanTag() {
            return this.tag.replace("/", "");
        }

        public String getTagCleanLower() {
            return this.getCleanTag().toLowerCase(Locale.ROOT);
        }
    }

    private class ResourceProvider
    implements Function<String, InputStream> {
        int zkVersion;
        int hash = -1;
        InputStream in;
        String fileName;

        ResourceProvider(InputStream in) throws IOException {
            this.in = in;
            if (in instanceof ZkSolrResourceLoader.ZkByteArrayInputStream) {
                ZkSolrResourceLoader.ZkByteArrayInputStream zkin = (ZkSolrResourceLoader.ZkByteArrayInputStream)in;
                this.zkVersion = zkin.getStat().getVersion();
                this.hash = Objects.hash(zkin.getStat().getCtime(), this.zkVersion, SolrConfig.this.overlay.getVersion());
                this.fileName = zkin.fileName;
            } else if (in instanceof SolrResourceLoader.SolrFileInputStream) {
                SolrResourceLoader.SolrFileInputStream sfin = (SolrResourceLoader.SolrFileInputStream)in;
                this.zkVersion = (int)sfin.getLastModified();
                this.hash = Objects.hash(sfin.getLastModified(), SolrConfig.this.overlay.getVersion());
            }
        }

        @Override
        public InputStream apply(String s) {
            return this.in;
        }
    }

    public static enum PluginOpts {
        MULTI_OK,
        REQUIRE_NAME,
        REQUIRE_NAME_IN_OVERLAY,
        REQUIRE_CLASS,
        LAZY,
        NOOP;

    }
}

