/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.components.configuration.configurators;

import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.Timer;

public class FontPreview
implements ActionListener,
MouseListener,
MouseMotionListener {
    private Timer timer;
    private static final int delay = 500;
    private JComponent glassPane;
    private JTable table;
    private JLabel label;
    private Point position;

    public FontPreview(JDialog dialog, JTable table) {
        this.glassPane = (JComponent)dialog.getGlassPane();
        this.table = table;
        table.addMouseMotionListener(this);
        table.addMouseListener(this);
        this.timer = new Timer(500, this);
        this.label = new JLabel();
        this.label.setSize(140, 60);
        this.label.setOpaque(true);
        this.label.setBackground(Color.YELLOW);
        this.label.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        this.position = null;
        this.timer.start();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.timer.restart();
        this.hideLabel();
        this.position = e.getPoint();
    }

    private void hideLabel() {
        this.label.setVisible(false);
        this.glassPane.remove(this.label);
        this.glassPane.revalidate();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.position == null) {
            return;
        }
        int r = this.table.rowAtPoint(this.position);
        if (r == -1) {
            return;
        }
        String fontName = (String)this.table.getValueAt(r, 0);
        Font font = new Font(fontName, 0, 14);
        this.label.setText("");
        this.label.setFont(font);
        this.label.setText("<html><center>&nbsp;<u>" + fontName + "</u>&nbsp;<br>&nbsp;The quick brown&nbsp;<br>&nbsp;fox jumps over&nbsp;<br>&nbsp;the lazy dog.");
        this.label.setSize(this.label.getPreferredSize());
        int x = this.glassPane.getWidth() / 2 - this.label.getWidth() / 2;
        int y = this.glassPane.getHeight() / 2 - this.label.getHeight() / 2;
        this.label.setLocation(x, y);
        this.glassPane.add(this.label);
        this.label.setVisible(true);
        this.glassPane.updateUI();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.timer.restart();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.timer.stop();
        this.hideLabel();
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }
}

