/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public final class ClassLoaderUtils {
    private static final ClassLoader classClassLoader = ClassLoaderUtils.getClassClassLoader(ClassLoaderUtils.class);
    private static final ClassLoader systemClassLoader = ClassLoaderUtils.getSystemClassLoader();
    private static final boolean systemClassLoaderAccessibleFromClassClassLoader = ClassLoaderUtils.isKnownClassLoaderAccessibleFrom(systemClassLoader, classClassLoader);

    public static ClassLoader getClassLoader(Class<?> clazz) {
        ClassLoader clazzClassLoader;
        ClassLoader contextClassLoader = ClassLoaderUtils.getThreadContextClassLoader();
        if (contextClassLoader != null) {
            return contextClassLoader;
        }
        if (clazz != null && (clazzClassLoader = ClassLoaderUtils.getClassClassLoader(clazz)) != null) {
            return clazzClassLoader;
        }
        return systemClassLoader;
    }

    public static Class<?> loadClass(String className) throws ClassNotFoundException {
        ClassNotFoundException notFoundException;
        block11: {
            notFoundException = null;
            ClassLoader contextClassLoader = ClassLoaderUtils.getThreadContextClassLoader();
            if (contextClassLoader != null) {
                try {
                    return Class.forName(className, false, contextClassLoader);
                }
                catch (ClassNotFoundException cnfe) {
                    notFoundException = cnfe;
                }
            }
            if (!ClassLoaderUtils.isKnownLeafClassLoader(contextClassLoader)) {
                block10: {
                    if (classClassLoader != null && classClassLoader != contextClassLoader) {
                        try {
                            return Class.forName(className, false, classClassLoader);
                        }
                        catch (ClassNotFoundException cnfe) {
                            if (notFoundException != null) break block10;
                            notFoundException = cnfe;
                        }
                    }
                }
                if (!systemClassLoaderAccessibleFromClassClassLoader && systemClassLoader != null && systemClassLoader != contextClassLoader && systemClassLoader != classClassLoader) {
                    try {
                        return Class.forName(className, false, systemClassLoader);
                    }
                    catch (ClassNotFoundException cnfe) {
                        if (notFoundException != null) break block11;
                        notFoundException = cnfe;
                    }
                }
            }
        }
        throw notFoundException;
    }

    public static Class<?> findClass(String className) {
        try {
            return ClassLoaderUtils.loadClass(className);
        }
        catch (ClassNotFoundException cnfe) {
            return null;
        }
    }

    public static boolean isClassPresent(String className) {
        return ClassLoaderUtils.findClass(className) != null;
    }

    public static URL findResource(String resourceName) {
        URL url;
        ClassLoader contextClassLoader = ClassLoaderUtils.getThreadContextClassLoader();
        if (contextClassLoader != null && (url = contextClassLoader.getResource(resourceName)) != null) {
            return url;
        }
        if (!ClassLoaderUtils.isKnownLeafClassLoader(contextClassLoader)) {
            if (classClassLoader != null && classClassLoader != contextClassLoader && (url = classClassLoader.getResource(resourceName)) != null) {
                return url;
            }
            if (!systemClassLoaderAccessibleFromClassClassLoader && systemClassLoader != null && systemClassLoader != contextClassLoader && systemClassLoader != classClassLoader && (url = systemClassLoader.getResource(resourceName)) != null) {
                return url;
            }
        }
        return null;
    }

    public static boolean isResourcePresent(String resourceName) {
        return ClassLoaderUtils.findResource(resourceName) != null;
    }

    public static InputStream loadResourceAsStream(String resourceName) throws IOException {
        InputStream inputStream = ClassLoaderUtils.findResourceAsStream(resourceName);
        if (inputStream != null) {
            return inputStream;
        }
        throw new IOException("Could not locate resource '" + resourceName + "' in the application's class path");
    }

    public static InputStream findResourceAsStream(String resourceName) {
        InputStream inputStream;
        ClassLoader contextClassLoader = ClassLoaderUtils.getThreadContextClassLoader();
        if (contextClassLoader != null && (inputStream = contextClassLoader.getResourceAsStream(resourceName)) != null) {
            return inputStream;
        }
        if (!ClassLoaderUtils.isKnownLeafClassLoader(contextClassLoader)) {
            if (classClassLoader != null && classClassLoader != contextClassLoader && (inputStream = classClassLoader.getResourceAsStream(resourceName)) != null) {
                return inputStream;
            }
            if (!systemClassLoaderAccessibleFromClassClassLoader && systemClassLoader != null && systemClassLoader != contextClassLoader && systemClassLoader != classClassLoader && (inputStream = systemClassLoader.getResourceAsStream(resourceName)) != null) {
                return inputStream;
            }
        }
        return null;
    }

    private static ClassLoader getThreadContextClassLoader() {
        try {
            return Thread.currentThread().getContextClassLoader();
        }
        catch (SecurityException se) {
            return null;
        }
    }

    private static ClassLoader getClassClassLoader(Class<?> clazz) {
        try {
            return clazz.getClassLoader();
        }
        catch (SecurityException se) {
            return null;
        }
    }

    private static ClassLoader getSystemClassLoader() {
        try {
            return ClassLoader.getSystemClassLoader();
        }
        catch (SecurityException se) {
            return null;
        }
    }

    private static boolean isKnownClassLoaderAccessibleFrom(ClassLoader accessibleCL, ClassLoader fromCL) {
        if (fromCL == null) {
            return false;
        }
        try {
            ClassLoader parent;
            for (parent = fromCL; parent != null && parent != accessibleCL; parent = parent.getParent()) {
            }
            return parent != null && parent == accessibleCL;
        }
        catch (SecurityException se) {
            return false;
        }
    }

    private static boolean isKnownLeafClassLoader(ClassLoader classLoader) {
        if (classLoader == null) {
            return false;
        }
        if (!ClassLoaderUtils.isKnownClassLoaderAccessibleFrom(classClassLoader, classLoader)) {
            return false;
        }
        return systemClassLoaderAccessibleFromClassClassLoader;
    }

    private ClassLoaderUtils() {
    }
}

