/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.cext;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.cext.PythonCextBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.common.HashingCollectionNodes;
import com.oracle.graal.python.builtins.objects.common.HashingStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.set.FrozenSetBuiltins;
import com.oracle.graal.python.builtins.objects.set.PBaseSet;
import com.oracle.graal.python.builtins.objects.set.PFrozenSet;
import com.oracle.graal.python.builtins.objects.set.PSet;
import com.oracle.graal.python.builtins.objects.set.SetBuiltins;
import com.oracle.graal.python.builtins.objects.set.SetNodes;
import com.oracle.graal.python.builtins.objects.str.StringBuiltins;
import com.oracle.graal.python.lib.PyObjectSizeNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedLoopConditionProfile;

public final class PythonCextSetBuiltins {

    static abstract class PySet_Size
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PySet_Size() {
        }

        @Specialization
        static long get(PBaseSet object, @Bind Node inliningTarget, @Cached HashingStorageNodes.HashingStorageLen lenNode) {
            return lenNode.execute(inliningTarget, object.getDictStorage());
        }
    }

    static abstract class PySet_Add
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PySet_Add() {
        }

        @Specialization
        static int add(PBaseSet self, Object o, @Bind Node inliningTarget, @Cached HashingCollectionNodes.SetItemNode setItemNode) {
            setItemNode.execute(null, inliningTarget, self, o, PNone.NO_VALUE);
            return 0;
        }

        @Specialization(guards={"!isAnySet(self)"})
        static int add(Object self, Object o, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.SystemError, ErrorMessages.EXPECTED_S_NOT_P, "a set object", self);
        }
    }

    static abstract class PySet_Clear
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PySet_Clear() {
        }

        @Specialization(guards={"!isNone(s)", "!isNoValue(s)"})
        static Object clear(PSet s, @Cached SetBuiltins.ClearNode clearNode) {
            clearNode.execute(null, s);
            return 0;
        }

        @Fallback
        int fallback(Object set) {
            throw this.raiseFallback(set, PythonBuiltinClassType.PSet);
        }
    }

    static abstract class PySet_Discard
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PySet_Discard() {
        }

        @Specialization(guards={"!isNone(s)", "!isNoValue(s)"})
        static Object discard(PSet s, Object key, @Cached SetNodes.DiscardNode discardNode) {
            return discardNode.execute(null, s, key) ? 1 : 0;
        }

        @Fallback
        int fallback(Object set, Object key) {
            throw this.raiseFallback(set, PythonBuiltinClassType.PSet);
        }
    }

    static abstract class PyFrozenSet_New
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyFrozenSet_New() {
        }

        @Specialization(guards={"!isNone(iterable)", "!isNoValue(iterable)"})
        static Object newFrozenSet(Object iterable, @Cached FrozenSetBuiltins.FrozenSetNode frozenSetNode) {
            return frozenSetNode.execute(null, (Object)PythonBuiltinClassType.PFrozenSet, iterable);
        }

        @Specialization
        static Object newFrozenSet(PNone iterable, @Bind PythonLanguage language) {
            return PFactory.createFrozenSet(language);
        }
    }

    static abstract class PySet_Pop
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PySet_Pop() {
        }

        @Specialization
        static Object pop(PSet set, @Cached SetBuiltins.PopNode popNode) {
            return popNode.execute(null, set);
        }

        @Fallback
        Object fallback(Object set) {
            throw this.raiseFallback(set, PythonBuiltinClassType.PSet);
        }
    }

    static abstract class GraalPyPrivate_Set_NextEntry
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        GraalPyPrivate_Set_NextEntry() {
        }

        @Specialization(guards={"pos < size(inliningTarget, set, sizeNode)"})
        static Object nextEntry(PSet set, long pos, @Bind Node inliningTarget, @Cached.Shared @Cached PyObjectSizeNode sizeNode, @Cached.Shared @Cached HashingStorageNodes.HashingStorageGetIterator getIterator, @Cached.Shared @Cached HashingStorageNodes.HashingStorageIteratorNext itNext, @Cached.Shared @Cached HashingStorageNodes.HashingStorageIteratorKey itKey, @Cached.Shared @Cached HashingStorageNodes.HashingStorageIteratorKeyHash itKeyHash, @Cached.Shared @Cached InlinedLoopConditionProfile loopProfile) {
            return GraalPyPrivate_Set_NextEntry.next(inliningTarget, (int)pos, set.getDictStorage(), getIterator, itNext, itKey, itKeyHash, loopProfile);
        }

        @Specialization(guards={"pos < size(inliningTarget, set, sizeNode)"})
        static Object nextEntry(PFrozenSet set, long pos, @Bind Node inliningTarget, @Cached.Shared @Cached PyObjectSizeNode sizeNode, @Cached.Shared @Cached HashingStorageNodes.HashingStorageGetIterator getIterator, @Cached.Shared @Cached HashingStorageNodes.HashingStorageIteratorNext itNext, @Cached.Shared @Cached HashingStorageNodes.HashingStorageIteratorKey itKey, @Cached.Shared @Cached HashingStorageNodes.HashingStorageIteratorKeyHash itKeyHash, @Cached.Shared @Cached InlinedLoopConditionProfile loopProfile) {
            return GraalPyPrivate_Set_NextEntry.next(inliningTarget, (int)pos, set.getDictStorage(), getIterator, itNext, itKey, itKeyHash, loopProfile);
        }

        @Specialization(guards={"isPSet(set) || isPFrozenSet(set)", "pos >= size(inliningTarget, set, sizeNode)"})
        static Object nextEntry(Object set, long pos, @Bind Node inliningTarget, @Cached.Shared @Cached PyObjectSizeNode sizeNode) {
            return GraalPyPrivate_Set_NextEntry.getNativeNull(inliningTarget);
        }

        @Specialization(guards={"!isPSet(anyset)", "!isPFrozenSet(anyset)", "isSetSubtype(inliningTarget, anyset, getClassNode, isSubtypeNode)"})
        static Object nextNative(Object anyset, Object pos, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared @Cached IsSubtypeNode isSubtypeNode, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.NotImplementedError, ErrorMessages.NATIVE_S_SUBTYPES_NOT_IMPLEMENTED, "set");
        }

        @Specialization(guards={"!isPSet(anyset)", "!isPFrozenSet(anyset)", "!isSetSubtype(inliningTarget, anyset, getClassNode, isSubtypeNode)"})
        static Object nextEntry(Object anyset, Object pos, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared @Cached IsSubtypeNode isSubtypeNode, @Cached StringBuiltins.StrNewNode strNode, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.SystemError, ErrorMessages.BAD_ARG_TO_INTERNAL_FUNC_WAS_S_P, strNode.executeWith(anyset), anyset);
        }

        protected boolean isSetSubtype(Node inliningTarget, Object obj, GetClassNode getClassNode, IsSubtypeNode isSubtypeNode) {
            return isSubtypeNode.execute(getClassNode.execute(inliningTarget, obj), (Object)PythonBuiltinClassType.PSet) || isSubtypeNode.execute(getClassNode.execute(inliningTarget, obj), (Object)PythonBuiltinClassType.PFrozenSet);
        }

        protected int size(Node inliningTarget, Object set, PyObjectSizeNode sizeNode) {
            return sizeNode.execute(null, inliningTarget, set);
        }

        private static Object next(Node inliningTarget, int pos, HashingStorage storage, HashingStorageNodes.HashingStorageGetIterator getIterator, HashingStorageNodes.HashingStorageIteratorNext itNext, HashingStorageNodes.HashingStorageIteratorKey itKey, HashingStorageNodes.HashingStorageIteratorKeyHash itKeyHash, InlinedLoopConditionProfile loopProfile) {
            HashingStorageNodes.HashingStorageIterator it = getIterator.execute(inliningTarget, storage);
            loopProfile.profileCounted(inliningTarget, (long)pos);
            int i = 0;
            while (loopProfile.inject(inliningTarget, i <= pos)) {
                if (!itNext.execute(inliningTarget, storage, it)) {
                    return GraalPyPrivate_Set_NextEntry.getNativeNull(inliningTarget);
                }
                ++i;
            }
            Object key = itKey.execute(inliningTarget, storage, it);
            long hash = itKeyHash.execute(null, inliningTarget, storage, it);
            return PFactory.createTuple(PythonLanguage.get(inliningTarget), new Object[]{key, hash});
        }
    }

    static abstract class PySet_Contains
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PySet_Contains() {
        }

        @Specialization
        static int contains(PSet anyset, Object item, @Bind Node inliningTarget, @Cached.Shared @Cached HashingStorageNodes.HashingStorageGetItem getItem) {
            HashingStorage storage = anyset.getDictStorage();
            return PInt.intValue(getItem.hasKey(null, inliningTarget, storage, item));
        }

        @Specialization
        static int contains(PFrozenSet anyset, Object item, @Bind Node inliningTarget, @Cached.Shared @Cached HashingStorageNodes.HashingStorageGetItem getItem) {
            HashingStorage storage = anyset.getDictStorage();
            return PInt.intValue(getItem.hasKey(null, inliningTarget, storage, item));
        }

        @Fallback
        int fallback(Object anyset, Object item) {
            throw this.raiseFallback(anyset, PythonBuiltinClassType.PSet, PythonBuiltinClassType.PFrozenSet);
        }
    }

    static abstract class PySet_New
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PySet_New() {
        }

        @Specialization(guards={"!isNone(iterable)", "!isNoValue(iterable)"})
        static Object newSet(Object iterable, @Cached SetNodes.ConstructSetNode constructSetNode) {
            return constructSetNode.execute(null, iterable);
        }

        @Specialization
        static Object newSet(PNone iterable, @Bind PythonLanguage language) {
            return PFactory.createSet(language);
        }
    }
}

