/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.geom.Rectangle2D;
import java.util.Map;
import org.apache.batik.bridge.AbstractSVGLightingElementBridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.ext.awt.image.Light;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.renderable.SpecularLightingRable8Bit;
import org.apache.batik.gvt.GraphicsNode;
import org.w3c.dom.Element;

public class SVGFeSpecularLightingElementBridge
extends AbstractSVGLightingElementBridge {
    public String getLocalName() {
        return "feSpecularLighting";
    }

    public Filter createFilter(BridgeContext bridgeContext, Element element, Element element2, GraphicsNode graphicsNode, Filter filter, Rectangle2D rectangle2D, Map map) {
        float f = SVGFeSpecularLightingElementBridge.convertNumber(element, "surfaceScale", 1.0f, bridgeContext);
        float f2 = SVGFeSpecularLightingElementBridge.convertNumber(element, "specularConstant", 1.0f, bridgeContext);
        float f3 = SVGFeSpecularLightingElementBridge.convertSpecularExponent(element, bridgeContext);
        Light light = SVGFeSpecularLightingElementBridge.extractLight(element, bridgeContext);
        double[] dArray = SVGFeSpecularLightingElementBridge.convertKernelUnitLength(element, bridgeContext);
        Filter filter2 = SVGFeSpecularLightingElementBridge.getIn(element, element2, graphicsNode, filter, map, bridgeContext);
        if (filter2 == null) {
            return null;
        }
        Rectangle2D rectangle2D2 = filter2.getBounds2D();
        Rectangle2D rectangle2D3 = SVGUtilities.convertFilterPrimitiveRegion(element, element2, graphicsNode, rectangle2D2, rectangle2D, bridgeContext);
        SpecularLightingRable8Bit specularLightingRable8Bit = new SpecularLightingRable8Bit(filter2, rectangle2D3, light, f2, f3, f, dArray);
        SVGFeSpecularLightingElementBridge.handleColorInterpolationFilters(specularLightingRable8Bit, element);
        SVGFeSpecularLightingElementBridge.updateFilterMap(element, specularLightingRable8Bit, map);
        return specularLightingRable8Bit;
    }

    protected static float convertSpecularExponent(Element element, BridgeContext bridgeContext) {
        String string = element.getAttributeNS(null, "specularExponent");
        if (string.length() == 0) {
            return 1.0f;
        }
        try {
            float f = SVGUtilities.convertSVGNumber(string);
            if (f < 1.0f || f > 128.0f) {
                throw new BridgeException(bridgeContext, element, "attribute.malformed", new Object[]{"specularConstant", string});
            }
            return f;
        }
        catch (NumberFormatException numberFormatException) {
            throw new BridgeException(bridgeContext, element, numberFormatException, "attribute.malformed", new Object[]{"specularConstant", string, numberFormatException});
        }
    }
}

