/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records.impl.pb;

import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ResourceUtilization;
import org.apache.hadoop.yarn.api.records.impl.pb.ProtoUtils;
import org.apache.hadoop.yarn.proto.YarnProtos;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ResourceUtilizationPBImpl
extends ResourceUtilization {
    private YarnProtos.ResourceUtilizationProto proto = YarnProtos.ResourceUtilizationProto.getDefaultInstance();
    private YarnProtos.ResourceUtilizationProto.Builder builder = null;
    private boolean viaProto = false;

    public ResourceUtilizationPBImpl() {
        this.builder = YarnProtos.ResourceUtilizationProto.newBuilder();
    }

    public ResourceUtilizationPBImpl(YarnProtos.ResourceUtilizationProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public YarnProtos.ResourceUtilizationProto getProto() {
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnProtos.ResourceUtilizationProto.newBuilder(this.proto);
        }
        this.viaProto = false;
    }

    @Override
    public int getPhysicalMemory() {
        YarnProtos.ResourceUtilizationProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.getPmem();
    }

    @Override
    public void setPhysicalMemory(int pmem) {
        this.maybeInitBuilder();
        this.builder.setPmem(pmem);
    }

    @Override
    public int getVirtualMemory() {
        YarnProtos.ResourceUtilizationProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.getVmem();
    }

    @Override
    public void setVirtualMemory(int vmem) {
        this.maybeInitBuilder();
        this.builder.setVmem(vmem);
    }

    @Override
    public float getCPU() {
        YarnProtos.ResourceUtilizationProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.getCpu();
    }

    @Override
    public void setCPU(float cpu) {
        this.maybeInitBuilder();
        this.builder.setCpu(cpu);
    }

    @Override
    public float getCustomResource(String resourceName) {
        return this.getCustomResources().get(resourceName).floatValue();
    }

    @Override
    public Map<String, Float> getCustomResources() {
        YarnProtos.ResourceUtilizationProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return ProtoUtils.convertStringFloatMapProtoListToMap(p.getCustomResourcesList());
    }

    @Override
    public void setCustomResources(Map<String, Float> customResources) {
        if (customResources != null) {
            this.maybeInitBuilder();
            this.builder.addAllCustomResources(ProtoUtils.convertMapToStringFloatMapProtoList(customResources));
        }
    }

    @Override
    public int compareTo(ResourceUtilization other) {
        int diff = this.getPhysicalMemory() - other.getPhysicalMemory();
        if (diff == 0 && (diff = this.getVirtualMemory() - other.getVirtualMemory()) == 0 && (diff = Float.compare(this.getCPU(), other.getCPU())) == 0) {
            diff = this.getCustomResources().size() - other.getCustomResources().size();
        }
        return diff;
    }
}

