/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.executor;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.executor.AbstractUpdateCoordinator;
import com.amazon.randomcutforest.executor.UpdateResult;
import com.amazon.randomcutforest.store.IPointStore;
import com.amazon.randomcutforest.store.PointStore;
import java.util.List;

public class PointStoreCoordinator<Point>
extends AbstractUpdateCoordinator<Integer, Point> {
    private final IPointStore<Integer, Point> store;

    public PointStoreCoordinator(IPointStore<Integer, Point> store) {
        CommonUtils.checkNotNull(store, "store must not be null");
        this.store = store;
    }

    @Override
    public Integer initUpdate(Point point, long sequenceNumber, boolean updateShingleOnly) {
        int index = this.store.add(point, sequenceNumber, updateShingleOnly);
        return index == PointStore.INFEASIBLE_POINTSTORE_INDEX ? null : Integer.valueOf(index);
    }

    @Override
    public void completeUpdate(List<UpdateResult<Integer>> updateResults, Integer updateInput) {
        if (updateInput != null) {
            updateResults.forEach(result -> {
                result.getAddedPoint().ifPresent(this.store::incrementRefCount);
                result.getDeletedPoint().ifPresent(this.store::decrementRefCount);
            });
            this.store.decrementRefCount(updateInput);
        }
        ++this.totalUpdates;
    }

    @Override
    public IPointStore<Integer, Point> getStore() {
        return this.store;
    }
}

