/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.tasks.dashboard;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import org.netbeans.modules.bugtracking.IssueImpl;
import org.netbeans.modules.bugtracking.RepositoryImpl;
import org.netbeans.modules.bugtracking.tasks.Category;
import org.netbeans.modules.bugtracking.tasks.actions.Actions;
import org.netbeans.modules.bugtracking.tasks.dashboard.CategoryNode;
import org.netbeans.modules.bugtracking.tasks.dashboard.DashboardViewer;
import org.netbeans.modules.bugtracking.tasks.dashboard.Submitable;
import org.netbeans.modules.bugtracking.tasks.dashboard.TaskNode;
import org.netbeans.modules.team.commons.treelist.TreeListNode;
import org.openide.util.ImageUtilities;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public class UnsubmittedCategoryNode
extends CategoryNode
implements Submitable {
    private final RepositoryImpl repository;
    private final PropertyChangeListener unsubmittedListener;
    private static final ImageIcon UNSUBMITTED_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/bugtracking/tasks/resources/category_unsubmitted.png", (boolean)true);
    private final RequestProcessor REQUEST_PROCESSOR = RequestProcessor.getDefault();

    public UnsubmittedCategoryNode(Category category, RepositoryImpl repository) {
        super(category, false);
        this.repository = repository;
        this.unsubmittedListener = new UnsubmittedCategoryListener();
        repository.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.unsubmittedListener, (Object)repository));
    }

    @Override
    ImageIcon getIcon() {
        return UNSUBMITTED_ICON;
    }

    @Override
    List<Action> getCategoryActions(List<TreeListNode> selectedNodes) {
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.addAll(Actions.getSubmitablePopupActions(selectedNodes.toArray(new TreeListNode[0])));
        return actions;
    }

    @Override
    public List<IssueImpl> getTasksToSubmit() {
        return this.getTasks(false);
    }

    @Override
    public boolean isUnsubmitted() {
        return true;
    }

    @Override
    void adjustTaskNode(TaskNode taskNode) {
    }

    public RepositoryImpl getRepository() {
        return this.repository;
    }

    private class UnsubmittedCategoryListener
    implements PropertyChangeListener {
        private UnsubmittedCategoryListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("bugtracking.repository.unsubmittedIssues.changed")) {
                if (SwingUtilities.isEventDispatchThread()) {
                    UnsubmittedCategoryNode.this.REQUEST_PROCESSOR.post(new Runnable(){

                        @Override
                        public void run() {
                            UnsubmittedCategoryListener.this.updateCatNode();
                        }
                    });
                } else {
                    this.updateCatNode();
                }
            }
        }

        private void updateCatNode() {
            UnsubmittedCategoryNode.this.updateContent();
            DashboardViewer.getInstance().updateCategoryNode(UnsubmittedCategoryNode.this);
        }
    }
}

