/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.core.support.java.method;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.j2ee.core.api.support.java.method.MethodModel;
import org.netbeans.modules.j2ee.core.support.java.method.MethodCustomizerPanel;
import org.openide.NotificationLineSupport;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class ValidatingPropertyChangeListener
implements PropertyChangeListener {
    private final MethodCustomizerPanel panel;
    private final NotifyDescriptor notifyDescriptor;
    private final NotificationLineSupport statusLine;
    private final boolean checkInterfaces;
    private final Collection<MethodModel> existingMethods;
    private final Set<String> existingMethodsNames;
    private final String prefix;

    public ValidatingPropertyChangeListener(MethodCustomizerPanel panel, NotifyDescriptor notifyDescriptor, Collection<MethodModel> existingMethods, String prefix) {
        this.panel = panel;
        this.notifyDescriptor = notifyDescriptor;
        this.statusLine = notifyDescriptor.createNotificationLineSupport();
        this.checkInterfaces = panel.supportsInterfacesChecking();
        this.existingMethods = existingMethods;
        this.existingMethodsNames = new HashSet<String>();
        for (MethodModel methodModel : existingMethods) {
            this.existingMethodsNames.add(methodModel.getName());
        }
        this.prefix = prefix;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        this.validate();
    }

    protected boolean validate() {
        this.statusLine.clearMessages();
        this.notifyDescriptor.setValid(false);
        String name = this.panel.getMethodName();
        if (!Utilities.isJavaIdentifier((String)name)) {
            this.statusLine.setErrorMessage(NbBundle.getMessage(ValidatingPropertyChangeListener.class, (String)"ERROR_nameNonJavaIdentifier"));
            return false;
        }
        if (this.prefix != null && !name.startsWith(this.prefix)) {
            this.statusLine.setErrorMessage(NbBundle.getMessage(ValidatingPropertyChangeListener.class, (String)"ERROR_wrongMethodPrefix", (Object)this.prefix));
            return false;
        }
        String returnType = this.panel.getReturnType();
        if ("".equals(returnType)) {
            this.statusLine.setErrorMessage(NbBundle.getMessage(ValidatingPropertyChangeListener.class, (String)"ERROR_returnTypeInvalid"));
            return false;
        }
        if (this.checkInterfaces) {
            boolean local = this.panel.hasLocal();
            boolean remote = this.panel.hasRemote();
            boolean allowsNoInterface = this.panel.allowsNoInterface();
            if (!(allowsNoInterface || local || remote)) {
                this.statusLine.setErrorMessage(NbBundle.getMessage(ValidatingPropertyChangeListener.class, (String)"ERROR_selectSomeInterface"));
                return false;
            }
            if (local && remote) {
                this.statusLine.setWarningMessage(NbBundle.getMessage(ValidatingPropertyChangeListener.class, (String)"LBL_commonImplForBothInterfaces"));
            }
        }
        if (this.existingMethodsNames.contains(name)) {
            List<MethodModel.Variable> proposedParams = this.panel.getParameters();
            for (MethodModel methodModel : this.existingMethods) {
                if (!this.sameParams(proposedParams, methodModel.getParameters())) continue;
                this.statusLine.setErrorMessage(NbBundle.getMessage(ValidatingPropertyChangeListener.class, (String)"ERROR_methodExists"));
                return false;
            }
        }
        List<MethodModel.Variable> params = this.panel.getParameters();
        for (MethodModel.Variable param : params) {
            String parName = param.getName();
            int count = 0;
            for (MethodModel.Variable par : params) {
                if (!parName.equals(par.getName())) continue;
                ++count;
            }
            if (count <= true) continue;
            this.statusLine.setErrorMessage(NbBundle.getMessage(ValidatingPropertyChangeListener.class, (String)"ERROR_duplicateParameterName", (Object)parName));
            return false;
        }
        this.notifyDescriptor.setValid(true);
        return true;
    }

    private boolean sameParams(List<MethodModel.Variable> proposedParams, List<MethodModel.Variable> existingParams) {
        if (existingParams.size() == proposedParams.size()) {
            for (int i = 0; i < existingParams.size(); ++i) {
                String existingType = existingParams.get(i).getType();
                String proposedType = proposedParams.get(i).getType();
                int existingIndex = existingType.lastIndexOf(46);
                int proposedIndex = proposedType.lastIndexOf(46);
                if (existingIndex == -1 && proposedIndex != -1) {
                    proposedType = proposedType.substring(proposedIndex + 1);
                } else if (existingIndex != -1 && proposedIndex == -1) {
                    existingType = existingType.substring(existingIndex + 1);
                }
                if (existingType.equals(proposedType)) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }
}

