/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.diff;

import java.awt.EventQueue;
import java.io.File;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.subversion.RepositoryFile;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.actions.ActionUtils;
import org.netbeans.modules.subversion.ui.actions.ContextAction;
import org.netbeans.modules.subversion.ui.diff.DiffAction;
import org.netbeans.modules.subversion.ui.diff.DiffTopComponent;
import org.netbeans.modules.subversion.ui.diff.MultiDiffPanel;
import org.netbeans.modules.subversion.ui.diff.SelectDiffTree;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class DiffToAction
extends ContextAction {
    @Override
    protected String getBaseName(Node[] nodes) {
        return "CTL_MenuItem_DiffTo";
    }

    @Override
    protected boolean enable(Node[] nodes) {
        return super.enable(nodes) && SvnUtils.getActionRoots(this.getCachedContext(nodes), false) != null;
    }

    @Override
    protected int getFileEnabledStatus() {
        return this.getDirectoryEnabledStatus();
    }

    @Override
    protected int getDirectoryEnabledStatus() {
        return -4;
    }

    @Override
    protected void performContextAction(final Node[] nodes) {
        SvnProgressSupport supp = new SvnProgressSupport(this){
            final /* synthetic */ DiffToAction this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            protected void perform() {
                if (!Subversion.getInstance().checkClientAvailable()) {
                    Logger.getLogger(DiffToAction.class.getName()).log(Level.FINE, "Client is unavailable, cannot perform Diff To");
                    return;
                }
                if (this.isCanceled()) {
                    return;
                }
                final Context ctx = this.this$0.getContext(nodes);
                final String contextName = this.this$0.getContextDisplayName(nodes);
                SVNUrl repositoryUrl = null;
                SVNUrl fileUrl = null;
                File[] roots = SvnUtils.getActionRoots(ctx, false);
                File interestingFile = null;
                if (roots != null && roots.length > 0) {
                    try {
                        interestingFile = roots.length == 1 ? roots[0] : SvnUtils.getPrimaryFile(roots[0]);
                        repositoryUrl = SvnUtils.getRepositoryRootUrl(interestingFile);
                        fileUrl = SvnUtils.getRepositoryUrl(interestingFile);
                    }
                    catch (SVNClientException ex) {
                        Logger.getLogger(DiffToAction.class.getName()).log(Level.INFO, null, ex);
                    }
                } else if (roots != null && roots.length == 0) {
                    Logger.getLogger(DiffToAction.class.getName()).log(Level.WARNING, "No cation roots for context: {0}", Arrays.asList(ctx.getRootFiles()));
                }
                if (repositoryUrl == null || fileUrl == null) {
                    Logger.getLogger(DiffToAction.class.getName()).log(Level.FINE, "No repository URL: {0} or file URL: {1} for roots: {2}", new Object[]{repositoryUrl, fileUrl, Arrays.asList(roots)});
                }
                final SelectDiffTree panel = new SelectDiffTree(new RepositoryFile(repositoryUrl, fileUrl, SVNRevision.HEAD), interestingFile);
                final SVNUrl fRepositoryUrl = repositoryUrl;
                final SVNUrl fFileUrl = fileUrl;
                EventQueue.invokeLater(new Runnable(){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public void run() {
                        if (!panel.showDialog()) {
                            return;
                        }
                        RepositoryFile left = panel.getRepositoryFile();
                        MultiDiffPanel panel2 = new MultiDiffPanel(ctx, -1, contextName, false, fRepositoryUrl, fFileUrl, left, new RepositoryFile(fRepositoryUrl, fFileUrl, SVNRevision.WORKING));
                        DiffTopComponent tc = new DiffTopComponent(panel2);
                        tc.setName(NbBundle.getMessage(DiffAction.class, (String)"CTL_DiffPanel_Title", (Object)contextName));
                        tc.open();
                        tc.requestActive();
                    }
                });
            }
        };
        supp.start(Subversion.getInstance().getRequestProcessor(), null, ActionUtils.cutAmpersand(this.getRunningName(nodes)));
    }
}

