/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.datatype;

import java.util.ArrayList;
import java.util.List;
import nu.validator.datatype.DatatypeStreamingValidatorImpl;
import nu.validator.datatype.Html5DatatypeException;
import org.relaxng.datatype.Datatype;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.DatatypeStreamingValidator;
import org.relaxng.datatype.ValidationContext;

public abstract class AbstractDatatype
implements Datatype {
    AbstractDatatype() {
    }

    public final boolean isValid(String literal, ValidationContext context) {
        try {
            this.checkValid(literal);
        }
        catch (DatatypeException e) {
            return false;
        }
        return true;
    }

    public void checkValid(String literal, ValidationContext context) throws DatatypeException {
        this.checkValid(literal);
    }

    public abstract void checkValid(CharSequence var1) throws DatatypeException;

    public DatatypeStreamingValidator createStreamingValidator(ValidationContext context) {
        return new DatatypeStreamingValidatorImpl(this);
    }

    public Object createValue(String literal, ValidationContext context) {
        return literal;
    }

    public final boolean sameValue(Object value1, Object value2) {
        if (value1 == null) {
            return value2 == null;
        }
        return value1.equals(value2);
    }

    public final int valueHashCode(Object value) {
        return value.hashCode();
    }

    public final int getIdType() {
        return 0;
    }

    public boolean isContextDependent() {
        return false;
    }

    protected final boolean isWhitespace(char c) {
        return c == ' ' || c == '\t' || c == '\f' || c == '\n' || c == '\r';
    }

    protected final boolean isAsciiDigit(char c) {
        return c >= '0' && c <= '9';
    }

    protected static final char toAsciiLowerCase(char c) {
        if (c >= 'A' && c <= 'Z') {
            c = (char)(c + 32);
        }
        return c;
    }

    protected static final String toAsciiLowerCase(CharSequence str) {
        if (str == null) {
            return null;
        }
        char[] buf = new char[str.length()];
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c >= 'A' && c <= 'Z') {
                c = (char)(c + 32);
            }
            buf[i] = c;
        }
        return new String(buf);
    }

    protected static final char toAsciiUpperCase(char c) {
        if (c >= 'a' && c <= 'z') {
            c = (char)(c - 32);
        }
        return c;
    }

    protected static final String toAsciiUpperCase(CharSequence str) {
        if (str == null) {
            return null;
        }
        char[] buf = new char[str.length()];
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c >= 'a' && c <= 'z') {
                c = (char)(c - 32);
            }
            buf[i] = c;
        }
        return new String(buf);
    }

    protected DatatypeException newDatatypeException(String message) {
        return new Html5DatatypeException(this.getClass(), this.getName(), message);
    }

    protected DatatypeException newDatatypeException(String head, String literal, String tail) {
        return new Html5DatatypeException(this.getClass(), this.getName(), head, literal, tail);
    }

    protected DatatypeException newDatatypeException(String head, char literal, String tail) {
        return new Html5DatatypeException(this.getClass(), this.getName(), head, String.valueOf(literal), tail);
    }

    protected DatatypeException newDatatypeException(int position, String message) {
        return new Html5DatatypeException(position, this.getClass(), this.getName(), message);
    }

    protected DatatypeException newDatatypeException(int position, String head, String literal, String tail) {
        return new Html5DatatypeException(position, this.getClass(), this.getName(), head, literal, tail);
    }

    protected DatatypeException newDatatypeException(int position, String head, char literal, String tail) {
        return new Html5DatatypeException(position, this.getClass(), this.getName(), head, String.valueOf(literal), tail);
    }

    protected DatatypeException newDatatypeException(String message, boolean warning) {
        return new Html5DatatypeException(this.getClass(), this.getName(), message, warning);
    }

    protected DatatypeException newDatatypeException(String head, String literal, String tail, boolean warning) {
        return new Html5DatatypeException(this.getClass(), this.getName(), head, literal, tail, warning);
    }

    protected DatatypeException newDatatypeException(String head, char literal, String tail, boolean warning) {
        return new Html5DatatypeException(this.getClass(), this.getName(), head, String.valueOf(literal), tail, warning);
    }

    protected DatatypeException newDatatypeException(int position, String message, boolean warning) {
        return new Html5DatatypeException(position, this.getClass(), this.getName(), message, warning);
    }

    protected DatatypeException newDatatypeException(int position, String head, String literal, String tail, boolean warning) {
        return new Html5DatatypeException(position, this.getClass(), this.getName(), head, literal, tail, warning);
    }

    protected DatatypeException newDatatypeException(int position, String head, char literal, String tail, boolean warning) {
        return new Html5DatatypeException(position, this.getClass(), this.getName(), head, String.valueOf(literal), tail, warning);
    }

    public abstract String getName();

    protected List<CharSequenceWithOffset> split(CharSequence sequence, char delimiter) {
        ArrayList<CharSequenceWithOffset> rv = new ArrayList<CharSequenceWithOffset>();
        int offset = 0;
        for (int i = 0; i < sequence.length(); ++i) {
            char c = sequence.charAt(i);
            if (c != delimiter) continue;
            rv.add(new CharSequenceWithOffset(sequence.subSequence(offset, i), offset));
            offset = i + 1;
        }
        rv.add(new CharSequenceWithOffset(sequence.subSequence(offset, sequence.length()), offset));
        return rv;
    }

    protected class CharSequenceWithOffset {
        private final CharSequence sequence;
        private final int offset;

        public CharSequenceWithOffset(CharSequence sequence, int offset) {
            this.sequence = sequence;
            this.offset = offset;
        }

        public int getOffset() {
            return this.offset;
        }

        public CharSequence getSequence() {
            return this.sequence;
        }
    }
}

