/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.lib.profiler.results.RuntimeCCTNode;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.MarkedCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.MethodCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.ServletRequestCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.SimpleCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.ThreadCPUCCTNode;

public final class RuntimeCCTNodeProcessor {
    private static final Logger LOGGER = Logger.getLogger(RuntimeCCTNodeProcessor.class.getName());

    private RuntimeCCTNodeProcessor() {
    }

    public static void process(RuntimeCCTNode root, Plugin ... plugins) {
        ArrayDeque<Item<RuntimeCCTNode>> nodeStack = new ArrayDeque<Item<RuntimeCCTNode>>();
        for (Plugin p : plugins) {
            if (p == null) continue;
            p.onStart();
        }
        nodeStack.push(new SimpleItem(nodeStack, root, plugins));
        int maxMethodId = root instanceof SimpleCPUCCTNode ? ((SimpleCPUCCTNode)root).getMaxMethodId() : Integer.MAX_VALUE;
        RuntimeCCTNodeProcessor.processStack(maxMethodId, nodeStack, plugins);
        for (Plugin p : plugins) {
            if (p == null) continue;
            p.onStop();
        }
    }

    private static void processStack(int maxMethodId, Deque<Item<RuntimeCCTNode>> stack, Plugin ... plugins) {
        while (!stack.isEmpty()) {
            Item<RuntimeCCTNode> item = stack.pollLast();
            if (item == null) continue;
            item.process(maxMethodId);
        }
    }

    public static interface Plugin {
        public void onStart();

        public void onStop();

        public void onNode(RuntimeCCTNode var1);

        public void onBackout(RuntimeCCTNode var1);
    }

    private static class SimpleItem
    extends Item<RuntimeCCTNode> {
        private final Deque<Item<RuntimeCCTNode>> stack;

        public SimpleItem(Deque<Item<RuntimeCCTNode>> stack, RuntimeCCTNode instance, Plugin ... plugins) {
            super(instance, plugins);
            this.stack = stack;
        }

        @Override
        void process(int maxMethodId) {
            this.stack.add(new BackoutItem(this.instance, this.plugins));
            for (RuntimeCCTNode n : this.instance.getChildren()) {
                if (n instanceof MethodCPUCCTNode && ((MethodCPUCCTNode)n).getMethodId() >= maxMethodId) continue;
                this.stack.add(new SimpleItem(this.stack, n, this.plugins));
            }
            for (Plugin p : this.plugins) {
                if (p == null) continue;
                p.onNode(this.instance);
            }
        }
    }

    private static abstract class Item<T extends RuntimeCCTNode> {
        protected final T instance;
        protected final Plugin[] plugins;

        public Item(T instance, Plugin ... plugins) {
            this.instance = instance;
            this.plugins = plugins;
        }

        abstract void process(int var1);
    }

    private static class BackoutItem
    extends Item<RuntimeCCTNode> {
        public BackoutItem(RuntimeCCTNode instance, Plugin ... plugins) {
            super(instance, plugins);
        }

        @Override
        void process(int maxMethodId) {
            for (Plugin p : this.plugins) {
                if (p == null) continue;
                p.onBackout(this.instance);
            }
        }
    }

    public static abstract class PluginAdapter
    implements Plugin {
        @Override
        public final void onBackout(RuntimeCCTNode node) {
            if (node instanceof MethodCPUCCTNode) {
                this.onBackout((MethodCPUCCTNode)node);
            } else if (node instanceof MarkedCPUCCTNode) {
                this.onBackout((MarkedCPUCCTNode)node);
            } else if (node instanceof ThreadCPUCCTNode) {
                this.onBackout((ThreadCPUCCTNode)node);
            } else if (node instanceof SimpleCPUCCTNode) {
                this.onBackout((SimpleCPUCCTNode)node);
            } else if (node instanceof ServletRequestCPUCCTNode) {
                this.onBackout((ServletRequestCPUCCTNode)node);
            } else {
                LOGGER.log(Level.WARNING, "Can not process uncrecoginzed node class {0}", node.getClass());
            }
        }

        @Override
        public final void onNode(RuntimeCCTNode node) {
            if (node instanceof MethodCPUCCTNode) {
                this.onNode((MethodCPUCCTNode)node);
            } else if (node instanceof MarkedCPUCCTNode) {
                this.onNode((MarkedCPUCCTNode)node);
            } else if (node instanceof ThreadCPUCCTNode) {
                this.onNode((ThreadCPUCCTNode)node);
            } else if (node instanceof SimpleCPUCCTNode) {
                this.onNode((SimpleCPUCCTNode)node);
            } else if (node instanceof ServletRequestCPUCCTNode) {
                this.onNode((ServletRequestCPUCCTNode)node);
            } else {
                LOGGER.log(Level.WARNING, "Can not process uncrecoginzed node class {0}", node.getClass());
            }
        }

        @Override
        public void onStart() {
        }

        @Override
        public void onStop() {
        }

        protected void onNode(MethodCPUCCTNode node) {
        }

        protected void onNode(MarkedCPUCCTNode node) {
        }

        protected void onNode(ThreadCPUCCTNode node) {
        }

        protected void onNode(SimpleCPUCCTNode node) {
        }

        protected void onNode(ServletRequestCPUCCTNode node) {
        }

        protected void onBackout(MethodCPUCCTNode node) {
        }

        protected void onBackout(MarkedCPUCCTNode node) {
        }

        protected void onBackout(ThreadCPUCCTNode node) {
        }

        protected void onBackout(SimpleCPUCCTNode node) {
        }

        protected void onBackout(ServletRequestCPUCCTNode node) {
        }
    }
}

