/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.javascript.debugger.breakpoints;

import java.util.List;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.modules.javascript2.debug.ui.models.ViewModelSupport;
import org.netbeans.modules.web.javascript.debugger.breakpoints.AbstractBreakpoint;
import org.netbeans.modules.web.javascript.debugger.breakpoints.Bundle;
import org.netbeans.modules.web.javascript.debugger.breakpoints.DOMBreakpoint;
import org.netbeans.modules.web.javascript.debugger.breakpoints.DOMNode;
import org.netbeans.modules.web.javascript.debugger.breakpoints.EventsBreakpoint;
import org.netbeans.modules.web.javascript.debugger.breakpoints.XHRBreakpoint;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;

public class BreakpointModel
extends ViewModelSupport
implements NodeModel {
    public static final String BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/NonLineBreakpoint";
    public static final String CURRENT_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/NonLineBreakpointHit";
    public static final String DISABLED_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/DisabledNonLineBreakpoint";
    public static final String DISABLED_CURRENT_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/DisabledNonLineBreakpointHit";

    public String getDisplayName(Object node) throws UnknownTypeException {
        if (node instanceof DOMBreakpoint) {
            int chn;
            DOMBreakpoint breakpoint = (DOMBreakpoint)((Object)node);
            String nodeName = breakpoint.getNode().getNodeName();
            List<? extends DOMNode.NodeId> nodePath = breakpoint.getNode().getPath();
            if (nodePath != null && !nodePath.isEmpty() && (chn = nodePath.get(nodePath.size() - 1).getChildNumber()) >= 0) {
                nodeName = nodeName + '[' + chn + ']';
            }
            StringBuilder modifications = new StringBuilder();
            if (breakpoint.isOnSubtreeModification()) {
                modifications.append(Bundle.LBL_DOM_Subtree());
            }
            if (breakpoint.isOnAttributeModification()) {
                if (modifications.length() > 0) {
                    modifications.append(", ");
                }
                modifications.append(Bundle.LBL_DOM_Attributes());
            }
            if (breakpoint.isOnNodeRemoval()) {
                if (modifications.length() > 0) {
                    modifications.append(", ");
                }
                modifications.append(Bundle.LBL_DOM_Removal());
            }
            return Bundle.LBL_DOMBreakpoint_on(nodeName, modifications);
        }
        if (node instanceof EventsBreakpoint) {
            EventsBreakpoint eb = (EventsBreakpoint)((Object)node);
            String eventsStr = eb.getEvents().toString();
            eventsStr = eventsStr.substring(1, eventsStr.length() - 1);
            return Bundle.LBL_EventsBreakpoint_on(eventsStr);
        }
        if (node instanceof XHRBreakpoint) {
            XHRBreakpoint xb = (XHRBreakpoint)((Object)node);
            String urlSubstring = xb.getUrlSubstring();
            return Bundle.LBL_XHRBreakpoint_on(urlSubstring);
        }
        throw new UnknownTypeException(node);
    }

    public String getIconBase(Object node) throws UnknownTypeException {
        String iconBase;
        boolean invalid;
        if (!(node instanceof Breakpoint)) {
            throw new UnknownTypeException(node);
        }
        Breakpoint b = (Breakpoint)node;
        boolean disabled = !b.isEnabled();
        boolean bl = invalid = b.getValidity() == Breakpoint.VALIDITY.INVALID;
        if (node instanceof AbstractBreakpoint) {
            AbstractBreakpoint breakpoint = (AbstractBreakpoint)((Object)node);
            iconBase = disabled ? DISABLED_BREAKPOINT : BREAKPOINT;
        } else {
            throw new UnknownTypeException(node);
        }
        if (invalid && !disabled) {
            iconBase = iconBase + "_broken";
        }
        return iconBase;
    }

    public String getShortDescription(Object node) throws UnknownTypeException {
        if (!(node instanceof Breakpoint)) {
            throw new UnknownTypeException(node);
        }
        Breakpoint b = (Breakpoint)node;
        String appendMsg = null;
        if (node instanceof Breakpoint) {
            Breakpoint.VALIDITY validity = b.getValidity();
            boolean valid = validity == Breakpoint.VALIDITY.VALID;
            boolean invalid = validity == Breakpoint.VALIDITY.INVALID;
            String message = b.getValidityMessage();
            if (valid) {
                appendMsg = Bundle.CTL_APPEND_BP_Valid();
            }
            if (invalid) {
                appendMsg = message != null ? Bundle.CTL_APPEND_BP_Invalid_with_reason(message) : Bundle.CTL_APPEND_BP_Invalid();
            }
        }
        return null;
    }
}

