/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.inspect.webkit;

import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JToolBar;
import org.netbeans.api.project.Project;
import org.netbeans.modules.web.browser.spi.EnhancedBrowser;
import org.netbeans.modules.web.common.api.UsageLogger;
import org.netbeans.modules.web.inspect.PageModel;
import org.netbeans.modules.web.inspect.actions.Resource;
import org.netbeans.modules.web.inspect.files.Files;
import org.netbeans.modules.web.inspect.webkit.Bundle;
import org.netbeans.modules.web.inspect.webkit.CSSUpdater;
import org.netbeans.modules.web.inspect.webkit.DOMNode;
import org.netbeans.modules.web.inspect.webkit.EditorSynchronizer;
import org.netbeans.modules.web.inspect.webkit.ui.CSSStylesPanel;
import org.netbeans.modules.web.webkit.debugging.api.Runtime;
import org.netbeans.modules.web.webkit.debugging.api.WebKitDebugging;
import org.netbeans.modules.web.webkit.debugging.api.css.CSS;
import org.netbeans.modules.web.webkit.debugging.api.css.StyleSheetHeader;
import org.netbeans.modules.web.webkit.debugging.api.debugger.RemoteObject;
import org.netbeans.modules.web.webkit.debugging.api.dom.DOM;
import org.netbeans.modules.web.webkit.debugging.api.dom.Node;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public class WebKitPageModel
extends PageModel {
    private final RequestProcessor RP = new RequestProcessor(WebKitPageModel.class);
    WebKitDebugging webKit;
    private DOMNode documentNode;
    private final Object DOCUMENT_NODE_LOCK = new Object();
    private final Map<Integer, DOMNode> nodes = Collections.synchronizedMap(new HashMap());
    private List<? extends org.openide.nodes.Node> selectedNodes = Collections.EMPTY_LIST;
    private List<? extends org.openide.nodes.Node> highlightedNodes = Collections.EMPTY_LIST;
    private List<? extends org.openide.nodes.Node> nodesMatchingSelectedRule = Collections.EMPTY_LIST;
    private String selectedSelector;
    private String highlightedSelector;
    private final DOM.Listener domListener;
    private final CSS.Listener cssListener;
    private boolean selectionMode;
    private boolean synchronizeSelection = true;
    private final Project project;
    private final Lookup pageContext;
    private final CSSUpdater cSSUpdater = CSSUpdater.getDefault();
    private final Map<Integer, RemoteObject> contentDocumentMap = new HashMap<Integer, RemoteObject>();
    private final Map<Integer, RemoteObject> remoteObjectMap = Collections.synchronizedMap(new HashMap());
    private final Map<Integer, EnumSet<CSS.PseudoClass>> pseudoClassMap = Collections.synchronizedMap(new HashMap());
    static final Logger LOG = Logger.getLogger(WebKitPageModel.class.getName());
    private boolean dummyPage;
    private static final int MAX_NODES = 100000;
    private static final int MAX_CHILD_NODES = 20000;
    private boolean pageSizeWarningShown = false;
    private static final UsageLogger USAGE_LOGGER = new UsageLogger.Builder("org.netbeans.ui.metrics.web.inspect").firstMessageOnly(true).message(WebKitPageModel.class, "USG_PAGE_INSPECTION").create();
    private final boolean external;
    private static final RequestProcessor WPRP = new RequestProcessor(WebPaneSynchronizer.class);

    public WebKitPageModel(Lookup pageContext) {
        this.pageContext = pageContext;
        this.webKit = (WebKitDebugging)pageContext.lookup(WebKitDebugging.class);
        this.project = (Project)pageContext.lookup(Project.class);
        this.external = pageContext.lookup(JToolBar.class) == null;
        this.addPropertyChangeListener(new WebPaneSynchronizer());
        this.addPropertyChangeListener(new EditorSynchronizer());
        this.domListener = this.createDOMListener();
        DOM dom = this.webKit.getDOM();
        dom.setClassForHover("-netbeans-hover");
        dom.addListener(this.domListener);
        this.cssListener = this.createCSSListener();
        CSS css = this.webKit.getCSS();
        css.addListener(this.cssListener);
        this.initializePage();
    }

    private void initializePage() {
        Resource.clearCache();
        org.openide.nodes.Node node = this.getDocumentNode();
        if (node == null) {
            LOG.info("getDocumentNode() returned null!");
        } else {
            Node webKitNode = (Node)node.getLookup().lookup(Node.class);
            Node.Attribute attr = (webKitNode = this.convertNode(webKitNode)).getAttribute(":netbeans_temporary");
            boolean bl = this.dummyPage = attr != null;
            if (!this.dummyPage) {
                String initScript = Files.getScript("initialization");
                this.webKit.getRuntime().evaluate(initScript);
                if (this.isExternal()) {
                    String shortcutsScript = Files.getScript("shortcuts");
                    this.webKit.getRuntime().evaluate(shortcutsScript);
                }
                this.cSSUpdater.start(this.webKit, this.getProject());
            }
        }
    }

    public WebKitDebugging getWebKit() {
        return this.webKit;
    }

    @Override
    public Project getProject() {
        return this.project;
    }

    @Override
    public Lookup getPageContext() {
        return this.pageContext;
    }

    @Override
    protected void dispose() {
        this.invokeInAllDocuments("NetBeans.releasePage();", false);
        DOM dom = this.webKit.getDOM();
        dom.removeListener(this.domListener);
        CSS css = this.webKit.getCSS();
        css.removeListener(this.cssListener);
        this.cSSUpdater.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public org.openide.nodes.Node getDocumentNode() {
        assert (!EventQueue.isDispatchThread());
        Object object = this.DOCUMENT_NODE_LOCK;
        synchronized (object) {
            DOM dom;
            Node node;
            if (this.documentNode == null && (node = (dom = this.webKit.getDOM()).getDocument()) != null) {
                WebKitPageModel webKitPageModel = this;
                synchronized (webKitPageModel) {
                    this.documentNode = this.updateNodes(node);
                }
            }
            return this.documentNode;
        }
    }

    @Override
    public void removeNode(org.openide.nodes.Node node) {
        Node webKitNode = (Node)node.getLookup().lookup(Node.class);
        if (webKitNode != null) {
            this.webKit.getDOM().removeNode(webKitNode);
        }
    }

    public String getDocumentURL() {
        Node webKitNode;
        String documentURL = null;
        org.openide.nodes.Node node = this.getDocumentNode();
        if (node != null && (webKitNode = (Node)node.getLookup().lookup(Node.class)) != null) {
            documentURL = webKitNode.getDocumentURL();
        }
        return documentURL;
    }

    private DOM.Listener createDOMListener() {
        return (DOM.Listener)Proxy.newProxyInstance(((Object)((Object)this)).getClass().getClassLoader(), new Class[]{DOM.Listener.class}, (InvocationHandler)new RPInvocationHandler(new DOMListener()));
    }

    private CSS.Listener createCSSListener() {
        return new CSS.Listener(){

            public void mediaQueryResultChanged() {
            }

            public void styleSheetAdded(StyleSheetHeader header) {
            }

            public void styleSheetRemoved(String styleSheetId) {
            }

            public void styleSheetChanged(String styleSheetId) {
                WebKitPageModel.this.RP.post(new Runnable(){

                    @Override
                    public void run() {
                        String script = "NetBeans.repaintGlassPane();";
                        WebKitPageModel.this.invokeInAllDocuments(script);
                    }
                });
            }
        };
    }

    private DOMNode updateNodes(Node node) {
        int nodeId = node.getNodeId();
        DOMNode domNode = this.nodes.get(nodeId);
        if (domNode == null) {
            domNode = new DOMNode(this, node);
            this.nodes.put(nodeId, domNode);
            if (this.nodes.size() > 100000) {
                this.showPageSizeWarning();
            }
        }
        boolean updateChildren = false;
        List subNodes = node.getChildren();
        if (subNodes == null) {
            int nodeType = node.getNodeType();
            if (nodeType == 1 || nodeType == 9 || nodeType == 11) {
                if (node.getChildrenCount() > 20000) {
                    this.showPageSizeWarning();
                }
                this.webKit.getDOM().requestChildNodes(nodeId);
            }
        } else {
            for (Node subNode : subNodes) {
                this.updateNodes(subNode);
            }
            updateChildren = true;
        }
        for (Node shadowRoot : node.getShadowRoots()) {
            this.updateNodes(shadowRoot);
            updateChildren = true;
        }
        final Node contentDocument = node.getContentDocument();
        if (contentDocument != null) {
            this.updateNodes(contentDocument);
            updateChildren = true;
            this.RP.post(new Runnable(){
                final /* synthetic */ WebKitPageModel this$0;
                {
                    this.this$0 = this$0;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    String initScript = Files.getScript("initialization") + "\nNetBeans.setSelectionMode(" + this.this$0.selectionMode + ");";
                    RemoteObject remote = this.this$0.webKit.getDOM().resolveNode(contentDocument, null);
                    if (remote == null) {
                        LOG.log(Level.INFO, "Node with ID {0} resolved to null RemoteObject!", contentDocument.getNodeId());
                    } else {
                        this.this$0.webKit.getRuntime().callFunctionOn(remote, "function() {\n" + initScript + "\n}");
                        WebKitPageModel webKitPageModel = this.this$0;
                        synchronized (webKitPageModel) {
                            this.this$0.contentDocumentMap.put(contentDocument.getNodeId(), remote);
                        }
                    }
                }
            });
        }
        if (updateChildren) {
            domNode.updateChildren(node);
        }
        return domNode;
    }

    private void showPageSizeWarning() {
        if (!this.pageSizeWarningShown) {
            EnhancedBrowser browser;
            this.pageSizeWarningShown = true;
            NotifyDescriptor.Confirmation descriptor = new NotifyDescriptor.Confirmation((Object)Bundle.WebKitPageModel_pageSizeWarningMessage(), Bundle.WebKitPageModel_pageSizeWarningTitle(), 0, 2);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
            if (descriptor.getValue() == NotifyDescriptor.YES_OPTION && (browser = (EnhancedBrowser)this.pageContext.lookup(EnhancedBrowser.class)) != null) {
                browser.close(true);
            }
        }
    }

    public DOMNode getNode(int nodeId) {
        return this.nodes.get(nodeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedNodes(List<? extends org.openide.nodes.Node> nodes) {
        assert (!EventQueue.isDispatchThread());
        WebKitPageModel webKitPageModel = this;
        synchronized (webKitPageModel) {
            if (this.selectedNodes.equals(nodes)) {
                return;
            }
            this.selectedNodes = this.knownNodes(nodes);
        }
        this.logPageInspectionUsage();
        this.firePropertyChange("selectedNodes", null, null);
    }

    private List<? extends org.openide.nodes.Node> knownNodes(List<? extends org.openide.nodes.Node> nodeList) {
        ArrayList<org.openide.nodes.Node> knownNodes = new ArrayList<org.openide.nodes.Node>(nodeList.size());
        for (org.openide.nodes.Node node : nodeList) {
            Node webKitNode = (Node)node.getLookup().lookup(Node.class);
            if (webKitNode == null) {
                knownNodes.add(node);
                continue;
            }
            int nodeId = webKitNode.getNodeId();
            org.openide.nodes.Node knownNode = (org.openide.nodes.Node)this.nodes.get(nodeId);
            if (knownNode == null) {
                LOG.log(Level.INFO, "Ignoring node that is not (no longer?) valid: {0}.", node);
                continue;
            }
            knownNodes.add(knownNode);
        }
        return knownNodes;
    }

    private void logPageInspectionUsage() {
        USAGE_LOGGER.log(new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<org.openide.nodes.Node> getSelectedNodes() {
        WebKitPageModel webKitPageModel = this;
        synchronized (webKitPageModel) {
            return Collections.unmodifiableList(this.selectedNodes);
        }
    }

    public void setHighlightedNodes(List<? extends org.openide.nodes.Node> nodes) {
        assert (!EventQueue.isDispatchThread());
        if (this.isSynchronizeSelection()) {
            this.setHighlightedNodesImpl(nodes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setHighlightedNodesImpl(List<? extends org.openide.nodes.Node> nodes) {
        WebKitPageModel webKitPageModel = this;
        synchronized (webKitPageModel) {
            if (this.highlightedNodes.equals(nodes)) {
                return;
            }
            this.highlightedNodes = nodes;
        }
        this.firePropertyChange("highlightedNodes", null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<? extends org.openide.nodes.Node> getHighlightedNodes() {
        WebKitPageModel webKitPageModel = this;
        synchronized (webKitPageModel) {
            return Collections.unmodifiableList(this.highlightedNodes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSelectedSelector(String selector) {
        WebKitPageModel webKitPageModel = this;
        synchronized (webKitPageModel) {
            this.selectedSelector = selector;
        }
        this.setNodesMatchingSelectedRule(this.matchingNodes(selector));
        this.firePropertyChange("selectedRule", null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSelectedSelector() {
        WebKitPageModel webKitPageModel = this;
        synchronized (webKitPageModel) {
            return this.selectedSelector;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setNodesMatchingSelectedRule(List<? extends org.openide.nodes.Node> nodes) {
        WebKitPageModel webKitPageModel = this;
        synchronized (webKitPageModel) {
            this.nodesMatchingSelectedRule = nodes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<? extends org.openide.nodes.Node> getNodesMatchingSelectedRule() {
        WebKitPageModel webKitPageModel = this;
        synchronized (webKitPageModel) {
            return this.nodesMatchingSelectedRule;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setHighlightedSelector(String selector) {
        WebKitPageModel webKitPageModel = this;
        synchronized (webKitPageModel) {
            this.highlightedSelector = selector;
        }
        this.setHighlightedNodes(this.matchingNodes(selector));
        this.firePropertyChange("highlightedRule", null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getHighlightedSelector() {
        WebKitPageModel webKitPageModel = this;
        synchronized (webKitPageModel) {
            return this.highlightedSelector;
        }
    }

    List<DOMNode> matchingNodes(String selector) {
        ArrayList<DOMNode> domNodes = Collections.EMPTY_LIST;
        if (selector != null) {
            selector = selector.replace(":hover", ".-netbeans-hover");
            DOM dom = this.webKit.getDOM();
            Node documentElement = dom.getDocument();
            if (documentElement != null) {
                List matchingNodes = dom.querySelectorAll(documentElement, selector);
                domNodes = new ArrayList<DOMNode>(matchingNodes.size());
                for (Node node : matchingNodes) {
                    int nodeId = node.getNodeId();
                    DOMNode domNode = this.getNode(nodeId);
                    if (domNode == null) continue;
                    domNodes.add(domNode);
                }
            }
        }
        return domNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSelectionMode(boolean selectionMode) {
        WebKitPageModel webKitPageModel = this;
        synchronized (webKitPageModel) {
            if (this.selectionMode == selectionMode) {
                return;
            }
            this.selectionMode = selectionMode;
            this.webKit.getCSS().setClassForHover(selectionMode ? "-netbeans-hover" : null);
        }
        this.firePropertyChange("selectionMode", !selectionMode, selectionMode);
        if (!selectionMode) {
            this.setHighlightedNodesImpl(Collections.EMPTY_LIST);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSelectionMode() {
        WebKitPageModel webKitPageModel = this;
        synchronized (webKitPageModel) {
            return this.selectionMode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSynchronizeSelection(boolean synchronizeSelection) {
        WebKitPageModel webKitPageModel = this;
        synchronized (webKitPageModel) {
            if (this.synchronizeSelection == synchronizeSelection) {
                return;
            }
            this.synchronizeSelection = synchronizeSelection;
        }
        if (!this.dummyPage) {
            this.firePropertyChange("synchronizeSelection", !synchronizeSelection, synchronizeSelection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSynchronizeSelection() {
        WebKitPageModel webKitPageModel = this;
        synchronized (webKitPageModel) {
            return this.synchronizeSelection;
        }
    }

    void invokeInAllDocuments(String script) {
        this.invokeInAllDocuments(script, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void invokeInAllDocuments(String script, boolean synchronous) {
        ArrayList<RemoteObject> documents;
        Runtime runtime = this.webKit.getRuntime();
        if (synchronous) {
            runtime.evaluate(script);
        } else {
            runtime.execute(script);
        }
        script = "function() {\n" + script + "\n}";
        WebKitPageModel webKitPageModel = this;
        synchronized (webKitPageModel) {
            documents = new ArrayList<RemoteObject>(this.contentDocumentMap.size());
            documents.addAll(this.contentDocumentMap.values());
        }
        for (RemoteObject contentDocument : documents) {
            if (synchronous) {
                runtime.callFunctionOn(contentDocument, script);
                continue;
            }
            runtime.callProcedureOn(contentDocument, script);
        }
    }

    RemoteObject getRemoteObject(Node webKitNode) {
        int id = webKitNode.getNodeId();
        RemoteObject remote = this.remoteObjectMap.get(id);
        if (remote == null && (remote = this.webKit.getDOM().resolveNode(webKitNode, null)) != null) {
            this.remoteObjectMap.put(id, remote);
        }
        return remote;
    }

    Node convertNode(Node node) {
        Node result = node;
        int type = node.getNodeType();
        if (type == 9) {
            List subNodes = node.getChildren();
            if (subNodes != null) {
                for (Node subNode : subNodes) {
                    if (subNode.getNodeType() != 1) continue;
                    result = subNode;
                    break;
                }
            }
        } else if (type == 11) {
            result = node.getParent();
        }
        return result;
    }

    @Override
    public PageModel.CSSStylesView getCSSStylesView() {
        CSSStylesPanel view = CSSStylesPanel.getDefault();
        view.updatePageModel();
        return view;
    }

    public CSS.PseudoClass[] getPseudoClasses(Node node) {
        int nodeId = node.getNodeId();
        Set pseudoClassSet = this.pseudoClassMap.get(nodeId);
        if (pseudoClassSet == null) {
            pseudoClassSet = Collections.EMPTY_SET;
        }
        CSS.PseudoClass[] pseudoClasses = new CSS.PseudoClass[pseudoClassSet.size()];
        int i = 0;
        for (CSS.PseudoClass pseudoClass : pseudoClassSet) {
            pseudoClasses[i++] = pseudoClass;
        }
        return pseudoClasses;
    }

    public void addPseudoClass(Node node, CSS.PseudoClass pseudoClass) {
        int nodeId = node.getNodeId();
        EnumSet<CSS.PseudoClass> pseudoClassSet = this.pseudoClassMap.get(nodeId);
        if (pseudoClassSet == null) {
            pseudoClassSet = EnumSet.noneOf(CSS.PseudoClass.class);
            this.pseudoClassMap.put(nodeId, pseudoClassSet);
        }
        pseudoClassSet.add(pseudoClass);
    }

    public void removePseudoClass(Node node, CSS.PseudoClass pseudoClass) {
        int nodeId = node.getNodeId();
        Set pseudoClassSet = this.pseudoClassMap.get(nodeId);
        if (pseudoClassSet != null) {
            pseudoClassSet.remove(pseudoClass);
        }
    }

    boolean isExternal() {
        return this.external;
    }

    class WebPaneSynchronizer
    implements PropertyChangeListener {
        private final Object LOCK_HIGHLIGHT = new Object();
        private final Object LOCK_SELECTION = new Object();

        WebPaneSynchronizer() {
        }

        @Override
        public void propertyChange(final PropertyChangeEvent evt) {
            WPRP.post(new Runnable(){
                final /* synthetic */ WebPaneSynchronizer this$1;
                {
                    this.this$1 = this$1;
                }

                @Override
                public void run() {
                    String propName = evt.getPropertyName();
                    if (propName.equals("highlightedNodes")) {
                        if (this.this$1.shouldSynchronizeHighlight()) {
                            this.this$1.updateHighlight();
                        }
                    } else if (propName.equals("selectedNodes")) {
                        if (this.this$1.shouldSynchronizeSelection()) {
                            this.this$1.updateSelection();
                        }
                    } else if (propName.equals("selectedRule")) {
                        if (this.this$1.shouldSynchronizeSelection()) {
                            this.this$1.updateSelectedRule(this.this$1.WebKitPageModel.this.getNodesMatchingSelectedRule());
                        }
                    } else if (propName.equals("selectionMode")) {
                        this.this$1.updateSelectionMode();
                        this.this$1.updateSynchronization();
                    } else if (propName.equals("synchronizeSelection")) {
                        this.this$1.updateSelectionMode();
                        this.this$1.updateSynchronization();
                    } else if (propName.equals("document")) {
                        this.this$1.WebKitPageModel.this.initializePage();
                        this.this$1.updateSelectionMode();
                    }
                }
            });
        }

        private boolean shouldSynchronizeSelection() {
            return WebKitPageModel.this.isSelectionMode();
        }

        private boolean shouldSynchronizeHighlight() {
            return true;
        }

        private void updateSynchronization() {
            if (this.shouldSynchronizeSelection()) {
                this.updateSelection();
                this.updateSelectedRule(WebKitPageModel.this.getNodesMatchingSelectedRule());
            } else {
                this.updateSelection(Collections.EMPTY_LIST);
                this.updateSelectedRule(Collections.EMPTY_LIST);
            }
            if (this.shouldSynchronizeHighlight()) {
                this.updateHighlight();
            } else {
                this.updateHighlight(Collections.EMPTY_LIST);
            }
        }

        private void updateHighlight() {
            List<? extends org.openide.nodes.Node> nodes = WebKitPageModel.this.getHighlightedNodes();
            this.updateHighlight(nodes);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateHighlight(List<? extends org.openide.nodes.Node> nodes) {
            Object object = this.LOCK_HIGHLIGHT;
            synchronized (object) {
                WebKitPageModel.this.invokeInAllDocuments("NetBeans.initNextHighlight();");
                for (org.openide.nodes.Node node : nodes) {
                    Node webKitNode = (Node)node.getLookup().lookup(Node.class);
                    RemoteObject remote = WebKitPageModel.this.getRemoteObject(webKitNode = WebKitPageModel.this.convertNode(webKitNode));
                    if (remote == null) continue;
                    WebKitPageModel.this.webKit.getRuntime().callFunctionOn(remote, "function() {NetBeans.addElementToNextHighlight(this);}");
                }
                WebKitPageModel.this.invokeInAllDocuments("NetBeans.finishNextHighlight();");
            }
        }

        private void updateSelection() {
            List<org.openide.nodes.Node> nodes = WebKitPageModel.this.getSelectedNodes();
            this.updateSelection(nodes);
        }

        private void updateSelection(List<? extends org.openide.nodes.Node> nodes) {
            this.updateSelection(nodes, "");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateSelection(List<? extends org.openide.nodes.Node> nodes, String type) {
            Object object = this.LOCK_SELECTION;
            synchronized (object) {
                WebKitPageModel.this.invokeInAllDocuments("NetBeans.initNext" + type + "Selection();");
                for (org.openide.nodes.Node node : nodes) {
                    RemoteObject remote;
                    Node webKitNode = (Node)node.getLookup().lookup(Node.class);
                    if (webKitNode == null || (remote = WebKitPageModel.this.getRemoteObject(webKitNode = WebKitPageModel.this.convertNode(webKitNode))) == null) continue;
                    WebKitPageModel.this.webKit.getRuntime().callProcedureOn(remote, "function() {NetBeans.addElementToNext" + type + "Selection(this);}");
                }
                WebKitPageModel.this.invokeInAllDocuments("NetBeans.finishNext" + type + "Selection();");
            }
        }

        private void updateSelectedRule(List<? extends org.openide.nodes.Node> nodes) {
            this.updateSelection(nodes, "Rule");
        }

        private synchronized void updateSelectionMode() {
            boolean selectionMode = WebKitPageModel.this.isSelectionMode();
            WebKitPageModel.this.invokeInAllDocuments("NetBeans.setSelectionMode(" + selectionMode + ")");
            this.performHoverRelatedStyleSheetUpdate(selectionMode);
        }

        private void performHoverRelatedStyleSheetUpdate(boolean selectionMode) {
            String hover = "':hover'";
            String clazz = "'.-netbeans-hover'";
            String params = selectionMode ? hover + "," + clazz : clazz + "," + hover;
            WebKitPageModel.this.invokeInAllDocuments("NetBeans.replaceInCSSSelectors(" + params + ")");
        }
    }

    private static class RPInvocationHandler
    implements InvocationHandler {
        private static final RequestProcessor RP = new RequestProcessor(RPInvocationHandler.class);
        private final Object target;

        RPInvocationHandler(Object target) {
            this.target = target;
        }

        @Override
        public Object invoke(Object proxy, Method method, final Object[] args) throws Throwable {
            Class<?>[] parameters = method.getParameterTypes();
            final Method thisMethod = this.target.getClass().getMethod(method.getName(), parameters);
            if (Void.TYPE.equals(thisMethod.getReturnType())) {
                RP.post(new Runnable(){
                    final /* synthetic */ RPInvocationHandler this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void run() {
                        this.this$0.invoke0(thisMethod, args);
                    }
                });
                return null;
            }
            if (Object.class.equals(method.getDeclaringClass()) && "equals".equals(method.getName())) {
                return args[0] == proxy;
            }
            return this.invoke0(thisMethod, args);
        }

        Object invoke0(Method method, Object[] args) {
            Object result = null;
            try {
                result = method.invoke(this.target, args);
            }
            catch (IllegalAccessException iaex) {
                Logger.getLogger(RPInvocationHandler.class.getName()).log(Level.INFO, null, iaex);
            }
            catch (InvocationTargetException itex) {
                Logger.getLogger(RPInvocationHandler.class.getName()).log(Level.INFO, null, itex);
            }
            return result;
        }
    }

    private class DOMListener
    implements DOM.Listener {
        private DOMListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void childNodesSet(Node parent) {
            WebKitPageModel webKitPageModel = WebKitPageModel.this;
            synchronized (webKitPageModel) {
                int nodeId = parent.getNodeId();
                DOMNode domNode = (DOMNode)((Object)WebKitPageModel.this.nodes.get(nodeId));
                if (domNode != null) {
                    WebKitPageModel.this.updateNodes(parent);
                    domNode.updateChildren(parent);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void childNodeRemoved(Node parent, Node child) {
            WebKitPageModel webKitPageModel = WebKitPageModel.this;
            synchronized (webKitPageModel) {
                Node contentDocument;
                int nodeId = parent.getNodeId();
                DOMNode domNode = (DOMNode)((Object)WebKitPageModel.this.nodes.get(nodeId));
                if (domNode != null) {
                    domNode.updateChildren(parent);
                }
                if ((contentDocument = child.getContentDocument()) == null) {
                    WebKitPageModel.this.nodes.remove(child.getNodeId());
                } else {
                    WebKitPageModel.this.contentDocumentMap.remove(contentDocument.getNodeId());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void childNodeInserted(Node parent, Node child) {
            WebKitPageModel webKitPageModel = WebKitPageModel.this;
            synchronized (webKitPageModel) {
                int nodeId = parent.getNodeId();
                WebKitPageModel.this.updateNodes(child);
                DOMNode domNode = (DOMNode)((Object)WebKitPageModel.this.nodes.get(nodeId));
                if (domNode != null) {
                    domNode.updateChildren(parent, child);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void documentUpdated() {
            Object object = WebKitPageModel.this.DOCUMENT_NODE_LOCK;
            synchronized (object) {
                WebKitPageModel.this.documentNode = null;
                WebKitPageModel webKitPageModel = WebKitPageModel.this;
                synchronized (webKitPageModel) {
                    WebKitPageModel.this.nodes.clear();
                    WebKitPageModel.this.contentDocumentMap.clear();
                    WebKitPageModel.this.remoteObjectMap.clear();
                    WebKitPageModel.this.pseudoClassMap.clear();
                    WebKitPageModel.this.selectedNodes = Collections.EMPTY_LIST;
                    WebKitPageModel.this.highlightedNodes = Collections.EMPTY_LIST;
                    WebKitPageModel.this.RP.post(new Runnable(){

                        @Override
                        public void run() {
                            WebKitPageModel.this.firePropertyChange("document", null, null);
                        }
                    });
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void attributeModified(Node node, String attrName, String attrValue) {
            WebKitPageModel webKitPageModel = WebKitPageModel.this;
            synchronized (webKitPageModel) {
                final boolean selected = ":netbeans_selected".equals(attrName);
                boolean highlighted = ":netbeans_highlighted".equals(attrName);
                boolean selectMode = ":netbeans_select_mode".equals(attrName);
                if (selected || highlighted) {
                    ArrayList<DOMNode> selection;
                    if (!WebKitPageModel.this.isSelectionMode()) {
                        return;
                    }
                    DOMNode n = WebKitPageModel.this.getNode(node.getNodeId());
                    if (n == null) {
                        selection = Collections.EMPTY_LIST;
                    } else if ("set".equals(attrValue)) {
                        selection = Collections.singletonList(n);
                    } else if ("clear".equals(attrValue)) {
                        selection = Collections.EMPTY_LIST;
                    } else {
                        ArrayList<DOMNode> newSelection = new ArrayList<DOMNode>();
                        newSelection.addAll(WebKitPageModel.this.selectedNodes);
                        if ("add".equals(attrValue)) {
                            newSelection.add(n);
                        } else if ("remove".equals(attrValue)) {
                            newSelection.remove((Object)n);
                        }
                        selection = newSelection;
                    }
                    WebKitPageModel.this.RP.post(new Runnable(){
                        final /* synthetic */ DOMListener this$1;
                        {
                            this.this$1 = this$1;
                        }

                        @Override
                        public void run() {
                            if (selected) {
                                this.this$1.WebKitPageModel.this.setSelectedNodes(selection);
                                this.this$1.WebKitPageModel.this.firePropertyChange("browserSelectedNodes", null, null);
                            } else {
                                this.this$1.WebKitPageModel.this.setHighlightedNodesImpl(selection);
                            }
                        }
                    });
                    return;
                }
                if (selectMode) {
                    final boolean newSelectMode = !WebKitPageModel.this.isSelectionMode();
                    WebKitPageModel.this.RP.post(new Runnable(){
                        final /* synthetic */ DOMListener this$1;
                        {
                            this.this$1 = this$1;
                        }

                        @Override
                        public void run() {
                            this.this$1.WebKitPageModel.this.setSelectionMode(newSelectMode);
                        }
                    });
                    return;
                }
                int nodeId = node.getNodeId();
                DOMNode domNode = (DOMNode)((Object)WebKitPageModel.this.nodes.get(nodeId));
                if (domNode != null) {
                    domNode.updateAttributes();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void attributeRemoved(Node node, String attrName) {
            WebKitPageModel webKitPageModel = WebKitPageModel.this;
            synchronized (webKitPageModel) {
                int nodeId = node.getNodeId();
                DOMNode domNode = (DOMNode)((Object)WebKitPageModel.this.nodes.get(nodeId));
                if (domNode != null) {
                    domNode.updateAttributes();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void characterDataModified(Node node) {
            WebKitPageModel webKitPageModel = WebKitPageModel.this;
            synchronized (webKitPageModel) {
                int nodeId = node.getNodeId();
                DOMNode domNode = (DOMNode)((Object)WebKitPageModel.this.nodes.get(nodeId));
                if (domNode != null) {
                    domNode.updateCharacterData();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shadowRootPushed(Node host, Node shadowRoot) {
            WebKitPageModel webKitPageModel = WebKitPageModel.this;
            synchronized (webKitPageModel) {
                int hostId = host.getNodeId();
                WebKitPageModel.this.updateNodes(shadowRoot);
                DOMNode domNode = (DOMNode)((Object)WebKitPageModel.this.nodes.get(hostId));
                if (domNode != null) {
                    domNode.updateChildren(host, shadowRoot);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shadowRootPopped(Node host, Node shadowRoot) {
            WebKitPageModel webKitPageModel = WebKitPageModel.this;
            synchronized (webKitPageModel) {
                int hostId = host.getNodeId();
                DOMNode domNode = (DOMNode)((Object)WebKitPageModel.this.nodes.get(hostId));
                if (domNode != null) {
                    domNode.updateChildren(host);
                }
                WebKitPageModel.this.nodes.remove(shadowRoot.getNodeId());
            }
        }
    }
}

