/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.composer;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.php.api.executable.InvalidPhpExecutableException;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.util.UiUtils;
import org.netbeans.modules.php.api.validation.ValidationResult;
import org.netbeans.modules.php.composer.Bundle;
import org.netbeans.modules.php.composer.commands.Composer;
import org.netbeans.modules.php.composer.options.ComposerOptions;
import org.netbeans.modules.php.composer.options.ComposerOptionsValidator;
import org.netbeans.modules.php.composer.output.model.ComposerPackage;
import org.netbeans.modules.php.composer.ui.PhpModuleExtenderPanel;
import org.netbeans.modules.php.spi.phpmodule.PhpModuleExtender;
import org.openide.filesystems.FileObject;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;

public class PhpModuleExtenderImpl
implements PhpModuleExtender {
    private volatile PhpModuleExtenderPanel panel = null;

    PhpModuleExtenderImpl() {
    }

    public String getIdentifier() {
        return "Composer";
    }

    public String getDisplayName() {
        return Bundle.PhpModuleExtenderImpl_displayName();
    }

    public void addChangeListener(ChangeListener listener) {
        this.getComponent().addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.getComponent().removeChangeListener(listener);
    }

    @NonNull
    public PhpModuleExtenderPanel getComponent() {
        if (this.panel == null) {
            this.panel = (PhpModuleExtenderPanel)Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<PhpModuleExtenderPanel>(){

                public PhpModuleExtenderPanel run() {
                    return new PhpModuleExtenderPanel();
                }
            });
        }
        return this.panel;
    }

    public HelpCtx getHelp() {
        return null;
    }

    public boolean isValid() {
        return this.getErrorMessage() == null;
    }

    public String getErrorMessage() {
        ValidationResult validationResult = this.getValidationResult();
        if (validationResult.hasErrors()) {
            return Bundle.PhpModuleExtenderImpl_error_composer(((ValidationResult.Message)validationResult.getErrors().get(0)).getMessage());
        }
        if (validationResult.hasWarnings()) {
            return Bundle.PhpModuleExtenderImpl_error_composer(((ValidationResult.Message)validationResult.getWarnings().get(0)).getMessage());
        }
        return null;
    }

    public String getWarningMessage() {
        return null;
    }

    public Set<FileObject> extend(PhpModule phpModule) throws PhpModuleExtender.ExtendingException {
        Composer composer;
        List<ComposerPackage> selectedPackages = this.getComponent().getSelectedPackages();
        if (selectedPackages.isEmpty()) {
            return Collections.emptySet();
        }
        try {
            composer = Composer.getDefault();
        }
        catch (InvalidPhpExecutableException ex) {
            assert (false) : ex.getLocalizedMessage();
            throw new PhpModuleExtender.ExtendingException(ex.getLocalizedMessage(), (Throwable)ex);
        }
        Future<Integer> task = composer.initIfNotPresent(phpModule);
        this.waitFinished(task);
        for (ComposerPackage composerPackage : selectedPackages) {
            task = composer.require(phpModule, composerPackage.asFullPackage());
            assert (task != null);
            this.waitFinished(task);
        }
        return Collections.emptySet();
    }

    private ValidationResult getValidationResult() {
        if (this.getComponent().getSelectedPackages().isEmpty()) {
            return new ValidationResult();
        }
        return new ComposerOptionsValidator().validate(ComposerOptions.getInstance()).getResult();
    }

    private void waitFinished(Future<Integer> task) throws PhpModuleExtender.ExtendingException {
        if (task == null) {
            return;
        }
        try {
            task.get(1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException ex) {
            UiUtils.processExecutionException((ExecutionException)ex);
            throw new PhpModuleExtender.ExtendingException(ex.getLocalizedMessage(), (Throwable)ex);
        }
        catch (TimeoutException ex) {
            task.cancel(true);
        }
    }

    public static final class FactoryImpl
    implements PhpModuleExtender.Factory {
        public PhpModuleExtender create() {
            return new PhpModuleExtenderImpl();
        }
    }
}

