/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util.featuregen;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import opennlp.tools.util.model.ArtifactSerializer;
import opennlp.tools.util.model.SerializableArtifact;

public class WordClusterDictionary
implements SerializableArtifact {
    private Map<String, String> tokenToClusterMap = new HashMap<String, String>();

    public WordClusterDictionary(InputStream in) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
        while ((line = reader.readLine()) != null) {
            String[] parts = line.split(" ");
            if (parts.length == 3) {
                this.tokenToClusterMap.put(parts[0], parts[1].intern());
                continue;
            }
            if (parts.length != 2) continue;
            this.tokenToClusterMap.put(parts[0], parts[1].intern());
        }
    }

    public String lookupToken(String string) {
        return this.tokenToClusterMap.get(string);
    }

    public void serialize(OutputStream out) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out));
        for (Map.Entry<String, String> entry : this.tokenToClusterMap.entrySet()) {
            writer.write(entry.getKey() + " " + entry.getValue() + "\n");
        }
        ((Writer)writer).flush();
    }

    @Override
    public Class<?> getArtifactSerializerClass() {
        return WordClusterDictionarySerializer.class;
    }

    public static class WordClusterDictionarySerializer
    implements ArtifactSerializer<WordClusterDictionary> {
        @Override
        public WordClusterDictionary create(InputStream in) throws IOException {
            return new WordClusterDictionary(in);
        }

        @Override
        public void serialize(WordClusterDictionary artifact, OutputStream out) throws IOException {
            artifact.serialize(out);
        }
    }
}

