/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.changes;

import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import org.infinispan.Cache;
import org.jboss.logging.Logger;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.session.UserSessionPersisterProvider;
import org.keycloak.models.sessions.infinispan.UserSessionAdapter;
import org.keycloak.models.sessions.infinispan.changes.CacheHolder;
import org.keycloak.models.sessions.infinispan.changes.PersistentSessionsChangelogBasedTransaction;
import org.keycloak.models.sessions.infinispan.changes.PersistentUpdate;
import org.keycloak.models.sessions.infinispan.changes.SessionEntityWrapper;
import org.keycloak.models.sessions.infinispan.changes.SessionUpdateTask;
import org.keycloak.models.sessions.infinispan.changes.SessionUpdatesList;
import org.keycloak.models.sessions.infinispan.changes.UserSessionPersistentChangelogBasedTransaction;
import org.keycloak.models.sessions.infinispan.entities.AuthenticatedClientSessionEntity;
import org.keycloak.models.sessions.infinispan.entities.EmbeddedClientSessionKey;

public class ClientSessionPersistentChangelogBasedTransaction
extends PersistentSessionsChangelogBasedTransaction<EmbeddedClientSessionKey, AuthenticatedClientSessionEntity> {
    private static final Logger LOG = Logger.getLogger(ClientSessionPersistentChangelogBasedTransaction.class);
    private final UserSessionPersistentChangelogBasedTransaction userSessionTx;

    public ClientSessionPersistentChangelogBasedTransaction(KeycloakSession session, ArrayBlockingQueue<PersistentUpdate> batchingQueue, CacheHolder<EmbeddedClientSessionKey, AuthenticatedClientSessionEntity> cacheHolder, CacheHolder<EmbeddedClientSessionKey, AuthenticatedClientSessionEntity> offlineCacheHolder, UserSessionPersistentChangelogBasedTransaction userSessionTx) {
        super(session, "clientSessions", batchingQueue, cacheHolder, offlineCacheHolder);
        this.userSessionTx = userSessionTx;
    }

    public void setUserSessionId(Collection<EmbeddedClientSessionKey> keys, String userSessionId, boolean offline) {
        keys.stream().map(this.getUpdates(offline)::get).filter(Objects::nonNull).map(SessionUpdatesList::getEntityWrapper).map(SessionEntityWrapper::getEntity).filter(Objects::nonNull).forEach(authenticatedClientSessionEntity -> authenticatedClientSessionEntity.setUserSessionId(userSessionId));
    }

    public SessionEntityWrapper<AuthenticatedClientSessionEntity> get(RealmModel realm, ClientModel client, UserSessionModel userSession, EmbeddedClientSessionKey key, boolean offline) {
        SessionUpdatesList<Object> myUpdates;
        if (key == null) {
            key = new EmbeddedClientSessionKey(userSession.getId(), client.getId());
        }
        if ((myUpdates = this.getUpdates(offline).get(key)) == null) {
            SessionEntityWrapper<AuthenticatedClientSessionEntity> wrappedEntity = null;
            Cache cache = this.getCache(offline);
            if (cache != null) {
                wrappedEntity = (SessionEntityWrapper<AuthenticatedClientSessionEntity>)cache.get((Object)key);
            }
            if (wrappedEntity == null) {
                LOG.tracef("Client-session not found in cache, loading from persister. userSessionId=%s, clientSessionId=%s, clientId=%s, offline=%s", new Object[]{userSession.getId(), key, client.getId(), offline});
                wrappedEntity = this.getSessionEntityFromPersister(realm, client, userSession, key, offline);
            } else {
                LOG.tracef("Client-session found in cache. userSessionId=%s, clientSessionId=%s, clientId=%s, offline=%s", new Object[]{userSession.getId(), key, client.getId(), offline});
            }
            if (wrappedEntity == null) {
                LOG.debugf("Client-session not found in persister. userSessionId=%s, clientSessionId=%s, clientId=%s, offline=%s", new Object[]{userSession.getId(), key, client.getId(), offline});
                return null;
            }
            ((AuthenticatedClientSessionEntity)wrappedEntity.getEntity()).setOffline(offline);
            wrappedEntity.getEntity().setUserSessionId(userSession.getId());
            RealmModel realmFromSession = this.kcSession.realms().getRealm(wrappedEntity.getEntity().getRealmId());
            if (!realmFromSession.getId().equals(realm.getId())) {
                LOG.warnf("Realm mismatch for session %s. Expected realm %s, but found realm %s", (Object)wrappedEntity.getEntity(), (Object)realm.getId(), (Object)realmFromSession.getId());
                return null;
            }
            myUpdates = new SessionUpdatesList<AuthenticatedClientSessionEntity>(realm, wrappedEntity);
            this.getUpdates(offline).put(key, myUpdates);
            return wrappedEntity;
        }
        boolean scheduledForRemove = myUpdates.getUpdateTasks().stream().map(SessionUpdateTask::getOperation).anyMatch(SessionUpdateTask.CacheOperation.REMOVE::equals);
        if (scheduledForRemove) {
            LOG.debugf("Client-session scheduled for removal in transaction. userSessionId=%s, clientSessionId=%s, clientId=%s, offline=%s", new Object[]{userSession.getId(), key, client.getId(), offline});
        }
        return scheduledForRemove ? null : myUpdates.getEntityWrapper();
    }

    private SessionEntityWrapper<AuthenticatedClientSessionEntity> getSessionEntityFromPersister(RealmModel realm, ClientModel client, UserSessionModel userSession, EmbeddedClientSessionKey clientSessionId, boolean offline) {
        UserSessionPersisterProvider persister = (UserSessionPersisterProvider)this.kcSession.getProvider(UserSessionPersisterProvider.class);
        AuthenticatedClientSessionModel clientSession = persister.loadClientSession(realm, client, userSession, offline);
        if (clientSession == null) {
            LOG.debugf("Client-session not loaded from persister. userSessionId=%s, clientSessionId=%s, clientId=%s, offline=%s", new Object[]{userSession.getId(), clientSessionId, client.getId(), offline});
            return null;
        }
        SessionEntityWrapper<AuthenticatedClientSessionEntity> authenticatedClientSessionEntitySessionEntityWrapper = this.importClientSession(realm, client, userSession, clientSession, clientSessionId);
        if (authenticatedClientSessionEntitySessionEntityWrapper == null) {
            LOG.debugf("Client-session not imported from persister. userSessionId=%s, clientSessionId=%s, clientId=%s, offline=%s", new Object[]{userSession.getId(), clientSessionId, client.getId(), offline});
        }
        return authenticatedClientSessionEntitySessionEntityWrapper;
    }

    public static AuthenticatedClientSessionEntity createAuthenticatedClientSessionInstance(String userSessionId, String userId, AuthenticatedClientSessionModel clientSession, String realmId, String clientId, boolean offline) {
        AuthenticatedClientSessionEntity entity = new AuthenticatedClientSessionEntity();
        entity.setRealmId(realmId);
        entity.setAction(clientSession.getAction());
        entity.setAuthMethod(clientSession.getProtocol());
        entity.setNotes(clientSession.getNotes() == null ? new ConcurrentHashMap() : clientSession.getNotes());
        entity.setClientId(clientId);
        entity.setRedirectUri(clientSession.getRedirectUri());
        entity.setTimestamp(clientSession.getTimestamp());
        entity.setOffline(offline);
        entity.setUserSessionId(userSessionId);
        entity.setUserId(userId);
        return entity;
    }

    private SessionEntityWrapper<AuthenticatedClientSessionEntity> importClientSession(RealmModel realm, ClientModel client, UserSessionModel userSession, AuthenticatedClientSessionModel persistentClientSession, EmbeddedClientSessionKey clientSessionId) {
        AuthenticatedClientSessionEntity entity = ClientSessionPersistentChangelogBasedTransaction.createAuthenticatedClientSessionInstance(userSession.getId(), userSession.getUser().getId(), persistentClientSession, realm.getId(), client.getId(), userSession.isOffline());
        boolean offline = userSession.isOffline();
        entity.setUserSessionId(userSession.getId());
        if (offline) {
            entity.setTimestamp(userSession.getLastSessionRefresh());
        }
        long lifespan = this.getLifespanMsLoader(offline).apply(realm, client, entity);
        long maxIdle = this.getMaxIdleMsLoader(offline).apply(realm, client, entity);
        if (lifespan == -2L || maxIdle == -2L) {
            LOG.debugf("Client-session has expired, not importing it. userSessionId=%s, clientSessionId=%s, clientId=%s, offline=%s", new Object[]{userSession.getId(), clientSessionId, client.getId(), offline});
            return null;
        }
        SessionEntityWrapper<AuthenticatedClientSessionEntity> wrapper = new SessionEntityWrapper<AuthenticatedClientSessionEntity>(entity);
        SessionEntityWrapper<AuthenticatedClientSessionEntity> imported = this.importSession(realm, clientSessionId, wrapper, offline, lifespan, maxIdle);
        if (imported != null) {
            LOG.debugf("Client-session already imported by another transaction. userSessionId=%s, clientSessionId=%s, clientId=%s, offline=%s", new Object[]{userSession.getId(), clientSessionId, client.getId(), offline});
            imported.getEntity().setUserSessionId(userSession.getId());
            return imported;
        }
        if (!(userSession instanceof UserSessionAdapter)) {
            throw new IllegalStateException("UserSessionModel must be instance of UserSessionAdapter");
        }
        UserSessionAdapter sessionToImportInto = (UserSessionAdapter)userSession;
        if (sessionToImportInto.getEntity().getClientSessions().add(client.getId())) {
            this.userSessionTx.registerClientSession(sessionToImportInto.getId(), client.getId(), offline);
        }
        return wrapper;
    }
}

