/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.changeset.query;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openstreetmap.josm.gui.dialogs.changeset.query.BBoxRestrictionPanel;
import org.openstreetmap.josm.gui.dialogs.changeset.query.OpenAndCloseStateRestrictionPanel;
import org.openstreetmap.josm.gui.dialogs.changeset.query.TimeRestrictionPanel;
import org.openstreetmap.josm.gui.dialogs.changeset.query.UserRestrictionPanel;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.VerticallyScrollablePanel;
import org.openstreetmap.josm.io.ChangesetQuery;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class AdvancedChangesetQueryPanel
extends JPanel {
    private final JCheckBox cbUserRestriction = new JCheckBox(I18n.tr("Select changesets owned by specific users", new Object[0]));
    private final JCheckBox cbOpenAndCloseRestrictions = new JCheckBox(I18n.tr("Select changesets depending on whether they are open or closed", new Object[0]));
    private final JCheckBox cbTimeRestrictions = new JCheckBox(I18n.tr("Select changesets based on the date/time they have been created or closed", new Object[0]));
    private final JCheckBox cbBoundingBoxRestriction = new JCheckBox(I18n.tr("Select only changesets related to a specific bounding box", new Object[0]));
    private final UserRestrictionPanel pnlUserRestriction = new UserRestrictionPanel();
    private final OpenAndCloseStateRestrictionPanel pnlOpenAndCloseRestriction = new OpenAndCloseStateRestrictionPanel();
    private final TimeRestrictionPanel pnlTimeRestriction = new TimeRestrictionPanel();
    private final BBoxRestrictionPanel pnlBoundingBoxRestriction = new BBoxRestrictionPanel();

    public AdvancedChangesetQueryPanel() {
        this.build();
    }

    protected JPanel buildQueryPanel() {
        RestrictionGroupStateChangeHandler stateChangeHandler = new RestrictionGroupStateChangeHandler();
        VerticallyScrollablePanel pnl = new VerticallyScrollablePanel(new GridBagLayout());
        pnl.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GBC gc = GBC.eol().fill(2);
        pnl.add((Component)this.cbUserRestriction, gc);
        this.cbUserRestriction.addItemListener(stateChangeHandler);
        pnl.add((Component)this.pnlUserRestriction, gc);
        pnl.add((Component)this.cbOpenAndCloseRestrictions, gc);
        this.cbOpenAndCloseRestrictions.addItemListener(stateChangeHandler);
        pnl.add((Component)this.pnlOpenAndCloseRestriction, gc);
        pnl.add((Component)this.cbTimeRestrictions, gc);
        this.cbTimeRestrictions.addItemListener(stateChangeHandler);
        pnl.add((Component)this.pnlTimeRestriction, gc);
        pnl.add((Component)this.cbBoundingBoxRestriction, gc);
        this.cbBoundingBoxRestriction.addItemListener(stateChangeHandler);
        pnl.add((Component)this.pnlBoundingBoxRestriction, gc);
        pnl.add((Component)new JPanel(), gc);
        return pnl;
    }

    protected final void build() {
        this.setLayout(new BorderLayout());
        JScrollPane spQueryPanel = GuiHelper.embedInVerticalScrollPane(this.buildQueryPanel());
        this.add((Component)spQueryPanel, "Center");
    }

    public void startUserInput() {
        this.restoreFromSettings();
        this.pnlBoundingBoxRestriction.setVisible(this.cbBoundingBoxRestriction.isSelected());
        this.pnlOpenAndCloseRestriction.setVisible(this.cbOpenAndCloseRestrictions.isSelected());
        this.pnlTimeRestriction.setVisible(this.cbTimeRestrictions.isSelected());
        this.pnlUserRestriction.setVisible(this.cbUserRestriction.isSelected());
        this.pnlOpenAndCloseRestriction.startUserInput();
        this.pnlUserRestriction.startUserInput();
        this.pnlTimeRestriction.startUserInput();
    }

    public void displayMessageIfInvalid() {
        if (this.cbUserRestriction.isSelected()) {
            if (!this.pnlUserRestriction.isValidChangesetQuery()) {
                this.pnlUserRestriction.displayMessageIfInvalid();
            }
        } else if (this.cbTimeRestrictions.isSelected()) {
            if (!this.pnlTimeRestriction.isValidChangesetQuery()) {
                this.pnlTimeRestriction.displayMessageIfInvalid();
            }
        } else if (this.cbBoundingBoxRestriction.isSelected() && !this.pnlBoundingBoxRestriction.isValidChangesetQuery()) {
            this.pnlBoundingBoxRestriction.displayMessageIfInvalid();
        }
    }

    public ChangesetQuery buildChangesetQuery() {
        ChangesetQuery query = new ChangesetQuery();
        if (this.cbUserRestriction.isSelected()) {
            if (!this.pnlUserRestriction.isValidChangesetQuery()) {
                return null;
            }
            this.pnlUserRestriction.fillInQuery(query);
        }
        if (this.cbOpenAndCloseRestrictions.isSelected()) {
            this.pnlOpenAndCloseRestriction.fillInQuery(query);
        }
        if (this.cbBoundingBoxRestriction.isSelected()) {
            if (!this.pnlBoundingBoxRestriction.isValidChangesetQuery()) {
                return null;
            }
            this.pnlBoundingBoxRestriction.fillInQuery(query);
        }
        if (this.cbTimeRestrictions.isSelected()) {
            if (!this.pnlTimeRestriction.isValidChangesetQuery()) {
                return null;
            }
            this.pnlTimeRestriction.fillInQuery(query);
        }
        return query;
    }

    public void rememberSettings() {
        Config.getPref().putBoolean("changeset-query.advanced.user-restrictions", this.cbUserRestriction.isSelected());
        Config.getPref().putBoolean("changeset-query.advanced.open-restrictions", this.cbOpenAndCloseRestrictions.isSelected());
        Config.getPref().putBoolean("changeset-query.advanced.time-restrictions", this.cbTimeRestrictions.isSelected());
        Config.getPref().putBoolean("changeset-query.advanced.bbox-restrictions", this.cbBoundingBoxRestriction.isSelected());
        this.pnlUserRestriction.rememberSettings();
        this.pnlOpenAndCloseRestriction.rememberSettings();
        this.pnlTimeRestriction.rememberSettings();
    }

    public void restoreFromSettings() {
        this.cbUserRestriction.setSelected(Config.getPref().getBoolean("changeset-query.advanced.user-restrictions", false));
        this.cbOpenAndCloseRestrictions.setSelected(Config.getPref().getBoolean("changeset-query.advanced.open-restrictions", false));
        this.cbTimeRestrictions.setSelected(Config.getPref().getBoolean("changeset-query.advanced.time-restrictions", false));
        this.cbBoundingBoxRestriction.setSelected(Config.getPref().getBoolean("changeset-query.advanced.bbox-restrictions", false));
    }

    class RestrictionGroupStateChangeHandler
    implements ItemListener {
        RestrictionGroupStateChangeHandler() {
        }

        protected void userRestrictionStateChanged() {
            AdvancedChangesetQueryPanel.this.pnlUserRestriction.setVisible(AdvancedChangesetQueryPanel.this.cbUserRestriction.isSelected());
        }

        protected void openCloseRestrictionStateChanged() {
            AdvancedChangesetQueryPanel.this.pnlOpenAndCloseRestriction.setVisible(AdvancedChangesetQueryPanel.this.cbOpenAndCloseRestrictions.isSelected());
        }

        protected void timeRestrictionsStateChanged() {
            AdvancedChangesetQueryPanel.this.pnlTimeRestriction.setVisible(AdvancedChangesetQueryPanel.this.cbTimeRestrictions.isSelected());
        }

        protected void boundingBoxRestrictionChanged() {
            AdvancedChangesetQueryPanel.this.pnlBoundingBoxRestriction.setVisible(AdvancedChangesetQueryPanel.this.cbBoundingBoxRestriction.isSelected());
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getSource() == AdvancedChangesetQueryPanel.this.cbUserRestriction) {
                this.userRestrictionStateChanged();
            } else if (e.getSource() == AdvancedChangesetQueryPanel.this.cbOpenAndCloseRestrictions) {
                this.openCloseRestrictionStateChanged();
            } else if (e.getSource() == AdvancedChangesetQueryPanel.this.cbTimeRestrictions) {
                this.timeRestrictionsStateChanged();
            } else if (e.getSource() == AdvancedChangesetQueryPanel.this.cbBoundingBoxRestriction) {
                this.boundingBoxRestrictionChanged();
            }
            AdvancedChangesetQueryPanel.this.validate();
            AdvancedChangesetQueryPanel.this.repaint();
        }
    }
}

