/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.edit;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.cmd.EditPointCmd;
import tim.prune.data.Coordinate;
import tim.prune.data.DataPoint;
import tim.prune.data.Field;
import tim.prune.function.Describer;
import tim.prune.function.edit.FieldEdit;
import tim.prune.gui.GuiGridLayout;

public class TruncatePointCoords
extends GenericFunction {
    private JDialog _dialog = null;
    private DataPoint _point = null;
    private JComboBox<String> _coordFormatDropdown = null;
    private JSpinner _numDigitsField = null;
    private JTextField _previewField = null;

    public TruncatePointCoords(App app) {
        super(app);
    }

    @Override
    public String getNameKey() {
        return "function.truncatecoords";
    }

    @Override
    public void begin() {
        this._point = this._app.getTrackInfo().getCurrentPoint();
        if (this._dialog == null) {
            this._dialog = new JDialog(this._parentFrame, this.getName(), true);
            this._dialog.setLocationRelativeTo(this._parentFrame);
            this._dialog.getContentPane().add(this.makeDialogComponents());
            this._dialog.pack();
        }
        this.showPreview();
        this._dialog.setVisible(true);
    }

    private Component makeDialogComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 10));
        jPanel.add((Component)new JLabel(I18nManager.getText("dialog.truncatecoords.intro")), "North");
        JPanel jPanel2 = new JPanel();
        GuiGridLayout guiGridLayout = new GuiGridLayout(jPanel2);
        String[] stringArray = new String[]{I18nManager.getText("units.degminsec"), I18nManager.getText("units.degmin"), I18nManager.getText("units.deg")};
        this._coordFormatDropdown = new JComboBox<String>(stringArray);
        this._coordFormatDropdown.setSelectedIndex(1);
        this._numDigitsField = new JSpinner(new SpinnerNumberModel(3, 0, 10, 1));
        this._numDigitsField.setValue(3);
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    TruncatePointCoords.this._dialog.dispose();
                }
            }
        };
        this._coordFormatDropdown.addKeyListener(keyAdapter);
        this._coordFormatDropdown.addActionListener(actionEvent -> this.showPreview());
        this._numDigitsField.addChangeListener(changeEvent -> this.showPreview());
        JLabel jLabel = new JLabel(I18nManager.getText("details.coordformat"));
        jLabel.setHorizontalAlignment(4);
        guiGridLayout.add(jLabel);
        guiGridLayout.add(this._coordFormatDropdown);
        JLabel jLabel2 = new JLabel(I18nManager.getText("dialog.truncatecoords.numdigits"));
        jLabel2.setHorizontalAlignment(4);
        guiGridLayout.add(jLabel2);
        guiGridLayout.add(this._numDigitsField);
        JLabel jLabel3 = new JLabel(I18nManager.getText("dialog.truncatecoords.preview"));
        jLabel3.setHorizontalAlignment(4);
        guiGridLayout.add(jLabel3);
        this._previewField = new JTextField("", 26);
        this._previewField.setEditable(false);
        guiGridLayout.add(this._previewField);
        jPanel.add((Component)jPanel2, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(2));
        JButton jButton = new JButton(I18nManager.getText("button.ok"));
        jButton.addActionListener(actionEvent -> this.finish());
        jPanel3.add(jButton);
        JButton jButton2 = new JButton(I18nManager.getText("button.cancel"));
        jButton2.addActionListener(actionEvent -> this._dialog.dispose());
        jPanel3.add(jButton2);
        jPanel.add((Component)jPanel3, "South");
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 15));
        return jPanel;
    }

    private void showPreview() {
        String[] stringArray = this.getTruncatedCoords();
        this._previewField.setText(String.valueOf(stringArray[0]) + ", " + stringArray[1]);
    }

    private String[] getTruncatedCoords() {
        Coordinate.Format[] formatArray = new Coordinate.Format[]{Coordinate.Format.DEG_MIN_SEC, Coordinate.Format.DEG_MIN, Coordinate.Format.DECIMAL_FORCE_POINT};
        Coordinate.Format format = formatArray[this._coordFormatDropdown.getSelectedIndex()];
        int n = ((SpinnerNumberModel)this._numDigitsField.getModel()).getNumber().intValue();
        return new String[]{this._point.getLatitude().output(format, n), this._point.getLongitude().output(format, n)};
    }

    private void finish() {
        String[] stringArray = this.getTruncatedCoords();
        List<FieldEdit> list = List.of(new FieldEdit(Field.LATITUDE, stringArray[0]), new FieldEdit(Field.LONGITUDE, stringArray[1]));
        int n = this._app.getTrackInfo().getSelection().getCurrentPointIndex();
        EditPointCmd editPointCmd = new EditPointCmd(n, list);
        Describer describer = new Describer("undo.editpoint", "undo.editpoint.withname");
        String string = this._app.getTrackInfo().getCurrentPoint().getWaypointName();
        editPointCmd.setDescription(describer.getDescriptionWithNameOrNot(string));
        editPointCmd.setConfirmText(I18nManager.getText("confirm.point.edit"));
        this._app.execute(editPointCmd);
        this._dialog.dispose();
    }
}

