/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jortho;

import com.inet.jortho.AutoSpellChecker;
import com.inet.jortho.Dictionary;
import com.inet.jortho.LanguageChangeEvent;
import com.inet.jortho.LanguageChangeListener;
import com.inet.jortho.SpellChecker;
import com.inet.jortho.SpellCheckerOptions;
import com.inet.jortho.Suggestion;
import com.inet.jortho.Tokenizer;
import com.inet.jortho.UserDictionaryProvider;
import com.inet.jortho.Utils;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Utilities;

public class CheckerListener
implements PopupMenuListener,
LanguageChangeListener {
    private Dictionary dictionary;
    private Locale locale;
    private final JComponent menu;
    private final SpellCheckerOptions options;

    CheckerListener(JComponent menu, SpellCheckerOptions options) {
        this.menu = menu;
        this.options = options == null ? SpellChecker.getOptions() : options;
        SpellChecker.addLanguageChangeLister(this);
        this.dictionary = SpellChecker.getCurrentDictionary();
        this.locale = SpellChecker.getCurrentLocale();
    }

    @Override
    public void languageChanged(LanguageChangeEvent ev) {
        this.dictionary = SpellChecker.getCurrentDictionary();
        this.locale = SpellChecker.getCurrentLocale();
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent ev) {
        if (this.dictionary == null || this.locale == null) {
            this.menu.setEnabled(false);
            return;
        }
        JPopupMenu popup = (JPopupMenu)ev.getSource();
        Component invoker = popup.getInvoker();
        if (invoker instanceof JTextComponent) {
            final JTextComponent jText = (JTextComponent)invoker;
            if (!jText.isEditable()) {
                this.menu.setEnabled(false);
                return;
            }
            Caret caret = jText.getCaret();
            int offs = Math.min(caret.getDot(), caret.getMark());
            Point p = jText.getMousePosition();
            if (p != null) {
                offs = jText.viewToModel(p);
            }
            try {
                String invalidWord;
                Document doc = jText.getDocument();
                if (offs > 0 && (offs >= doc.getLength() || Character.isWhitespace(doc.getText(offs, 1).charAt(0)))) {
                    --offs;
                }
                if (offs < 0) {
                    this.menu.setEnabled(false);
                    return;
                }
                final int begOffs = Utilities.getWordStart(jText, offs);
                final int endOffs = Utilities.getWordEnd(jText, offs);
                final String word = jText.getText(begOffs, endOffs - begOffs);
                Tokenizer tokenizer = new Tokenizer(jText, this.dictionary, this.locale, offs, this.options);
                do {
                    invalidWord = tokenizer.nextInvalidWord();
                } while (tokenizer.getWordOffset() < begOffs);
                this.menu.removeAll();
                if (!word.equals(invalidWord)) {
                    this.menu.setEnabled(false);
                    return;
                }
                if (this.dictionary == null) {
                    this.menu.setEnabled(false);
                    return;
                }
                List<Suggestion> list = this.dictionary.searchSuggestions(word);
                this.menu.setEnabled(list.size() > 0);
                boolean needCapitalization = tokenizer.isFirstWordInSentence() && Utils.isFirstCapitalized(word);
                for (int i = 0; i < list.size() && i < this.options.getSuggestionsLimitMenu(); ++i) {
                    Suggestion sugestion = list.get(i);
                    String sugestionWord = sugestion.getWord();
                    if (needCapitalization) {
                        sugestionWord = Utils.getCapitalized(sugestionWord);
                    }
                    JMenuItem item = new JMenuItem(sugestionWord);
                    this.menu.add(item);
                    final String newWord = sugestionWord;
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            jText.setSelectionStart(begOffs);
                            jText.setSelectionEnd(endOffs);
                            jText.replaceSelection(newWord);
                        }
                    });
                }
                UserDictionaryProvider provider = SpellChecker.getUserDictionaryProvider();
                if (provider == null) {
                    return;
                }
                JMenuItem addToDic = new JMenuItem(Utils.getResource("addToDictionary"));
                addToDic.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        UserDictionaryProvider provider = SpellChecker.getUserDictionaryProvider();
                        if (provider != null) {
                            provider.addWord(word);
                        }
                        CheckerListener.this.dictionary.add(word);
                        CheckerListener.this.dictionary.trimToSize();
                        AutoSpellChecker.refresh(jText);
                    }
                });
                if (list.size() > 0) {
                    if (this.menu instanceof JMenu) {
                        ((JMenu)this.menu).addSeparator();
                    } else if (this.menu instanceof JPopupMenu) {
                        ((JPopupMenu)this.menu).addSeparator();
                    }
                }
                this.menu.add(addToDic);
                this.menu.setEnabled(true);
            }
            catch (BadLocationException ex) {
                ex.printStackTrace();
            }
        }
    }
}

